/*global D_GWC_FORMAT_GB, D_GWC_FORMAT_MB, D_GWC_FORMAT_KB, D_GWC_FORMAT_BYTES*/

if (!d3.wgchart) {
    d3.wgchart = {};
}

d3.wgchart.sb = function () {
    var data, stacked_data;
    var width = 960;
    var height = 600;
    var padding = {top: 70, right: 30, bottom: 140, left: 65};
    var barLegendPadding = {top: 80, right: 10, bottom: 20, left: 65};
    var legendRightPadding = 65, legendTopPadding = 10;
    var xScale, yScale;
    var xAxis, yAxis;
    var xAxisLabel, yAxisLabel;
    var xAxisLblTxt, yAxisLblTxt;

    var prevChartWidth = 0;
    var updateTransistionMS = 800; // milliseconds

    var xaxis_key = 'update_time';
    var yaxis_key = "clients";
    var stack_by_key = "key";

    var xaxis_format, xaxis_tickFunc, xaxis_tickInterval = 1;
    var chartSvg;
    var chartWidth, chartHeight;

    var color_palettes10 = ['#2BBED8', '#2382AB', '#00467F', '#9A4351', '#B73384',
                            '#F26824', '#F89829', '#937E32', '#4AAB53', '#44B494'];
    var color_map = {};
    var callBackFunc, callBackPopUpFunc;

    var view_band_by = 'wap_name';
    var legendTitle = "", legendSummary = "";

    var BAR_WIDTH = 30, POPUP_WIDTH = 250, POPUP_HEIGHT = 'auto';
    var LGND_BAR_WIDTH = 15, LGND_BAR_HEIGHT = 15, LGND_X_SPACING = 50, LGND_Y_SPACING = 25;

    // -------------------------------------------- Private functions ---------------------------------------------------------------
    function dateFormat() {
        var format = d3.time.format("%Y-%m-%d %H:%M:%S");
        return format;
    }
    function formatClients(d) {
        var c = d3.format(",.0f")(d);
        return c;
    }
    function formatBytes(d) {
        var b = $.formatBytes(d, D_GWC_FORMAT_GB, D_GWC_FORMAT_MB, D_GWC_FORMAT_KB, D_GWC_FORMAT_BYTES, 1);
        return b;
    }
    function processData() {
        var stack = d3.layout.stack()
                             .values(function (d) { return d.values; })
                             .x(function (d) { return new Date(dateFormat().parse(d[xaxis_key])); })
                             .y(function (d) { return d[yaxis_key]; });
        stacked_data = stack(data);
    }
    function createChartLegend() {
        var legendTitleGroup = d3.select('svg').append('g');
        var legendGroup = d3.select('svg').append('g')
                                  .attr("class", "legendGroup")
                                  .attr("transform", "translate(" + (chartWidth + legendRightPadding) + ", " + legendTopPadding + ")");
        legendTitleGroup.append("text")
                     .classed("legend_title", true)
                     .attr("x", 0)
                     .attr("y", legendTopPadding)
                     .attr("dy", ".35em")
                     .style("font-family", "Raleway")
                     .style("font-size", "18px")
                     .style("fill", "#666")
                     .text(legendTitle);
        var cur_y = 0;
        $.each(legendSummary, function (i, v) {
            legendGroup.append("text")
                     .classed("legend_summary", true)
                     .attr("x", padding.right)
                     .attr("y", cur_y)
                     .attr("dy", ".12em")
                     .style("fill", "#666")
                     .style("font-size", "12px")
                     .style("text-anchor", "end")
                     .text(v);
            cur_y = cur_y + 15;
        });
    }
    function reDrawBarLegend() {
        var legendBarGroup = d3.select('.barLegendGroup').selectAll('text')
                               .data(stacked_data);
        var row_y_pos = 0,
            prev_elem_spacing = 0,
            pos_y = -12;
        var newRowForElem = [];

        legendBarGroup.enter().append('text').text(function (d, i) {
            return d.key;
        }).attr("id", function (d, i) {
            return ('id_' + i);
        });

        legendBarGroup.attr("x", function (d, i) {
            var cur_pos = 0;
            //current node
            var currNode = d3.select('#id_' + i).node();
            var currTextBox = currNode.getBBox();
            var currTextW = currTextBox.width;

            if (i === 0) {
                cur_pos = LGND_BAR_WIDTH + 5;
                prev_elem_spacing = cur_pos + currTextW;
            } else {
                var new_pos = LGND_BAR_WIDTH + LGND_X_SPACING + currTextW + prev_elem_spacing;
                var rightPos = chartWidth - (chartWidth / 5);
                if (new_pos > rightPos) {
                    cur_pos = LGND_BAR_WIDTH + 5;
                    prev_elem_spacing = cur_pos + currTextW;
                    newRowForElem.push(i);
                } else {
                    cur_pos = LGND_BAR_WIDTH + LGND_X_SPACING + prev_elem_spacing;
                    prev_elem_spacing = new_pos;
                }
            }
            return cur_pos;
        }).attr("y", function (d, i) {
            if ($.inArray(i, newRowForElem) !== -1) {
                row_y_pos = row_y_pos + LGND_Y_SPACING;
            }
            return row_y_pos;
        });

        var legendRect = d3.select('.barLegendGroup')
                            .selectAll('rect')
                            .data(stacked_data);

        legendRect.enter()
                  .append("rect");

        legendRect
            .attr("x", function (d, i) {
                var currNode = d3.select('#id_' + i).node();
                var currTextBox = currNode.getBBox();
                var currTextX = currTextBox.x;
                return currTextX - (LGND_BAR_WIDTH + 5);
            })
            .attr("y", function (d, i) {
                if ($.inArray(i, newRowForElem) !== -1) {
                    pos_y = pos_y + (LGND_BAR_HEIGHT + 10);
                }
                if (pos_y >= 100) {
                    barLegendPadding.top = barLegendPadding.top + LGND_Y_SPACING;
                    padding.bottom = padding.bottom + LGND_Y_SPACING;
                } else {
                    padding.bottom = 140;
                    barLegendPadding.top = 80;
                }
                return pos_y;
            })
            .style("fill", function (d, i) {
                return color_map[d.key];
            })
            .attr("width", LGND_BAR_WIDTH)
            .attr("height", LGND_BAR_HEIGHT);
    }
    function createBarLegend() {
        var leftPos = chartWidth / 5;
        d3.select('svg').append('g')
                            .attr("class", "barLegendGroup")
                            .attr("transform", "translate(" + leftPos + ", " + (height - barLegendPadding.top) + ")");
        reDrawBarLegend();
    }
    function createAxisContainers() {
        // create the x axis container
        chartSvg.append("g")
                .attr("class", "x axis");

        // create the y axis container
        chartSvg.append("g")
                .attr("class", "y axis");
    }
    function initScalesAndAxis() {
        // define the parts of the axis that aren't dependent on width or height
        xScale = d3.time.scale();
        yScale = d3.scale.linear();

        xAxis = d3.svg.axis()
                  .scale(xScale)
                  .orient("bottom")
                  .ticks(xaxis_tickFunc, xaxis_tickInterval)
                  .tickFormat(d3.time.format(xaxis_format));

        yAxis = d3.svg.axis()
                  .scale(yScale)
                  .orient("left");
    }
    function initAxisLabels() {
        xAxisLabel = chartSvg.append("text")      // text label for the x axis
                               .attr("class", "x-label")
                               .attr("text-anchor", "middle");

        yAxisLabel = chartSvg.append("text")
                               .attr("transform", "rotate(-90)")
                               .attr("class", "y-label")
                               .attr("y", -padding.left)
                               .attr("dy", ".75em")
                               .style("text-anchor", "middle");
    }
    function updateDomains() {
        var maxY = d3.max(stacked_data, function (d) {
            return d3.max(d.values, function (d) {
                return d.y0 + d.y;
            });
        });
        var x_dmin = d3.extent(data[0].values, function (d) {
                return new Date(dateFormat().parse(d[xaxis_key]));
            });
        xScale.domain(x_dmin).nice(xaxis_tickFunc, 4);

        yScale.domain([0, maxY > 10 ? maxY : 10]);
    }
    function reDrawAxis(animate) {
        xAxisLabel.attr("transform", "translate(" + (chartWidth / 2) + " ," + (chartHeight + padding.bottom) + ")")
                  .text(xAxisLblTxt);

        yAxisLabel.attr("x", -chartHeight / 2)
                  .text(yAxisLblTxt);

        if (yaxis_key === 'bytes') {
            yAxis.tickFormat(formatBytes);
        } else {
            yAxis.tickFormat(formatClients);
        }
        if (animate) {
            chartSvg.select(".x")
                      .attr("transform", "translate(0," + chartHeight  + ")")
                    .call(xAxis);

            chartSvg.select(".y")
                    .call(yAxis);
        } else {
            var t = chartSvg.transition()
                              .duration(updateTransistionMS);

            t.select(".x")
                .attr("transform", "translate(0," + chartHeight  + ")")
                .call(xAxis);

            t.select(".y")
                .call(yAxis);
        }
    }
    function reDrawLegend() {
        d3.select('.legendGroup')
            .transition()
            .duration(updateTransistionMS)
            .attr("transform", "translate(" + (chartWidth + legendRightPadding) + ", " + legendTopPadding + ")");

        d3.select('.legend_title')
            .text(legendTitle);
        d3.selectAll('.legend_summary').remove();

        var cur_y = 0;
        $.each(legendSummary, function (i, v) {
            d3.select('.legendGroup').append("text")
                   .classed("legend_summary", true)
                   .attr("x", padding.right)
                   .attr("y", cur_y)
                   .attr("dy", ".12em")
                   .style("fill", "#666")
                   .style("font-size", "12px")
                   .style("text-anchor", "end")
                   .text(v);
            cur_y = cur_y + 15;
        });
    }
    function updateTickerSpacing(update) {
        if (update) {
            xAxis.ticks(Math.max(width / 80, 2));
        } else {
            xAxis.ticks(xaxis_tickFunc, xaxis_tickInterval);
        }
    }
    function reDrawChart(animate) {
        chartWidth = width - padding.left - padding.right;
        chartHeight = height - padding.top - padding.bottom;

        xScale.range([0, chartWidth]);
        yScale.range([chartHeight, 0]);
        var layerGroup = chartSvg.append('g')
                                   .classed('stack', true)
                                 .selectAll('g')
                                   .data(stacked_data, function (d) {return d[stack_by_key]; });

        layerGroup.enter()
                  .append('g')
                  .attr('class', 'layer');
        layerGroup.attr('fill', function (d, i) {
            if (color_map[d[stack_by_key]] !== undefined) {
                return color_map[d[stack_by_key]];
            }
            return color_palettes10[i];
        });
        // bind a <rect> to each value inside the layer
        var rectElem = layerGroup.selectAll("g.layer rect")
                             .data(function (d) {return d.values; });
        var data_count = data[0].values.length;
        var bar_st_pos = xScale(new Date(dateFormat().parse(data[0].values[0][xaxis_key])));
        var bar_end_pos = xScale(new Date(dateFormat().parse(data[0].values[data[0].values.length - 1][xaxis_key])));
        var bar_range = bar_end_pos - bar_st_pos;
        var new_bar_width = (bar_range / data_count) - 5;
        var updateTckSpcing = false;
        rectElem.enter()
            .append("rect")
               .attr('x', function (d) {return xScale(new Date(dateFormat().parse(d[xaxis_key]))); })
               .attr("y", chartHeight)
               .attr("width", function (d) {
                if (bar_range === 0 || (new_bar_width <= 0 || new_bar_width >= BAR_WIDTH)) {
                    if (new_bar_width < 0) {
                        updateTckSpcing = true;
                    }
                    return BAR_WIDTH;
                }
                updateTckSpcing = true;
                return new_bar_width;
            })
               .attr("height", 0)
            .on("mouseover", function (d) {
                var cpos = $("#gwc_chart").offset();

                d3.select(this)
                    .style({'cursor': 'pointer'});

                var y_point_st = this.y.animVal.value;
                var bar_h = this.height.animVal.value;
                var mytop = cpos.top + y_point_st + bar_h / 2;
                $("#gwc_popup").removeClass("left right");

                var myleft = cpos.left + chartWidth - (chartWidth - this.x.animVal.value) +
                                         POPUP_WIDTH / 3;
                if (myleft >= chartWidth) {
                    $("#gwc_popup").removeClass("right");
                    $("#gwc_popup").addClass("left");
                    myleft = cpos.left + chartWidth - (chartWidth - this.x.animVal.value) - POPUP_WIDTH / 2 - 90;
                } else {
                    $("#gwc_popup").removeClass("left");
                    $("#gwc_popup").addClass("right");
                }
                $("#gwc_popup").show()
                               .offset({top: mytop + 20, left: myleft})
                               .width(POPUP_WIDTH)
                               .height(POPUP_HEIGHT)
                               .css('pointer-events', 'None');

                callBackPopUpFunc(view_band_by, d);
            })
            .on("click", function (d) {
                $("#gwc_popup").hide();
                callBackFunc(view_band_by, d[view_band_by]);
            })
            .on("mouseout", function (d) {
                $("#gwc_popup").hide();
                d3.select(this)
                    .style({'opacity': '1', 'cursor': 'pointer'});
            });
        if (animate) {
            layerGroup.selectAll("rect")
                      .transition().duration(updateTransistionMS)
                        .attr('y', function (d) { return yScale(d.y0 + d.y); })
                        .attr('height', function (d) { return (chartHeight - yScale(d.y)); });
        } else {
            layerGroup.selectAll("rect")
                        .attr('y', function (d) { return yScale(d.y0 + d.y); })
                        .attr('height', function (d) { return (chartHeight - yScale(d.y)); });
        }
        updateTickerSpacing(updateTckSpcing);
    }
    function reDraw() {
        if (prevChartWidth !== width) {
            prevChartWidth = width;
            d3.select('g.stack').remove();
            d3.select('g.barLegendGroup').remove();
            reDrawChart(false);
            reDrawAxis(false);
            reDrawLegend();
            createBarLegend();
        }
    }
    function filterView() {
        d3.select('g.stack').remove();
        d3.select('g.barLegendGroup').remove();
        processData();
        reDrawChart(true);
        reDrawAxis(false);
        reDrawLegend();
        createBarLegend();
    }
    // Public 
    function sb(container) {
        prevChartWidth = width;
        processData();
        chartSvg = d3.select(container)
                     .append("svg")
                       .attr("height", height)
                     .append("g")
                       .attr("transform", "translate(" + padding.left + "," + padding.top + ")");

        createAxisContainers();
        initScalesAndAxis();
        initAxisLabels();
        updateDomains();
        reDrawChart(false);
        reDrawAxis(true);
        createChartLegend();
        createBarLegend();
    }
    sb.filterChart = function () {
        processData();
        updateDomains();
        filterView();
        return sb;
    };
    sb.data = function (value) {
        if (!arguments.length) {
            return data;
        }
        data = value;
        return sb;
    };
    sb.height = function (value) {
        if (!arguments.length) {
            return height;
        }
        height = value;
        return sb;
    };
    sb.width = function (value) {
        if (!arguments.length) {
            return width;
        }
        width = value;
        return sb;
    };
    sb.viewBandBy = function (value) {
        if (!arguments.length) {
            return view_band_by;
        }
        view_band_by = value;
        return sb;
    };
    sb.resize = function () {
        reDraw();
        return sb;
    };
    sb.axisAttrs = function (value) {
        if (!arguments.length) {
            return {'xaxis_key': xaxis_key, 'yaxis_key': yaxis_key, 'stack_by_key': stack_by_key};
        }
        if (value.xaxis_key !== undefined) {
            xaxis_key = value.xaxis_key;
        }
        if (value.yaxis_key !== undefined) {
            yaxis_key = value.yaxis_key;
        }
        if (value.stack_by_key !== undefined) {
            stack_by_key = value.stack_by_key;
        }
        if (value.xaxis !== undefined) {
            if (value.xaxis.format !== undefined) {
                xaxis_format = value.xaxis.format;
            }
            if (value.xaxis.tickFunc !== undefined) {
                xaxis_tickFunc = value.xaxis.tickFunc;
            }
            if (value.xaxis.tickInterval !== undefined) {
                xaxis_tickInterval = value.xaxis.tickInterval;
            }
        }
        return sb;
    };
    sb.legendAttrs = function (value) {
        if (!arguments.length) {
            return {'legend_title': legendTitle, 'legend_summary': legendSummary};
        }
        if (value.legend_title !== undefined) {
            legendTitle = value.legend_title;
        }
        if (value.legend_summary !== undefined) {
            legendSummary = value.legend_summary;
        }
        return sb;
    };
    sb.axisLabels = function (value) {
        if (!arguments.length) {
            return {'xAxisLblTxt': xAxisLblTxt, 'yAxisLblTxt': yAxisLblTxt};
        }
        if (value.xAxisLblTxt !== undefined) {
            xAxisLblTxt = value.xAxisLblTxt;
        }
        if (value.yAxisLblTxt !== undefined) {
            yAxisLblTxt = value.yAxisLblTxt;
        }
        return sb;
    };
    sb.callBackHandler = function (value) {
        if (!arguments.length) {
            return callBackFunc;
        }
        callBackFunc = value;
        return sb;
    };
    sb.callBackPopUpHandler = function (value) {
        if (!arguments.length) {
            return callBackPopUpFunc;
        }
        callBackPopUpFunc = value;
        return sb;
    };
    sb.barColors = function (value) {
        if (!arguments.length) {
            return color_map;
        }
        color_map = value;
        return sb;
    };
    sb.refreshScales = function (value) {
        if (value) {
            initScalesAndAxis();
        }
        return sb;
    };
    return sb;
};
