/*global is_page_locked, lock_page */
var S_USER_MODE = {
    save_btn_id : '#submit_button',
    //Set this flag true from caller, if you want to warn user[currently applicable to config settings log server, system settings]
    show_warning_msg: false,
    selected_tab: '',
    view_mode: false,

    // initialize UI elements
    initUI : function (ids, view_mode) {
        $.each(ids, function (index, id) {
            if (view_mode) {
                $(id).hide();
            } else {
                $(id).show();
            }
        });
        S_USER_MODE.view_mode = view_mode;
        if (view_mode) {
            window.sessionStorage.removeItem('cur_locked_pg');
        } else {
            window.sessionStorage.setItem('cur_locked_pg', lock_page);
        }
        WGRD.updateModeUI(view_mode);
    },

    initEvents : function () {
        //User mode changes
        $('#user_mode_btn').click(S_USER_MODE.check_mode);

        $('#mode_switch_save_btn').click(function () {
            $('#mode_switch_dlg').modal("hide");
            S_USER_MODE.cancel_operation();
        });
    },

    check_mode : function () {
        var sel_tab = S_USER_MODE.selected_tab;
        if (S_USER_MODE.view_mode) { //Currently view only
            var page_info = {'page': lock_page};
            if (sel_tab.length !== 0) {
                page_info.selected_tab = sel_tab;
            }
            WGRD.checkUserMode(page_info).success(function (response) {
                if (response.status) {
                    window.sessionStorage.setItem(lock_page, lock_page);
                    window.sessionStorage.setItem('cur_locked_pg', lock_page);
                }
                WGRD.handleUserModeResponse(response, S_USER_MODE.save_btn_id);
            });
        } else { //Currently readwrite mode, switch to view only mode
            if (S_USER_MODE.show_warning_msg) {
                $('#mode_switch_dlg').modal("show");
            } else {
                S_USER_MODE.cancel_operation();
                window.sessionStorage.removeItem(lock_page);
            }
        }
    },

    cancel_operation : function () {
        var page_info = {'page': lock_page};
        var sel_tab = S_USER_MODE.selected_tab;
        if (sel_tab.length !== 0) {
            page_info.selected_tab = sel_tab;
        }
        WGRD.resetUserMode(page_info);
    }
};
$(document).ready();
