$(document).ready(function() {     
    var resultData = new Object();
    var reportName= '';                 
    var allVars = $.getUrlVars();
    var urlSn = $.getUrlVar('sn');
    var date = $.getUrlVar('date');
    var id = $.getUrlVar('id');
    if (id == null) {
        id = '';
    }
    var period = $.getUrlVar('period');
    if (period == null) {
        period = '1d';
    }
    var urlTz = $.getUrlVar('tz');     
    var repType = $.getUrlVar('reptype');    
    var htmlDate = $("#date").val();
    var htmlSn = $("#sn").val();      
    var startTime = '';
    var endTime = '';

    // Set the report type from the url              
    if(repType != null){
        $('#chart_select').val(repType);
    }
    
    if(period != null && period == 'custom'){
        $('#chart_select').hide();
    }    
        
    $('#csv_link').click(function(){
        resultData.grid_data = updateTimezones(resultData.grid_data, resultData.col_model);
        
        data = JSON.stringify(resultData);
        
        var startEnd = R_DATE_NAVBAR.getStartEndIsoStr();
        var startTime = R_DATE_NAVBAR.convertDateStr2GMT(startEnd[0] + ":00");
        var endTime = R_DATE_NAVBAR.convertDateStr2GMT(startEnd[1] + ":00");

        var reportType = $('#chart_select option:selected').val();

        WGRD.progressModal(S_EXPORTING_FILE, S_PROCESSING);

        $.ajax({
            url: "saveAsCsv?serial=" + htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=" + reportType + "&start_time=" + startTime + "&end_time=" + endTime,
            type: 'POST',
            data: data,
            contentType: 'application/json',
            success: function(data) {
                if(!data.status){
                    if(data.message){
                        alert(data.message);
                    }
                    return true;
                }
                var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                window.location = "get_csv_file?serial=" + htmlSn + file_args;
                return false;
            },
            complete: function(filename) {
                WGRD.progressModalClose();
            }
        });
    });        

     // Add handler for change the type of chart
     $("#chart_select").change(function () {   getChartData();  });
        
     function showChartLoading(){
     }
     $("#custom_datepicker_trigger").bind('click', function() {
        // Listen fora click on this div, it means the date changed 
        // and a refresh is needed
        getChartData();
     });       
     
     function getChartData(){
        var report_type = $('#chart_select option:selected').val();     
        var dates = R_DATE_NAVBAR.getStartEndSeconds();
        var url = 'get_data?report_type=' + report_type + '&sn=' + urlSn + '&id=' + id + '&period=' + period + '&start_time=' + dates[0] + '&end_time=' + dates[1];

        if (report_type === 'policy_usage') {
            url = url + '&client_tz=' + WGRD.client_tz;
        }
        showChartLoading();
        $.ajax({
           url: url,
           method: 'GET',
           dataType: 'json',
           success: onDataReceived
        });            
     }    
     
     // Return data handler functions
     function onDataReceived(series){
        $('#chart').show();
        $('#chart_loading').hide();        

        showHideLinkIcon(series, 'csv');

        startTime = $.getDateDisplay(series.earliest_record, true, urlTz);
        endTime = $.getDateDisplay(series.latest_record, true, urlTz);
        reportName = $('#chart_select option:selected').text(); 
                
        // Notify the date navbar the report range changed
        $('#report_range').trigger('reportRange', { start_time: startTime, 
                                                    end_time: endTime, 
                                                    name: reportName });        
                                                            
        // Unload the grid and then recreate it and populate the rows
        jQuery("#grid_area").GridUnload("#grid_area");
        createGrid(series.col_names, series.col_model, series.grid_sort);
        
        var i = 0;
        for(i=0;i<=series.grid_data.length;i++) {
            $("#grid_area").jqGrid('addRowData',i+1,series.grid_data[i]);
        }
        $("#grid_area").setGridParam({rowNum:i});                 
         
        $("#grid_area").jqGrid('footerData','set', series.footer, false);
        
        resultData = series;
     }          
     
     // Report DataGrid
     function createGrid(colNames, colModel, gridSort){
        $("#grid_area").jqGrid({ 
            datatype: "local", 
            colNames:colNames,
            colModel:colModel,
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder,
            autoencode: true,
            height:'auto',
            shrinkToFit: true,
            autowidth: true,
            footerrow:true
        });       

        $("#grid_area").setColProp('bytes', { formatter: WGRD.bwFormatterSpan });
        $("#grid_area").setColProp('hits', { formatter: $.commaify });
        $("#grid_area").setColProp('status', { formatter: statusFormatter });
        $("#grid_area").setColProp('host', { formatter: linkFormatter });     
        $("#grid_area").setColProp('ip', { formatter: linkFormatter });     
        $("#grid_area").setColProp('user', { formatter: linkFormatter });         
     }      
    
    linkFormatter = function(elem, cellval, opts){
        return formatPerClientLink(elem, cellval, opts);
    };

    function formatPerClientLink(elem, cellval, opts){
        var index = startTime.indexOf(' ');
        var start_date = startTime.substring(0,index);
        var start_time = startTime.substring(index + 1, startTime.length);
        index = endTime.indexOf(' ');
        var end_date = endTime.substring(0,index);
        var end_time = endTime.substring(index + 1, endTime.length);            

        uri = 'perclient?sn=' + urlSn + 
              '&start_date=' + start_date + 
              '&start_time=' + start_time + 
              '&end_date=' + end_date + 
              '&end_time=' + end_time;
        uri += createURLToPerClient(elem, cellval, opts);
        return "<a href='" + uri + "'>" + escapeHtml(elem) + "</a>";
    } 
    
    $(window).bind('resizeEnd', function() {
        var grid = "#grid_area";
        var parent = "#grid_data";
        var grid_width = resizegrid();
        $("#webui_content").width(grid_width);
        $(grid).setGridWidth(100, true); 
        $(grid).setGridWidth($(parent).width(), true);
    });        

    function statusFormatter(cellvalue, options, rowObject) {
        var data = 0;
        var div = '';
        var color_class = 'color:#FF0000;';
        var delete_flag = '';

        if (options.colModel.index === 'status') {
            data = rowObject.status;
            // delete_flag = rowObject.delete_flag;
            if (data.indexOf(S_DELETED) != -1) {
                div = '<div style=' + color_class +'>' + data + '</div>';
            } else {
                div = '<div>' + data + '</div>';
            }
        } 
        return div;
    }
});
