var WGRD_PING = {
    pingTimeout : 300000,
    keepAlive: true,
    tid : null,
    init : function () {
        WGRD_PING.tid = setTimeout(WGRD_PING.pingTimer, WGRD_PING.pingTimeout);
    },

    pingTimer : function () {
        if (!WGRD_PING.keepAlive) {
            return;
        }
        WGRD_PING.ping();
        WGRD_PING.tid = setTimeout(WGRD_PING.pingTimer, WGRD_PING.pingTimeout);
    },

    abortPingTimer : function () {
        clearTimeout(WGRD_PING.tid);
    },

    ping : function () {
        $.ajax({
            type: 'POST',
            url: '/ping/',
            success: WGRD_PING.pingResponse,
            contentType: 'text/plain'
        });
    },

    pingResponse : function (response) {
        if (response && response === 'pong') {
            return;
        }

        WGRD_PING.keepAlive = false;
        WGRD_PING.abortPingTimer();
    }
};
$(document).ready(WGRD_PING.init);
