/*global R_DATE_NAVBAR, checkLoginPageRedirect, decodeURIComponent, S_EXPORTING_LOGS, S_PROCESSING*/
var L_SEARCH = {
    allVars: '',
    urlSn: '',
    urlCluster: '',
    urlLt: '',
    urlSearch: '',
    urlName: '',
    urlTz: '',
    lastQuery: null,
    getSessionFailures: 0,
    init: function () {
        L_SEARCH.allVars = $.getUrlVars();
        L_SEARCH.urlSn = $.getUrlVar('sn');
        L_SEARCH.urlCluster = $.getUrlVar('cluster_id');
        L_SEARCH.urlLt = $.getUrlVar('l_t');
        if (L_SEARCH.urlLt === null) {
            L_SEARCH.urlLt = 'tr';
        }
        L_SEARCH.urlSearch = $.getUrlVar('search');
        L_SEARCH.urlName = $.getUrlVar('name');
        L_SEARCH.urlTz = $.getUrlVar('tz');

        L_SEARCH.initUI();
        L_SEARCH.initEvents();
    },

    initUI: function () {
        $(".searchTable").hide();

        $('#tr').tooltip();
        $('#al').tooltip();
        $('#ev').tooltip();
        $('#db').tooltip();
        $('#pe').tooltip();
        $('#all').tooltip();

        $("#tr, #al, #ev, #db, #pe, #all").click(function (eo) {
            var selector = "#tr";
            if (this.id !== null) {
                selector = "#" + this.id;
            }
            L_SEARCH.urlLt = this.id;
            $("#tr, #al, #ev, #db, #pe, #all").removeClass('active');
            $(selector).addClass('active');
        });

        $("#tr, #al, #ev, #db, #pe, #all").removeClass('active');
        $("#" +  L_SEARCH.urlLt).addClass('active');

        L_SEARCH.initWithQuery();

        $(".searchTable").show();

        if ($("#log_search_load_error").length) {
            $("#load_query_dlg").modal();
        } else if (!$("#select_sn").length) {
            // Prompt to select device when navigating from /log/search
            setTimeout(function () { $("#btn_device_list").click(); }, 100);
        }
    },

    /* -=-=-=- Grid definitions -=-=-=- */
    getGridData: function () {
        $.ajax({
            url: 'log_grid_columns?l_t=search',
            method: 'GET',
            dataType: 'json',
            success: L_SEARCH.onColumnDataReceived
        });
    },

    doDetailView: function (xml_log) {
        var output = "<table width='100%' style='padding: 3px;'>";

        var terms = xml_log.toString().split(",");
        var j;
        for (j = 0; j < terms.length; j++) {
            output += "<tr><td>" + terms[j] + "</td></tr>";
        }

        output += "</table>";

        $("#detailview .modal-body").html("<div>" + output + "</div>");
        $("#detailview").modal({ keyboard: true, backdrop: false });
    },

    utcDateFormatter: function (cellvalue, options, rowObject) {
        return $.getDateDisplay(cellvalue, true, L_SEARCH.urlTz);
    },

    boldFormatter: function (cellvalue, options, rowObject) {
        if (L_SEARCH.lastQuery === null) {
            return cellvalue;
        }
        var value = cellvalue;
        var tmp = '';
        var q = L_SEARCH.lastQuery.q;
        var i, j, terms;
        /* HTML encoded the cell value */
        value = $.jgrid.htmlEncode(value);
        for (i = 0; i < q.length; i++) {
            terms = [];
            if (q[i].all.length > 0) {
                for (j = 0; j < q[i].all.length; j++) {
                    terms = terms.concat(q[i].all[j].split(" "));
                }
            }
            if (q[i].any.length > 0) {
                for (j = 0; j < q[i].any.length; j++) {
                    terms = terms.concat(q[i].any[j].split(" "));
                }
            }
            if (q[i].exact.length > 0) {
                terms = terms.concat(q[i].exact);
            }
            /* HTML encoded the search terms */
            for (j = 0; j < terms.length; j++) {
                terms[j] = $.jgrid.htmlEncode(terms[j]);
            }
            for (j = 0; j < terms.length; j++) {
                tmp = L_SEARCH.boldify(value, terms[j], 0);
                value = tmp;
            }
        }
        value = L_SEARCH.finalboldify(value);
        return value;
    },

    boldify: function (src, searchstr, offset) {
        if (searchstr === '') {
            return src;
        }

        var pos = src.toLowerCase().indexOf(searchstr.toLowerCase(), offset);
        if (pos === -1) {
            return src;
        }
        var searchlen = searchstr.length;
        var highlight = '<' + src.substring(pos, pos + searchlen) + '>';
        var result = src.substring(0, pos) + highlight + src.substring(pos + searchlen);

        return L_SEARCH.boldify(result, searchstr, pos + highlight.length);
    },

    finalboldify: function (src) {
        var leftarrow = src.split('<');

        for (var i = 0; i < leftarrow.length; i++) {
            if (leftarrow[i].indexOf('>') !== -1) {
                leftarrow[i] = leftarrow[i].split('>').join('</font>');
            }
        }

        return leftarrow.join('<font style="font-weight:bold;">');
    },

    onColumnDataReceived: function (columns) {
        // Unload the grid and then recreate it 
        jQuery("#logs_search").GridUnload("#logs_search");

        /* Search log grid  */
        $("#logs_search").jqGrid({
            altRows: true,
            altclass: 'gridAltRow',
            autoencode: true,
            url: 'log_search_data?id=' + $("#select_sn").val(),
            datatype: 'json',
            mtype: 'GET',
            colNames: columns.col_names,
            colModel: columns.col_model,
            pager: '#pager',
            pagerpos: 'right',
            loadui: 'block',
            rowNum: 25,
            rowList: [25, 100, 250, 500],
            sortname: 'update_time',
            sortorder: 'desc',
            caption: '',
            height: 'auto',
            width: '100%',
            viewrecords: true,
            recordpos: 'left',
            toppager: true,
            jsonReader: {
                root: "data",
                page: "currpage",
                total: "totalpages",
                records: "totalrecords",
                userdata: 'data',
                repeatitems: false
            },
            loadError: checkLoginPageRedirect,
            loadComplete: function (data) {
                $("#totalrecords").html(data.totalrecords);
                L_SEARCH.doResize();
            },
            onSelectRow: function (rowid, status, e) {
                var row_data = $("#logs_search").getGridParam('userData')[rowid - 1];
                var xml_log = row_data.xml_log;
                xml_log = L_SEARCH.boldFormatter(xml_log);
                L_SEARCH.doDetailView(xml_log);
            },
        }).navGrid("#pager", { refresh: false, search: false, edit: false, add: false, del: false }, {}, { width: 350 }, {});

        var l_t = $("#options_logtype option:selected").val();
        if (l_t === 'all') {
            $("#logs_search").showCol('log_type');
        } else {
            $("#logs_search").hideCol('log_type');
        }
        $("#logs_search").setColProp('update_time', { formatter: L_SEARCH.utcDateFormatter });
        $("#logs_search").setColProp('xml_log', { formatter: L_SEARCH.boldFormatter});
        $(window).resize();
    },

    buildQuery: function () {
        var parts = [];
        $("#search_widgets .search_widget").each(function (index, element) {
            var data = {
                'any': [],
                'all': [],
                'exact': [],
                'none': []
            };
            $(".sub_search_widget", this).each(function (index, element) {
                var type = $(".search_widget_select", this).val();
                var search_text = $(".search_widget_input", this).val();
                if (search_text.length > 0) {
                    data[type].push(search_text);
                }
            });

            if (data.any.length > 0 ||
                    data.all.length > 0 ||
                    data.exact.length > 0 ||
                    data.none.length > 0) {

                parts.push(data);
            }
        });

        var times = R_DATE_NAVBAR.getStartEndSeconds();
        var b_time = times[0];
        var e_time = times[1];

        var ret = {
            'sn': $("#select_sn").val(),
            'cluster_id': '',
            'name': $("#select_name").html(),
            'minutes': '',
            'b_time': b_time,
            'e_time': e_time,
            'l_t': L_SEARCH.urlLt,
            'q': parts
        };

        return ret;
    },

    loadQuery: function (data) {
        $("#search_widgets .search_widget:last").each(function (index, element) {
            var type = 'any';
            var val = decodeURIComponent(data.any);
            if (data.all.length > 0) {
                type = 'all';
            } else if (data.exact.length > 0) {
                type = 'exact';
            } else if (data.none.length > 0) {
                type = 'none';
            }
            $(".search_widget_select [value='" + type + "']").attr('selected', true);
            $(".search_widget_input", this).val(val);
        });
    },

    initWithQuery: function () {
        var querystring = $("#loaded_query").html();

        if (querystring) {
            var data = JSON.parse(querystring);

            if ((data.sn !== null && data.sn !== '') || (data.cluster_id !== null && data.cluster_id !== '')) {

                $("#options_logtype [value='" + data.l_t + "']").attr('selected', true);
                if (data.minutes === '') {
                    $("#options_timerange [value='timerange_custom']").attr('selected', true);
                } else {
                    $("#options_timerange [value='" + data.minutes + "']").attr('selected', true);
                }
            }
            if (data.q && data.q.length > 0) {
                var q = data.q;
                var i;
                for (i = 0; i < q.length; i++) {
                    L_SEARCH.AddWidget();
                    L_SEARCH.loadQuery(q[i]);
                }
            }

            $("#loaded_query").remove();
            if (data.start_search) {
                L_SEARCH.showMenuBarProgress();
                setTimeout(L_SEARCH.doSearch, 3000);
            } else {
                L_SEARCH.showMenuBarComplete();
                L_SEARCH.getGridData();
                L_SEARCH.lastQuery = data;
            }
        } else {
            L_SEARCH.AddWidget();
        }

    },

    initEvents: function () {
        /* -=-=-=- Buttons -=-=-=- */
        $("#btn_addtosearch").click(L_SEARCH.AddWidget);

        $("#btn_load").click(function () {
            $("#load_query_dlg").modal();
        });

        $("#hidden_btn_select_device").click(function () {
            var sn = $("#select_sn").html();
            var name = $("#select_name").html();
            var cluster_id = $("#select_cluster").html();
            if (cluster_id.length === 0) {
                $("#crumbname").html(name);
            } else if (sn.length === 0) {
                $("#crumbname").html(cluster_id);
            } else {
                $("#crumbname").html(cluster_id + ' ' + name);
            }
            $("#device_list_dlg").modal('hide');
        });
        $(document).on('click', '.ui-widget-overlay', function (eo) {
            $("#device_list_dlg").modal('hide');
        });

        $("#btn_save").click(function () {
            var query = L_SEARCH.buildQuery();
            if (query.length === 0) {
                return;
            }

            $.ajax({
                url: 'log_search_save?id=' + $("#select_sn").val(),
                type: 'POST',
                contentType: 'application/json',
                dataType: 'text',
                processData: false,
                data: JSON.stringify(query),
                error: function (xhr, status, error) {
                    WGRD.okMessageModal(error, '');
                },
                success: function (data) {
                    window.location = '/log/log_search_savequery?id=' + $("#select_sn").val();
                }
            });
        });

        $("#btn_search").click(L_SEARCH.doSearch);

        $("#btn_export").click(function () {
            WGRD.progressModal(S_EXPORTING_LOGS, S_PROCESSING);
            $.ajax({
                url: "/log/export_search?id=" + $("#select_sn").val() + "&client_tz=" + WGRD.client_tz,
                method: 'GET',
                dataType: 'json',
                error: checkLoginPageRedirect,
                success: function (data) {
                    if (data === null) {
                        $("#search_processing").modal('hide');
                        return;
                    }
                    if (!data.status) {
                        if (data.message) {
                            WGRD.okMessageModal(data.message, '');
                        }
                        return true;
                    }
                    var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                    window.location = "/log/get_export_file?id=" + $("#select_sn").val() + file_args;
                    return false;
                },
                complete: function (filename) {
                    WGRD.progressModalClose();
                }
            });
        });

        $("#btn_clear").click(function () {
            $.ajax({
                url: 'log_search_cancel?id=' + $("#select_sn").val(),
                type: 'GET',
                dataType: 'json',
                error: function (xhr, status, error) {
                    L_SEARCH.showMenuBarDefault();
                    WGRD.okMessageModal(error, '');
                },
                success: function (response) {
                    L_SEARCH.showMenuBarDefault();
                    jQuery("#logs_search").GridUnload("#logs_search");
                    $("#complete_row").hide();
                }
            });
        });
        $("#btn_cancel").click(function () {
            //$("#btn_cancel").button("disable");
            $.ajax({
                url: 'log_search_cancel?id=' + $("#select_sn").val(),
                type: 'GET',
                dataType: 'json',
                error: function (xhr, status, error) {
                    L_SEARCH.showMenuBarDefault();
                    WGRD.okMessageModal(error, '');
                },
                success: function (response) {
                    L_SEARCH.showMenuBarDefault();
                    jQuery("#logs_search").GridUnload("#logs_search");
                    $("#complete_row").hide();
                }
            });
        });

        $("#detailview_close").click(function () {
            $("#detailview").modal('hide');
        });

        $(document).on('click', '#btn_close', function (eo) {
            var div = $(this).closest(".search_widget");
            var sub_div = $(this).closest(".sub_search_widget");
            if ($(".and", sub_div).is(':visible')) {
                sub_div.remove();
            } else {
                div.remove();
                L_SEARCH.toggleOR();
            }
        });

        $(document).on('click', '#btn_addtoblock', function (eo) {
            var div = $(this).closest(".search_block");
            if ($(".sub_search_widget", div).length > 3) {
                return;
            }
            var widget_html = $("#base_sub_search_widget").html();
            if (widget_html.length > 0) {
                div.append(widget_html);
            }
            $(".and", div).each(function (i) {
                if (i === 0) {
                    $(this).hide();
                } else {
                    $(this).show();
                }
            });
            $("#btn_addtoblock", div).each(function (i) {
                if (i === 0) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
        $(window).bind('resizeEnd', function () {
            L_SEARCH.doResize();
        });
    },

    showMenuBarDefault: function () {
        $("#complete_row").hide();
        $("#progress_row").hide();
        $("#button_row button").each(function () {
            $(this).removeClass('disabled');
            //$(this).button("enable");
        });
        $("#button_row").show();
    },

    showMenuBarComplete: function () {
        $("#complete_row").show();
        $("#progress_row").hide();
        $("#button_row button").each(function () {
            $(this).removeClass('disabled');
            //$(this).button("enable");
        });
        $("#button_row").show();
    },

    showMenuBarProgress: function () {
        $("#btn_cancel").button("enable");
        $("#progress_row").show();
        $("#complete_row").hide();
        $("#progress .bar").css({ width: 0 }); //progressbar({ value: 0 });
        $("#button_row button").each(function () {
            $(this).addClass('disabled'); //button("disable");
        });
    },

    getSessionInfo: function () {
        /* */
        $.ajax({
            url: 'log_search_session_info?id=' + $("#select_sn").val(),
            type: 'GET',
            dataType: 'json',
            error: checkLoginPageRedirect,
            success: function (response) {
                if (response === null) {
                    if (L_SEARCH.getSessionFailures < 2) {
                        // Be patient
                        setTimeout(L_SEARCH.getSessionInfo, 1500);
                        L_SEARCH.getSessionFailures += 1;
                    } else {
                        L_SEARCH.showMenuBarDefault();
                    }
                    return;
                }
                $("#progress .bar").css('width', response.percent_complete + '%'); //
                //$("#progress").progressbar("option", "value", response.percent_complete);
                if (response.status === 2 ||
                        response.status === 3) {
                    $("#progress .bar").css('width', '100%'); //
                    //$("#progress").progressbar("option", "value", 100);
                    if ($("#progress").is(":visible") && parseInt(response.count, 10) > 0) {
                        $("#logs_search").setGridParam().trigger("reloadGrid");
                    }
                    setTimeout(L_SEARCH.showMenuBarComplete, 1000);
                } else {
                    setTimeout(L_SEARCH.getSessionInfo, 1500);
                }
                $("#totalrecords").html(response.count);
            }
        });
    },

    doSearch: function () {

        L_SEARCH.getSessionFailures = 0;
        L_SEARCH.showMenuBarProgress();
        var query = L_SEARCH.buildQuery();
        if (query.length === 0) {
            return;
        }
        L_SEARCH.lastQuery = null;

        $.ajax({
            url: 'log_search?id=' + $("#select_sn").val(),
            type: 'POST',
            contentType: 'application/json',
            dataType: 'text',
            processData: false,
            data: JSON.stringify(query),
            error: function (xhr, status, error) {
                L_SEARCH.showMenuBarDefault();
                WGRD.okMessageModal(error, '');
            },
            success: function (data) {
                setTimeout(L_SEARCH.getSessionInfo, 2000);
                L_SEARCH.getGridData();
                L_SEARCH.lastQuery = query;
            }
        });
    },

    toggleOR: function () {
        $("#search_widgets .search_widget .or").each(function (i) {
            if (i === 0) {
                $(this).hide();
            } else {
                $(this).show();
            }
        });
        if ($("#search_widgets .search_widget").length > 0) {
            $("#btn_search").removeClass('disabled')
                            .removeAttr('disabled');
        } else {
            $("#btn_search").addClass('disabled')
                            .attr('disabled', true);
        }
    },

    AddWidget: function () {
        if ($(".search_widget").length > 9) {
            return;
        }
        var widget_html = $("#base_search_widget").html();
        if (widget_html.length > 0) {
            $("#search_widgets").append(widget_html);
            L_SEARCH.toggleOR();
        }
    },

    /* -=-=-=- Page resizing -=-=-=- */
    doResize: function () {
        var fpwidth = $("#main_div_row").width();
        fpwidth -= $(".date_navbar_td").width();
        var padleft = 0;
        var grid_width = fpwidth - padleft * 2;

        $('#logs_search').setGridWidth(grid_width);

        return;
    },

    showwaitcursor: function () {
        document.getElementById("loading").style.visibility = 'visible';
        document.getElementById("OK").style.visibility = 'hidden';
    }
};
$(document).ready(L_SEARCH.init);
