/*global data, breadcrumb_title, is_device_admin, is_group, comment_str, checkLoginPageRedirect, escapeHtml, validateDomainNameWildcardStr, IPHELPER,
D_SUMMARY_THREAT_LEVEL_MAP,R_DATE_NAVBAR, D_SUMMARY_EXECUTIVE_GROUPS, D_SUMMARY_EXECUTIVE_GROUP_NAMES, D_SUMMARY_SECURITY_GROUPS, D_SUMMARY_SECURITY_GROUP_NAMES, D_SUMMARY_SECURITY, D_SUMMARY_SECURITY_THREAT_ID, D_SUMMARY_FORMAT_GB, D_SUMMARY_FORMAT_MB, D_SUMMARY_FORMAT_KB, D_SUMMARY_EXECUTIVE_ZERO_DAY_APT,D_SUMMARY_BYTES_SPAN, D_SUMMARY_VIEW_ALL,
D_SUMMARY_BYTES, D_SUMMARY_HITS, D_SUMMARY_FILTERON, D_SUMMARY_OPEN_WEBUI, D_SUMMARY_BLOCKED_SITES, D_SUMMARY_IP4_ADDRESS, D_SUMMARY_NETWORK4_ADDRESS, D_SUMMARY_IP6_ADDRESS, D_SUMMARY_NETWORK6_ADDRESS, D_SUMMARY_FQDN, D_SUMMARY_BS_ERROR_HOST4, D_SUMMARY_BS_ERROR_NETWORK4, D_SUMMARY_BS_ERROR_HOST6, D_SUMMARY_BS_ERROR_NETWORK6, D_SUMMARY_BS_ERROR_FQDN,
D_SUMMARY_BS_UNSUPPORTED, D_SUMMARY_BS_ERROR_DESCR_LENGTH, D_SUMMARY_BS_ERROR_DESCR_CHARS, D_SUMMARY_SECURITY_FULL_NAME, S_EXPORTING_FILE, S_PROCESSING, D_SUMMARY_BOTNET_SITE_EXCEPTIONS_TITLE, D_SUMMARY_BLOCKED_SITES_TITLE, D_SUMMARY_BOTNET_SITE_EXCEPTIONS, anonymization_enabled */
var D_SUMMARY = {
    allVars: '',
    dashboardType: 'executive',
    urlCluster: '',
    urlSn: '',
    urlTz: null,
    minutes: 1440,
    connected: false,
    is_group: 0,
    device_sn: '',
    device_admin: false,
    groups: [],
    group_names: [],
    popover_data: {
        /* Data structure describing what the summary table popover should show for a given tab.
         * The grid names come from D_SUMMARY_EXECUTIVE_GROUPS and D_SUMMARY_SECURITY_GROUPS.
         * Supported fields and their defaults:
         *   {<grid>: {'show_hits': true (boolean),
         *             'show_bytes', false (boolean),
         *             'xtmwebui_link_name': null (string),
         *             'xtmwebui_link_path': null (String),
         *             'blocked_sites': false (boolean)
         *   ...}
         */
        'undetected_apt': {},
        'source': {'show_bytes': true, 'blocked_sites': true},
        'device': {'show_bytes': true},
        'domains': {'show_bytes': true, 'blocked_sites': true},
        'webblocker': {'xtmwebui_link_name': 'WebBlocker', 'xtmwebui_link_path': '/security/webblocker'},
        'destination': {'show_bytes': true, 'blocked_sites': true},
        'app': {'show_bytes': true, 'xtmwebui_link_name': 'Application Control', 'xtmwebui_link_path': '/security/appcontrol'},
        'app_cat': {'show_bytes': true, 'xtmwebui_link_name': 'Application Control', 'xtmwebui_link_path': '/security/appcontrol'},
        'protocol': {'show_bytes': true},
        'denied_apt': {},
        'denied_source': {'blocked_sites': true},
        'denied_device': {},
        'denied_destination': {'blocked_sites': true},
        'denied_webblocker': {'xtmwebui_link_name': 'WebBlocker', 'xtmwebui_link_path': '/security/webblocker'},
        'denied_app': {'xtmwebui_link_name': 'Application Control', 'xtmwebui_link_path': '/security/appcontrol'},
        'denied_app_cat': {'xtmwebui_link_name': 'Application Control', 'xtmwebui_link_path': '/security/appcontrol'},
        'denied_protocol': {},
        'denied_ips': {},
        'denied_gav': {},
        'denied_botnet': {'blocked_exception_sites': true, 'blocked_reason': '1'}
    },
    dashboard_reports: {
        'executive' : ['undetected_apt,source,device',
                      'domains,webblocker,destination',
                      'app,app_cat,protocol'],
        'security' : ['denied_apt,denied_botnet,denied_source,denied_device',
                     'denied_destination,denied_webblocker,denied_app',
                     'denied_app_cat,denied_protocol,denied_ips,denied_gav']
    },
    blockedSitesVals: {},  // used to preserve user input while changing types
    blockedSitesComment: '',
    blockedReason: '',
    byte_color: 'rgb(65,100,48)',
    hit_color: 'rgb(31,119,180)',
    deny_color: 'rgb(240, 16, 0)',
    data_filter_selector: '',   // Filter, e.g. 'destination'
    data_filter_data: '',       // Filter data, e.g. 'muser@wgti.net'
    drilldown: '',
    total_entities: 0,
    total_bytes: 0,
    total_cxns: 0,
    chartMaxBytes: 1,
    chartMaxHits: 1,
    tidResize: null,

    init: function () {
        D_SUMMARY.allVars = $.getUrlVars();
        D_SUMMARY.urlSn = $.getUrlVar('sn');

        D_SUMMARY.dashboardType = data.dashboard_type;
        D_SUMMARY.initUI();
        D_SUMMARY.initEvents();
    },

    initUI: function () {
        $(".frontpanelUnit").hide();

        // management connection up/down
        if (data.control) {
            D_SUMMARY.connected = data.control.connected === 1;
        }

        // store if we are working with a device group or not
        D_SUMMARY.is_group = is_group;

        // store if user is an admin for this device or not
        D_SUMMARY.device_admin = is_device_admin;

        // default comment string for xtm config changes
        D_SUMMARY.blockedSitesComment = comment_str;

        // device serial number with cluster case handling
        var idx;
        var member;
        D_SUMMARY.device_sn = data.log_current_sn;
        if (D_SUMMARY.connected && data.members) {
            for (idx = 0; idx < data.members.length; idx++) {
                member = data.members[idx];
                if (member.control.role === 'master') {
                    D_SUMMARY.device_sn = member.id;
                }
            }
        }

        D_SUMMARY.groups = D_SUMMARY_EXECUTIVE_GROUPS;
        D_SUMMARY.group_names = D_SUMMARY_EXECUTIVE_GROUP_NAMES;
        if (D_SUMMARY.dashboardType === 'security') {
            D_SUMMARY.groups = D_SUMMARY_SECURITY_GROUPS;
            D_SUMMARY.group_names = D_SUMMARY_SECURITY_GROUP_NAMES;
            $(".root").html(D_SUMMARY_SECURITY);
            $('.progress .bar').css('background-color', 'red');
        }
        var group = '';
        var name = '';
        var i = 0;
        for (i = 0; i < D_SUMMARY.groups.length; i++) {
            group = D_SUMMARY.groups[i];
            name = D_SUMMARY.group_names[i];
            D_SUMMARY.createGridDiv(group, name);
        }
    },

    initEvents: function () {
        $(document).on('click', '#root_breadcrumb', function (eo) {
            $("#breadcrumb_lhs").html('<span class="">' + breadcrumb_title + '</span>');

            D_SUMMARY.toggleZoomOptions(false);
            D_SUMMARY.toggleFilterOptions(false, D_SUMMARY.data_filter_selector, D_SUMMARY.data_filter_data);
            D_SUMMARY.getChartData();
        });
        $(document).on('click', '#data_filter_data', function (eo) {
            D_SUMMARY.toggleZoomOptions(false);
            D_SUMMARY.toggleFilterOptions(true, D_SUMMARY.data_filter_selector, D_SUMMARY.data_filter_data);
            D_SUMMARY.getChartData();
        });
        $(document).on('click', '.drilldown_link', function (eo) {
            $('#summary_popover').hide();
            var filter_selector = this.name; //"source";
            var filter_data = this.title; // "10.0.1.3";
            if (filter_selector === 'denied_apt' || filter_selector === 'undetected_apt') {
                filter_data = filter_data.substring(D_SUMMARY_SECURITY_THREAT_ID.length);
            }
            var name_index = filter_data.indexOf(D_SUMMARY_SECURITY_FULL_NAME);
            if (name_index > 0) {
                filter_data = filter_data.substring(0, name_index - 1);
            }
            D_SUMMARY.toggleFilterOptions(true, filter_selector, filter_data);
            D_SUMMARY.getChartData();
        });
        $(document).on('click', '.zoom_link', function (eo) {
            var group = this.id;
            // For 'view all' links, remove _all from the id
            group = group.replace('_all', '');
            var name = $('#' + group).text();
            if (D_SUMMARY.drilldown !== '') {
                return;
            }

            D_SUMMARY.drilldown = group;

            $('.frontpanelUnit').hide();
            D_SUMMARY.toggleZoomOptions(true, name);
            D_SUMMARY.getChartData();
        });

        $(window).bind('resizeEnd', function () {
            D_SUMMARY.doResize();
        });

        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen for a click on this div, it means the date changed
            // and a refresh is needed
            D_SUMMARY.getChartData();
        });
        $('#exec_sum_pdf').find('img').click(function (eo) {
            eo.preventDefault();
            var pdf_state = $(this).css('cursor');
            if (pdf_state === 'default') {
                return;
            }
            var startEnd = R_DATE_NAVBAR.getStartEndIsoStr();
            var startTime = startEnd[0];
            var endTime = startEnd[1];

            startTime = R_DATE_NAVBAR.convertDateStr2GMT(startTime + ':00');
            endTime = R_DATE_NAVBAR.convertDateStr2GMT(endTime + ':00');

            var repType = 'exec_summary';

            WGRD.progressModal(S_EXPORTING_FILE, S_PROCESSING);

            $.ajax({
                url: "/report/saveAsPdf?serial=" + D_SUMMARY.urlSn + "&client_tz=" + WGRD.client_tz + "&start_time=" + startTime + "&end_time=" + endTime + "&report_type=" + repType,
                type: 'POST',
                contentType: 'application/json',
                success: function (data) {
                    if (!data.status) {
                        if (data.message) {
                            WGRD.okMessageModal(data.message, '');
                        }
                        return true;
                    }
                    var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                    window.location = "/report/get_pdf_file?serial=" + D_SUMMARY.urlSn + file_args;
                    return false;
                },
                complete: function (filename) {
                    WGRD.progressModalClose();
                }
            });
        });

        $('#summary_popover_close_btn').click(function (eo) {
            // close the popover
            $('#summary_popover').hide();
        });

        $(document).click(function (eo) {
            // hide the popover if anything outside of the popover is selected
            var $target = $(eo.target);
            if ($('#summary_popover').is(':visible') && $target.parents('#summary_popover').length === 0) {
                $('#summary_popover').hide();
            }
            return true;
        });

        $(document).on('click', '.popover_link', function (eo) {
            // create the popover
            var grid_name = this.name;  // eg, "source";
            var grid_title = this.title;
            D_SUMMARY.showSummaryPopover("#div_" + grid_name + "_grid", grid_name, grid_title, eo);

            // block the document's click handler
            if (eo.stopPropagation) {
                eo.stopPropagation();
            } else if (window.event) {
                window.event.cancelBubble = true;
            }
        });

        $(document).on('click', '.bs_link', function (eo) {
            D_SUMMARY.doBlockedSites($(eo.target).text());
        });
        $(document).on('focus', '#bs_type', function (eo) {
            D_SUMMARY.preserveBlockedSitesTypeVal();
        });
        $(document).on('change', '#bs_type', function (eo) {
            D_SUMMARY.updateBlockedSitesType();
        });
        $(document).on('change keyup', '#bs_type, #bs_value, #bs_descr', function (eo) {
            $('#bs_error').hide();
        });
    },

    unZoom: function () {
        var selector = "#" + D_SUMMARY.minutes;
        $(selector).click();
    },

    toggleZoomOptions: function (enable, zoom_selector) {
        if (enable) {
            $("#breadcrumb_lhs").html('');
            $("#breadcrumb_lhs").html('<span id="root_breadcrumb" class=""><a href="#">' + breadcrumb_title + '</a></span>');
            if (D_SUMMARY.data_filter_selector !== '') {
                $("#breadcrumb_lhs").append('<span id="data_filter_divider" class="divider">/</span><span><a href="#" id="data_filter_data"></a></span>');
                $("#data_filter_data").text(D_SUMMARY.data_filter_data);
            }
            $("#breadcrumb_lhs").append('<span class="divider">/</span><span>' + zoom_selector + '</span>');
        } else {
            if (D_SUMMARY.drilldown !== '') {
                $("#sum_top_drilldown_" + D_SUMMARY.drilldown).remove();
            }
            D_SUMMARY.drilldown = '';
        }
    },

    toggleFilterOptions: function (enable, filter_selector, filter_data) {
        if (enable) {
            if (D_SUMMARY.drilldown !== '') {
                D_SUMMARY.toggleZoomOptions(false);
            }

            $("#breadcrumb_lhs").html('');
            $("#breadcrumb_lhs").html('<span id="root_breadcrumb" class=""><a href="#">' + breadcrumb_title + '</a></span>');
            $("#breadcrumb_lhs").append('<span id="data_filter_divider" class="divider">/</span><span id="data_filter_data"></span>');

            $('#tab_' + filter_selector).hide();
            D_SUMMARY.data_filter_selector = filter_selector;
            D_SUMMARY.data_filter_data = filter_data;
            if ((filter_selector === 'denied_apt' || filter_selector === 'undetected_apt') && filter_data.indexOf(D_SUMMARY_SECURITY_THREAT_ID) !== 0) {
                D_SUMMARY.data_filter_data = D_SUMMARY_SECURITY_THREAT_ID + filter_data;
            }
            $("#data_filter_data").html(escapeHtml(D_SUMMARY.data_filter_data));
        } else {
            $('#tab_' + D_SUMMARY.data_filter_selector).show();
            D_SUMMARY.data_filter_selector = "";
            D_SUMMARY.data_filter_data = "";

            $("#data_filter_data").html("");

        }
    },

    getChartData: function (start, end) {
        D_SUMMARY.widgets_processed = 0;
        // Disable click event on breadcrumb and widget links till all the widgets are loaded
        $('.frontpanelUnit, .breadcrumb').addClass('disableLink');
        $("#progress .bar").css('width', '5%');
        if (D_SUMMARY.urlCluster === null) {
            D_SUMMARY.urlCluster = 'NONE';
        }
        D_SUMMARY.toggleSpinner(true);

        var start_dt = $("#reports_toolbar_start").text();
        var end_dt = $("#reports_toolbar_end").text();
        if (start_dt !== '') {
            start_dt = start_dt.substring(0, start_dt.length - 2).trim(); //Remove the '-' from date at the end'
            start_dt = $.getDateLocalToSecs(start_dt);
        }
        if (end_dt !== '') {
            end_dt = $.getDateLocalToSecs(end_dt);
        }

        D_SUMMARY.dashboard_begin = 'get_summary_data?';
        D_SUMMARY.url_group = 'groups=';
        D_SUMMARY.dashboard_url_end = '';
        D_SUMMARY.url_group_index = 0;
        D_SUMMARY.dashboard_group_index = 0;
        var i;
        if (D_SUMMARY.drilldown === '') {
            for (i = 0; i < D_SUMMARY.groups.length; i++) {
                $("#sum_top_" + D_SUMMARY.groups[i]).hide();
            }
            D_SUMMARY.url_group += D_SUMMARY.dashboard_reports[D_SUMMARY.dashboardType][D_SUMMARY.dashboard_group_index];

        } else {
            $("#progress .bar").css('width', '100%');
            D_SUMMARY.url_group += D_SUMMARY.drilldown + '&drilldown=1';
        }

        var filter_url = D_SUMMARY._getFilterURL();

        if (D_SUMMARY.dashboardType === 'security') {
            D_SUMMARY.dashboard_url_end += '&disp_deny=1';
        }
        D_SUMMARY.dashboard_url_end += '&sn=' + D_SUMMARY.urlSn + '&start_time=' + start_dt + '&end_time=' + end_dt;
        var dashboard_url = D_SUMMARY.dashboard_begin + D_SUMMARY.url_group + filter_url + D_SUMMARY.dashboard_url_end;
        D_SUMMARY.fetchData(dashboard_url);
    },

    _getFilterURL: function () {
        var filter_url = '';
        var filter_selector = D_SUMMARY.data_filter_selector;
        if (filter_selector.indexOf('denied_') === 0) {
            filter_selector = filter_selector.substring('denied_'.length);
        }
        if (D_SUMMARY.data_filter_selector !== undefined && D_SUMMARY.data_filter_selector !== '') {
            var filter_data = D_SUMMARY.data_filter_data;
            if (filter_data.indexOf(D_SUMMARY_SECURITY_THREAT_ID) === 0) { //If THREAT ID is at the beginning
                filter_data = filter_data.substring(D_SUMMARY_SECURITY_THREAT_ID.length);
            }
            filter_url = '&filter=' + filter_selector + '&filterdata=' + encodeURIComponent(filter_data);
        }
        return filter_url;
    },

    fetchData: function (url) {
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: checkLoginPageRedirect,
            success: D_SUMMARY.onDataReceived
        });
    },

    toggleSpinner: function (b) {
        if (b) {
            $('#pdf_link').css('cursor', 'default');
            $("#progress").show();
        } else {
            $("#progress").hide();
            $('#pdf_link').css('cursor', 'pointer');
        }
    },

    onDataReceived: function (data) {
        $.jqplot.config.enablePlugins = true; // on the page before plot creation.

        var columns = {};
        var widgets_request_count = D_SUMMARY.dashboard_reports[D_SUMMARY.dashboardType].length - 1;
        columns.col_names = data.col_names;
        columns.col_model = data.col_model;

        D_SUMMARY.chartMaxBytes = 1;
        D_SUMMARY.chartMaxHits = 1;

        var group = '';
        var i = 0;
        var grid_selector = '';
        D_SUMMARY.total_entities = 0;
        D_SUMMARY.total_bytes = 0;
        D_SUMMARY.total_cxns = 0;
        $("#entity_info").hide();
        if (D_SUMMARY.drilldown === '') {
            var cur_group = D_SUMMARY.dashboard_reports[D_SUMMARY.dashboardType][D_SUMMARY.dashboard_group_index];
            var cur_group_list = cur_group.split(',');
            for (i = 0; i < cur_group_list.length; i++) {
                group = cur_group_list[i];
                if (group === D_SUMMARY.data_filter_selector) {
                    $("#sum_top_" + group).hide();
                    continue;
                }
                D_SUMMARY.createGrid("#sum_top_" + group, "#div_" + group + "_grid", "#div_" + group + "_pager", group, data.items[i], columns);
            }
            // Refresh grids so max is applied correctly
            for (i = 0; i < cur_group_list.length; i++) {
                grid_selector = "#div_" + cur_group_list[i] + "_grid";
                $(grid_selector).trigger("reloadGrid");
            }
        } else {
            D_SUMMARY.toggleSpinner(false);
            group = D_SUMMARY.drilldown;
            D_SUMMARY.createGrid("#sum_top_" + group, "#div_" + group + "_grid", "#div_" + group + "_pager", group, data.items[0], columns);
            $("#entity_info").show();
            grid_selector = "#div_" + D_SUMMARY.drilldown + "_grid";
            $(grid_selector).trigger('reloadGrid');

        }
        $("#bytecnt").html($.commaify(D_SUMMARY.total_bytes));
        $("#hitcnt").html(D_SUMMARY.total_entities);
        $("#cxncnt").html(D_SUMMARY.total_cxns);
        if (D_SUMMARY.drilldown === '' && (D_SUMMARY.dashboard_group_index < widgets_request_count)) {
            D_SUMMARY.dashboard_group_index += 1;
            var percent_complete = ((D_SUMMARY.dashboard_group_index + 1) / D_SUMMARY.dashboard_reports[D_SUMMARY.dashboardType].length) * 100;
            $("#progress .bar").css('width', percent_complete + '%');
            var filter_url = D_SUMMARY._getFilterURL();
            var url_group = 'groups=' + D_SUMMARY.dashboard_reports[D_SUMMARY.dashboardType][D_SUMMARY.dashboard_group_index];
            var dashboard_url = D_SUMMARY.dashboard_begin + url_group + filter_url + D_SUMMARY.dashboard_url_end;
            D_SUMMARY.fetchData(dashboard_url);
        } else {
            $("#progress .bar").css('width', 0);
            D_SUMMARY.toggleSpinner(false);
        }
        D_SUMMARY.doResize();
        D_SUMMARY.tidResize = setTimeout(D_SUMMARY.doResize, 1000); // Delay firing another resize to help initial display if scrollbar isn't shown yet
        // When all the widgets are loaded, remove the disable class
        if (D_SUMMARY.widgets_processed === widgets_request_count || D_SUMMARY.drilldown !== '') {
            setTimeout(function () {
                $('.frontpanelUnit, .breadcrumb').removeClass('disableLink');
            }, 500);
        }
        D_SUMMARY.widgets_processed++;
    },

    doResize: function () {
        clearInterval(D_SUMMARY.tidResize);
        var fpwidth = $("#main_div_row").width();
        fpwidth -= $(".date_navbar_td").width();
        var marginleft = parseInt($(".frontpanelUnit").css('margin-left'), 10);
        var marginright = parseInt($(".frontpanelUnit").css('margin-right'), 10);
        var CHARTCOUNT = 1;
        $(".frontpanelUnitBig").height('auto');
        if (D_SUMMARY.drilldown === '' && fpwidth > 800) {
            CHARTCOUNT = 2;
            $(".frontpanelUnitBig").height(385); // Set explicit height for div containing grid
        }

        var fp_div_width = (fpwidth / CHARTCOUNT) - (marginright + marginleft) - 4;
        $(".frontpanelUnitBig").width(fp_div_width);
        $(".resizableGrid").setGridWidth(fp_div_width - 1);
    },

    linkFormatter: function (cellvalue, options, rowObject) {
        var name = escapeHtml(rowObject.name);
        var title = name;
        var row_detail = rowObject.detail;
        if (rowObject.group === 'denied_apt' || rowObject.group === 'undetected_apt') {
            title = D_SUMMARY_SECURITY_THREAT_ID + title;
            name = escapeHtml(row_detail);
        }
        if (row_detail.length > 38) {
            title = title + '\n' + D_SUMMARY_SECURITY_FULL_NAME + rowObject.detail;
        }
        var link_class = 'popover_link';
        var href_str = '';
        if (D_SUMMARY.is_group || !D_SUMMARY.connected) {
            link_class = 'drilldown_link';
            href_str = 'href="#" ';
        }
        var href = '<a ' + href_str + 'name="' + rowObject.group + '"title="' + title + '" class="' + link_class + '" style="cursor: pointer;">' + name + '</a>';
        return href;
    },

    linkUnFormatter: function (cellvalue, options, rowObject) {
        return escapeHtml(cellvalue);
    },

    chartFormatter: function (cellvalue, options, rowObject) {
        var data = 0;
        var div = '';
        var div_w = 0;
        var color_class = 'pctbar_hits';
        var font_class = '';
        var percent = 0;
        if (options.colModel.index === 'bytes') {
            var bytes = parseInt(rowObject.bytes, 10);
            data = $.formatBytes(bytes, D_SUMMARY_BYTES_SPAN.format(D_SUMMARY_FORMAT_GB), D_SUMMARY_BYTES_SPAN.format(D_SUMMARY_FORMAT_MB), D_SUMMARY_BYTES_SPAN.format(D_SUMMARY_FORMAT_KB), ' ');

            percent = parseInt((bytes / D_SUMMARY.chartMaxBytes) * 100, 10);
            div_w = (percent > 1 || bytes === 0) ? percent : 1;
            color_class = 'pctbar_byte';
            div = '<div class="pctbar progress-inverse pctbar"><div class="' + color_class
                + ' pctbar-bar" style="width:' + div_w + '%;"></div></div>'
                + '<div style="width:50%;">' + data + '</div>';
        } else if (options.colModel.index === 'threat_level') {
            data = rowObject.threat_level;
            font_class = "td-threat-level";
            if (data === 'high') {
                color_class = "threat-high";
            } else if (data === 'medium') {
                color_class = "threat-med";
            } else {
                color_class = "threat-low";
            }
            div = '<div class="pctbar pctbar-circle"><div class="pctbar-bar ' + font_class + ' ' + color_class + '"></div></div><span class="table-text">' + D_SUMMARY_THREAT_LEVEL_MAP[data] + '</span>';
        } else {
            data = $.commaify(rowObject.connections);
            percent = parseInt((rowObject.connections / D_SUMMARY.chartMaxHits) * 100, 10);
            div_w = (percent > 1) ? percent : 1;
            if (D_SUMMARY.dashboardType === 'security') {
                color_class = 'pctbar_deny';
            } else {
                color_class = 'pctbar_hits';
            }
            div = '<div class="pctbar progress-inverse pctbar"><div class="' + color_class
                + ' pctbar-bar" style="width:' + div_w + '%;"></div></div>'
                + '<div style="width:50%;">' + data + '</div>';
        }

        return div;
    },

    createGridDiv: function (group, group_name) {
        $("#sum_top_" + group).remove();
        var title = '';
        if (group === 'undetected_apt') {
            title = D_SUMMARY_EXECUTIVE_ZERO_DAY_APT;
        }
        var div_html = '<div id="sum_top_' + group + '" class="frontpanelUnit frontpanelUnitBig">'
                      + '<div class="frontpanelUnitHeader" title="' + title + '">'
                      + '<div class="zoom_link pull-right breadcrumb pointer" id="' + group + '_all' + '">' + D_SUMMARY_VIEW_ALL + '</div>'
                      + '<div class="zoom_link pointer" id="' + group + '">' + group_name + '</div>'
                      + '</div>'
                      + '<div class="grid">'
                        + '<div id="chart_' + group + '" class="shown">'
                          + '<div class="logView">'
                            + '<div id="div_' + group + '" class="cl">'
                              + '<table id="div_' + group + '_grid" class="resizableGrid scroll" ></table>'
                              + '<div id="div_' + group + '_pager" class="scroll" style="text-align:right;"></div>'
                            + '</div>'
                          + '</div>'
                        + '</div>'
                      + '</div>'
                    + '</div>';
        $("#div_dashboard_wrapper").append(div_html);
        $("#sum_top_" + group).hide();
    },

    createGrid: function (div_selector, grid_selector, pager_selector, group, series, columns) {
        // Unload the grid and then recreate it
        jQuery(grid_selector).GridUnload(grid_selector);

        if (series === undefined || series.length === 0) {
            $(div_selector).hide();
            return;
        }
        $(div_selector).show();

        var total_bytes = 0;

        $(grid_selector).jqGrid({
            datatype: "local",
            altRows: true,
            altclass: 'gridAltRow',
            autoencode: true,
            colNames: columns.col_names,
            colModel: columns.col_model,
            rowNum: -1,
            height: 'auto',
            loadonce: true,
            sortname: 'bytes',
            sortorder: 'desc',
            scroll: false,
            autowidth: true,
            forceFit: false,
            shrinkToFit: true
        }).navGrid();

        var total_entities = 0;
        var total_cxns = 0;
        var i = 0;
        var hits = 0;
        var bytes = 0;
        total_bytes = 0;
        if (series !== undefined) {
            for (i = 0; i < series.length; i++) {
                if (series[i].name === 'other') {
                    continue;
                }
                D_SUMMARY.chartMaxBytes = Math.max(D_SUMMARY.chartMaxBytes, series[i].bytes);
                D_SUMMARY.chartMaxHits = Math.max(D_SUMMARY.chartMaxHits, series[i].connections);
            }
            for (i = 0; i < series.length; i++) {
                if (series[i].name === 'other') {
                    continue;
                }
                hits = series[i].connections;
                bytes = parseInt(series[i].bytes, 10);
                series[i].group = group;
                series[i].byte_color = D_SUMMARY.byte_color;
                series[i].hit_color = D_SUMMARY.hit_color;
                $(grid_selector).jqGrid('addRowData', i, series[i]);
                total_entities += 1;
                total_cxns += hits;
                total_bytes += bytes;
            }
            D_SUMMARY.total_entities += total_entities;
            D_SUMMARY.total_bytes += total_bytes;
            D_SUMMARY.total_cxns += total_cxns;
            $(grid_selector).showCol('bytes');
            $(grid_selector).setGridParam({ rowNum: series.length });
            $(grid_selector).setColProp('name', { formatter: D_SUMMARY.linkFormatter, unformat: D_SUMMARY.linkUnFormatter });
            $(grid_selector).setColProp('bytes', { formatter: D_SUMMARY.chartFormatter });
            if (total_bytes === 0 || isNaN(D_SUMMARY.chartMaxBytes)) {
                $(grid_selector).hideCol('bytes');
                $(grid_selector).setGridParam({ sortname: 'connections' });
            }
            $(grid_selector).setColProp('connections', { formatter: D_SUMMARY.chartFormatter });

            // In executive dashboard report, show column "threat_level" in section
            // (Zero-day APT report), and use "level_order" to order.
            if (group === 'undetected_apt') {
                $(grid_selector).showCol('threat_level');
                $(grid_selector).setGridParam({ sortname: 'level_order' });
                $(grid_selector).setColProp('threat_level', { formatter: D_SUMMARY.chartFormatter });
                $(grid_selector).hideCol('level_order');
            } else {
                $(grid_selector).hideCol('threat_level');
                $(grid_selector).hideCol('level_order');
            }
        }
    },

    doBlockedSites: function (bs_val) {
        var bs_type = D_SUMMARY.detectBsType(bs_val);
        $('#summary_popover').hide();
        WGRD.doModal('#bs_dlg',
                     D_SUMMARY.initBlockedSitesModal,
                     D_SUMMARY.saveBlockedSitesModal,
                     {'type': bs_type, 'value': bs_val},
                     null,
                     true);
    },

    initBlockedSitesModal: function (data) {
        var d_val = data.value;
        var d_type = data.type;
        var title = (D_SUMMARY.blockedReason === '1') ? D_SUMMARY_BOTNET_SITE_EXCEPTIONS_TITLE : D_SUMMARY_BLOCKED_SITES_TITLE;
        var i;

        // initialize the UI before showing the dialog
        $('#bs_type').val(d_type);
        $('#bs_value').val(d_val);
        $('#bs_descr').val(D_SUMMARY.blockedSitesComment);
        $("#bs_title").html(title);

        D_SUMMARY.blockedSitesVals = {'ipv4_host': '', 'ipv4_net': '', 'ipv6_host': '', 'ipv6_net': '', 'fqdn': ''};
        D_SUMMARY.blockedSitesVals[d_type] = d_val;
        if (d_type === 'ipv4_host') {
            // pre-populate the network value if it is a host ip
            i = d_val.lastIndexOf('.');
            if (i > 0) {
                D_SUMMARY.blockedSitesVals.ipv4_net = d_val.substring(0, i + 1) + '0/24';
            }
        }

        D_SUMMARY.updateBlockedSitesType();

        return true;
    },

    saveBlockedSitesModal: function () {
        // validate the blocked sites value based on the selected type
        var bs_type = $('#bs_type').val();
        var bs_val = $('#bs_value').val();
        var descr = $('#bs_descr').val();

        if (bs_type === 'ipv4_host') {
            // ipv4 host
            if (!IPHELPER.validIP4(bs_val)) {
                return D_SUMMARY_BS_ERROR_HOST4;
            }
        } else if (bs_type === 'ipv4_net') {
            // ipv4 network
            if (!IPHELPER.validNetwork4(bs_val)) {
                return D_SUMMARY_BS_ERROR_NETWORK4;
            }
        } else if (bs_type === 'ipv6_host') {
            // ipv6 network
            if (!IPHELPER.validIP6(bs_val)) {
                return D_SUMMARY_BS_ERROR_HOST6;
            }
        } else if (bs_type === 'ipv6_net') {
            // ipv6 network
            if (!IPHELPER.validNetwork6(bs_val)) {
                return D_SUMMARY_BS_ERROR_NETWORK6;
            }
        } else if (bs_type === 'fqdn') {
            // FQDN
            if (!validateDomainNameWildcardStr(bs_val)) {
                return D_SUMMARY_BS_ERROR_FQDN;
            }
        } else {
            return D_SUMMARY_BS_UNSUPPORTED;
        }

        // validate the description
        if (descr.length > 127) {
            return D_SUMMARY_BS_ERROR_DESCR_LENGTH;
        }
        if (!/^[\w\d\s_\-+.*:@\/\(\)]*$/.test(descr)) {
            // allow letters, numbers, ' ', '_', '-', '+', '.', '*', ':', '@', '/', '(', ')'
            return D_SUMMARY_BS_ERROR_DESCR_CHARS;
        }

        // disable the controls and show the spinner
        $('#bs_error').hide();
        WGRD.enableUIElements(false, ['#bs_type', '#bs_value', '#bs_descr', '#bs_close', '#bs_ok']);
        $('#bs_loading').show();

        // make the device config change
        $.ajax({
            url: 'add_blocked_site',
            type: 'POST',
            dataType: 'json',
            data: {'device_id': D_SUMMARY.device_sn, 'bs_type': bs_type, 'bs_value': bs_val, 'bs_description': descr, 'bs_reason': D_SUMMARY.blockedReason},
            success: function (data, textStatus, jqXHR) {
                // close the dialog or show the error
                if (data.success) {
                    $('#bs_dlg').modal('hide');
                } else {
                    $('#bs_error').html(data.error);
                    $('#bs_error').show();
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                // show the error
                $('#bs_error').html(errorThrown);
                $('#bs_error').show();
            },
            complete: function (jqXHR, textStatus) {
                // hide the spinner and enable the controls
                WGRD.enableUIElements(true, ['#bs_type', '#bs_value', '#bs_descr', '#bs_close', '#bs_ok']);
                $('#bs_loading').hide();
            }
        });

        return null;  // no error
    },

    updateBlockedSitesType: function () {
        var val = $('#bs_type').val();
        if (val === 'ipv4_host') {
            $('#bs_value_label').html(D_SUMMARY_IP4_ADDRESS);
        } else if (val === 'ipv4_net') {
            $('#bs_value_label').html(D_SUMMARY_NETWORK4_ADDRESS);
        } else if (val === 'ipv6_host') {
            $('#bs_value_label').html(D_SUMMARY_IP6_ADDRESS);
        } else if (val === 'ipv6_net') {
            $('#bs_value_label').html(D_SUMMARY_NETWORK6_ADDRESS);
        } else if (val === 'fqdn') {
            $('#bs_value_label').html(D_SUMMARY_FQDN);
        }
        $('#bs_value').val(D_SUMMARY.blockedSitesVals[val]);
    },

    preserveBlockedSitesTypeVal: function () {
        var val = $('#bs_type').val();
        D_SUMMARY.blockedSitesVals[val] = $('#bs_value').val();
    },

    detectBsType: function (str) {
        if (!str) {
            return 'fqdn';
        }
        if (str.indexOf(':') >= 0 && str.indexOf('/') >= 0) {
            return 'ipv6_net';
        }
        if (str.indexOf(':') >= 0) {
            return 'ipv6_host';
        }
        if (str.indexOf('/') >= 0) {
            return 'ipv4_net';
        }
        if (IPHELPER.validIP4(str)) {
            return 'ipv4_host';
        }

        return 'fqdn';
    },

    showSummaryPopover: function (grid_selector, group, title, e) {
        // show the table-specific popover
        if (D_SUMMARY.popover_data.hasOwnProperty(group)) {
            var group_data = D_SUMMARY.popover_data[group];
            var show_bytes = D_SUMMARY.getPopoverDataVal(group_data, 'show_bytes', false);
            var webui_link_name = D_SUMMARY.getPopoverDataVal(group_data, 'xtmwebui_link_name', null);
            var webui_link_path = D_SUMMARY.getPopoverDataVal(group_data, 'xtmwebui_link_path', null);
            var blocked_sites = D_SUMMARY.getPopoverDataVal(group_data, 'blocked_sites', false) && D_SUMMARY.device_admin;
            var blocked_exception_sites = D_SUMMARY.getPopoverDataVal(group_data, 'blocked_exception_sites', false) && D_SUMMARY.device_admin;
            D_SUMMARY.blockedReason = D_SUMMARY.getPopoverDataVal(group_data, 'blocked_reason', '');

            var valid = D_SUMMARY.createSummaryPopover(grid_selector, title, show_bytes, webui_link_name, webui_link_path, blocked_sites, blocked_exception_sites, e);
            if (valid) {
                // popover height/width
                var popover_width = 350;
                var popover_height = 105 + (show_bytes ? 20 : 0) + (webui_link_name ? 20 : 0) + (blocked_sites ? 20 : 0) + (blocked_exception_sites ? 20 : 0);
                D_SUMMARY.positionSummaryPopover(popover_width, popover_height, e);
            }
        }
    },

    createSummaryPopover: function (grid_selector, title, show_bytes, webui_link_name, webui_link_path, blocked_sites, blocked_exception_sites, e) {
        var $td = $(e.target).closest(grid_selector + ' td');
        var $tr = $td.closest('tr.jqgrow');
        var row_id = $tr.attr('id');
        var row_data;
        var group_name;
        var show_blocked_sites;

        if (!row_id) {
            return false;
        }

        // get the row data
        $(grid_selector).jqGrid('setSelection', row_id);
        row_data = $(grid_selector).getRowData(row_id);
        group_name = row_data.group;
        var name_raw = row_data.name;
        var bytes_val = $('div + div', $("<div>" + row_data.bytes + "</div>")).text().trim();
        var conns_val = $('div + div', $("<div>" + row_data.connections + "</div>")).text();
        if (name_raw.length > 38) {
            name_raw = '...' + name_raw.substring(name_raw.length - 35);
        }
        var filter_link = '<a href="#" name="' + row_data.group + '" title="' + title + '" class="drilldown_link" style="cursor:pointer;">' + name_raw + '</a>';
        // title text
        $("#summary_popover_title").html(name_raw);

        // content
        var resources = '<table>';
        if (show_bytes) {
            resources += '<tr><td>' + D_SUMMARY_BYTES + ' </td><td>' + bytes_val + '</td></tr>';
        }
        resources += '<tr><td>' + D_SUMMARY_HITS + ' </td><td>' + conns_val + '</td></tr>';
        resources += '</table>';
        resources += '<div style="padding-top:7px;">' + D_SUMMARY_FILTERON + ' ' + filter_link + '</div>';
        // Show 'Add to blocked sites list:' if anonymization is disabled 
        // or if widget is not 'Top Clients', 'Top Mobile Devices', 'Top Blocked Clients' or 'Top Blocked Mobile Devices'
        if (blocked_sites) {
            if (anonymization_enabled === 1 &&
                    ((group_name === 'source') ||
                     (group_name === 'denied_source') ||
                     (group_name === 'device') ||
                     (group_name === 'denied_device'))) {
                show_blocked_sites = false;
            } else {
                show_blocked_sites = true;
            }
            if (show_blocked_sites) {
                resources += '<div style="padding-top:7px;">' + D_SUMMARY_BLOCKED_SITES + ' <a class="bs_link" href="#">' + name_raw + '</a>';
            }
        }
        if (blocked_exception_sites) {
            resources += '<div style="padding-top:7px;">' + D_SUMMARY_BOTNET_SITE_EXCEPTIONS + ' <a class="bs_link" href="#">' + name_raw + '</a>';
        }
        if (webui_link_name && webui_link_path) {
            resources += '<div style="padding-top:7px;">' + D_SUMMARY_OPEN_WEBUI + ' <a class="xtmwebui_link" href="/control/xtmwebui?sn=' + D_SUMMARY.device_sn + '&target_page=' + webui_link_path + '" target="xtmwebui_' + D_SUMMARY.device_sn + '">' + webui_link_name + '</a>';
        }
        resources += '</div>';
        $("#summary_popover_content").html(resources);

        // show the popover
        $("#summary_popover").show();

        return true;
    },

    positionSummaryPopover: function (popover_width, popover_height, e) {
        // the target popover location is just to the right of the trigger element
        // but, we shift it to the left side or top or bottom if it hits the edge of the page
        var viewport_bottom, doc_width;
        var popover_top, popover_left;
        var v_offset, navbar_height;
        var pad_small = 5, pad = 10, pad_medium = 15, big_pad = 25;
        var target_width = $(e.target).width();
        if (target_width > 100) {
            target_width = 100;
        }
        var targetX = $(e.target).offset().left + target_width;
        var targetY = $(e.target).offset().top + $(e.target).height() / 2;
        var wgrd_nav = $('#wgrd_nav');
        var main_div = $('#main_div');
        var left_edge = 0;
        var popover = $("#summary_popover");

        doc_width = $(document).width();
        viewport_bottom = $(window).height() + $(window).scrollTop();

        // find the left edge
        if (wgrd_nav && main_div && !main_div.hasClass('nav-closed')) {
            left_edge = wgrd_nav.width() + pad;
        } else {
            left_edge = big_pad;
        }

        // clear alignment
        popover.removeClass("top bottom left right");

        // adjust up/down as needed
        popover_top = targetY - (0.5 * popover_height);  // center vertically
        navbar_height = $('.navbar-fixed-top').height() || 0;  // account for top nav-bar height
        v_offset = e.pageY - e.clientY + navbar_height;

        // set popover arrow to point up or down at top/bottom of page
        if (popover_top < v_offset) {
            popover_top = e.pageY + pad;
            popover.addClass("bottom");
        } else if (popover_top + popover_height > viewport_bottom) {
            popover_top = targetY - popover_height - pad;
            popover.addClass("top");
        }

        // adjust right/left and update arrow, if needed
        if (popover.hasClass('top') || popover.hasClass('bottom')) {
            // move left/right, but keep top/bottom arrow
            popover_left = targetX - (0.5 * popover_width) + pad;
            if (popover_left + popover_width > doc_width) {
                popover_left = doc_width - popover_width - pad;
            } else if (popover_left < left_edge) {
                popover_left = left_edge;
            }
        } else {
            // change alignment as it nears the edge of the window
            popover_left = targetX + pad_medium;
            popover.removeClass("top bottom");
            popover.addClass("right");
            if (popover_left + popover_width > doc_width) {
                if (popover_left - popover_width - target_width > left_edge) {
                    popover_left -= (popover_width + target_width);
                    popover.removeClass("right");
                    popover.addClass("left");
                    popover_left -= (2 * pad_medium) + pad_small;
                }
            }
        }

        popover.offset({ top: popover_top, left: popover_left });
        popover.width(popover_width);
        popover.height(popover_height);
    },

    getPopoverDataVal: function (data, field, default_val) {
        // use hasOwnProperty() since jslint doesn't let me use 'in'
        return (data.hasOwnProperty(field)) ? data[field] : default_val;
    }

};
$(document).ready(D_SUMMARY.init);
