#!/bin/sh
# wgdevice-ssh.sh - Setup SSH server to handle port forwarding requests from devices.

. /etc/default/wg_system
WGDEVICE_SSHDIR="${WG_ETCDIR}/wgdevice_ssh"
SSHD_CONFIG="${WGDEVICE_SSHDIR}/sshd_config"
SSHD_AUTHKEYS_FILE="${WGDEVICE_SSHDIR}/authorized_keys"
SSHD_PIDFILE="${WG_RUNDIR}/wgdevice_sshd/sshd.pid"
RSA_KEY="${WGDEVICE_SSHDIR}/ssh_host_rsa_key"

/usr/sbin/sshd -D -f "$SSHD_CONFIG" -h "$RSA_KEY" -o "PidFile ${SSHD_PIDFILE}" -o "AuthorizedKeysFile ${SSHD_AUTHKEYS_FILE}"
