#!/bin/sh

set -e

usage() {
    echo "usage: <iface.prog> [<resolv.conf>]" >&2
    exit 1
}

if [ $# -lt 1 ]; then
    usage $0
fi

IFACEPROG=$1
RESCONF=$2

if [ -z "${IFACEPROG}" ] ; then
    echo "$0: Error: No interface name specified." >&2
    exit 1
fi

if [ -z "${RESCONF}" ] ; then
    /sbin/resolvconf -d "${IFACEPROG}"
else
    if [ -f "${RESCONF}" ] ; then
        cat "${RESCONF}" | /sbin/resolvconf -a "${IFACEPROG}"
    else
        echo "$0: "${RESCONF}" does not exist or is not a regular file" >&2
        exit 1
    fi
fi

exit 0
