#!/bin/sh

apt_list_check() {
    sigfiles=`find $listdir -name '*.gpg' -type f`

    for sigfile in $sigfiles; do
        listfile=`echo $sigfile | sed -e 's/.gpg$//'`
        if ! gpgv --keyring $keyring $sigfile $listfile; then
            echo "$listfile: invalid APT package list" >&2
            return 1
        fi
    done

    listfiles=`find $listdir ! -name '*.gpg' ! -name lock -type f`

    for listfile in $listfiles; do
        if ! egrep -m 1 -q '^(Origin|Package): ' $listfile; then
            echo "$listfile: corrupt APT package list" >&2
            return 1
        fi
    done

    return 0
}

apt_list_clean() {
    echo "Cleaning APT package list files"
    listfiles=`find $listdir ! -name lock -type f`

    if [ -n "$listfiles" ]; then
        /bin/rm -f $listfiles
    fi
}

#########################
# Execution begins here #
#########################

set -u

keyring=/etc/apt/trusted.gpg
listdir=/var/lib/apt/lists
no_update=0

if [ "$#" -gt 1 ]; then
    if [ "$1" = "-n" ]; then
        no_update=1
    fi
fi

apt_list_check || apt_list_clean

if [ "$no_update" -gt 0 ]; then
    exit $?
fi

if ! apt-get update; then
    apt_list_clean
    apt-get update
fi
