/*global world_countries,world_states_provinces,world_lakes,D_NETMAPPER*/
var WGMAP_ORTHOGRAPHIC = {
    width: 1280,
    height: 720,
    projection: null,
    path: null,
    svg: null,
    zoomLevel: 1.0,
    countryColor: { 'stroke': 'rgb(102,103,102)', 'fill': 'rgb(225,225,225)', 'strokewidth': '0.15px' },
    sphereColor: { 'stroke': 'rgb(20,72,126)', 'fill': 'rgb(20,72,126)', 'strokewidth': '0.35px' },
    waterColor: { 'stroke': 'rgb(20,72,126)', 'fill': 'rgb(20,72,126)', 'strokewidth': '0px' },
    init: function () {
        return;
    },
    /* initMap()
        divid - parent id
        data - {'nodes': [{'status', 'latitude', 'longitude'}], 'links': [{'status', 'sourceidx', 'targetidx'}] }
        width - optional
        height - optional
        zoomLevel - optional
     */
    initMap: function (divid, data, width, height, zoomLevel) {
        if (width) {
            WGMAP_ORTHOGRAPHIC.width = width;
        }
        if (height) {
            WGMAP_ORTHOGRAPHIC.height = height;
        }
        if (zoomLevel) {
            WGMAP_ORTHOGRAPHIC.zoomLevel = zoomLevel;
        }
        $("#" + divid).width(WGMAP_ORTHOGRAPHIC.width);
        $("#" + divid).height(WGMAP_ORTHOGRAPHIC.height);
        $("#" + divid).css('margin-left', 'auto');
        $("#" + divid).css('margin-right', 'auto');
        $("#" + divid).mousedown(function (eo) {
            // Disable click to drag on svg image
            return false;
        });

        WGMAP_ORTHOGRAPHIC.projection = d3.geo
            .orthographic()
            .clipAngle(90 + 1e-6)
            .scale(256)
            .clipExtent([[2.5, 2.5], [WGMAP_ORTHOGRAPHIC.width - 2.5, WGMAP_ORTHOGRAPHIC.height - 2.5]])
            .translate([WGMAP_ORTHOGRAPHIC.width / 2, WGMAP_ORTHOGRAPHIC.height / 2]);

        var centerLngLat = D_NETMAPPER.getCenter(data.nodes);

        if (isNaN(centerLngLat[0]) || isNaN(centerLngLat[1])) {
            centerLngLat = [-100, 40];
        }
        WGMAP_ORTHOGRAPHIC.projection.rotate([-centerLngLat[0], -centerLngLat[1] / 2]); /* Adjust /2 to constrain initial rotation */

        WGMAP_ORTHOGRAPHIC.path = d3.geo.path()
            .projection(WGMAP_ORTHOGRAPHIC.projection);

        if (WGMAP_ORTHOGRAPHIC.svg !== null) {
            WGMAP_ORTHOGRAPHIC.svg.remove();
            $("#" + divid + " div").remove();
        }

        WGMAP_ORTHOGRAPHIC.svg = d3.select("#" + divid).append("svg")
            .attr("width", WGMAP_ORTHOGRAPHIC.width)
            .attr("height", WGMAP_ORTHOGRAPHIC.height);

        $("#" + divid).on('mouseleave', WGMAP_ORTHOGRAPHIC.onMouseUp);
        WGMAP_ORTHOGRAPHIC.mapObject = WGMAP_ORTHOGRAPHIC.svg
            .append("g")
            .on("mousemove", WGMAP_ORTHOGRAPHIC.onMouseMove)
            .on("mouseup", WGMAP_ORTHOGRAPHIC.onMouseUp)
            .on("mousedown", WGMAP_ORTHOGRAPHIC.onMouseDown);

        WGMAP_ORTHOGRAPHIC.mapObject.selectAll(".sphere").remove();
        WGMAP_ORTHOGRAPHIC.mapObject.append("path")
            .datum({ type: "Sphere" })
            .attr("class", "sphere")
            .attr("fill", WGMAP_ORTHOGRAPHIC.sphereColor.fill)
            .attr("stroke", WGMAP_ORTHOGRAPHIC.sphereColor.stroke)
            .attr("stroke-width", WGMAP_ORTHOGRAPHIC.sphereColor.strokewidth)
            .attr("d", WGMAP_ORTHOGRAPHIC.path);

        var world_objects = [
            { 'obj': world_countries, 'class': 'countries', 'color': WGMAP_ORTHOGRAPHIC.countryColor },
            { 'obj': world_states_provinces, 'class': 'states_provinces', 'color': WGMAP_ORTHOGRAPHIC.countryColor },
            { 'obj': world_lakes, 'class': 'lakes', 'color': WGMAP_ORTHOGRAPHIC.waterColor }];
        var idx, world_object;
        for (idx = 0; idx < world_objects.length; idx++) {
            world_object = world_objects[idx];
            WGMAP_ORTHOGRAPHIC.mapObject.selectAll("path." + world_object.class).remove();
            WGMAP_ORTHOGRAPHIC.mapObject.selectAll(world_object.class)
                .data(world_object.obj.features)
                .enter().append("path")
                    .attr("class", world_object.class)
                    .attr("fill", world_object.color.fill)
                    .attr("stroke", world_object.color.stroke)
                    .attr("stroke-width", world_object.color.strokewidth)
                    .attr("d", WGMAP_ORTHOGRAPHIC.path);
        }

        D_NETMAPPER.update(data, WGMAP_ORTHOGRAPHIC.mapObject, WGMAP_ORTHOGRAPHIC.projection, divid);
        WGMAP_ORTHOGRAPHIC.draw(WGMAP_ORTHOGRAPHIC.zoomLevel);
    },
    draw: function (scale) {
        WGMAP_ORTHOGRAPHIC.projection.scale(scale * 256);

        D_NETMAPPER.draw(WGMAP_ORTHOGRAPHIC.path);
        WGMAP_ORTHOGRAPHIC.mapObject.selectAll("path.countries")
            .attr("d", WGMAP_ORTHOGRAPHIC.path);
        WGMAP_ORTHOGRAPHIC.mapObject.selectAll("path.states_provinces")
            .attr("d", WGMAP_ORTHOGRAPHIC.path);
        WGMAP_ORTHOGRAPHIC.mapObject.selectAll("path.lakes")
            .attr("d", WGMAP_ORTHOGRAPHIC.path);
        WGMAP_ORTHOGRAPHIC.mapObject.selectAll(".sphere")
            .attr("d", WGMAP_ORTHOGRAPHIC.path);
    },
    onMouseDown: function () {
        /* Remember clicked position for offset on move */
        WGMAP_ORTHOGRAPHIC.currentRotation = WGMAP_ORTHOGRAPHIC.projection.rotate();
        WGMAP_ORTHOGRAPHIC.mousePosOnDown = d3.mouse(this);
        WGMAP_ORTHOGRAPHIC.ismousedown = true;
    },
    onMouseUp: function () {
        WGMAP_ORTHOGRAPHIC.ismousedown = false;
    },
    onMouseMove: function (e) {
        if (WGMAP_ORTHOGRAPHIC.ismousedown) {
            var p = d3.mouse(this);
            // Calculate long/lat that we moved since clicking down
            var currentLongLat = WGMAP_ORTHOGRAPHIC.projection.invert(WGMAP_ORTHOGRAPHIC.mousePosOnDown);
            var newLongLat = WGMAP_ORTHOGRAPHIC.projection.invert(p);
            var diffLongLat = [currentLongLat[0] - newLongLat[0], currentLongLat[1] - newLongLat[1]];

            var long = WGMAP_ORTHOGRAPHIC.currentRotation[0] - diffLongLat[0];
            if (long > 360) { long -= 360; }
            if (long < -360) { long += 360; }
            var lat = WGMAP_ORTHOGRAPHIC.currentRotation[1] - diffLongLat[1];
            if (lat > 30) { lat = 30; }
            if (lat < -30) { lat = -30; }
            var rotate = [long, lat];
            WGMAP_ORTHOGRAPHIC.projection
                .rotate(rotate);

            WGMAP_ORTHOGRAPHIC.draw(WGMAP_ORTHOGRAPHIC.zoomLevel);
            d3.event.preventDefault();
        }
    }
};

$(document).ready(WGMAP_ORTHOGRAPHIC.init);

