var NODEPOPOVER = {
    divid: 'cxn_popup',
    init: function () {
        NODEPOPOVER.initUI();
        NODEPOPOVER.initEvents();
    },
    initUI: function () {
        var div = '<div id="' + NODEPOPOVER.divid + '" class="popover" style="background-color: rgba(255,255,255,0.8);">';
        div += '<div class="arrow"></div>';
        div += '<div class="popover-inner">';
        div += '<div class="pull-right" style="margin-top:7px;margin-right:7px;">';
        div += '<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>';
        div += '</div>';
        div += '<h3 id="cxn_popup_title" class="popover-title" style="background-color: rgba(247,247,247,0.8);"></h3>';
        div += '<div id="cxn_popup_resources" class="popover-content" style="overflow:auto;"></div>';
        div += '</div></div>';

        $("#" + NODEPOPOVER.divid).remove();
        $("body").append(div);
    },
    initEvents: function () {
        $(document).on('click', '#' + NODEPOPOVER.divid + ' .close', function (eo) {
            NODEPOPOVER.closePopover();
        });
        $(document).keyup(function (eo) {
            if (eo.keyCode === 27) {
                NODEPOPOVER.closePopover();
            }
        });
    },
    closePopover: function () {
        $("#" + NODEPOPOVER.divid).hide();
        NODEPOPOVER.popupShown = false;
    },
    customPopover: function (titlediv, contentdiv, d) {
        //Override this function
        $(titlediv).html(d.name);
        $(contentdiv).html(d.coordinates + "<br/>" + d.overlapcount);
    },
    popover: function (parent_id, d, offset) {
        NODEPOPOVER.popupShown = true;
        NODEPOPOVER.data_popup_name = d.name;
        $("#" + NODEPOPOVER.divid).show();
        NODEPOPOVER.customPopover("#cxn_popup_title", "#cxn_popup_resources", d);
        $("#cxn_popup_spinner").hide();
        $(".popover-content").show();
        var dx = 350;
        var dy = 200;
        return NODEPOPOVER.doPositionNodePopover(parent_id, d, dx, dy, offset);
    },
    doPositionNodePopover: function (parent_id, d, dx, dy, offset) {
        var pos = $("#" + parent_id).offset();
        if (d.is_unknown_devices) {
            d.x = $("#" + parent_id).width();
            d.y = 0;
        }
        var x = pos.left + d.x,
            y = pos.top + d.y;

        var width = $(window).width();
        var height = $(window).height();
        if (x + dx > width) {
            x = x - dx - offset;
        } else {
            x += offset;
        }

        if (x < 0) {
            x = 0;
        }
        if (y + dy > height) {
            y = y - dy - (offset * 2);
        } else {
            y -= (offset * 2);
        }
        $("#" + NODEPOPOVER.divid).offset({ top: y, left: x });
        $("#" + NODEPOPOVER.divid).width(dx);
        $("#" + NODEPOPOVER.divid).height(dy);

        var title_height = $("#" + NODEPOPOVER.divid + " .popover-title").outerHeight();
        var resources_height = dy - title_height - 20;
        $("#" + NODEPOPOVER.divid + " .popover-content").height(resources_height);
    },
    toolTip: function (parent_id, d, offset) {
        if (NODEPOPOVER.popupShown) {
            return;
        }
        NODEPOPOVER.popupShown = false;
        NODEPOPOVER.data_popup_name = d.name;
        $("#" + NODEPOPOVER.divid).show();
        NODEPOPOVER.customPopover("#cxn_popup_title", "#cxn_popup_resources", d);
        $("#cxn_popup_spinner").hide();
        $(".popover-content").hide();
        var dx = 200;
        var dy = 36;
        return NODEPOPOVER.doPositionNodePopover(parent_id, d, dx, dy, offset);
    },
    toolTipClose: function () {
        if (!NODEPOPOVER.popupShown) {
            NODEPOPOVER.closePopover();
        }
    }
};

$(document).ready(NODEPOPOVER.init);

