/*global NODEPOPOVER*/
var D_NETMAPPER = {
    rawNodes: [],
    mapNodes: [],
    mapLinks: [],
    svg: null,
    projection: null,
    pixelpos: null,
    useBezierCurveLink: true,
    nodeSize: 8,
    clrAlive: '#4aab53',
    clrDisabled: '#aaa',
    clrDead: '#f84529',
    clrMixed: '#f89829',
    filteridx: undefined,
    parent_id: '',
    scale: -1,
    hasNodePopover: false,
    init: function () {
        var typeNodePopover = typeof NODEPOPOVER;
        if (typeNodePopover !== 'undefined') {
            D_NETMAPPER.hasNodePopover = true;
        }
        return;
    },
    update: function (data, svg, projection, parent_id, pixelpos, scale) {
        var calcnodes = false;
        if (D_NETMAPPER.hasNodePopover) {
            NODEPOPOVER.closePopover();
        }
        if (data && svg && projection && parent_id) {
            D_NETMAPPER.rawNodes = data.nodes;
            D_NETMAPPER.mapNodes = data.nodes;
            D_NETMAPPER.mapLinks = data.links;
            D_NETMAPPER.svg = svg;
            D_NETMAPPER.projection = projection;
            D_NETMAPPER.parent_id = parent_id;
            calcnodes = true;
        }
        if (pixelpos) {
            D_NETMAPPER.pixelpos = pixelpos;
        }
        if (scale && scale !== D_NETMAPPER.scale) {
            calcnodes = true;
            D_NETMAPPER.scale = scale;
        }
        var links = [];
        D_NETMAPPER.mapLinks.forEach(function (a) {
            var source = D_NETMAPPER.mapNodes[a.sourceidx];
            var target = D_NETMAPPER.mapNodes[a.targetidx];
            var status = a.status;
            links.push({
                'status': status,
                'source': { 'idx': a.sourceidx, 'longlat': source.longlat },
                'target': { 'idx': a.targetidx, 'longlat': target.longlat }
            });
        });
        if (calcnodes) {
            // Detect overlapping nodes
            var i = 0;
            D_NETMAPPER.mapNodes = [];
            var threshold = 4.0 / D_NETMAPPER.scale;
            var foundoverlap = false;
            var overlapnode = {};
            D_NETMAPPER.rawNodes.forEach(function (node) {
                foundoverlap = false;
                node.overlapcount = 1;
                node.nodes = [];
                for (i = 0; i < D_NETMAPPER.mapNodes.length; i++) {
                    if (Math.abs(D_NETMAPPER.mapNodes[i].longlat[0] - node.longlat[0]) < threshold
                            && Math.abs(D_NETMAPPER.mapNodes[i].longlat[1] - node.longlat[1]) < threshold) {
                        foundoverlap = true;
                        D_NETMAPPER.mapNodes[i].overlaps = true;
                        D_NETMAPPER.mapNodes[i].overlapcount += 1;
                        if (node.status !== D_NETMAPPER.mapNodes[i].status) {
                            D_NETMAPPER.mapNodes[i].status = 3;
                        }
                        D_NETMAPPER.mapNodes[i].nodes.push(node);
                        D_NETMAPPER.mapNodes[i].name = D_NETMAPPER.mapNodes[i].overlapcount + ' devices';
                        break;
                    }
                }
                if (!foundoverlap) {
                    overlapnode = { 'status': node.status, 'longlat': node.longlat, 'name': node.name, overlapcount: 1 };
                    overlapnode.nodes = [node];
                    D_NETMAPPER.mapNodes.push(overlapnode);
                }
            });
        }

        D_NETMAPPER.svg.selectAll("path.arcs2").remove();
        D_NETMAPPER.svg
            .selectAll("arcs2")
            .data(links)
            .enter().append("path")
            .attr("class", "arcs2");

        D_NETMAPPER.svg.selectAll("g.nodes").remove();
        D_NETMAPPER.nodeState = D_NETMAPPER.svg.selectAll("g.nodes")
            .data(D_NETMAPPER.mapNodes);
        D_NETMAPPER.nodeState.enter().append("g")
            .datum(function (d) {
                d.coordinates = d.longlat;
                return d;
            })
            .attr("class", "nodes")
            .style("cursor", function () { return (D_NETMAPPER.hasNodePopover) ? "pointer" : "auto"; })
            .on("mouseout", D_NETMAPPER._onMouseOut)
            .on("mouseover", D_NETMAPPER._onMouseOver)
            .on("click", D_NETMAPPER._onMouseClick);
        D_NETMAPPER.nodeState.append("path")
            .attr("class", "devices")
            .datum(function (d) {
                return { nodes: d.nodes, type: "Point", overlaps: d.overlaps, overlapcount: d.overlapcount,
                    count: d.count, coordinates: [d.longlat[0], d.longlat[1]], width: '20px',
                    status: d.status, name: d.name,
                    'logging': d.logging, 'managed': d.managed };
            });
        D_NETMAPPER.nodeState.append("text")
            .attr("class", "devices")
            .attr("text-anchor", "middle")
            .attr("font-weight", "bold")
            .attr("font-size", function (d) { return (1.0 / D_NETMAPPER.scale) + "em"; })
            .attr("dy", "0.4em")
            .attr("fill", "#fff")
            .text(function (d) {
                if (d.overlapcount > 1) {
                    return d.overlapcount;
                }
            });

    },
    pointRadius: function (d) {
        if (d.type === "Point") {
            if (d.overlapcount > 1) {
                return D_NETMAPPER.nodeSize * 1.4;
            }
        }
        return D_NETMAPPER.nodeSize;
    },
    draw: function (path) {
        var svg = D_NETMAPPER.svg;
        D_NETMAPPER.path = path;
        svg
            .selectAll("path.arcs2")
            .style("display", function (d) {
                if (D_NETMAPPER.filteridx !== undefined && (d.source.idx !== D_NETMAPPER.filteridx && d.target.idx !== D_NETMAPPER.filteridx)) {
                    return "none";
                }
                return "block";
            })
            .attr("fill", function (d) {
                if (D_NETMAPPER.useBezierCurveLink) {
                    switch (d.status) {
                    case 0:
                        return D_NETMAPPER.clrDead;
                    case 1:
                        return D_NETMAPPER.clrAlive;
                    case 2:
                        return D_NETMAPPER.clrDisabled;
                    case 3:
                        return D_NETMAPPER.clrMixed;
                    }
                }
                return "none";
            })
            .attr("stroke-width", function (d) {
                if (D_NETMAPPER.useBezierCurveLink) {
                    return D_NETMAPPER.nodeSize / 3 + "px";
                }
                return "2.5px";
            })
            .attr("stroke", function (d) {
                switch (d.status) {
                case 0:
                    return D_NETMAPPER.clrDead;
                case 1:
                    return D_NETMAPPER.clrAlive;
                case 2:
                    return D_NETMAPPER.clrDisabled;
                case 3:
                    return D_NETMAPPER.clrMixed;
                }
            })
            .attr("d", D_NETMAPPER._drawLinkCB);

        path.pointRadius(D_NETMAPPER.pointRadius);
        svg.selectAll("path.devices")
            .attr("stroke", "white")
            .attr("stroke-width", function (d) { return 0.8 / D_NETMAPPER.scale; })
            .attr("fill", function (d) {
                switch (d.status) {
                case 0:
                    return D_NETMAPPER.clrDead;
                case 1:
                    return D_NETMAPPER.clrAlive;
                case 2:
                    return D_NETMAPPER.clrDisabled;
                case 3:
                    return D_NETMAPPER.clrMixed;
                }
            })
            .attr("d", path);

        svg.selectAll("text.devices")
            .attr("transform", function (d) {
                var pixelpos = D_NETMAPPER.projection(d.longlat);
                return "translate(" + pixelpos[0] + "," + pixelpos[1] + ")";
            });
    },
    getCenter: function (nodes) {
        /* Determine the center latitude and longitude of the current data set */
        var bounds = D_NETMAPPER._getBounds(nodes);
        var north = bounds[1][0];
        var south = bounds[0][0];
        var east = bounds[1][1];
        var west = bounds[0][1];
        return [north - ((north - south) / 2), east - ((east - west) / 2)];
    },

    _drawLinkC: function (source, target, r) {
        /* source
        */
        var minVal = 0.01;
        var x0 = source.x,
            x1 = target.x,
            x2 = x0 + (x1 - x0) / 2,
            x3 = x0 + (x1 - x0) / 2,
            y0 = source.y - r,
            y1 = target.y - r,
            y2 = source.y + r,
            y3 = target.y + r;
        if (y3 - y1 < minVal) {
            y3 = y1 + minVal;
        }
        if (y2 - y0 < minVal) {
            y2 = y0 + minVal;
        }
        var linkpath = "M" + x0 + "," + y0 + "C" + x2 + "," + y0 + " " + x3 + "," + y1 + " " + x1 + "," + y1;
        linkpath += "L" + x1 + "," + y3;
        linkpath += "C" + x3 + "," + y3 + " " + x2 + "," + y2 + " " + x0 + "," + y2;
        linkpath += "L" + x0 + "," + y0;

        return linkpath;
    },
    _drawLink: function (source, target) { // derived from flowmapDrawLink
        var dx = target.x - source.x,
            dy = target.y - source.y,
            dr = Math.sqrt(dx * dx + dy * dy);
        var linkpath = "M" + source.x + "," + source.y + "A" + dr + "," + dr +
            " 0 0,1 " + target.x + "," + target.y;

        return linkpath;
    },
    _drawLinkCB: function (d) {
        var src = D_NETMAPPER.projection(d.source.longlat);
        var tgt = D_NETMAPPER.projection(d.target.longlat);
        var source = { 'x': src[0], 'y': src[1] };
        var target = { 'x': tgt[0], 'y': tgt[1] };
        if (D_NETMAPPER.useBezierCurveLink) {
            return D_NETMAPPER._drawLinkC(source, target, D_NETMAPPER.nodeSize / 4);
        }
        return D_NETMAPPER._drawLink(source, target, D_NETMAPPER.nodeSize / 4);
    },
    getZoom: function (width, height, scaleMax) {
        var getBounds = D_NETMAPPER._getBounds();
        var bl = D_NETMAPPER.projection(getBounds[0]);
        var tr = D_NETMAPPER.projection(getBounds[1]);
        var bounds = [bl, tr];
        var dx = bounds[1][0] - bounds[0][0],
            dy = bounds[1][1] - bounds[0][1],
            x = (bounds[0][0] + bounds[1][0]) / 2,
            y = (bounds[0][1] + bounds[1][1]) / 2,
            scale = 0.9 / Math.max(dx / width, dy / height);
        if (scaleMax !== undefined) {
            scale = Math.min(scale, scaleMax);
        }
        var translate = [width / 2 - scale * x, height / 2 - scale * y];
        return [scale, translate];
    },
    _getBounds: function (nodes) {
        /* Determine the lower left and upper right bounds of the current data */
        if (!nodes) {
            nodes = D_NETMAPPER.mapNodes;
        }
        var minlat = 360, minlong = 360,
            maxlat = -360, maxlong = -360,
            idx, node;
        for (idx = 0; idx < nodes.length; idx++) {
            node = nodes[idx];
            minlat = Math.min(minlat, node.longlat[0]);
            minlong = Math.min(minlong, node.longlat[1]);
            maxlat = Math.max(maxlat, node.longlat[0]);
            maxlong = Math.max(maxlong, node.longlat[1]);
        }
        return [[minlat, minlong], [maxlat, maxlong]];
    },
    _onMouseOut: function (d) {
        NODEPOPOVER.toolTipClose();
    },
    _onMouseOver: function (d) {
        var pixelpos = D_NETMAPPER.pixelpos(d.coordinates);
        d.x = pixelpos[0];
        d.y = pixelpos[1];
        NODEPOPOVER.toolTip(D_NETMAPPER.parent_id, d, D_NETMAPPER.nodeSize * D_NETMAPPER.scale);
    },
    _onMouseClick: function (d) {
        D_NETMAPPER.filteridx = d.idx;
        D_NETMAPPER.draw(D_NETMAPPER.path);

        var pixelpos = D_NETMAPPER.pixelpos(d.coordinates);
        d.x = pixelpos[0];
        d.y = pixelpos[1];
        d.dx = D_NETMAPPER.nodeSize * 4;
        d.dy = 0;
        if (D_NETMAPPER.hasNodePopover) {
            NODEPOPOVER.popover(D_NETMAPPER.parent_id, d, D_NETMAPPER.nodeSize * D_NETMAPPER.scale);
        }
        d3.event.stopPropagation();
    }
};

$(document).ready(D_NETMAPPER.init);

