/*global escapeHtml, show_local_users:true, lock_page, is_page_locked, S_ERR_AD_USER, S_USER_ADD_MSG, S_DEVICE_ADD_MSG, S_ERR_MGMT_IP, IPHELPER, usersRolesColNames, resizeGrid, active_users_list, role_engNames_LocNames_map, usersRolesColModel, S_ERR_ROLES, S_USER_EDIT_MSG, role_locNames_engNames_map, UserObj, S_ERR_USER_DUPLICATE, S_ERR_AD_GROUP, user_type_map, avail_device_list, S_VIEW_USER_TITLE, S_EDIT_USER_TITLE, roles_id_map, writeErrorContainer, avail_usergroup_list:true, UserManagementObj, validatePassword, S_USER_MODE, S_VIEW_TEXT, S_EDIT_TEXT, S_PASSWORD_EMPTY, S_ERR_ADMIN_MIN_PASSPHRASE, S_ERR_ADMIN_MAX_PASSPHRASE, S_ERR_PASSPHRASE_MATCH, S_PASSWORD_CHANGE_SUCCESS, S_PASSWORD_CHANGE_FAILED, S_SEL_DEVICES_TITLE, S_SEL_USERGROUPS_TITLE, S_EG_AD_USER, S_EG_AD_GROUP, S_USER_NAME_EMPTY, S_PASSWORD_EMPTY, S_ADD_USER_TITLE, S_ADMIN_USER_REMOVE_ERROR, S_USER_DEL_MSG, S_ERR_LOCAL_USER, S_USER_ROLES_TITLE, S_ERR_ROLE_CHECKED_MSG, S_LOCAL_GROUP_TITLE, S_ERR_RADIUS_USER, S_RADIUS_PASS, S_TXT_LOCKED, localized_user_type, S_TXT_GLOBAL_ACL_SETTINGS, S_TXT_USER_SETTINGS, S_TXT_GROUP_SETTINGS, S_TXT_GLOBAL_SETTINGS, S_ERROR_IPCIDR_INVALID, S_ERROR_IPCIDR_EXISTS*/

var USER_MANAGEMENT = {
    mode : '',
    localEnabled: true,
    global_roles : ['#sa', '#ra', '#ga', '#gm', '#val', '#var', '#po', '#dia'],
    custom_roles : ['#da', '#dm', '#va', '#vm', '#vl', '#vr'],
    parent_child_role_id_array : [
        ['ra',  ['var', 'val', 'vr', 'vl']],
        ['gm',  ['var', 'val', 'vr', 'vl']],
        ['var', ['vr']],
        ['val', ['vl']],
        ['da',  ['dm']],
        ['va',  ['vm']]
    ],

    init : function () {
        USER_MANAGEMENT.initUI();
        USER_MANAGEMENT.initEvents();
    },

    initUI : function () {
        $('#error_container').hide();

        if (show_local_users) {
            USER_MANAGEMENT.toggleLocal();
            USER_MANAGEMENT.showLocalUsers();
        } else {
            USER_MANAGEMENT.toggleRemote();
            USER_MANAGEMENT.showRemoteUsers();
        }

        WGRD.enableUIElements(false, ['#edit_users', '#remove_users']);
        //Users and Roles
        USER_MANAGEMENT.createUsersRolesGrid();
        USER_MANAGEMENT.initUserModeUI();
    },

    initUserModeUI : function () {
        var ids = ['#add_users', '#remove_users', '#add_save'];
        USER_MANAGEMENT.pg_tracker = window.sessionStorage.getItem(lock_page);

        var viewMode = WGRD.userInViewMode(is_page_locked, USER_MANAGEMENT.pg_tracker);
        if (viewMode) {
            $('#edit_users').val(S_VIEW_TEXT);
        } else {
            $('#edit_users').val(S_EDIT_TEXT);
        }
        S_USER_MODE.initUI(ids, viewMode);
    },

    showLocalConfirmDlg : function () {
        if (USER_MANAGEMENT.localEnabled) {
            return;
        }
        USER_MANAGEMENT.toggleRemote();
        $('#toggle_local_dlg').modal();
    },

    showRemoteConfirmDlg : function () {
        if (!USER_MANAGEMENT.localEnabled) {
            return;
        }
        USER_MANAGEMENT.toggleLocal();
        $('#toggle_remote_dlg').modal();
    },

    initEvents : function () {
        WGRD.pgUnloadCallBack(USER_MANAGEMENT.pg_tracker, lock_page);
        $('#local_button').button().click(USER_MANAGEMENT.showLocalConfirmDlg);
        $('#remote_button').button().click(USER_MANAGEMENT.showRemoteConfirmDlg);
        //Users and Roles
        $('#add_users').button().click(USER_MANAGEMENT.showUserRoleModal);
        $('#edit_users').button().click(USER_MANAGEMENT.showUserRoleModal);
        $('#remove_users').button().click(USER_MANAGEMENT.removeUserRole);

        $('#change_pass_chkbox').click(USER_MANAGEMENT.togglePasswordDiv);

        $('#add_resource').on('click', USER_MANAGEMENT.addResource);
        $('#remove_resource').on('click', USER_MANAGEMENT.removeResource);
        $('#device_server_name').on("keyup", USER_MANAGEMENT.groupDeviceSearchEvent);

        $('#user_add_host_network').on('click', USER_MANAGEMENT.addHostNetwork);
        $('#remove_user_host_network').on('click', USER_MANAGEMENT.removeHostNetwork);

        $('#copy_device').on('click', USER_MANAGEMENT.copyGroupDevice);
        $('#del_device').on('click', USER_MANAGEMENT.delGroupDevice);

        $('#specify_device_close').on('click', USER_MANAGEMENT.closeGroupDevice);
        $('#specify_device_save').on('click', USER_MANAGEMENT.saveGroupDevice);

        $('#add_group').click(USER_MANAGEMENT.addUserGroup);
        $('#remove_group').click(USER_MANAGEMENT.removeUserGroup);
        $('#copy_group').on('click', USER_MANAGEMENT.copyUserGroup);
        $('#del_group').on('click', USER_MANAGEMENT.delUserGroup);

        $('#manage_role').click(USER_MANAGEMENT.manageRole);
        $('#remove_role').on('click', USER_MANAGEMENT.removeRole);

        $('#usergroup_name').on("keyup", USER_MANAGEMENT.userGroupSearchEvent);

        $('.specify_group_close').on('click', USER_MANAGEMENT.closeUserGroup);
        $('#specify_group_save').on('click', USER_MANAGEMENT.saveUserGroup);

        $('.specify_roles_close').on('click', USER_MANAGEMENT.closeUserRoleDialog);
        $('#specify_roles_save').on('click', USER_MANAGEMENT.saveUserRoles);

        $('#select_user_types').on('change', USER_MANAGEMENT.toggleUserType);
        $('#user_devices').click(USER_MANAGEMENT.toggleDeviceType);

        $.each(USER_MANAGEMENT.global_roles, function (index, value) {
            $(value).click(USER_MANAGEMENT.handleGlobalRoleSelection);
        });

        $.each(USER_MANAGEMENT.custom_roles, function (index, value) {
            $(value).click(USER_MANAGEMENT.handleCustomRoleSelection);
        });

        $('#select_role').on('change', USER_MANAGEMENT.toggleUserRole);

        $('#sys_page').click(USER_MANAGEMENT.showSysPage);

        $('#local_cancel_btn').click(function () {
            USER_MANAGEMENT.toggleRemote();
        });

        $('#local_save_btn').click(function () {
            $('#toggle_local_dlg').modal("hide");
            USER_MANAGEMENT.toggleLocal();
            USER_MANAGEMENT.showLocalUsers();
            //Trigger a save only if localEnabled is not True
            if (!show_local_users) {
                var obj = new UserManagementObj();
                obj.is_ext_mgmt_enabled = false;
                // save the data to the server
                WGRD.putData(obj).success(function (response) {
                    // we need to do some things after the save operations is successful
                    if (response.status) {
                        window.location = '/usersandroles/users';
                    }
                });
            }
        });

        $('#remote_cancel_btn').click(function () {
            USER_MANAGEMENT.toggleLocal();
        });

        $('#remote_save_btn').click(function () {
            $('#toggle_remote_dlg').modal("hide");
            USER_MANAGEMENT.toggleRemote();
            USER_MANAGEMENT.showRemoteUsers();
        });

        $('#confirm_save_btn').click(function () {
            $('#confirm_dlg').modal("hide");
            window.location = '/system/settings';
        });

        $('#user_confirm_save_btn').click(function () {
            $('#user_confirm_dlg').modal("hide");
            USER_MANAGEMENT.deleteUser();
        });

        $(window).bind('resizeEnd', function () {
            USER_MANAGEMENT.resizeGrids();
        });

        $('#active_usergroups_dev').on('dblclick', USER_MANAGEMENT.showGroupRolePolicies);
        $('.local_group_close').on('click', USER_MANAGEMENT.closeLocalGroupDialog);

        $(document).keydown(function (e) {
            if (e.which === 27) { // escape key pressed
                $('#main_rbac_div').show();
                if ($('#local_group_div').is(":visible")) { // hide local groups dialog
                    $('#local_group_div').hide();
                } else if ($('#specify_usergroups_div').is(":visible")) { // hide add groups dialog
                    $('#specify_usergroups_div').hide();
                } else if ($('#specify_userroles_div').is(":visible")) { // hide roles dialog
                    $('#specify_userroles_div').hide();
                } else if ($('#specify_device_div').is(":visible")) { // hide devices dialog
                    $('#specify_device_div').hide();
                } else { // hide the main dialog
                    $('#manage_users_roles_dlg').modal("hide");
                }
            }
        });
        /*
          When user switches to 'Account' tab, then check if 'Super Admin'
          role is present in either 'Role(s)' section or 'Group Membership' section under 'Policies' tab.
          If present then, check and disable 'Allow user to change their Passphrase' checkbox.
         */
        $('.nav-tabs a[data-toggle="tab"]').on('shown', function (e) {
            var curTab = e.target.hash;
            if (curTab === '#user_settings') {
                var cur_state = $('#allow_change_pass_chkbox').is(':checked');
                var active_roles = USER_MANAGEMENT._get_active_roles();
                var sa_role = role_engNames_LocNames_map['Super Administrator'];
                var user_is_super_admin = false;

                if (active_roles.length !== 0 && active_roles[0] === sa_role) {
                    user_is_super_admin = true;
                } else {
                    var data = $("#users_roles_table").jqGrid('getGridParam', 'data');
                    var inspect_user_groups = function (active_user_groups) {
                        if (active_user_groups.length !== 0) {
                            $.each(active_user_groups, function () {
                                if (user_is_super_admin) {
                                    return;
                                }
                                var group_name = this.name || this.login;
                                var tmp_user_obj = null;
                                var i, len;
                                for (i = 0, len = data.length; i < len; i++) {
                                    tmp_user_obj = data[i];
                                    if (tmp_user_obj.user_name === group_name) {
                                        break;
                                    }
                                }
                                var group_roles = tmp_user_obj.user_roles;
                                if (group_roles.length !== 0 && group_roles[0] === sa_role) {
                                    user_is_super_admin = true;
                                } else {
                                    inspect_user_groups(tmp_user_obj.active_usergroups);
                                }
                            });
                        }
                    };
                    inspect_user_groups(USER_MANAGEMENT._get_user_groups());
                }
                $('#allow_change_pass_chkbox').prop('disabled', user_is_super_admin)
                                              .prop('checked', user_is_super_admin || cur_state);
            }
        });

        //User mode changes
        S_USER_MODE.initEvents();
    },

    _invalid_password_msg : function (error_val) {
        var err_msg = S_PASSWORD_EMPTY;
        if (error_val === 2) {
            err_msg = S_ERR_ADMIN_MIN_PASSPHRASE;
        } else if (error_val === 3) {
            err_msg = S_ERR_ADMIN_MAX_PASSPHRASE;
        }
        return err_msg;
    },

    addHostNetwork: function (event) {
        event.preventDefault();

        var user_host_network = IPHELPER.trimIP4($('#user_host_network').val());

        // verify server is valid ip
        if (IPHELPER.usableHostIP4(user_host_network) !== 0 && IPHELPER.usableNetworkIP4(user_host_network) !== 0) {
            $('#user_host_network').focus();
            $('#user_host_network').select();
            $('#add_error').show()
                        .text(S_ERROR_IPCIDR_INVALID);
            return;
        }

        // don't allow duplicates
        if ($('#user_host_network_list option[value="' + user_host_network + '"]').length > 0) {
            $('#user_host_network').focus();
            $('#user_host_network').select();
            $('#add_error').show()
                        .text(S_ERROR_IPCIDR_EXISTS);
            return;
        }

        $('#user_host_network_list').append('<option value="' + user_host_network + '">' + user_host_network + '</option>');
        $('#user_host_network').val("");
    },

    removeHostNetwork : function (event) {
        event.preventDefault();
        $('#user_host_network_list option:selected').remove();
    },

    changeAdminPassphrase : function () {
        var $id = $('#passphrase_success_error');
        $id.hide();

        var password = $('#user_passsword').val();
        var confirm_password = $('#confirm_user_passsword').val();

        var val = validatePassword(password);
        if (val !== 0) {
            $('#user_passsword').focus();
            $('#user_passsword').select();
            var err_msg = USER_MANAGEMENT._invalid_password_msg(val);
            USER_MANAGEMENT._show_success_error_msg($id, err_msg, false);
            return err_msg;
        }

        if (password !== confirm_password) {
            $('#user_passsword').select();
            $('#user_passsword').focus();
            USER_MANAGEMENT._show_success_error_msg($id, S_ERR_PASSPHRASE_MATCH, false);
            return S_ERR_PASSPHRASE_MATCH;
        }

        var is_disabled = $('#account_is_locked_out').is(':disabled');
        var is_checked = $('#account_is_locked_out').is(':checked');
        var unlock_admin = false;

        if (!is_disabled && !is_checked) {
            unlock_admin = true;
        }

        val = '';
        var test_data = {'password': password, 'unlock_admin': unlock_admin};
        $.ajax({
            url: 'change_passphrase',
            type: 'POST',
            dataType: 'json',
            async: false,
            data: test_data,
            success : function (data) {
                if (data.status) {
                    USER_MANAGEMENT._show_success_error_msg($id, S_PASSWORD_CHANGE_SUCCESS, true);
                    val = S_PASSWORD_CHANGE_SUCCESS;
                    $('#add_close').prop("disabled", true);
                    $('#loading').show();
                    setTimeout(function () {
                        window.location = 'user_logout';
                    }, 3000);

                } else {
                    USER_MANAGEMENT._show_success_error_msg($id, S_PASSWORD_CHANGE_FAILED, false);
                    val = S_PASSWORD_CHANGE_FAILED;
                }
            },
            error : function (data) {
                USER_MANAGEMENT._show_success_error_msg($id, S_PASSWORD_CHANGE_FAILED, false);
                val = S_PASSWORD_CHANGE_FAILED;
            }
        });
        return val;
    },

    addResource : function (event) {
        event.preventDefault();
        $('#add_error_device').hide();
        $('#device_server_name').val("");

        $('#filtered_devices_servers').empty();
        $('#active_devices_servers').empty();

        USER_MANAGEMENT.populate_group_device_select();

        $('#active_devices_servers')
            .append($('#active_group_dev option')
                .clone()
                .children()
                .end());

        $('#specify_device_div')
                         .show()
                         .find('h3').text(S_SEL_DEVICES_TITLE);
        $('#main_rbac_div').hide();
    },

    removeResource : function (event) {
        event.preventDefault();
        $('#active_group_dev option:selected').remove();
    },

    copyGroupDevice : function (event) {
        event.preventDefault();
        var selected_items = $('#filtered_devices_servers option:selected');

        $.each(selected_items, function (index, value) {
            var device_id = value.value;
            var title = value.text;
            var type = value.id;
            if ($('#active_devices_servers option[value ="' + device_id + '"]').length === 0) {
                $('#active_devices_servers').append('<option id=' + type + ' value=' + device_id + ' title="' + title + '">' + title + '</option>');
            }
        });
    },

    delGroupDevice : function (event) {
        event.preventDefault();
        $('#active_devices_servers option:selected').remove();
    },

    closeGroupDevice : function () {
        $('#specify_device_div').hide();
        $('#main_rbac_div').show();
    },

    saveGroupDevice : function () {
        var active_grp_device_length = $('#active_devices_servers option').length;
        if (active_grp_device_length !== 0) {
            $('#active_group_dev').empty();
            $('#active_group_dev')
                .append($('#active_devices_servers option')
                    .clone()
                    .children()
                    .end());
        }
        USER_MANAGEMENT.closeGroupDevice();
    },

    groupDeviceSearchEvent : function () {
        var val = $('#device_server_name').val();

        $('#filtered_devices_servers').empty();
        var matching_list = $.map(avail_device_list, function (value) {
                var search = new RegExp(val, "gi");
                var name_sn = value.name;
                if (name_sn.match(search)) {
                    return value;
                }
                return null;
            });

        $.each(matching_list, function (index, value) {
            var resource_id = value.id;
            var name_sn = value.name;
            var type = value.type;
            $('#filtered_devices_servers').append('<option id=' + type + ' value=' + resource_id + ' title="' + name_sn + '">' + name_sn + '</option>');
        });
    },

    populate_group_device_select : function () {
        $('#filtered_devices_servers').empty();
        $.each(avail_device_list, function (index, value) {
            var resource_id = value.id;
            var name_sn = value.name;
            var type = value.type || resource_id;
            $('#filtered_devices_servers').append('<option id=' + type + ' value=' + resource_id + ' title="' + name_sn + '">' + name_sn + '</option>');
        });
    },

    get_active_group_info : function () {
        $.ajax({
            url: 'get_active_groups',
            async: false,
            success: function (response) {
                avail_usergroup_list = response.active_usergroup;
            },
            error: function (response) {
                avail_usergroup_list = [];
            }
        });
    },

    get_usergroup_info : function (user_name, user_type) {
        var active_group = [];
        $.ajax({
            url: 'get_usergroup_info',
            async: false,
            data: {'user_name': user_name, 'user_type': user_type},
            success: function (response) {
                active_group = response.usergroup_membership;
            },
            error: function (response) {
                active_group = [];
            }
        });
        return active_group;
    },

    addUserGroup : function (event) {
        event.preventDefault();
        $('#add_error').hide();
        $('#add_error_group').hide();
        $('#usergroup_name').val("");

        $('#filtered_usergroups').empty();
        $('#active_usergroups').empty();

        $('#active_usergroups')
            .append($('#active_usergroups_dev option')
                .clone()
                .children()
                .end());

        USER_MANAGEMENT.get_active_group_info();
        USER_MANAGEMENT.populate_usergroup_select();

        $('#specify_usergroups_div')
                         .show()
                         .find('h3').text(S_SEL_USERGROUPS_TITLE);
        $('#main_rbac_div').hide();
    },

    removeUserGroup : function (event) {
        event.preventDefault();
        $('#active_usergroups_dev option:selected').remove();
    },

    copyUserGroup : function (event) {
        event.preventDefault();
        var selected_items = $('#filtered_usergroups option:selected');

        $.each(selected_items, function (index, value) {
            var group_id = value.value;
            var title = value.text;
            var type = value.id;
            if ($('#active_usergroups option[value ="' + group_id + '"]').length === 0) {
                $('#active_usergroups').append('<option id=' + type + ' value=' + group_id + ' title="' + title + '">' + title + '</option>');
            }
        });
    },

    delUserGroup : function (event) {
        event.preventDefault();
        $('#active_usergroups option:selected').remove();
    },

    closeUserGroup : function () {
        $('#specify_usergroups_div').hide();
        $('#main_rbac_div').show();
    },

    saveUserGroup : function () {
        var active_usergroups_length = $('#active_usergroups option').length;
        if (active_usergroups_length !== 0) {
            $('#active_usergroups_dev').empty();
            $('#active_usergroups_dev')
                .append($('#active_usergroups option')
                    .clone()
                    .children()
                    .end());
        }
        USER_MANAGEMENT.closeUserGroup();
    },

    userGroupSearchEvent : function () {
        var val = $('#usergroup_name').val();

        $('#filtered_usergroups').empty();
        var matching_list = $.map(avail_usergroup_list, function (value) {
                var search = new RegExp(val, "gi");
                var login = value.login;
                if (login.match(search)) {
                    return value;
                }
                return null;
            });

        $.each(matching_list, function (index, value) {
            var group_id = value.id;
            var group_login = value.login;
            var group_name = value.name;
            $('#filtered_usergroups').append('<option id=' + group_id + ' value=' + group_id + ' title="' + group_name + '">' + group_login + '</option>');
        });
    },

    populate_usergroup_select : function () {
        $('#filtered_usergroups').empty();
        $.each(avail_usergroup_list, function (index, value) {
            var group_id = value.id;
            var group_login = value.login;
            var group_name = value.name;
            $('#filtered_usergroups').append('<option id=' + group_id + ' value=' + group_id + ' title="' + group_name + '">' + group_login + '</option>');
        });
    },

    toggleUserType : function () {
        var index = $('#select_user_types')[0].selectedIndex;
        if (index === 0) {
            $('#local_user_pass').show();
            $('#user_type_eg').text("");
            if (USER_MANAGEMENT.mode === 'add') {
                $('#account_is_locked_out_div').hide();
            } else {
                $('#account_is_locked_out_div').show();
            }
        } else {
            if (index === 1) {
                $('#user_type_eg').text("");
            } else if (index === 2) {
                $('#user_type_eg').html(S_EG_AD_USER);
            } else if (index === 3) {
                $('#user_type_eg').html(S_EG_AD_GROUP);
            } else {
                $('#user_type_eg').text("");
            }
            $('#local_user_pass').hide();
            $('#account_is_locked_out_div').hide();
        }
        USER_MANAGEMENT.updatePasswordControlUI();
    },

    toggleDeviceType : function () {
        if ($('#user_devices')[0].selectedIndex === 0) {
            $('#selected_resources').hide();
        } else {
            $('#selected_resources').show();
        }
    },

    _show_success_error_msg : function (id, msg, success) {
        $(id)
             .text(msg)
             .show();
        if (success) {
            $(id)
                 .addClass("alert-success wgrd-modal-success")
                 .removeClass("alert-error wgrd-modal-error");
        } else {
            $(id)
                 .removeClass("alert-success wgrd-modal-success")
                 .addClass("alert-error wgrd-modal-error");
        }
    },

    /*
       Called when add or Edit buttons are clicked for groups
       If edit, then pass in row data
    */
    showUserRoleModal : function () {
        var button_id = $(this).attr('id');
        var params = {'parent_id': button_id};
        if (button_id === 'edit_users') {
            var sel_row = jQuery('#users_roles_table').jqGrid('getGridParam', 'selrow');
            if (sel_row === null) {
                return;
            }
        }
        $('#main_rbac_div a[href="#user_settings"]').tab('show');
        WGRD.doModal('#manage_users_roles_dlg',
                     USER_MANAGEMENT.initializeUsersRoles,
                     USER_MANAGEMENT.saveUsersRoles,
                     params,
                     USER_MANAGEMENT.closeBtn,
                     true,
                     true);
    },

    /*
        closeBtn cancelhandler function of #manage_users_role_dlg modal
        to handle "admin" user lockout removal
    */
    closeBtn : function () {
        var is_disabled = $('#account_is_locked_out').is(':disabled');
        var is_checked = $('#account_is_locked_out').is(':checked');
        var user_name = $('#username').val();

        if (user_name === "admin" && !is_disabled && !is_checked) {
            USER_MANAGEMENT._update_user();
        }
    },

    initializeUsersRoles : function (params) {
        var parent_id = params.parent_id;
        $("#save_user").prop("disabled", false);

        $("#admin_user_div").hide();
        $("#rp_span").show();
        $("#active_userroles_div").show();
        $('#user_host_network').val("");

        if (parent_id === 'add_users') { //Initialize UI
            USER_MANAGEMENT.mode = 'add';
            USER_MANAGEMENT._add_users();
        } else { //Update UI
            USER_MANAGEMENT.mode = 'edit';
            USER_MANAGEMENT._edit_users();
        }
        $('#main_rbac_div').show();
        $('#specify_usergroups_div').hide();
        $('#specify_device_div').hide();
        $('#specify_userroles_div').hide();
        $('#local_group_div').hide();
        return true;
    },

    _add_users : function () {

        //Set title
        $('#manage_users_roles_dlg h3').text(S_ADD_USER_TITLE);

        //Reset username
        $('#username').val("")
                      .attr('disabled', false);

        //Reset password and confirm
        $('#user_passsword').val("");
        $('#confirm_user_passsword').val("");

        $('#change_pass_chkbox').prop('checked', false);
        $("#add_save").show();
        //Set local user as default
        $('#select_user_types')[0].selectedIndex = 0;
        $('#select_user_types').prop("disabled", false);
        $('#active_group_dev').empty();
        $('#active_usergroups_dev').empty();
        $('#active_userroles').empty();
        $('#user_host_network_list').empty();
        USER_MANAGEMENT.toggleUserType();
        $('#change_pass_div').hide();
        $('#account_is_locked_out_div').hide();
        $("#selected_usergroups").show();
        //Select All devices option
        $('#user_devices').val("0");
        $('#user_devices').prop("disabled", false);
        USER_MANAGEMENT.toggleDeviceType();
    },

    _get_active_roles : function () {
        var active_roles = [];
        $('#active_userroles option').each(function () {
            var role_id = this.value;
            // we need the role names, get that from roles_id_map
            var role_name = roles_id_map[role_id];
            active_roles.push(role_name);
        });
        return active_roles;
    },

    _get_user_groups : function () {
        var active_usergroups_list = [];
        $('#active_usergroups_dev option').each(function () {
            var usergroup = {};
            usergroup.id = this.id;
            usergroup.login = this.value;
            usergroup.name = this.title;
            active_usergroups_list.push(usergroup);
        });
        return active_usergroups_list;
    },

    _edit_users : function () {

        //Set title
        if (WGRD.userInViewMode(is_page_locked, USER_MANAGEMENT.pg_tracker)) {
            $('#manage_users_roles_dlg h3').text(S_VIEW_USER_TITLE);
            $("#add_group").hide();
            $("#remove_group").hide();
            $("#manage_role").hide();
            $("#remove_role").hide();
            $("#user_host_network_field").hide();
            $('#remove_user_host_network').hide();
            USER_MANAGEMENT.toggleChangeViewMode(false);
        } else {
            $('#manage_users_roles_dlg h3').text(S_EDIT_USER_TITLE);
            USER_MANAGEMENT.toggleChangeViewMode(true);
        }

        var sel_row = jQuery('#users_roles_table').jqGrid('getGridParam', 'selrow');
        var row_data = jQuery('#users_roles_table').jqGrid('getRowData', sel_row);
        var data = $("#users_roles_table").jqGrid('getGridParam', 'data');

        var user_obj = null;
        var i, len;
        for (i = 0, len = data.length; i < len; i++) {
            user_obj = data[i];
            if (user_obj.user_name === row_data.user_name && localized_user_type[user_obj.user_type] === row_data.user_type) {
                break;
            }
        }

        //sanitize user_roles
        $.each(user_obj.user_roles, function (index, value) {
            user_obj.user_roles[index] = $.trim(value);
        });

        $('#username')
                     .val(user_obj.user_name)
                     .attr('disabled', true);

        //Reset password and confirm
        $('#user_passsword').val("");
        $('#confirm_user_passsword').val("");

        var user_type = user_obj.user_type;

        var value = user_type_map[user_type];

        $('#select_user_types')[0].selectedIndex = value;
        $('#select_user_types').prop("disabled", true);
        USER_MANAGEMENT.toggleUserType();

        $('#change_pass_chkbox').prop('checked', false);

        if (value === "0") {
            $("#change_pass_div").show();
        } else {
            $("#change_pass_div").hide();
        }

        USER_MANAGEMENT.togglePasswordDiv();

        if (user_obj.locked_out) {
            $('#account_is_locked_out').prop('checked', true);
        } else {
            $('#account_is_locked_out').prop('checked', false);
            $('#account_is_locked_out').prop('disabled', true);
        }

        $('#user_host_network_list').empty();
        var acl_list = user_obj.user_network_acl_list;
        $.each(acl_list, function (index, value) {
            $('#user_host_network_list').append('<option value="' + value + '">' + value + '</option>');
        });
        if (acl_list.length === 0) {
            $('#access_rights_from_txt').show();
            var group_list = user_obj.group_network_acl_list;
            if (group_list.length > 0) {
                var group_list_str = group_list.join(", ");
                $('#acl_settings_from').text(group_list_str);
            } else {
                $('#acl_settings_from').text(S_TXT_GLOBAL_ACL_SETTINGS);
            }
        } else {
            $('#access_rights_from_txt').hide();
        }

        USER_MANAGEMENT.updatePasswordControlUI(user_obj);

        if (user_obj.user_name === 'admin') {
            $("#local_user_pass").hide();
            $("#admin_user_div").show();
            $("#rp_span").hide();
            $("#active_userroles_div").hide();
            USER_MANAGEMENT.toggleRoleAndDeviceSelection(true);
            $("#selected_usergroups").hide();
            return;
        }

        $("#selected_usergroups").show();
        $('#active_group_dev').empty();
        $('#active_usergroups_dev').empty();
        $("#active_userroles").empty();

        var usergroup_list = USER_MANAGEMENT.get_usergroup_info(user_obj.user_name, user_obj.user_type);
        var count = 0;
        if (usergroup_list.length !== 0) {

            var usergroup_ids = [];
            $.each(usergroup_list, function (i, usergroup) {
                usergroup_ids.push(usergroup.id);
            });

            $.each(avail_usergroup_list, function (i, usergroup) {
                var usergroup_id = usergroup.id;

                if (usergroup_ids.indexOf(usergroup_id) !== -1) {
                    var id = usergroup.id;
                    var usergroup_name = usergroup.login;
                    $('#active_usergroups_dev').append('<option id=' + id + ' value=' + id + ' title="' + usergroup_name + '">' + usergroup_name + '</option>');
                    count = count + 1;
                }
                if (count === usergroup_list.length) {
                    return false;
                }
            });
        }

        var user_roles = user_obj.user_roles;
        var global_role = true;
        var first_role_id = '#' + roles_id_map[user_roles[0]];
        if ($.inArray(first_role_id, USER_MANAGEMENT.custom_roles) !== -1) {
            global_role = false;
        }
        $.each(user_roles, function (index, value) {
            var role_id = roles_id_map[value];
            var role_name = roles_id_map[role_id];
            var loc_role_name = role_engNames_LocNames_map[role_name];
            $('#active_userroles').append('<option value=' + role_id + ' title="' + loc_role_name + '">' + loc_role_name + '</option>');
        });

        var selected_option = 0;  //All devices
        count = 0;
        if (!global_role) {
            var device_list = user_obj.active_devices;
            selected_option = 1;  //Specify devices

            if (device_list.length !== 0) {
                var device_ids = [];
                $.each(device_list, function (i, device) {
                    device_ids.push(device.hashid);
                });

                $.each(avail_device_list, function (i, resource) {
                    var resource_id = resource.id;

                    if (device_ids.indexOf(resource_id) !== -1) {
                        var type = resource.type || resource.id;
                        var id = resource.id;
                        var name_sn = resource.name;
                        $('#active_group_dev').append('<option id=' + type + ' value=' + id + ' title="' + name_sn + '">' + name_sn + '</option>');
                        count = count + 1;
                    }
                    //We only want to iterate the avail_device_list till we have looked into all of the devices in device_list.
                    if (count === device_list.length) {
                        return false;
                    }
                });
            }
        }

        $('#user_devices').prop("disabled", true);
        $('#user_devices').prop('selectedIndex', selected_option);

        USER_MANAGEMENT.toggleDeviceType();

        // disable the other element ids in RO mode.
        if (WGRD.userInViewMode(is_page_locked, USER_MANAGEMENT.pg_tracker)) {
            USER_MANAGEMENT.toggleChangeViewMode(false);
        }
    },

    /*
      1. Show the UI to 'allow users to change their password' only when user type is Local
      2. If user has 'Super Admin' role then this option should be checked and disabled
     */
    updatePasswordControlUI : function (obj) {
        $('#allow_change_pass_chkbox').prop('checked', false)
                                      .prop('disabled', false);
        $('#allow_change_pass_div').hide();

        var index = $('#select_user_types')[0].selectedIndex;
        if (index === 0) { // For local users
            $('#allow_change_pass_div').show();
        }
        if (obj !== undefined && obj.hasOwnProperty('password_control')) {
            $('#allow_change_pass_chkbox').prop('checked', obj.password_control);
            var user_roles = obj.combined_roles;
            if (user_roles[0] === role_engNames_LocNames_map['Super Administrator']) {
                $('#allow_change_pass_chkbox').prop('disabled', true)
                                              .prop('checked', true);
            }
        }
    },

    removeUserRole : function () {
        var sel_row = jQuery('#users_roles_table').jqGrid('getGridParam', 'selrow');
        var row_data = jQuery('#users_roles_table').jqGrid('getRowData', sel_row);
        if (sel_row === null || row_data.user_name === 'admin') {
            if (sel_row === 'admin') {
                $('#rem_admin_error')
                                    .show()
                                    .text(S_ADMIN_USER_REMOVE_ERROR)
                                    .delay(2000)
                                    .fadeOut();
            }
            return;
        }
        $("#user_confirm_dlg").modal();
    },

    deleteUser : function () {
        WGRD.enableUIElements(false, ['#remove_users']);
        var sel_row = jQuery('#users_roles_table').jqGrid('getGridParam', 'selrow');
        var row_data = jQuery('#users_roles_table').jqGrid('getRowData', sel_row);
        var data = $("#users_roles_table").jqGrid('getGridParam', 'data');
        var user_obj = null;
        var i, len;
        for (i = 0, len = data.length; i < len; i++) {
            user_obj = data[i];
            if (user_obj.user_name === row_data.user_name && localized_user_type[user_obj.user_type] === row_data.user_type) {
                break;
            }
        }

        var obj = new UserManagementObj();
        obj.is_ext_mgmt_enabled = false;
        user_obj.user_action = 2;
        obj.user_obj = user_obj;
        // save the data to the server
        WGRD.putData(obj).success(function (response) {
            if (response.status) {
                data.splice($.inArray(user_obj, data), 1);
                $('#users_roles_table').trigger('reloadGrid');
                $('#error_container').text(S_USER_DEL_MSG);
            }
            $('#error_container')
                .delay(2000)
                .fadeOut();
        });
    },

    saveUsersRoles : function (params) {
        var parent_id = params.parent_id;

        if (parent_id === 'add_users') { //Initialize UI
            return USER_MANAGEMENT._save_user();
        }
        return USER_MANAGEMENT._update_user();
    },

    _validate_user_type : function (user_type, obj) {
        var patt = '';
        var user_name = $('#username').val();
        var password = $('#user_passsword').val();
        var confirm_password = $('#confirm_user_passsword').val();
        var is_checked = $('#change_pass_chkbox').is(':checked');
        switch (user_type) {
        case 0:
            patt = /[\-!\@$%\^&*()_+|~=`#{}\[\]:";'<>?,\/]/;
            if (patt.test(user_name)) {
                $('#username').focus();
                $('#username').select();
                return S_ERR_LOCAL_USER;
            }
            if (USER_MANAGEMENT.mode === 'add' || is_checked) {
                //Local User validate password
                var val = validatePassword(password);
                if (val !== 0) {
                    $('#user_passsword').focus();
                    $('#user_passsword').select();
                    var err_msg = USER_MANAGEMENT._invalid_password_msg(val);
                    return err_msg;
                }

                if (password !== confirm_password) {
                    $('#user_passsword').select();
                    $('#user_passsword').focus();
                    return S_ERR_PASSPHRASE_MATCH;
                }
            }
            break;
        case 1:
            patt = /[\-!\@$%\^&*()_+|~=`#{}\[\]:";'<>?,\/]/;
            if (patt.test(user_name)) {
                $('#username').focus();
                $('#username').select();
                return S_ERR_LOCAL_USER;
            }
            break;
        case 2:
            //AD User validation
            if (USER_MANAGEMENT.mode === 'add') {
                patt = /[^\s]+@[^\s]+([.]\w{2,})+/;
                if (!patt.test(user_name)) {
                    $('#username').focus();
                    $('#username').select();
                    return S_ERR_AD_USER;
                }
            }
            break;
        case 3:
            if (USER_MANAGEMENT.mode === 'add') {

                //CN=joe,OU=Users,OU=My,DC=test,DC=loc. Canonically that looks like test.loc/My/Users/joe
                //formatGroup regex should start with any word char ie matches any single letter, number or underscore (same as [a-zA-Z0-9_])
                //It could also contain a space, ' or a dash(-) Should have at least one dot followed by a word and atleast one / and ending with a word
                var formatGroup = /^((\w+((-|\s|')+\w+)*\.\w+((-|\s|')+\w+)*)+\/)+(\w+((-|\s|\.|'|\.\s)+\w+)*\/)*\w+((-|\s|\.|')+\w+)*$/;

                //FormatCN should start with a cn=<any word and allow - or ' or . or space in the name followed by 0 or more ou= and atleast two dc=
                //Should not have leading or trailing spaces or - or ' or .
                //Can have dashes, spaces or single quotes for the values of cn= or ou= or dc=. In addition periods are allowed for cn= and ou=.
                //Atleast one cn=should be present, ou= are optional and at least 2 dc= should be present.
                //The distinguished name format should not end with a comma and should not have consecutive occurrences of the allowed special characters.
                var formatCN = /^(cn=\w+((-|\s|\.|')*\w+)*,)+(ou=\w+((-|\s|\.|'|\.\s)*\w+)*,)*(dc=\w+((-|\s|')*\w+)*,)+dc=\w+((-|\s|')*\w+)*$/;

                user_name = user_name.toLowerCase();

                if (formatGroup.test(user_name)) {
                    obj.user_name = user_name;
                } else if (formatCN.test(user_name)) {
                    obj.user_name = USER_MANAGEMENT._normalize_ad_group(user_name);
                } else {
                    $('#username').focus();
                    $('#username').select();
                    return S_ERR_AD_GROUP;
                }
            }
            break;
        case 4: //RADIUS User
            if (user_name.trim().length > 253) {
                return S_ERR_RADIUS_USER;
            }
            break;
        case 5: //RADIUS Group
            if (user_name.trim().length > 253) {
                return S_ERR_RADIUS_USER;
            }
            break;
        }
        return '';
    },

    _normalize_ad_group : function (user_name) {
        //Extract dc
        var dc_index = user_name.indexOf('dc=');
        var cn_str = '';
        var ou_str = '/';
        var dc_str = user_name.substring(dc_index, user_name.length).trim();

        //check if we have 'ou='
        var ou_index = user_name.indexOf('ou=');
        if (ou_index === -1) {//
            cn_str = user_name.substring(0, dc_index - 1);
        } else {
            ou_str = user_name.substring(ou_index, dc_index - 1);
            ou_str = ou_str.replace(/ou=/g, '');
            var ou_comma_index = ou_str.indexOf(',');
            if (ou_comma_index !== -1) {
                var tmp_ou = '';
                var ou;
                ou_str = ou_str.split(',');
                for (ou = ou_str.length - 1; ou >= 0; ou--) {
                    tmp_ou = tmp_ou + ou_str[ou] + '/';
                }
                ou_str = '/' + tmp_ou;
            } else {
                ou_str = '/' + ou_str + '/';
            }
            cn_str = user_name.substring(0, ou_index - 1);
        }
        cn_str = cn_str.replace(/cn=/g, '');
        var cn_comma_index = cn_str.indexOf(',');
        if (cn_comma_index !== -1) {
            var tmp_cn = '';
            cn_str = cn_str.split(',');
            var cn;
            for (cn = cn_str.length - 1; cn >= 0; cn--) {
                tmp_cn = tmp_cn + cn_str[cn] + '/';
            }
            cn_str = tmp_cn.substring(0, tmp_cn.length - 1);
        }
        dc_str = dc_str.replace(/dc=/g, '');
        dc_str = dc_str.replace(/,/g, '.');
        return dc_str + ou_str + cn_str;
    },

    _save_user : function () {

        //validate dialog controls
        var user_name = $('#username').val();

        var grid_data = $("#users_roles_table").jqGrid('getGridParam', 'data');

        var user_obj = null;

        var user_type = $('#select_user_types')[0].selectedIndex;

        if (user_name.trim().length === 0) {
            return S_USER_NAME_EMPTY;
        }

        if (user_type === 2) { //Type AD group check if it matches CN= format
            var formatCNRegex = /^(cn=\w+(\w+|'|\s|-)*(\w)+,)+(ou=(\w)+(\w|\s|-|')*(\w)+,)*(dc=\w+(\w+|'|\s|-)*,)+(dc=\w+(\w+|'|\s|-)*)$/;
            if (formatCNRegex.test(user_name)) {
                user_name = USER_MANAGEMENT._normalize_ad_group(user_name);
            }
        }
        var user_type_convert = ["Local User", "Local Group", "AD User", "AD Group", "RADIUS User", "RADIUS Group"];
        var i, len;
        for (i = 0, len = grid_data.length; i < len; i++) {
            user_obj = grid_data[i];
            if (user_obj.user_name === user_name && user_obj.user_type === user_type_convert[user_type]) {
                return S_ERR_USER_DUPLICATE;
            }
        }
        user_obj = new UserObj();
        user_obj.user_name = user_name;
        var msg = USER_MANAGEMENT._update_user_obj(user_obj);
        if (msg) {
            return msg;
        }
        var obj = new UserManagementObj();
        obj.is_ext_mgmt_enabled = false;
        user_obj.user_action = 0;
        obj.user_obj = user_obj;

        // SJK code needed here
        // if this is a user group then add to avail_usergroup_list

        // save the data to the server
        WGRD.putData(obj).success(function (response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                $('#manage_users_roles_dlg').modal("hide");
                grid_data.push({
                    'user_name': user_obj.user_name,
                    'user_type': user_obj.user_type,
                    'password': user_obj.password,
                    'password_control': user_obj.password_control,
                    'user_roles': user_obj.user_roles,
                    'combined_roles': user_obj.combined_roles,
                    'active_devices': user_obj.active_devices,
                    'active_usergroups': user_obj.active_usergroups,
                    'user_network_acl_list': user_obj.user_network_acl_list,
                    'group_network_acl_list': user_obj.group_network_acl_list,
                    '__module__': 'modules.scripts.users.user_scripts',
                    '__class__': 'UserObj'
                });
                $('#users_roles_table').trigger('reloadGrid');
                $('#error_container').text(S_USER_ADD_MSG);
            }
            $('#error_container')
                .delay(2000)
                .fadeOut();
        });
        return '';
    },

    _update_user : function () {

        //validate dialog controls
        var user_name = $('#username').val();

        var user_type = $('#select_user_types')[0].selectedIndex;

        if (user_name.trim().length === 0) {
            return S_USER_NAME_EMPTY;
        }

        var data = $("#users_roles_table").jqGrid('getGridParam', 'data');

        var user_type_convert = ["Local User", "Local Group", "AD User", "AD Group", "RADIUS User", "RADIUS Group"];
        var user_obj = null;
        var i, len;
        for (i = 0, len = data.length; i < len; i++) {
            user_obj = data[i];
            if (user_obj.user_name === user_name && user_obj.user_type === user_type_convert[user_type]) {
                break;
            }
        }

        var current_user_roles = user_obj.user_roles;

        jQuery.each(current_user_roles, function (i, val) {
            if (role_locNames_engNames_map[val] !== undefined) {
                current_user_roles[i] = role_locNames_engNames_map[val];
            }
        });

        var msg = USER_MANAGEMENT._update_user_obj(user_obj);
        if (msg) {
            return msg;
        }

        var updated_user_roles = user_obj.user_roles;

        user_obj.current_user_roles = current_user_roles;
        user_obj.user_roles = updated_user_roles;

        var obj = new UserManagementObj();
        obj.is_ext_mgmt_enabled = false;
        user_obj.user_action = 1;
        obj.user_obj = user_obj;
        var is_checked = $('#change_pass_chkbox').is(':checked');

        // save the data to the server
        WGRD.putData(obj).success(function (response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                $('#users_roles_table').trigger('reloadGrid');
                $('#error_container').text(S_USER_EDIT_MSG);
            }
            if (user_obj.user_name === "admin" && is_checked) {
                var $id = $('#passphrase_success_error');
                USER_MANAGEMENT._show_success_error_msg($id, S_PASSWORD_CHANGE_SUCCESS, true);
                setTimeout(function () {
                    $id.hide();
                    $('#manage_users_roles_dlg').modal("hide");
                }, 1000);
            } else {
                $('#manage_users_roles_dlg').modal("hide");
                $('#error_container')
                    .delay(2000)
                    .fadeOut();
            }
        });
        return "";
    },

    _update_user_obj : function (user_obj) {

        var user_type = $('#select_user_types')[0].selectedIndex;

        var val = USER_MANAGEMENT._validate_user_type(user_type, user_obj);

        if (val !== '') {
            return val;
        }
        user_obj.user_type = user_type_map[user_type];
        var user_password = $('#user_passsword').val();
        if (user_type === 0 && user_password.trim() !== '') {
            user_obj.password = user_password;
        } else {
            user_obj.password = "";
        }

        user_obj.locked_out = $('#account_is_locked_out').is(':checked');
        user_obj.password_control = $('#allow_change_pass_chkbox').is(':checked');

        var active_device_list = [];
        var index = $('#user_devices')[0].selectedIndex;
        if (index !== 0 && $('#active_group_dev option').length === 0) {
            return S_DEVICE_ADD_MSG;
        }

        var active_roles = USER_MANAGEMENT._get_active_roles();

        if (user_obj.user_name === "admin") {
            active_roles[0] = roles_id_map.sa;
        }

        user_obj.user_roles = active_roles;

        var is_group_present = false;
        if (index !== 0) {
            $('#active_group_dev option').each(function () {
                var resource = {};
                resource.hashid = this.value;
                resource.type = parseInt(this.id, 10);
                resource.name = '';
                resource.serialno = '';
                if (!is_group_present && resource.type === 3) {
                    is_group_present = true;
                }
                active_device_list.push(resource);
            });
        }

        user_obj.active_devices = active_device_list;

        var active_usergroups_list = USER_MANAGEMENT._get_user_groups();
        user_obj.active_usergroups = active_usergroups_list;

        user_obj.user_network_acl_list = [];
        $('#user_host_network_list option').each(function () {
            user_obj.user_network_acl_list.push(this.text);
        });

        if (active_roles.length === 0 && active_usergroups_list.length === 0 && user_obj.user_name !== 'admin') {
            $('.nav-tabs li:eq(1) a').tab('show');
            return S_ERR_ROLES;
        }

        user_obj.combined_roles = active_roles;
        if (active_usergroups_list.length !== 0) {
            // populate combined role, which is a combination of roles
            // in groups and any roles that the user added explicitly
            user_obj.combined_roles = USER_MANAGEMENT.get_combined_roles(user_obj);
        }
    },

    toggleLocal : function () {
        $('#local_button').addClass('active');
        $('#remote_button').removeClass('active');
        USER_MANAGEMENT.localEnabled = true;
    },

    toggleRemote : function () {
        $('#local_button').removeClass('active');
        $('#remote_button').addClass('active');
        USER_MANAGEMENT.localEnabled = false;
    },

    showLocalUsers : function () {
        $('#local_users').show();
        $('#external_users').hide();
        USER_MANAGEMENT.resizeGrids();
    },

    showRemoteUsers : function () {
        $('#local_users').hide();
        $('#external_users').show();
    },

    toggleChangeViewMode : function (enabled) {
        // Disable or enable the other element ids in RO or RW mode.
        var elem_ids = ['#change_pass_chkbox', '#account_is_locked_out',
                        '#user_devices', '#active_group_dev', '#allow_change_pass_chkbox'];
        WGRD.enableUIElements(enabled, elem_ids);
        if (enabled) {
            $('#add_resource').show();
            $('#remove_resource').show();
            $("#add_save").show();
            $("#user_add_host_network").show();
            $("#user_host_network_field").show();
            $("#remove_user_host_network").show();
        } else {
            $('#add_resource').hide();
            $('#remove_resource').hide();
            $("#add_save").hide();
            $("#user_add_host_network").hide();
            $("#user_host_network_field").hide();
            $("#remove_user_host_network").hide();
        }
    },

    toggleRoleAndDeviceSelection : function (enabled) {
        if (enabled) {
            $('#user_devices').val("0");
        } else {
            $('#user_devices').val("1");
        }
        $('#user_devices').prop("disabled", true);
        USER_MANAGEMENT.toggleDeviceType();
    },

    togglePasswordDiv : function () {
        var enable = $('#change_pass_chkbox').is(':checked');

        if (enable) {
            $('#local_user_pass').show();
        } else {
            $('#local_user_pass').hide();
        }
    },

    createUsersRolesGrid : function () {
        var users_roles_grid = $('#users_roles_table').jqGrid({
            loadonce: true,
            loadui: 'block',
            datatype: USER_MANAGEMENT.refreshUsersRolesGrid,
            height: 'auto',
            autoencode: true,
            autowidth: true,
            shrinkToFit: true,
            colNames: usersRolesColNames,
            colModel: usersRolesColModel,
            pager: '#users_roles_pager',
            sortname: 'user_name',
            viewrecords: true,
            sortorder: 'asc',
            rowNum: 10,
            rowList: [10, 20, 50, 100],
            altRows: true,
            altclass: 'gridAltRow',
            loadComplete: function () {
                USER_MANAGEMENT.toggleEditRemoveBtn();
            },
            onSelectRow: function (rowid, status, e) {
                USER_MANAGEMENT.toggleEditRemoveBtn();
            }
        });
         // add the pager with custom actions for the "delete" button
        users_roles_grid.jqGrid('navGrid', '#users_roles_pager', { edit: false, add: false, del: false, search: false, refresh: false});
    },

    toggleEditRemoveBtn: function () {
        // enable/disable "Remove"/"Edit" button depending on if any rows are selected or not
        var selRowId = $('#users_roles_table').jqGrid('getGridParam', 'selrow');
        var row_data = jQuery('#users_roles_table').jqGrid('getRowData', selRowId);
        WGRD.enableUIElements(row_data.user_name, ['#edit_users', '#remove_users']);
    },

    localizeUserType: function (cellvalue, options, rowObject) {
        return localized_user_type[cellvalue];
    },

    userRolesFormatter: function (cellvalue, options, rowObject) {
        jQuery.each(cellvalue, function (i, val) {
            if (role_engNames_LocNames_map[val] !== undefined) {
                var add_space = '';
                if (i > 0) {
                    add_space = ' ';
                }
                cellvalue[i] = add_space + role_engNames_LocNames_map[val];
            }
        });
        return cellvalue;
    },

    userLockoutStatus: function (cellvalue, options, rowObject) {
        if (!rowObject.locked_out) {
            return escapeHtml(cellvalue);
        }
        return escapeHtml(cellvalue) + " (" + S_TXT_LOCKED + ")";
    },

    userNetworkACL: function (cellvalue, options, rowObject) {
        if (rowObject.user_network_acl_list.length > 0) {
            // return group settings for group types
            if (user_type_map[rowObject.user_type] === "1" ||
                    user_type_map[rowObject.user_type] === "3" ||
                    user_type_map[rowObject.user_type] === "5") {
                return S_TXT_GROUP_SETTINGS;
            }
            return S_TXT_USER_SETTINGS;
        }
        if (rowObject.group_network_acl_list.length > 0) {
            return S_TXT_GROUP_SETTINGS;
        }
        return S_TXT_GLOBAL_SETTINGS;
    },

    refreshUsersRolesGrid : function () {
        $('#users_roles_table').jqGrid('setGridParam', {
            datatype: 'local',
            data: active_users_list
        });
        $('#users_roles_table').trigger('reloadGrid');
    },

    resizeGrids : function () {
        // Pass the <table> id then the <div> that wraps it
        resizeGrid('#users_roles_table', '#local_users');
    },

    // validate all UI input
    validateUI : function () {

        var isLocalEnabled = USER_MANAGEMENT.localEnabled;

        if (isLocalEnabled) {  //Validate local user settings
            //verify if at least 'admin' user is present

            return true;
        }
        //validate remote settings
        var ip = $('#mgmt_ip').val();
        if (IPHELPER.usableHostIP4(ip) !== 0) {
            $('#mgmt_ip').focus();
            $('#mgmt_ip').select();
            writeErrorContainer(S_ERR_MGMT_IP, false);
            return false;
        }
        return true;
    },

    removeRole : function (event) {
        event.preventDefault();
        $('#active_userroles option:selected').remove();
    },

    manageRole : function (event) {
        event.preventDefault();
        $('#specify_userroles_div')
                         .show()
                         .find('h3').text(S_USER_ROLES_TITLE);
        $('#main_rbac_div').hide();
        USER_MANAGEMENT._updateRoleDialog();
    },

    _updateRoleDialog : function () {
        //First, un-check all checkboxes
        $('#all_devices_role input:checked').removeAttr('checked')
                                            .removeAttr('disabled');
        $('#specific_devices_role input:checked').removeAttr('checked')
                                                 .removeAttr('disabled');
        //select global role
        $('#select_role').prop('selectedIndex', 0);
        var active_roles = [];
        $.each($('#active_userroles option'), function (index, value) {
            var role_id = value.value;
            active_roles.push(role_id);
        });
        // if active_userroles has an option, then select the appropriate drop-down
        // in 'select_role' and check the necessary roles
        if (active_roles.length !== 0) {
            var first_role_id = '#' + active_roles[0];
            var global_role = true;
            if ($.inArray(first_role_id, USER_MANAGEMENT.custom_roles) !== -1) {
                $('#select_role').prop('selectedIndex', 1);
                global_role = false;
            }
            $.each(active_roles, function (index, value) {
                $('#' + value).prop("checked", true);
                if (global_role) {
                    USER_MANAGEMENT.handleGlobalRoleSelection(value);
                } else {
                    USER_MANAGEMENT.handleCustomRoleSelection(value);
                }
            });
        }
        USER_MANAGEMENT.toggleUserRole();
    },

    closeUserRoleDialog : function () {
        $('#specify_userroles_div').hide();
        $('#main_rbac_div').show();
    },

    saveUserRoles : function () {
        $('#add_error').hide();
        // check which role type user selected: global or customr
        var index = $('#select_role')[0].selectedIndex;
        var checked;
        if (index === 0) { // global roles
            checked = $('#all_devices_role input:checked');
        } else { // custom roles
            checked = $('#specific_devices_role input:checked');
        }
        if (checked.length === 0) {
            $('#role_error').show()
                            .text(S_ERR_ROLE_CHECKED_MSG);
            return;
        }
        $('#active_userroles').empty();
        if (index === 0) {
            USER_MANAGEMENT._add_global_roles();
            USER_MANAGEMENT.toggleRoleAndDeviceSelection(true);
        } else {
            USER_MANAGEMENT._add_custom_roles();
            USER_MANAGEMENT.toggleRoleAndDeviceSelection(false);
        }
        USER_MANAGEMENT.closeUserRoleDialog();
    },

    _add_global_roles : function () {
        var sa_checked = $('#sa').is(':checked');
        var ra_checked = $('#ra').is(':checked');
        var ga_checked = $('#ga').is(':checked');
        var gm_checked = $('#gm').is(':checked');
        var val_checked = $('#val').is(':checked');
        var var_checked = $('#var').is(':checked');
        var po_checked = $('#po').is(':checked');
        var dia_checked = $('#dia').is(':checked');
        var role_id,
            role_name,
            loc_role_name = '';
        if (sa_checked) {
            role_id = 'sa';
        } else if (ga_checked) {
            role_id = 'ga';
        } else if (ra_checked && gm_checked) {
            role_id = 'ra';
            role_name = roles_id_map[role_id];
            loc_role_name = role_engNames_LocNames_map[role_name];
            $('#active_userroles').append('<option value=' + role_id + ' title="' + loc_role_name + '">' + loc_role_name + '</option>');
            role_id = 'gm';
        } else if (ra_checked) {
            role_id = 'ra';
        } else if (gm_checked) {
            role_id = 'gm';
        } else if (val_checked && var_checked) {
            role_id = 'val';
            role_name = roles_id_map[role_id];
            loc_role_name = role_engNames_LocNames_map[role_name];
            $('#active_userroles').append('<option value=' + role_id + ' title="' + loc_role_name + '">' + loc_role_name + '</option>');
            role_id = 'var';
        } else if (val_checked) {
            role_id = 'val';
        } else if (var_checked) {
            role_id = 'var';
        }
        if (po_checked && !sa_checked) {
            role_name = roles_id_map.po;
            loc_role_name = role_engNames_LocNames_map[role_name];
            $('#active_userroles').append('<option value=po' + ' title="' + loc_role_name + '">' + loc_role_name + '</option>');
        }
        if (dia_checked && !sa_checked) {
            role_name = roles_id_map.dia;
            loc_role_name = role_engNames_LocNames_map[role_name];
            $('#active_userroles').append('<option value=dia' + ' title="' + loc_role_name + '">' + loc_role_name + '</option>');
        }
        if (role_id !== undefined) {
            role_name = roles_id_map[role_id];
            loc_role_name = role_engNames_LocNames_map[role_name];
            $('#active_userroles').append('<option value=' + role_id + ' title="' + loc_role_name + '">' + loc_role_name + '</option>');
        }
    },

    _add_custom_roles : function () {
        var da_checked = $('#da').is(':checked');
        var dm_checked = $('#dm').is(':checked');
        var va_checked = $('#va').is(':checked');
        var vm_checked = $('#vm').is(':checked');
        var vl_checked = $('#vl').is(':checked');
        var vr_checked = $('#vr').is(':checked');

        var checked_roles = [];
        if (da_checked) {
            checked_roles.push('da');
        } else if (dm_checked) {
            checked_roles.push('dm');
        }
        if (va_checked) {
            checked_roles.push('va');
        } else if (vm_checked) {
            checked_roles.push('vm');
        }
        if (vl_checked) {
            checked_roles.push('vl');
        }
        if (vr_checked) {
            checked_roles.push('vr');
        }

        $.each(checked_roles, function (index, value) {
            var role_name = roles_id_map[value];
            var loc_role_name = role_engNames_LocNames_map[role_name];
            $('#active_userroles').append('<option value=' + value + ' title="' + loc_role_name + '">' + loc_role_name + '</option>');
        });
    },

    toggleUserRole : function () {
        $('#role_error').hide();
        var index = $('#select_role')[0].selectedIndex;
        if (index === 0) { // global roles
            $('#all_devices_role').show();
            $('#specific_devices_role').hide();
        } else {
            $('#all_devices_role').hide();
            $('#specific_devices_role').show();
        }
    },

    //This is useful if someone checks / unchecks super admin role or report admin role
    //If check super admin role - disable other roles and uncheck them
    //Uncheck super admin role - enable other roles and uncheck them
    _reset_roles : function (arg, roles) {
        $.each(roles, function (index, role_id) {
            $(role_id).prop("checked", arg);
            $(role_id).prop("disabled", arg);
        });
    },

    /*
    If 'Device Administrator' role's state changed :
      a.  role checked: check and disable device monitor
    If 'VPN Administrator' role's state changed:
      a.  role checked: check and disable vpn monitor
    */
    handleCustomRoleSelection : function (checked_role, mode) {
        var role_id = this.id || checked_role;

        var enable = $('#' + role_id).is(':checked');

        switch (role_id) {
        case 'da':
            USER_MANAGEMENT._reset_roles(enable, ['#dm']);
            break;
        case 'va':
            USER_MANAGEMENT._reset_roles(enable, ['#vm']);
            break;
        case 'dm':
        case 'vm':
        case 'vl':
        case 'vr': // nothing to do
            break;
        }
    },

    /*
    If 'Super Administrator' role's state changed:
      a.  role checked: check and disable all global roles
      b.  role un-checked: uncheck and enable all global roles

    If 'Report Administrator' role's state changed:
      a. role checked: check and disable view all logs and view all reports role
      b. role un-checked:
        b.1. uncheck and enable view all logs and view all reports role
        b.2. keep view all logs and view all reports checked and disabled
             if either global administrator or global monitor is checked

    If 'Global Administrator' role's state changed:
       a.  role checked: check and disable global monitor, view all logs and view all reports role
       b.  role un-checked:
         b.1.  uncheck and enable global monitor, view all logs and view all reports role
         b.2.  keep view all logs and view all reports checked and disabled 
               if report administrator is checked

    If 'Global Monitor' role's state changed:
       a.  role checked: check and disable view all logs and view all reports role
       b.  role un-checked:
         b.1.  uncheck and enable view all logs and view all reports role
         b.2.  keep view all logs and view all reports checked and disabled 
               if report administrator is checked

    If 'View all Logs ', 'View all reports' role's state changed:
      Reset update_roles, nothing else to do
     */
    handleGlobalRoleSelection : function (checked_role) {
        var role_id = this.id || checked_role;
        var enable = $('#' + role_id).is(':checked');
        var ra_enable = $('#ra').is(':checked');
        var ga_enable = $('#ga').is(':checked');
        var gm_enable = $('#gm').is(':checked');
        var update_roles = ['#val', '#var'];

        switch (role_id) {
        case 'sa': // select and disable all roles
            update_roles = ['#ra', '#ga', '#gm', '#val', '#var', '#po'];
            break;
        case 'ra':
            enable = enable || ga_enable || gm_enable;
            break;
        case 'ga':
            if (!enable) {
                // uncheck view gm role
                USER_MANAGEMENT._reset_roles(enable, ['#ra', '#gm']);
            } else {
                update_roles.push('#ra', '#gm');
            }
            break;
        case 'gm':
            enable = enable || ra_enable;
            break;
        case 'po':
        case 'dia':
        case 'val':
        case 'var': // nothing to do, other than to reset update_roles
            update_roles = [];
            break;
        }
        USER_MANAGEMENT._reset_roles(enable, update_roles);
    },

    showGroupRolePolicies : function () {
        var groups_selected  = $('#active_usergroups_dev option:selected').length;
        if (groups_selected !== 1) {
            return;
        }
        var selected_local_group = $('#active_usergroups_dev option:selected').attr('title');
        $('#local_group_div')
                         .show()
                         .find('h3').text(S_LOCAL_GROUP_TITLE);
        $('#main_rbac_div').hide();
        USER_MANAGEMENT.populate_local_user_grp(selected_local_group);
    },

    closeLocalGroupDialog : function () {
        $('#local_group_div').hide();
        $('#main_rbac_div').show();
    },

    /*
      The main purpose of this method is to normalize the roles that will be shown in 'Users & Groups' page.

      a. For all the local groups for this user:
         a.1. get the role id
         a.2. add it to the combined_role_ids array
         a.3. ensure duplicates are not added

      b. For all the roles that the user added explicitly:
         b.1. get the role id
         b.2. add it to the combined_role_ids array
         b.3. ensure duplicates are not added

      c. The following rules decide what roles finally show up in the user roles grid:
         c.1. if 'super admin' role is present, then return 'Super Admin' only.

         c.2. if 'global admin' role is present, then return 'Global Admin' only.

         c.3. if 'report admin' role is present:
              c.3.1. Check if any of these roles are present: ['var', 'val', 'vr', 'vl']
              c.3.2. 'ra' implies roles mentioned above, don't show them in the main page

         c.4. if 'global admin' role is present:
              c.4.1. Check if any of these roles are present: ['var', 'val', 'vr', 'vl']
              c.4.2. 'gm' implies roles mentioned above, don't show them in the main page

         c.5. if 'var' role is present:
              c.5.1. Check if any of these roles are present: ['vr']
              c.5.2. 'var' implies 'vr' don't show it in the main page

         c.6. if 'val' role is present:
              c.6.1. Check if any of these roles are present: ['vl']
              c.6.2. 'val' implies 'vl' don't show it in the main page

         c.7. if 'da' role is present:
              c.7.1. Check if any of these roles are present: ['dm']
              c.7.2. 'da' implies 'dm' don't show it in the main page

         c.8. if 'va' role is present:
              c.8.1. Check if any of these roles are present: ['vm']
              c.8.2. 'va' implies 'vm' don't show it in the main page
    */
    get_combined_roles : function (user_obj) {
        var data = $("#users_roles_table").jqGrid('getGridParam', 'data');
        var local_groups = user_obj.active_usergroups;

        var combined_role_ids = [];
        var combined_role_names = [];

        // Internal function: If the passed in role_id already exists in the combined_role_ids
        // array, return true, else return false
        function role_id_exists(role_id) {
            return ($.inArray(role_id, combined_role_ids) !== -1);
        }

        // Internal function: Based on the passed in operation modify the combined_role_ids array.
        // If operation is 'add': Add the role id to the combined_role_ids if it does not already exists
        // If operation is 'del':
        //   Check if the passed in role_id exists in combined_role_ids array, if so:
        //     Loop through the passed in rem_role_ids array, check if the individual role_ids are present in the array
        //     if so remove it from combined_role_ids array
        function modify_role_array(operation, role_id, rem_role_ids) {
            if (operation === 'add' && !role_id_exists(role_id)) {
                combined_role_ids.push(role_id);
            } else if (operation === 'rem' && role_id_exists(role_id)) {
                $.each(rem_role_ids, function (index, value) {
                    if (role_id_exists(value)) {
                        combined_role_ids.splice(combined_role_ids.indexOf(value), 1);
                    }
                });
            }
        }

        /*
         Internal function: recursively check if there are any nested groups
         If so update the modify_role_array by adding the role_ids.
         */
        function handle_nested_groups(nested_groups) {
            $.each(nested_groups, function () {
                var group_name = this.name || this.login;
                var tmp_user_obj = null;
                var i, len;
                for (i = 0, len = data.length; i < len; i++) {
                    tmp_user_obj = data[i];
                    if (tmp_user_obj.user_name === group_name) {
                        break;
                    }
                }
                // check if this group has a nested group
                var nested_groups_tmp = tmp_user_obj.active_usergroups;
                if (nested_groups_tmp.length !== 0) {
                    handle_nested_groups(nested_groups_tmp);
                }
                var group_roles = tmp_user_obj.user_roles;
                $.each(group_roles, function (index, value) {
                    var role_id = roles_id_map[value];
                    modify_role_array('add', role_id, '');
                });
            });
        }

        // loop through any groups and store the role ids, remove duplicates
        $.each(local_groups, function () {
            handle_nested_groups(local_groups);
        });

        //Loop through any user roles and store the role ids, remove duplicates
        var user_roles = user_obj.user_roles;
        $.each(user_roles, function (index, value) {
            var role_id = roles_id_map[value];
            modify_role_array('add', role_id, '');
        });

        // if 'Super Admin' is present in return only that
        if (role_id_exists('sa')) {
            combined_role_names = [roles_id_map.sa];
        } else if (role_id_exists('ga')) { // GA is present, return only that
            combined_role_names = [roles_id_map.ga];
        } else {
            $.each(USER_MANAGEMENT.parent_child_role_id_array, function (index, value) {
                modify_role_array('rem', value[0], value[1]);
            });

            // Finally get the roles names for the role id(s)
            $.each(combined_role_ids, function (index, value) {
                var role_name = roles_id_map[value];
                combined_role_names.push(role_name);
            });
        }
        return combined_role_names;
    },

    populate_local_user_grp : function (selected_local_group) {
        var data = $("#users_roles_table").jqGrid('getGridParam', 'data');

        var user_obj = null;
        var i, len;
        for (i = 0, len = data.length; i < len; i++) {
            user_obj = data[i];
            if (user_obj.user_name === selected_local_group) {
                break;
            }
        }
        $('#groupname')
                     .val(user_obj.user_name);

        $('#active_local_userroles').empty();
        $('#local_active_group_dev').empty();

        var user_roles = user_obj.user_roles;
        var global_role = true;
        var first_role_id = '#' + roles_id_map[user_roles[0]];
        if ($.inArray(first_role_id, USER_MANAGEMENT.custom_roles) !== -1) {
            global_role = false;
        }
        $.each(user_roles, function (index, value) {
            var role_id = roles_id_map[value];
            var role_name = roles_id_map[role_id];
            var loc_role_name = role_engNames_LocNames_map[role_name];
            $('#active_local_userroles').append('<option value=' + role_id + ' title="' + loc_role_name + '">' + loc_role_name + '</option>');
        });

        var selected_option = 0;  //All devices
        var count = 0;
        if (!global_role) {
            var device_list = user_obj.active_devices;

            if (device_list.length !== 0) {
                selected_option = 1;  //Specify devices

                var device_ids = [];
                $.each(device_list, function (i, device) {
                    device_ids.push(device.hashid);
                });

                $.each(avail_device_list, function (i, resource) {
                    var resource_id = resource.id;

                    if (device_ids.indexOf(resource_id) !== -1) {
                        var type = resource.type || resource.id;
                        var id = resource.id;
                        var name_sn = resource.name;
                        $('#local_active_group_dev').append('<option id=' + type + ' value=' + id + ' title="' + name_sn + '">' + name_sn + '</option>');
                        count = count + 1;
                    }
                    //We only want to iterate the avail_device_list till we have looked into all of the devices in device_list.
                    if (count === device_list.length) {
                        return false;
                    }
                });
            }
        }

        $('#local_selected_resources').hide();
        $('#local_user_devices').prop("disabled", true);
        $('#local_user_devices').prop('selectedIndex', selected_option);
        if (selected_option === 1) {
            $('#local_selected_resources').show();
        }
    }
};
$(document).ready(USER_MANAGEMENT.init);
