/*global POLLER, WGRD, S_STATUS_SYNC_FK_OK_MSG, S_STATUS_SYNC_FK_REQ_SEND_MSG, S_STATUS_SYNC_FK_REQ_PROGRESS_MSG, S_STATUS_MSG, S_STATUS_IMPORTING_MSG, S_STATUS_IMPORTING_NO_CONTENT_MSG */
var S_LS_S = {

    poller: null,

    // setup the page
    init: function () {
        S_LS_S.initUI();
        S_LS_S.initEvents();
    },

    // initialize UI elements
    initUI: function () {
        WGRD.enableUIElements(false, ['#btn_server_start', '#btn_server_stop', '#btn_server_restart']);
        S_LS_S.updateServerInfo();
    },

    // add event handlers
    initEvents: function () {
        $('#btn_server_start').button().click(S_LS_S.startServer);
        $('#btn_server_stop').button().click(S_LS_S.stopServer);
        $('#btn_server_restart').button().click(S_LS_S.restartServer);
        $('#feature_key_import_btn').button().click(S_LS_S.importFeatureKey);
        $('#feature_key_sync_btn').button().click(S_LS_S.syncFeatureKey);

        // start a poller to refresh the server info every minute
        S_LS_S.poller = new POLLER('server_info', {'interval': '5'}, 60000, S_LS_S.serverInfoRefreshSuccessHandler, S_LS_S.serverInfoRefreshErrorHandler);
    },

    serverInfoRefreshSuccessHandler: function (response) {
        S_LS_S.updateServerInfoUI(response);
        return true;
    },

    serverInfoRefreshErrorHandler: function (response, num_failed) {
        return true;
    },

    startServer: function () {
        S_LS_S.serverAction('start');
    },

    stopServer: function () {
        S_LS_S.serverAction('stop');
    },

    restartServer: function () {
        S_LS_S.serverAction('restart');
    },

    serverAction: function (param) {
        $('#progress_server_action').show();
        WGRD.enableUIElements(false, ['#btn_server_start', '#btn_server_stop', '#btn_server_restart']);
        if (S_LS_S.poller !== null) {
            S_LS_S.poller.pause();
        }

        $.ajax({
            url: 'server_action?action=' + param,
            type: 'POST',
            dataType: 'json',
            data: '',
            success: S_LS_S.updateServerInfo,
            error: S_LS_S.updateServerInfo
        });
    },

    // ajax call to get some updated server info and refresh the UI
    updateServerInfo: function () {
        $.ajax({
            url: 'server_info',
            type: 'POST',
            dataType: 'json',
            data: {'interval': 0.2},
            success: function (data) {
                S_LS_S.updateServerInfoUI(data);
            }
        });
    },

    updateServerInfoUI: function (data) {
        if (data.server_status === undefined) {
            $('#log_server_status').html('');
        } else {
            $('#log_server_status').html(data.server_status);
        }
        if (data.db_status === undefined) {
            $('#log_db_status').html('');
        } else {
            $('#log_db_status').html(data.db_status);
        }
        if (data.uptime === undefined) {
            $('#log_server_uptime').html('');
        } else {
            $('#log_server_uptime').html(data.uptime);
        }
        if (data.memory === undefined) {
            $('#log_server_memory').html('');
        } else {
            $('#log_server_memory').html(data.memory);
        }
        if (data.disk_usage === undefined) {
            $('#log_server_du').html('');
        } else {
            $('#log_server_du').html(data.disk_usage);
        }

        if (data.avail === undefined || (data.avail !== 0 && data.avail !== 1)) {
            // server is not available
            WGRD.enableUIElements(true, ['#btn_server_start']);
            WGRD.enableUIElements(false, ['#btn_server_stop', '#btn_server_restart']);
        } else {
            // server is available
            WGRD.enableUIElements(true, ['#btn_server_stop', '#btn_server_restart']);
            WGRD.enableUIElements(false, ['#btn_server_start']);
        }

        if (data.cpu_tooltip !== undefined) {
            $('#log_server_cpu').html(data.cpu + '&nbsp;<a id="log_server_cpu_tooltip" data-toggle="tooltip"><i class="icon-question-sign"></i></a>');
            $('#log_server_cpu_tooltip').tooltip({
                html: true,
                placement: 'right',
                title: data.cpu_tooltip
            });
        } else if (data.cpu !== undefined) {
            $('#log_server_cpu').html(data.cpu);
        } else {
            $('#log_server_cpu').html('');
        }

        $('#progress_server_action').hide();
        if (S_LS_S.poller !== null) {
            S_LS_S.poller.resume(false);
        }
    },

    importFeatureKey: function () {
        WGRD.doModal('#import_fk_dlg',
                S_LS_S.initializeImportFeatureKeyDlg,
                S_LS_S.doImportFeatureKey,
                null,  // params
                null,  // cancelHadler
                true); // stayOpenOnSave
    },

    initializeImportFeatureKeyDlg: function (params) {
        // Initialize UI
        $('#fk_import_text').val('');
        WGRD.showUIElements(false, ['#fk_import_loading_spinner', '#fk_import_close']);
        WGRD.showUIElements(true, ['#fk_import_cancel', '#fk_import_ok']);
        WGRD.enableUIElements(true, ['#fk_import_cancel', '#fk_import_ok', '#fk_import_text']);
        $("#fk_import_status_msg").removeClass("alert alert-success alert-error");
        $('#fk_import_status_msg').text('');

        return true;
    },

    doImportFeatureKey: function (params) {
        //verify feature key was inserted
        if (!$('#fk_import_text').val()) {
            $('#fk_import_status_msg').text('');
            $('#fk_import_status_msg').removeClass('alert alert-success alert-error');
            return S_STATUS_IMPORTING_NO_CONTENT_MSG;
        }

        WGRD.showUIElements(true, ['#fk_import_loading_spinner', '#fk_import_close', '#fk_import_status_msg']);
        WGRD.showUIElements(false, ['#fk_import_ok', '#fk_import_cancel']);
        WGRD.enableUIElements(false, ['#fk_import_text']);
        $('#fk_import_status_msg').removeClass('alert alert-success alert-error');
        $('#fk_import_status_msg').text(S_STATUS_IMPORTING_MSG);

        var import_data = {'fk' : $('#fk_import_text').val()};

        $.ajax({
            url: 'import_feature_keys',
            type: 'POST',
            data: import_data,
            dataType: 'json',
            success: function (data) {
                WGRD.showUIElements(false, ['#fk_import_loading_spinner']);
                var i, substatus;
                if (data.substatus) {
                    substatus = data.substatus;
                    $('#fk_import_status_msg').text('');
                    for (i = 0; i < substatus.length; i++) {
                        $('#fk_import_status_msg').append(substatus[i]);
                    }
                } else if (data.status) {
                    $('#fk_import_status_msg').attr('class', 'alert alert-success');
                    $('#fk_import_status_msg').text(data.message);
                    WGRD.showUIElements(true, ['#fk_import_close']);
                    WGRD.showUIElements(false, ['#fk_import_ok', '#fk_import_cancel']);
                    WGRD.enableUIElements(true, ['#fk_import_close']);
                    WGRD.enableUIElements(false, ['#fk_import_text']);
                } else {
                    $('#fk_import_status_msg').attr('class', 'alert alert-error');
                    $('#fk_import_status_msg').text(data.message);
                    WGRD.showUIElements(false, ['#fk_import_close']);
                    WGRD.showUIElements(true, ['#fk_import_ok', '#fk_import_cancel']);
                    WGRD.enableUIElements(true, ['#fk_import_text']);
                }
            }
        });

        return;
    },

    syncFeatureKey: function () {
        WGRD.doModal('#fk_sync_modal',
                S_LS_S.initUpdateFKModal,
                S_LS_S.doDeviceUpdateFK,
                null,  // params
                null,  // cancelHadler
                true,  // stayOpenOnSave
                true);
    },

    initUpdateFKModal: function () {
        $('#fk_sync_status_msg').text(S_STATUS_SYNC_FK_REQ_SEND_MSG);
        $('#fk_sync_status_msg').removeClass('alert alert-success alert-error');
        $('#fk_sync_ok_msg').text(S_STATUS_SYNC_FK_OK_MSG);
        WGRD.showUIElements(true, ['#fk_sync_modal_yes', '#fk_sync_modal_no', '#fk_sync_ok_msg']);
        WGRD.showUIElements(false, ['#fk_sync_modal_close']);
        return true;
    },

    doDeviceUpdateFK: function () {
        $('#fk_sync_status_msg').text(S_STATUS_SYNC_FK_REQ_PROGRESS_MSG);
        WGRD.showUIElements(false, ['#fk_sync_modal_yes', '#fk_sync_modal_no', '#fk_sync_ok_msg']);
        WGRD.showUIElements(true, ['#fk_sync_modal_close']);
        WGRD.enableUIElements(true, ['#fk_sync_modal_close']);

        $.ajax({
            url: 'update_feature_keys',
            method: 'GET',
            dataType: 'json'
        });
        return;
    }
};
$(document).ready(S_LS_S.init);
