/*global R_DATE_NAVBAR, anonymization_enabled*/
var S_SINGLE_REP = {
    resultData : '',
    filterData : '',
    allVars : '', 
    urlSn : '',
    date : '',
    id : '',
    period : '',
    urlTz : '',
    repType : '',
    htmlDate : '',
    htmlSn : '',
    startTime : '',
    endTime : '',
    seriesEarliestRecord : '',
    seriesLatestRecord : '',
    reportName : '',
    lastScrollLeft :0,
    portal_link : "https://securityportal.watchguard.com/Threats/Detail?ruleId=",
    summary_detail_reports_map: {'alarms':'alarms',
                                 'deniedpackets':'denied_packets_detail',
                                 'deniedquota':'denied_quota_detail',
                                 'smtp':'smtp_proxy_detail',
                                 'pop3':'pop3_proxy_detail',
                                 'imap':'imap_proxy_detail',
                                 'webaudit':'web_audit_category',
                                 'webblocker':'web_blocker_category',
                                 'dlp':'dlp_detail',
                                 'ips':'ips_detail',
                                 'gav':'gav_detail',
                                 'apt':'apt_detail',
                                 'undetected_apt':'undetected_apt_detail',
                                 'botnet':'botnet_detail'
                                },
    show_bw_hits_rep_list: ['pf_src', 'pf_dest', 'pf_service', 'pf_session',
                            'px_src', 'px_dest', 'px_protocol', 'px_session',
                            'web_active_cli_clients', 'web_active_cli_devices',
                            'top_cli_proxy_users', 'top_cli_proxy_hosts', 'top_cli_proxy_mobiles'],
    detail_rep_path: 'detail?sn=',
    reportPath:'',

    init: function() {
        S_SINGLE_REP.allVars = $.getUrlVars();
        S_SINGLE_REP.urlSn = $.getUrlVar('sn');
        S_SINGLE_REP.date = $.getUrlVar('date');
        S_SINGLE_REP.id = $.getUrlVar('id');
        S_SINGLE_REP.period = $.getUrlVar('period');
        S_SINGLE_REP.urlTz = $.getUrlVar('tz');
        S_SINGLE_REP.repType = $.getUrlVar('reptype');
        S_SINGLE_REP.htmlDate = $("#date").val();
        S_SINGLE_REP.htmlSn = $("#sn").val();
        S_SINGLE_REP.reportPath = this.location.pathname;
        S_SINGLE_REP.initUI();
        S_SINGLE_REP.initEvents();
    },

    initUI: function() {
        // Set the report type from the url
        if(S_SINGLE_REP.repType != null) {
            $('#chart_select').val(S_SINGLE_REP.repType);
        }
        if(S_SINGLE_REP.repType === "undetected_apt_malware_by_content" || S_SINGLE_REP.repType === "undetected_apt_malware_by_uuid"
            || S_SINGLE_REP.repType === "undetected_apt_malicious_activity" || S_SINGLE_REP.repType === "undetected_apt_destination"
            || S_SINGLE_REP.repType === "undetected_apt_threat") {
                $('#page_label_id').attr("title", D_SUMMARY_EXECUTIVE_ZERO_DAY_APT);
        }

        if(S_SINGLE_REP.period != null && S_SINGLE_REP.period == 'custom') {
            $('#chart_select').hide();
        }
        S_SINGLE_REP.showChartLoading();
    }, 
    getRepType: function (repType) {
        if ($.inArray(repType, S_SINGLE_REP.show_bw_hits_rep_list) !== -1) {
            if ($('#in_out_select').is(":visible")) {
                repType += $('#in_out_select option:selected').val();
            }
            repType = repType + $('#bw_hits_select option:selected').val();
        }
        return repType;
    },
    initEvents: function() {
        $('#interfaces_select').change(function () {
            S_SINGLE_REP.showInterfaceData();
        });
        $('#pivots_select').change(function () {
            S_SINGLE_REP.showPivotsData();
        });
        $('#data_filter_select').change(function () {
            var filter_data = $('#data_filter_select option:selected').val();
            if (filter_data !== undefined) {
                S_SINGLE_REP.filterData = filter_data;
                S_SINGLE_REP.getData();
            }
        });

        $('#pdf_link').click(function() {
            var reportType = $('#chart_select option:selected').val();
            reportType = S_SINGLE_REP.getRepType(reportType);
            var tzOffsetStart = $.getDateUTCOffsetString(S_SINGLE_REP.seriesEarliestRecord, S_SINGLE_REP.urlTz);
            var tzOffsetEnd = $.getDateUTCOffsetString(S_SINGLE_REP.seriesLatestRecord, S_SINGLE_REP.urlTz);
            var interface_type = '';
            if (reportType === 'interface_summary') {
                interface_type = $('#interfaces_select option:selected').val();
                var pivot_type = $('#pivots_select option:selected').val();
                if (pivot_type === 'by_bytes') {
                    interface_type = interface_type.concat('_0');
                } else if(pivot_type === 'by_rate') {
                    interface_type = interface_type.concat('_1');
                } else {
                    interface_type = interface_type.concat('_2');
                }
            }
            var filter_data = $('#data_filter_select option:selected').val();
            if (!filter_data) {
                filter_data = '';
            }

            WGRD.progressModal(S_EXPORTING_FILE, S_PROCESSING);

            $.ajax({
                url: "saveAsPdf?serial=" + S_SINGLE_REP.htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=" + reportType + "&start_time=" + S_SINGLE_REP.seriesEarliestRecord + "&end_time=" + S_SINGLE_REP.seriesLatestRecord
                   + "&tz_offset_start=" + S_SINGLE_REP.tzOffsetStart +  "&tz_offset_end=" + S_SINGLE_REP.tzOffsetEnd +  "&search=" + encodeURIComponent(filter_data) + "&interface_type=" + interface_type,
                type: 'POST',
                contentType: 'application/json',
                success: function(data) {
                    if(!data.status) {
                        if(data.message) {
                            alert(data.message);
                        }
                        return true;
                    }
                    var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                    window.location = "get_pdf_file?serial=" + S_SINGLE_REP.htmlSn + file_args;
                    return false;
                },
                complete: function (filename) {
                    WGRD.progressModalClose();
                }
            });
       });

        // Add handler for change the type of chart
        $("#chart_select").change(function () {   S_SINGLE_REP.getData();  });
        $("#in_out_select").change(function () {   S_SINGLE_REP.getData();  });
        $("#bw_hits_select").change(function () {   S_SINGLE_REP.getData();  });

        $("#custom_datepicker_trigger").bind('click', function() {
            // Listen fora click on this div, it means the date changed 
            // and a refresh is needed
            S_SINGLE_REP.getData();
            S_SINGLE_REP.showHideDetailsLink();
        });

        $(window).bind('resizeEnd', function() {
            if(window.plot_trend) {
                var grid = "#grid_area";
                var parent = "#grid_data";
                var grid_width = resizegrid();
                $("#webui_content").width(grid_width);
                $(grid).setGridWidth(100, true); 
                $(grid).setGridWidth($(parent).width(), true);
                plot_trend.replot();
            }
        });

    },

    // Show the detail link only for those summary reports that have a corresponding details report
    showHideDetailsLink: function () {

        var rep_type_from_path = S_SINGLE_REP.reportPath.substring(S_SINGLE_REP.reportPath.lastIndexOf('/') + 1, S_SINGLE_REP.reportPath.length);

        $('#view_details_link').hide();
        if (rep_type_from_path === undefined) {
            return;
        }

        var detail_rep_name = S_SINGLE_REP.summary_detail_reports_map[rep_type_from_path];
        if (detail_rep_name === undefined || anonymization_enabled === 1) {
            return;
        }

        var dt = R_DATE_NAVBAR.getStartEndSeconds();
        var start_dt = dt[0];
        var end_dt = dt[1];
        var id = S_SINGLE_REP.id;
        if (!S_SINGLE_REP.id) {
            id = '';
        }

        $.ajax({
            url: 'get_detail_data?report_type=' + detail_rep_name + '&sn=' + S_SINGLE_REP.htmlSn + '&start_time=' + start_dt + '&end_time=' + end_dt + '&div=detail&rep_id=' + id + "&period=" + S_SINGLE_REP.period,
            method: 'GET',
            dataType: 'json',
            success: function (data) {
                if (data && data.col_model.length > 0 && data.col_names.length > 0) {
                    $('#view_details_link').show();
                    var detail_href = S_SINGLE_REP.detail_rep_path + S_SINGLE_REP.htmlSn + '&reptype=' + detail_rep_name;
                    $('#view_details_link').attr('href', detail_href);
                }
            }
        });
    },

    showChartLoading : function() {
        $('#chart_loading').show();
        $('#chart').hide();
    },

    interfaceDataHandler: function(series) {
        var interfaces = series.interfaces;
        S_SINGLE_REP.resultData = series;
        $('#interfaces_select').empty()
                               .show();
        $('#pivots_select').show();
        $.each(interfaces, function(index, value) {
            var interface_id = value[0];
            var interface_name = value[1];
            $('#interfaces_select').append('<option value='+ interface_id + ' title="'+ interface_name +'">' + interface_name + '</option>');
        });
        if (S_SINGLE_REP.id !== null) {
            $('#interfaces_select option[value=' + S_SINGLE_REP.id + ']').prop('selected', true);
        }
        S_SINGLE_REP.showInterfaceData();
    },

    showInterfaceData : function() {
       var interface_type = $('#interfaces_select option:selected').val();
       var series = S_SINGLE_REP.resultData[interface_type];

       onDataReceived(series, true);
       S_SINGLE_REP.dataReceived(series);
       S_SINGLE_REP.showPivotsData();
    },

    showPivotsData : function() {
       var interface_type = $('#interfaces_select option:selected').val();
       var series = S_SINGLE_REP.resultData[interface_type];
       var pivot_type = $('#pivots_select option:selected').val();

       onDataReceived(series, true);

       var grid = $("#grid_area");
       var parent = $("#grid_data");

       //Hide / show cols based on the pivot selected, always show 'Time' column
       if (pivot_type === 'by_bytes') {
           //Hide Upload Rate, Download Rate, Sent Packets, Received packets and Dropped packets col
           S_SINGLE_REP.showGridCols(false, grid, [3, 4, 5, 6, 7]);
           //Show Sent bytes and Received bytes col
           S_SINGLE_REP.showGridCols(true, grid, [1, 2]);
       } else if (pivot_type === 'by_rate') {
           //Hide Sent bytes, Received bytes, Sent Packets, Received packets and Dropped packets col
           S_SINGLE_REP.showGridCols(false, grid, [1, 2, 5, 6, 7]);
           //Show Upload Rate and Download Rate col
           S_SINGLE_REP.showGridCols(true, grid, [3, 4]);
       } else if (pivot_type === 'by_pckts') {
           //Hide Sent bytes, Received bytes, Upload Rate and Download Rate col
           S_SINGLE_REP.showGridCols(false, grid, [1, 2, 3, 4]);
           //Show Sent Packets, Received packets and Dropped packets col
           S_SINGLE_REP.showGridCols(true, grid, [5, 6, 7]);
       }
       var grid_width = resizegrid();
       $("#webui_content").width(grid_width);
       grid.setGridWidth(100, true); 
       grid.setGridWidth(parent.width(), true);
    },

    showGridCols : function (showCols, grid, cols) {
        $.each(cols, function(index, value) {
            if (showCols) {
                grid.jqGrid('showCol', grid.getGridParam("colModel")[value].name);
            } else {
                grid.jqGrid('hideCol', grid.getGridParam("colModel")[value].name);
            }
        });
    },

    getData : function () {
        var filter_view = '';
        var report_type = $('#chart_select option:selected').val();
        if ($.inArray(report_type, S_SINGLE_REP.show_bw_hits_rep_list) === -1) {
            $('#bw_hits_select').hide();
            $('#chart_select').css('width','187px');
        } 
        else {
            $('#bw_hits_select').show();
            $('#chart_select').css('width','120px');
            filter_view = $('#bw_hits_select option:selected').val();
        }

        if ($.inArray(report_type, ['top_cli_proxy_users', 'top_cli_proxy_hosts', 'top_cli_proxy_mobiles']) !== -1) {
            if (filter_view === '_conn_count') {
                $('#in_out_select').hide();
            }
            else {
                $('#in_out_select').show();
                filter_view = $('#in_out_select option:selected').val() + filter_view;
            }
        }

        var filter = {'filter_view': filter_view, 'filter_data': S_SINGLE_REP.filterData};
        //Once the date is set, refresh all the charts
        var jqxhr = getChartData('chart', S_SINGLE_REP.htmlSn, true, S_SINGLE_REP.id, filter);

        if (report_type !== 'interface_summary') { 
            jqxhr.success(S_SINGLE_REP.dataReceived);
        }
    },

    // Return data handler functions
    dataReceived : function (series) {
        var report_type = $('#chart_select option:selected').val();
        if (report_type !== 'interface_summary') { 
            S_SINGLE_REP.resultData = series;
        }

        showHideLinkIcon(series, 'pdf');

        S_SINGLE_REP.seriesEarliestRecord = series.earliest_record;
        S_SINGLE_REP.seriesLatestRecord = series.latest_record;
        S_SINGLE_REP.startTime = $.getDateDisplay(series.earliest_record, true, S_SINGLE_REP.urlTz);
        S_SINGLE_REP.endTime = $.getDateDisplay(series.latest_record, true, S_SINGLE_REP.urlTz);
        S_SINGLE_REP.reportName = $('#chart_select option:selected').text();

        // Notify the date navbar the report range changed
        $('#report_range').trigger('reportRange', { start_time: S_SINGLE_REP.startTime,
                                                    end_time: S_SINGLE_REP.endTime,
                                                    name: S_SINGLE_REP.reportName });
        if ($.inArray(report_type, S_SINGLE_REP.show_bw_hits_rep_list) !== -1 && report_type.indexOf('top_cli_proxy') === -1) {
            if ($('#bw_hits_select').is(":visible") && series.chart_type === "bar") {
                $('#bw_hits_select').hide();
                $('#chart_select').css('width','187px');
                var current_rep_name = $('#chart_select option:selected').text();
                if (current_rep_name.lastIndexOf(S_BY_HITS) === -1) {
                    $('#chart_select option:selected').text(current_rep_name + " " + S_BY_HITS);
                }
            }
        }

        // Handle the series contains filter label and filter data.
        if (S_SINGLE_REP.filterData === '' && series.filter_data && series.filter_data.length > 0) {
            if (series.filter_label) {
                $('#data_filter_label').text(series.filter_label[0]);
                $('#data_filter_label').show();
            }
            
            $('#data_filter_select').empty()
                                    .show();
            $.each(series.filter_data, function(index, value) {
                $('#data_filter_select').append('<option value="' + value.id + '">' + value.name + '</option>');
            });
            $('#data_filter_select').prop('selectedIndex', 0);
        }

        // Unload the grid and then recreate it and populate the rows
        jQuery("#grid_area").GridUnload("#grid_area");

        // When series contains no data, series.grid_sord is undefined,
        // which causes createGrid() to raise an error.
        // Can't let this function return at the beginning when series has no data,
        // because it would make the empty report shown not like usual
        if (series.grid_sort) {
            S_SINGLE_REP.createGrid(series.col_names, series.col_model, series.grid_sort);
        }

        var i = 0;
        for(i=0;i<=series.grid_data.length;i++) {
            $("#grid_area").jqGrid('addRowData',i+1,series.grid_data[i]);
        }
        $("#grid_area").setGridParam({rowNum:i});

        // For interface_summary reports, enable the colModel formatter on
        // the footer columns.
        footer_format = report_type === 'interface_summary'

        // Load the footer data.
        $("#grid_area").jqGrid('footerData','set', series.footer, footer_format);
    },

    // Report DataGrid
    createGrid : function (colNames, colModel, gridSort) {
        $("#grid_area").jqGrid({ 
            datatype: "local", 
            colNames:colNames,
            colModel:colModel,
            sortname: gridSort.sortname,
            sortorder: gridSort.sortorder,
            autoencode: true,
            height:'auto',
            autowidth: true,
            shrinkToFit: true,
            footerrow:true
        });

        $("#grid_area").setColProp('sent_bps', { formatter: WGRD.bpsFormatterGrid });
        $("#grid_area").setColProp('recv_bps', { formatter: WGRD.bpsFormatterGrid });

        var reportType = $('#chart_select option:selected').val();

        if (anonymization_enabled !== 1) {
            $("#grid_area").setColProp('host', { formatter: S_SINGLE_REP.linkFormatter });
            $("#grid_area").setColProp('ip', { formatter: S_SINGLE_REP.linkFormatter });
            $("#grid_area").setColProp('user', { formatter: S_SINGLE_REP.linkFormatter });
            $("#grid_area").setColProp('device', { formatter: S_SINGLE_REP.linkFormatter });

            if (reportType === "ips_signature" || reportType === "ips_source" || reportType === "ips_threat" || reportType === "ips_protocol") {
                $("#grid_area").setColProp('application', { formatter: S_SINGLE_REP.ipsLinkFormatter });
                $("#grid_area").setColProp('more_info', { formatter: S_SINGLE_REP.ipsLinkFormatter });
            } else if (reportType === "gav_virus" || reportType === "gav_host" || reportType === "gav_protocol" || reportType === "gav_email") {
                $("#grid_area").setColProp('application', { formatter: S_SINGLE_REP.gavLinkFormatter });
            } else if (reportType === "apt_malware_by_content" || reportType === "apt_malware_by_uuid" ||
                     reportType === "apt_malicious_activity" || reportType === "apt_mime" ||
                     reportType === "apt_protocol" || reportType === "apt_destination" ||
                     reportType === "apt_source" || reportType === "apt_threat" ||
                     reportType === "undetected_apt_malware_by_content" || reportType === "undetected_apt_malware_by_uuid" ||
                     reportType === "undetected_apt_malicious_activity" || reportType === "undetected_apt_destination" ||
                     reportType === "undetected_apt_threat") {
                $("#grid_area").setColProp('application', { formatter: S_SINGLE_REP.aptLinkFormatter });
            } else if (reportType === "botnet_block_sites" || reportType === "botnet_client" || reportType === "botnet_destination") {
                $("#grid_area").setColProp('name', { formatter: S_SINGLE_REP.botnetLinkFormatter });
            }
        }
    },

    linkFormatter : function(elem, cellval, opts) {
        return S_SINGLE_REP.formatPerClientLink(elem, cellval, opts);
    },

    formatPerClientLink : function (elem, cellval, opts) {
        var index = S_SINGLE_REP.startTime.indexOf(' ');
        var start_date = S_SINGLE_REP.startTime.substring(0, index);
        var start_time = S_SINGLE_REP.startTime.substring(index + 1, S_SINGLE_REP.startTime.length);
        index = S_SINGLE_REP.endTime.indexOf(' ');
        var end_date = S_SINGLE_REP.endTime.substring(0,index);
        var end_time = S_SINGLE_REP.endTime.substring(index + 1, S_SINGLE_REP.endTime.length);

        var uri = 'perclient?sn=' + S_SINGLE_REP.urlSn + 
                  '&start_date=' + start_date + 
                  '&start_time=' + start_time + 
                  '&end_date=' + end_date + 
                  '&end_time=' + end_time;
        uri += createURLToPerClient(elem, cellval, opts);
        return "<a href='" + uri + "'>" + escapeHtml(elem) + "</a>";
    },

    ipsLinkFormatter : function (elem, cellval, opts) {
        if(cellval.colModel.name === 'application') {
            var reportType = $('#chart_select option:selected').val();
            var uri = 'detail?sn=' + S_SINGLE_REP.urlSn;
            if(reportType === "ips_signature") {
                uri = uri + '&reptype=ips_detail&search=' + encodeURIComponent('signature=' + elem);
            }else if(reportType === "ips_source") {
                uri = uri + '&reptype=ips_detail&search=' + encodeURIComponent('source=' + elem);
            }else if(reportType === "ips_threat") {
                uri = uri + '&reptype=ips_detail&search=' + encodeURIComponent('threat=' + opts.severity);
            }else if(reportType === "ips_protocol") {
                uri = uri + '&reptype=ips_detail&search=' + encodeURIComponent('protocol=' + elem);
            }
            return "<a href='" + uri + "'>" + elem + "</a>";
        } else if(cellval.colModel.name === 'more_info') {
            return "<a href='" + S_SINGLE_REP.portal_link + opts.application +"' target='ipsportal'>"+ elem + "</a>";
        }
    },

    gavLinkFormatter : function (elem, cellval, opts) {
        if(cellval.colModel.name === 'application') {
            var reportType = $('#chart_select option:selected').val();
            var uri = 'detail?sn=' + S_SINGLE_REP.urlSn;
            if(reportType === "gav_virus") {
                uri = uri + '&reptype=gav_detail&search=' + encodeURIComponent('virus=' + elem);
            }else if(reportType === "gav_host") {
                uri = uri + '&reptype=gav_detail&search=' + encodeURIComponent('host=' + elem);
            }else if(reportType === "gav_protocol") {
                uri = uri + '&reptype=gav_detail&search=' + encodeURIComponent('protocol=' + elem);
            }else if(reportType === "gav_email") {
                uri = uri + '&reptype=gav_detail&search=' + encodeURIComponent('email=' + elem);
            }
        }
        return "<a href='" + uri + "'>" + elem + "</a>";
    },

    aptLinkFormatter : function (elem, cellval, opts) {
        if(cellval.colModel.name === 'application') {
            var reportType = $('#chart_select option:selected').val();
            var uri = 'detail?sn=' + S_SINGLE_REP.urlSn;
            if(reportType === "apt_malware_by_content" || reportType === "apt_malware_by_uuid") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('threat_id=' + elem);
            }else if(reportType === "apt_malicious_activity") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('activity=' + elem);
            }else if(reportType === "apt_mime") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('mime_type=' + elem);
            }else if(reportType === "apt_protocol") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('protocol=' + elem);
            }else if(reportType === "apt_destination") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('recipient_destination=' + elem);
            }else if(reportType === "apt_source") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('sender_source=' + elem);
            }else if(reportType === "apt_threat") {
                uri = uri + '&reptype=apt_detail&search=' + encodeURIComponent('threat_level=' + elem);
            }else if(reportType === "undetected_apt_malware_by_content" || reportType === "undetected_apt_malware_by_uuid") {
                uri = uri + '&reptype=undetected_apt_detail&search=' + encodeURIComponent('threat_id=' + elem);
            }else if(reportType === "undetected_apt_malicious_activity") {
                uri = uri + '&reptype=undetected_apt_detail&search=' + encodeURIComponent('activity=' + elem);
            }else if(reportType === "undetected_apt_destination") {
                uri = uri + '&reptype=undetected_apt_detail&search=' + encodeURIComponent('recipient_destination=' + elem);
            }else if(reportType === "undetected_apt_threat") {
                uri = uri + '&reptype=undetected_apt_detail&search=' + encodeURIComponent('threat_level=' + elem);
            }
            return "<a href='" + uri + "'>" + elem + "</a>";
        }
    },

    botnetLinkFormatter : function (elem, cellval, opts) {
        if (cellval.colModel.name === "name") {
            var reportType = $('#chart_select option:selected').val();
            var uri = 'detail?sn=' + S_SINGLE_REP.urlSn;
            if (reportType === "botnet_block_sites") {
                uri = uri + '&reptype=botnet_detail&search=' + encodeURIComponent('botnet=' + elem);
            }else if (reportType === "botnet_client") {
                uri = uri + '&reptype=botnet_detail&search=' + encodeURIComponent('source=' + elem);
            }else if (reportType === "botnet_destination") {
                uri = uri + '&reptype=botnet_detail&search=' + encodeURIComponent('destination=' + elem);
            }
            return "<a href='" + uri + "'>" + elem + "</a>";
        }
    }
};
$(document).ready(S_SINGLE_REP.init);
