$(document).ready(function() {                      
    var htmlDate = $("#date").val();
    var htmlSn = $("#sn").val();
    var urlTz = $.getUrlVar('tz');         
    var resultData = new Object();

    /* Start page loading by retrieving the data */
    getData();
    
    function getData(){
        showLoading();
        var seconds = R_DATE_NAVBAR.getStartEndSeconds();
        var start_seconds = seconds[0];
        var end_seconds = seconds[1];
        var jqxhr = $.ajax({
           url: 'get_data?report_type=server_audit_detail&sn=' + htmlSn + '&div=audit_grid_area' + '&start_time=' + start_seconds + '&end_time=' + end_seconds,
           method: 'GET',
           dataType: 'json',
           success: success,
           error: errorHandler
        });     
        return jqxhr;
    }     
    
    function success(series){
        if(series.count > 0){
            showTable();
            $("#csv_link_detail").show();
            $('#audit_grid_area').GridUnload('#audit_grid_area');
            $('#audit_grid_area').jqGrid({ 
                datatype: "local", 
                colNames:series.col_names,
                colModel:series.col_model,
                sortname: series.grid_sort.sortname,
                sortorder: series.grid_sort.sortorder,                
                autoencode: true,
                height:'auto',
                autowidth: true,
                shrinkToFit: true
            });             
            
            var i = 0; 
            for(i=0;i<series.grid_data.length;i++) {
                $('#audit_grid_area').jqGrid('addRowData',i+1,series.grid_data[i]);
            }   
            $("#audit_grid_area").setGridParam({rowNum:i});                                    
                        
        }else{
            showEmpty();
            $("#csv_link_detail").hide();
        }        
        resultData = series;
    }    
    
    
    $("#custom_datepicker_trigger").unbind('click').click( function() {
        // Listen fora click on this div, it means the date changed 
        // and a refresh is needed
        getData();
    });       

    function showTable(){
        $("#audit_grid_data").show();
        $("#audit_loading").hide();
        $("#audit_empty").hide();
    }
    function showEmpty(){
        $("#audit_empty").show();            
        $("#audit_grid_data").hide();
        $("#audit_loading").hide();
    }
    function showLoading(){
        $("#audit_loading").show();    
        $("#audit_empty").hide();            
        $("#audit_grid_data").hide();
    }    
    
    $('#csv_link_detail').click(function(){
        // No data available 
        if(resultData.count <= 0){
            return;
        }

        resultData.grid_data = updateTimezones(resultData.grid_data, resultData.col_model);
        resultData.user_data = updateUserTimezones(resultData.user_data, resultData.user_col_model);

        data = JSON.stringify(resultData);

        var startTime = R_DATE_NAVBAR.convertDateStr2GMT(R_DATE_NAVBAR.getStartEndIsoStr()[0] + ":00");
        var endTime = R_DATE_NAVBAR.convertDateStr2GMT(R_DATE_NAVBAR.getStartEndIsoStr()[1] + ":00");

        WGRD.progressModal(S_EXPORTING_FILE, S_PROCESSING);

        $.ajax({
            url:"saveAsCsv?serial=" + htmlSn +  "&client_tz=" + WGRD.client_tz + "&report_type=server_audit_detail" + "&start_time=" + startTime + "&end_time=" + endTime,
            type: 'POST',
            data: data,
            contentType: 'application/json',
            success: function(data) {                
                if(!data.status){
                    if(data.message){
                        alert(data.message);
                    }
                    return true;
                }
                var file_args = '&tmp_file_name=' + data.tmp_file_name + '&file_name=' + data.file_name;
                window.location = "get_csv_file?serial=" + htmlSn + file_args;
                return false;
            },
            complete: function (filename) {
                WGRD.progressModalClose();
            }
        });
    }); 
});