$(document).ready(function() {
	var resultData = new Object();
	var reportName = '';             
	var reportCategory = '';
    var htmlSn = $("#sn").val();      
    var reportType = $("#report_type").val();
    var urlTz = $.getUrlVar('tz');
    var startTime = '';
    var endTime = '';
    
	$('#pdf_link').click(function(){
		resultData.grid_data = updateTimezones(resultData.grid_data, resultData.col_model);
		resultData.user_data = updateUserTimezones(resultData.user_data, resultData.user_col_model);
		
		data = JSON.stringify(resultData);
		
		var tzOffsetStart = $.getDateUTCOffsetString(startTime, urlTz);
		var tzOffsetEnd = $.getDateUTCOffsetString(endTime, urlTz);

		$.ajax({
			url:"saveAsPdf?serial=" + htmlSn + "&client_tz=" + WGRD.client_tz + "&report_type=" + reportType + "&start_time=" + startTime + "&end_time=" + endTime
			      + "&tz_offset_start=" + tzOffsetStart +  "&tz_offset_end=" + tzOffsetEnd,
			type: 'POST',
			data: data,
			contentType: 'application/json',
			success: function(data) {
				if(!data.status){
					if(data.message){
						alert(data.message);
					}
					return true;
				}
				window.location = "get_pdf_file?serial=" + htmlSn;
				return false;
			}	
		});
	}); 
    
    getData();
         
    function showChartLoading(){
        $('#chart_loading').show();        
        $('#chart_empty').hide();                
        $('#chart').hide();
    }
     
    function getData(){
        //Once the date is set, refresh all the charts
        var jqxhr = getOnDemandChartData('chart', htmlSn, true, true, reportType);
    }
    
    function getOnDemandChartData(){
        var b_time = $('#start_time_picker').val();
        var e_time = $('#end_time_picker').val();
        var begin_time = $.getDateLocalToSecs(b_time);
        var end_time = $.getDateLocalToSecs(e_time); 
                    
        if(!begin_time || !end_time){ return; }

        showChartLoading('chart');
        var jqxhr = $.ajax({
           url: 'get_ondemand_data?report_type=' + reportType + '&sn=' + htmlSn + '&start_time=' + begin_time + '&end_time=' + end_time,
           method: 'GET',
           dataType: 'json',
           success: onDemandReceived,
           error: errorHandler
        });     
        return jqxhr;
    }     
     
    // Return data handler functions
    function onDemandReceived(series){
        if(series.count > 0){
            showChart('chart');
            plotChart(series, 'chart', true);
        }else{
            showChartEmpty('chart');
            return;
        }        
    
        startTime = $.getDateDisplay(series.earliest_record, true, urlTz);
        endTime = $.getDateDisplay(series.latest_record, true, urlTz);
        $('#report_select').find('option:selected').each(function(){
        	reportCategory = $(this).parent().attr("label");
        });
        reportName = $('#report_select option:selected').text(); 
        
        // Unload the grid and then recreate it and populate the rows
        jQuery("#grid_area").GridUnload("#grid_area");
        createGrid(series.col_names, series.col_model);
                        
        var i = 0;
        for(i=0;i<=series.grid_data.length;i++) {
            $("#grid_area").jqGrid('addRowData',i+1,series.grid_data[i]);
        }
        $("#grid_area").setGridParam({rowNum:i});        
        $("#grid_area").jqGrid('footerData','set', series.footer, false);          
        
        resultData = series;     
    }          
     
    // Report DataGrid
    function createGrid(colNames, colModel){
        $("#grid_area").jqGrid({ 
            datatype: "local", 
            colNames:colNames,
            colModel:colModel,
            autoencode: true,
            autowidth: true,
            shrinkToFit: true,
            footerrow:true,
            height:'auto'         
        });       
        $("#grid_area").setColProp('host', { formatter: linkFormatter });     
        $("#grid_area").setColProp('ip', { formatter: linkFormatter });     
        $("#grid_area").setColProp('user', { formatter: linkFormatter });        
    }
         
    linkFormatter = function(elem, cellval, opts){
        return formatPerClientLink(elem, cellval);
    }

    function formatPerClientLink(elem, cellval){
        var index = startTime.indexOf(' ');
        var start_date = startTime.substring(0,index);
        var start_time = startTime.substring(index + 1, startTime.length);
        index = endTime.indexOf(' ');
        var end_date = endTime.substring(0,index);
        var end_time = endTime.substring(index + 1, endTime.length);            

        uri = 'perclient?sn=' + htmlSn + 
              '&start_date=' + start_date + 
              '&start_time=' + start_time + 
              '&end_date=' + end_date + 
              '&end_time=' + end_time;
        if(cellval.colModel.name == 'ip'){
            uri = uri + '&ip=' + elem;
        }else if(cellval.colModel.name == 'user'){
            uri = uri + '&user=' + elem;
        }else if(cellval.colModel.name == 'host'){
            uri = uri + '&host=' + escape(elem);
        }              

        return "<a href='" + uri + "'>" + escapeHtml(elem) + "</a>";
    }                    
    
    $(window).bind('resizeEnd', function() {
        if(window.plot_trend){  
            var grid = "#grid_area";
            var parent = "#grid_data";
            var grid_width = resizegrid();
            $("#webui_content").width(grid_width);
            $(grid).setGridWidth(100, true); 
            $(grid).setGridWidth($(parent).width(), true);
            plot_trend.replot();
        }
    });     
});
