/*global checkLoginPageRedirect, view_logs_for_specific_device_perm, view_reports_for_specific_device_perm, monitor_device_perm, date_nav_start_date, R_DATE_NAVBAR_CONTROL, R_DATE_NAVBAR_CONTROL_HEALTH, R_DATE_NAVBAR_LOGS, R_DATE_NAVBAR_LOGMANAGER, R_DATE_NAVBAR_LOGSEARCH, sn_is_group, R_DATE_NAVBAR_DASHBOARDS, R_DATE_NAVBAR_EXECUTIVE, R_DATE_NAVBAR_SECURITY, R_DATE_NAVBAR_THREATMAP, R_DATE_NAVBAR_FIREWATCH, R_DATE_NAVBAR_FLOWMAP, R_DATE_NAVBAR_ACCESS_POINTS, R_DATE_NAVBAR_MOBILE_DEVICES, R_DATE_NAVBAR_REPORTS, R_DATE_NAVBAR_PERCLIENT_SUMMARY, R_DATE_NAVBAR_PERCLIENT_DETAIL, R_DATE_NAVBAR_COLLAPSE_TEXT, R_DATE_NAVBAR_EXPAND_TEXT, R_DATE_NAVBAR_LAST_UPDATE, R_DATE_NAVBAR_SECURITY_SERVICES, anonymization_enabled*/
var R_DATE_NAVBAR = {
    urlSn: '',
    lastStartTime: '',
    lastEndTime: '',
    needData: false,
    startPickerIsOpen: false,
    endPickerIsOpen: false,
    repDates: {},
    availDates: {},
    COLLAPSE_THRESHOLD: 768,
    autoCollapse: true,
    active_div_id: '',
    init: function () {
        R_DATE_NAVBAR.urlSn = $.getUrlVar('sn');

        R_DATE_NAVBAR.initUI();
        R_DATE_NAVBAR.initEvents();
        R_DATE_NAVBAR.initTimeZone();
        R_DATE_NAVBAR.getAvailDates();
        R_DATE_NAVBAR.toggleMobile();
        R_DATE_NAVBAR.doResize();
    },
    initUI: function () {
        if ($('#wgrd_nav').length === 0) {
            // The navigation is hidden so remove all traces of it
            R_DATE_NAVBAR.hideNavClasses();
        } else {
            $("body").addClass("bkgrnd");
        }

        $("#datepicker").attr('disabled', true);
        $("#datepicker_end").attr('disabled', true);
        $('#available_reports').show();

        // Create date picker and handle events (need to do this before we set the date)
        $("#datepicker").datetimepicker({
            onClose: R_DATE_NAVBAR.onCloseStart,
            onSelect: R_DATE_NAVBAR.onSelectStart,
            beforeShow: R_DATE_NAVBAR.beforeShowStart,
            beforeShowDay: R_DATE_NAVBAR.beforeShowDay,
            dateFormat: 'yy-mm-dd'
        });
        $("#datepicker_end").datetimepicker({
            onClose: R_DATE_NAVBAR.onCloseEnd,
            onSelect: R_DATE_NAVBAR.onSelectEnd,
            beforeShow: R_DATE_NAVBAR.beforeShowEnd,
            beforeShowDay: R_DATE_NAVBAR.beforeShowDayEnd,
            dateFormat: 'yy-mm-dd'
        });

        $(document).on('click', '#date_apply', function () {
            R_DATE_NAVBAR.updateReport(R_DATE_NAVBAR.apply_starttime, R_DATE_NAVBAR.apply_endtime);
            R_DATE_NAVBAR.datePickerState();
        });

        $(document).on('click', '.ui-datepicker-close', R_DATE_NAVBAR.onDone);

        $("#datepicker").change(R_DATE_NAVBAR.weNeedData);
        $("#datepicker_end").change(R_DATE_NAVBAR.weNeedData);
        $("#show_hide_reps").on('click', R_DATE_NAVBAR.toggleReportsHeader);
        $(document).on('click', "li.nav-header", R_DATE_NAVBAR.trackHeaderState);
        R_DATE_NAVBAR.trackHeaderState();
        R_DATE_NAVBAR.toggleReportsHeader();
        R_DATE_NAVBAR.datePickerState();
    },
    initEvents: function () {
        $(window).bind('resizeEnd', function () {
            R_DATE_NAVBAR.doResize();
        });

        $(".mobile_datenav_btn").click(function (eo) {
            var visible_phone = false;
            if ($(window).width() < R_DATE_NAVBAR.COLLAPSE_THRESHOLD) {
                visible_phone = true;
            }
            R_DATE_NAVBAR.autoCollapse = false;
            if ($("#daily_mobile").css('display') !== 'none') {
                R_DATE_NAVBAR.toggleMobile(false);
                if (!visible_phone) {
                    $(window).resize();
                }
            } else {
                R_DATE_NAVBAR.toggleMobile(true);
                $(window).resize();
            }
        });
        $('#report_tabs a[data-toggle="tab"]').on('shown', function (e) {
            var curTab = e.target.toString();
            R_DATE_NAVBAR.datePickerState(curTab);
            R_DATE_NAVBAR.curTab = curTab;
        });
    },
    setUpdateTime: function (dateStr) {
        $("#reports_last_update").text(R_DATE_NAVBAR_LAST_UPDATE + dateStr);
    },
    datePickerState: function (curTab) {
        var thispage = window.location.pathname;
        if ((thispage === '/control/device' || thispage === '/control/config_history') &&
                (curTab === undefined || curTab.indexOf('tabReports') === -1)) {
            $("#date_change_buttons").hide();
            $("#start_date_disabled").show();
            $("#end_date_disabled").show();
            $("#datepicker").hide();
            $("#datepicker_end").hide();
            $("#reports_last_update").show();
            $("#reports_toolbar_start").hide();
            $("#reports_toolbar_end").hide();
        } else {
            $("#date_change_buttons").hide();
            $("#start_date_disabled").hide();
            $("#end_date_disabled").hide();
            $("#datepicker").removeAttr('disabled')
                            .show();
            $("#datepicker_end").removeAttr('disabled')
                                .show();
            $("#reports_last_update").hide();
            $("#reports_toolbar_start").show();
            $("#reports_toolbar_end").show();
        }
    },
    updatePerClientURI: function (event) {
        event.preventDefault();
        var href = event.target.href;
        var ip_addr = $('#ip_addr').val();
        var host_name = $('#host_name').val();
        var user_name = $('#user_name').val();
        var device_name = $('#device_name').val();
        var policy_name = $('#policy_name').val();
        var rule_name = $('#rule_name').val();
        if (ip_addr !== undefined && ip_addr !== '') {
            href += "&ip=" + ip_addr;
        }
        if (host_name !== undefined && host_name !== '') {
            href += "&host=" + encodeURIComponent(host_name);
        }
        if (user_name !== undefined && user_name !== '') {
            href += "&user=" + user_name;
        }
        if (device_name !== undefined && device_name !== '') {
            href += "&device=" + encodeURIComponent(device_name);
        }
        if (policy_name !== undefined && policy_name !== '') {
            href += "&policy=" + policy_name;
        }
        if (rule_name !== undefined && rule_name !== '') {
            href += "&rule=" + rule_name;
        }
        window.location = href;
    },
    toggleMobile: function (b) {
        var closed = false;
        if ($('#main_div').hasClass('nav-closed')) {
            closed = true;
        }
        if (b) {
            $("#daily_desktop").hide();
            $(".mobile_datenav_btn.btn").addClass("closed");
            $("body").removeClass("bkgrnd");
            $("body").addClass("no-bkgrnd");
            if (!closed) {
                $("#wgrd_nav").animate({
                    left: "-=234"
                }, 500, function () {
                    $(".mobile_date_navbar_daterange").fadeIn("slow");
                    $("#daily_mobile").fadeIn("slow");
                });
            }
            $("#main_div").addClass("nav-closed");
            setTimeout(function () {
                $(window).resize();
            }, 510);
        } else {
            $("#daily_desktop").show();
            $("#daily_mobile").hide();
            $(".mobile_datenav_btn.btn").removeClass("closed");
            if (closed) {
                $("#wgrd_nav").animate({
                    left: "+=234"
                }, 500, function () {
                    $("body").removeClass("no-bkgrnd");
                    $("body").addClass("bkgrnd");
                });
            }
            $("#main_div").removeClass("nav-closed");
            setTimeout(function () {
                $(window).resize();
            }, 510);
        }
    },

    hideNavClasses : function () {
        $(".mobile_datenav_btn.btn").addClass("closed");
        $("#main_div").addClass("nav-closed");
        $("body").removeClass("bkgrnd");
        $("body").addClass("no-bkgrnd");
    },

    doResize: function () {
        if (!R_DATE_NAVBAR.autoCollapse) {
            return;
        }
        if ($(window).width() < R_DATE_NAVBAR.COLLAPSE_THRESHOLD) {
            if ($("#daily_mobile").css('display') === 'none') {
                R_DATE_NAVBAR.toggleMobile(true);
                $(window).resize();
            }
        } else {
            if ($("#daily_mobile").css('display') !== 'none') {
                R_DATE_NAVBAR.toggleMobile(false);
                $(window).resize();
            }
        }
    },
    convertDate: function (dateStr) {
        var dateParts = dateStr.match(/(\d+)/g);
        var secs = "00";
        if (dateParts.length > 5) {
            secs = dateParts[5];
        }
        var newDate = new Date(dateParts[0], dateParts[1] - 1, dateParts[2], dateParts[3], dateParts[4], secs);

        return newDate;
    },
    /* Date picker support --> */
    getShortDateText: function (dateText) {
        if (dateText === '' || dateText === null) {
            return dateText;
        }
        return dateText.substring(dateText.length - 5);
    },
    onSelectStart: function (dateText, inst) {
        if (dateText.length > 5) {
            var newStartTime = R_DATE_NAVBAR.getShortDateText(dateText);
            if ((R_DATE_NAVBAR.lastStartTime.length > 0 || newStartTime !== '00:00') && R_DATE_NAVBAR.lastStartTime !== newStartTime) {
                // Don't refresh when changing time
                R_DATE_NAVBAR.lastStartTime = newStartTime;
                R_DATE_NAVBAR.needData = true;
                return;
            }
            R_DATE_NAVBAR.updateTimeStart(dateText);
        }
    },
    onSelectEnd: function (dateText, inst) {
        if (dateText !== '') {
            var newEndTime = R_DATE_NAVBAR.getShortDateText(dateText);
            if ((R_DATE_NAVBAR.lastEndTime.length > 0 || newEndTime !== '00:00') && R_DATE_NAVBAR.lastEndTime !== newEndTime) {
                // Don't refresh when changing time
                R_DATE_NAVBAR.lastEndTime = newEndTime;
                R_DATE_NAVBAR.needData = true;
                return;
            }
            R_DATE_NAVBAR.updateTimeEnd(dateText);
        }
    },
    updateTimeStart: function (newStartTime) {
        if (newStartTime !== null && newStartTime.length > 5) {
            // Called on datepicker close through done, clicking away, or clicking on a month.
            var start_time = $('#datepicker').datetimepicker('getDate');
            var end_time = $('#datepicker_end').datetimepicker('getDate');
            var start_time_fmt = start_time.format("yyyy-mm-dd HH:MM:ss");
            if (start_time && end_time && end_time <= start_time) {
                //$("#datepicker_end").datepicker("setDate", null);
                $("#datepicker_end").val('');
                end_time = null;
            }
            var end_time_fmt = '';
            if (end_time !== null) {
                end_time_fmt = end_time.format("yyyy-mm-dd HH:MM:ss");
            }
            R_DATE_NAVBAR.lastStartTime = R_DATE_NAVBAR.getShortDateText(newStartTime);

            R_DATE_NAVBAR.setCurrentDate(start_time_fmt, end_time_fmt);
            $("#datepicker").datetimepicker("hide");
            R_DATE_NAVBAR.needData = false;
            R_DATE_NAVBAR.startPickerIsOpen = false;
        }
    },
    updateTimeEnd: function (newEndTime) {
        if (newEndTime !== '') {
            // Called on datepicker close through done, clicking away, or clicking on a month.
            var start_time = $('#datepicker').datetimepicker('getDate');
            var end_time = $('#datepicker_end').datetimepicker('getDate');
            if (start_time === null) {
                return;
            }
            var end_time_fmt = end_time.format('yyyy-mm-dd HH:MM:ss');
            var start_time_fmt = '';
            if (start_time && end_time) {
                var start_secs = start_time.getTime();
                var end_secs = end_time.getTime();
                if (end_secs === start_secs) {
                    // Let the user adjust the time in this case
                    return;
                }
                if (end_secs < start_secs) {
                    // Clear the end time
                    $("#datepicker_end").val('');
                    end_time = null;
                    end_time_fmt = '';
                }
            }
            R_DATE_NAVBAR.lastEndTime = R_DATE_NAVBAR.getShortDateText(newEndTime);

            start_time_fmt = start_time.format("yyyy-mm-dd HH:MM:ss");
            R_DATE_NAVBAR.setCurrentDate(start_time_fmt, end_time_fmt);
            $("#datepicker_end").datetimepicker("hide");
            R_DATE_NAVBAR.needData = false;
            R_DATE_NAVBAR.endPickerIsOpen = false;
        }
    },
    weNeedData: function () {
        R_DATE_NAVBAR.needData = true;
    },
    onDone: function () {
        // Called when the done button is clicked.
        if (R_DATE_NAVBAR.startPickerIsOpen) {
            var start_time = R_DATE_NAVBAR._getInternalTimeStr(true);
            R_DATE_NAVBAR.updateTimeStart(start_time);
        } else if (R_DATE_NAVBAR.endPickerIsOpen) {
            var end_time = R_DATE_NAVBAR._getInternalTimeStr(false);
            R_DATE_NAVBAR.updateTimeEnd(end_time);
        }
    },
    beforeShowDay: function (date) {
        if (R_DATE_NAVBAR.repDates[date.format("yyyy-mm-dd")]) {
            return [true, ''];
        }
        return [false, ''];
    },
    beforeShowDayEnd: function (date) {
        var d = new Date(date);
        var start_time = $('#datepicker').datepicker('getDate');
        start_time.setHours(0, 0, 0);
        if (start_time > d) {
            return [false, ''];
        }
        if (R_DATE_NAVBAR.repDates[date.format("yyyy-mm-dd")]) {
            return [true, ''];
        }
        return [false, ''];
    },
    beforeShowStart: function (input, inst) {
        R_DATE_NAVBAR._beforeShowCommon(input, inst);
        R_DATE_NAVBAR.startPickerIsOpen = true;
    },
    beforeShowEnd: function (input, inst) {
        R_DATE_NAVBAR._beforeShowCommon(input, inst);
        R_DATE_NAVBAR.endPickerIsOpen = true;
    },
    _beforeShowCommon: function (input, inst) {
        var widget = $(inst).datepicker('widget');
        widget.css('font-size', '11px');
        widget.css('margin-left', ($(input).outerWidth() - widget.outerWidth()) / 2);
    },
    convertDateStr2GMT: function (dateStr) {
        function f(n) {
            // Format integers to have at least two digits.
            return n < 10 ? '0' + n : n;
        }

        var newDate = R_DATE_NAVBAR.convertDate(dateStr);

        var gmtStr = newDate.getUTCFullYear() + '-' +
                     f(newDate.getUTCMonth() + 1) + '-' +
                     f(newDate.getUTCDate()) + ' ' +
                     f(newDate.getUTCHours()) + ':' +
                     f(newDate.getUTCMinutes()) + ':' +
                     f(newDate.getUTCSeconds());
        return gmtStr;
    },
    initTimeZone: function () {
        if (date_nav_start_date !== '') {
            if (parseInt(view_logs_for_specific_device_perm, 10) === 0 && parseInt(view_reports_for_specific_device_perm, 10) === 1) {
                var date_text = $("#date").val();
                var end_date_text = $("#end_date").val();
                date_text = $.getDateDisplay(date_text + " GMT", false, '');
                if (end_date_text.trim().length > 0) {
                    end_date_text = $.getDateDisplay(end_date_text + " GMT", false, '');
                    R_DATE_NAVBAR.setCurrentDate(date_text, end_date_text);
                } else {
                    R_DATE_NAVBAR.setCurrentDate(date_text);
                }
                return;
            }
            R_DATE_NAVBAR.getDailyReports();
            return;
        }
        var d = new Date();
        d.setHours(0, 0, 0);
        var midnight_local = d.format("yyyy-mm-dd HH:MM:ss");
        $('#datepicker').datepicker("setDate", R_DATE_NAVBAR.convertDate(midnight_local));
        R_DATE_NAVBAR.updateReport(midnight_local);
    },

    getAvailDates: function () {

        $.ajax({
            url: '/report/get_avail_dates?sn=' + R_DATE_NAVBAR.urlSn,
            method: 'GET',
            dataType: 'json',
            error: checkLoginPageRedirect,
            success: R_DATE_NAVBAR.onAvailDates
        });
    },
    onAvailDates: function (data) {
        R_DATE_NAVBAR.datePickerState();
        // If no data and only monitor_device_perm then just show the conrol url)
        if (data.length === 0 && (parseInt(monitor_device_perm, 10) === 0)) {
            R_DATE_NAVBAR.createControlSection();
            return;
        }
        var availDate,
            rep,
            localDate;
        for (rep in data) {
            if (data.hasOwnProperty(rep)) {
                availDate = rep.replace(" GMT", "");
                availDate = availDate.replace(/\-/g, "/");
                // Save the available dates(yyyy/mm/dd HH:00:00)
                R_DATE_NAVBAR.availDates[availDate] = true;
                localDate = $.getDateDisplay(rep);
                localDate = localDate.substring(0, localDate.indexOf(' '));
                R_DATE_NAVBAR.repDates[localDate] = true;
            }
        }
    },

    setCurrentDate: function (starttime, endtime) {
        $("#date_change_buttons").show();
        $("#reports_toolbar_start").hide();
        $("#reports_toolbar_end").hide();
        R_DATE_NAVBAR.apply_starttime = starttime;
        R_DATE_NAVBAR.apply_endtime = endtime;
    },
    updateReport: function (starttime, endtime) {
        // Set the date on the server, must implement the getAllData function in each tab
        R_DATE_NAVBAR.apply_starttime = starttime;
        R_DATE_NAVBAR.apply_endtime = endtime;

        $("#date").val(starttime);

        var url = '/report/set_date?sn=' + R_DATE_NAVBAR.urlSn + '&date_text=' + R_DATE_NAVBAR.convertDateStr2GMT(starttime);
        if (endtime) {
            url += '&end_date_text=' + R_DATE_NAVBAR.convertDateStr2GMT(endtime);
        }
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: checkLoginPageRedirect,
            success: R_DATE_NAVBAR.dateSet
        });
    },
    dateSet: function (data) {

        // Call a click event on a hidden prop so the tabs can refresh when the date changes
        //$("#custom_datepicker_trigger").click();
        if (parseInt(view_logs_for_specific_device_perm, 10) === 0 &&  parseInt(view_reports_for_specific_device_perm, 10) === 1) {
            R_DATE_NAVBAR.createLogsSection(data);
        } else {
            R_DATE_NAVBAR.getDailyReports();
        }
    },

    createControlSection : function () {
        var fragment = '<ul class="nav nav-list">';
        var dashboard = '';
        var classval;
        var control_urls = [
            { 'href': '', 'name': R_DATE_NAVBAR_CONTROL },
            { 'href': '/control/device?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_CONTROL_HEALTH }
        ];
        var thispage = window.location.pathname + window.location.search;
        var href;
        for (dashboard in control_urls) {
            if (control_urls.hasOwnProperty(dashboard)) {
                href = control_urls[dashboard].href;
                if (thispage.indexOf(href) === 0) {
                    $('#report_tabs a[href="#tabDashboard"]').tab("show");
                    classval = "active";
                }
                if (href === '') {
                    fragment += '<li class="nav-header">' + control_urls[dashboard].name + '</li>';
                } else {
                    fragment += '<li class="' + classval + '"><a href="' + control_urls[dashboard].href + '">' + control_urls[dashboard].name + '</a></li>';
                }
                classval = '';
            }
        }
        fragment += '</ul>';
        $("#todays_dashboard").html(fragment);
    },

    createLogsSection: function (data) {
        var fragment = '';
        var dashboard = '';
        var dashboard_urls = [];
        var classval;

        var show_lm = true;
        if (anonymization_enabled === 1) {
            show_lm = false;
        }

        var log_urls  = [
            { 'href': '', 'name': R_DATE_NAVBAR_LOGS, 'show': show_lm },
            { 'href': '/log/device?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_LOGMANAGER, 'show': show_lm },
            { 'href': '/log/search?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_LOGSEARCH, 'show': show_lm }
        ];
        // For servers, update the url to pass in srv information
        if (R_DATE_NAVBAR.pageIsServerReport()) {
            log_urls = [
                { 'href': '', 'name': R_DATE_NAVBAR_LOGS, 'show': show_lm},
                { 'href': '/log/server?sn=' + R_DATE_NAVBAR.urlSn + "&l_t=srv" + "&name=" + $.getUrlVar('name'), 'name': R_DATE_NAVBAR_LOGMANAGER, 'show': show_lm }
            ];
        }
        var control_urls = [
            { 'href': '', 'name': R_DATE_NAVBAR_CONTROL, 'show': true},
            { 'href': '/control/device?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_CONTROL_HEALTH, 'show': true }
        ];
        var thispage = window.location.pathname + window.location.search;

        fragment += '<ul class="nav nav-list">';
        // Show control page if we have manage device perm and sn is not group
        if (parseInt(monitor_device_perm, 10) === 0 && parseInt(sn_is_group, 10) === 0) {
            dashboard_urls = control_urls.concat(log_urls);
        } else {
            dashboard_urls = log_urls;
        }
        var href,
            show;
        for (dashboard in dashboard_urls) {
            if (dashboard_urls.hasOwnProperty(dashboard)) {
                href = dashboard_urls[dashboard].href;
                show = dashboard_urls[dashboard].show;
                if (show !== undefined && show === false) {
                    continue;
                }
                if (thispage.indexOf(href) === 0) {
                    $('#report_tabs a[href="#tabDashboard"]').tab("show");
                    classval = "active";
                }
                if (href === '') {
                    fragment += '<li class="nav-header">' + dashboard_urls[dashboard].name + '</li>';
                } else {
                    fragment += '<li class="' + classval + '"><a href="' + dashboard_urls[dashboard].href + '">' + dashboard_urls[dashboard].name + '</a></li>';
                }
                classval = '';
            }
        }
        fragment += '</ul>';
        $("#todays_dashboard").html(fragment);

        R_DATE_NAVBAR.convertTimeAndDisplay(data);
        $("#custom_datepicker_trigger").click();
    },

    getDailyReports: function () {
        // Get the list of reports for the current date
        var is_server_report = R_DATE_NAVBAR.pageIsServerReport();
        if (is_server_report === true) {
            $.ajax({
                url: '/report/get_daily_reports?sn=' + R_DATE_NAVBAR.urlSn + "&server_reports=true",
                method: 'GET',
                dataType: 'json',
                error: checkLoginPageRedirect,
                success: R_DATE_NAVBAR.onDataDailyServerReports
            });
        } else {
            $.ajax({
                url: '/report/get_daily_reports?sn=' + R_DATE_NAVBAR.urlSn,
                method: 'GET',
                dataType: 'json',
                error: checkLoginPageRedirect,
                success: R_DATE_NAVBAR.onDataDailyReports
            });
        }
    },

    pageIsServerReport: function () {
        var is_server_report = false;
        var location = window.location.pathname;
        if (location === "/report/server" || location === "/log/server") {
            return true;
        }
        return is_server_report;
    },

    onDataDailyServerReports: function (data) {
        var existingTab = R_DATE_NAVBAR.curTab;
        // Handler for the list of today's server reports
        var fragment = '';
        $('#show_hide_reps').hide();
        var todays_reports = data.todays_reports;
        var server_urls = [
            { 'href': '', 'name': R_DATE_NAVBAR_LOGS },
            { 'href': '/log/server?sn=' + R_DATE_NAVBAR.urlSn + "&l_t=srv" + "&name=" + $.getUrlVar('name'), 'name': R_DATE_NAVBAR_LOGMANAGER }
        ];
        if (view_logs_for_specific_device_perm === 0) {
            fragment = R_DATE_NAVBAR.getToolTabFragment(todays_reports, server_urls);
            $("#todays_dashboard").html(fragment);
        }

        fragment = R_DATE_NAVBAR.getServerReportTabFragment(todays_reports);
        $('#todays_reports').html(fragment);

        R_DATE_NAVBAR.convertTimeAndDisplay(todays_reports);
        $("#todays_reports .group_name > a").addClass('change_color');
        $("#custom_datepicker_trigger").click();

        if (window.location.pathname === '/report/server') {
            $('#report_tabs a[href="#tabReports"]').tab("show");
            $('#show_hide_reps').hide();
        }
        if (existingTab && existingTab.indexOf('tabReports') !== -1) {
            $('#report_tabs a[href="#tabReports"]').tab("show");
        }
    },

    onDataDailyReports: function (data) {
        var existingTab = R_DATE_NAVBAR.curTab;
        // Handler for the list of today's reports
        var fragment = '';
        var todays_reports = data.todays_reports;
        var show_ss_dashboard = data.show_ss;
        var show_ap_dashboard = data.show_ap;
        var show_md_dashboard = data.show_md;
        var show_pm_dashboard = data.show_pm;
        var show_log_dashboard = data.show_lm && ((parseInt(view_logs_for_specific_device_perm, 10) === 1) ? false : true); //Check if User has permissions to view logs
        var show_pc_dashboard = data.show_pc;
        var control_urls = [
            { 'href': '', 'name': R_DATE_NAVBAR_CONTROL, 'show': true },
            { 'href': '/control/device?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_CONTROL_HEALTH, 'show': true }
        ];
        var dashboard_urls = [
            { 'href': '', 'name': R_DATE_NAVBAR_DASHBOARDS, 'show': true },
            { 'href': '/dashboard/executive?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_EXECUTIVE, 'show': true },
            { 'href': '/dashboard/security?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_SECURITY, 'show': true },
            { 'href': '/dashboard/ss?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_SECURITY_SERVICES, 'show': show_ss_dashboard },
            { 'href': '/dashboard/threatmap?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_THREATMAP, 'show': true },
            { 'href': '/dashboard/firewatch?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_FIREWATCH, 'show': true },
            { 'href': '/dashboard/flowmap?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_FLOWMAP, 'show': show_pm_dashboard },
            { 'href': '/dashboard/ap?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_ACCESS_POINTS, 'show': show_ap_dashboard },
            { 'href': '/dashboard/mobiledevice?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_MOBILE_DEVICES, 'show': show_md_dashboard },
            { 'href': '', 'name': R_DATE_NAVBAR_LOGS, 'show': show_log_dashboard },
            { 'href': '/log/device?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_LOGMANAGER, 'show': show_log_dashboard },
            { 'href': '/log/search?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_LOGSEARCH, 'show': show_log_dashboard },
            { 'href': '', 'name': R_DATE_NAVBAR_REPORTS, 'show': show_pc_dashboard },
            { 'id': 'perclient', 'href': '/report/perclient?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_PERCLIENT_SUMMARY, 'show': show_pc_dashboard },
            { 'id': 'perclientdetail', 'href': '/report/perclientdetail?sn=' + R_DATE_NAVBAR.urlSn, 'name': R_DATE_NAVBAR_PERCLIENT_DETAIL, 'show': show_pc_dashboard }
        ];

        // Show control page if we have manage device perm and sn is not group
        if (parseInt(monitor_device_perm, 10) === 0  && parseInt(sn_is_group, 10) === 0) {
            dashboard_urls = control_urls.concat(dashboard_urls);
        }

        if (todays_reports[0].reports.length === 0) {
            // REVIEW: Need to detect devices set up for Control only
            todays_reports[0].reports = [0];
        }
        fragment = R_DATE_NAVBAR.getToolTabFragment(todays_reports, dashboard_urls);
        $("#todays_dashboard").html(fragment);

        fragment = R_DATE_NAVBAR.getReportTabFragment(todays_reports);
        R_DATE_NAVBAR.convertTimeAndDisplay(todays_reports);

        $("#todays_reports").html(fragment);

        if (R_DATE_NAVBAR.active_div_id !== '') {
            $(R_DATE_NAVBAR.active_div_id).addClass("in");
        }

        $('#perclient, #perclientdetail').on('click', R_DATE_NAVBAR.updatePerClientURI);
        $("#todays_reports .group_name > a").addClass('change_color');
        $("#custom_datepicker_trigger").click();

        if (existingTab && existingTab.indexOf('tabReports') !== -1) {
            $('#report_tabs a[href="#tabReports"]').tab("show");
        }
    },

    hasAvailDates: function (startDate, endDate) {
        // The startDate/endDate: "yyyy-mm-dd HH:MM GMT"
        var startTime = startDate.replace(" GMT", ":00");
        startTime = startTime.replace(/\-/g, "/");

        var endTime = endDate.replace(" GMT", ":00");
        endTime = endTime.replace(/\-/g, "/");

        var sTime = new Date(startTime);
        var eTime = new Date(endTime);
        sTime.setMinutes(0);
        eTime.setMinutes(0);
        var date,
            availDate;
        // Check if it has avail date in this period
        for (date in R_DATE_NAVBAR.availDates) {
            if (R_DATE_NAVBAR.availDates.hasOwnProperty(date)) {
                availDate = new Date(date);
                if (sTime <= availDate && availDate <= eTime) {
                    return true;
                }
            }
        }
        return false;
    },

    getToolTabFragment: function (data, dashboard_urls) {
        var thispage = window.location.pathname + window.location.search;
        var fragment = '';
        var dashboard,
            href,
            elem_id,
            show,
            classval;
        fragment += '<ul class="nav nav-list">';
        if (data && data.length > 0 && (data[0].reports.length > 0 || R_DATE_NAVBAR.hasAvailDates(data[0].data_begin_time, data[0].data_end_time))) {
            for (dashboard in dashboard_urls) {
                if (dashboard_urls.hasOwnProperty(dashboard)) {
                    show = dashboard_urls[dashboard].show;
                    href = dashboard_urls[dashboard].href;
                    elem_id = dashboard_urls[dashboard].id;
                    if (show !== undefined && show === false) {
                        continue;
                    }
                    if (thispage.indexOf(href) === 0) {
                        $('#report_tabs a[href="#tabDashboard"]').tab("show");
                        classval = "active";
                    }
                    if (href === '') {
                        fragment += '<li class="nav-header">' + dashboard_urls[dashboard].name + '</li>';
                    } else {
                        if (elem_id !== undefined) {
                            fragment += '<li class="' + classval + '"><a id="' + elem_id + '" href="' + dashboard_urls[dashboard].href + '">' + dashboard_urls[dashboard].name + '</a></li>';
                        } else {
                            fragment += '<li class="' + classval + '"><a href="' + dashboard_urls[dashboard].href + '">' + dashboard_urls[dashboard].name + '</a></li>';
                        }
                    }
                    classval = '';
                }
            }
        }
        fragment += '</ul>';
        return fragment;
    },

    /* Check if the wrapper div has in class, indicating it's expanded
       If the number of divs that have the 'in' class is 0 then none of the
       report categories are expanded - Change text to read 'Expand All'
       If the number of divs that have the 'in' class is 8 then all of the
       report categories are expanded - Change text to read 'Collapse All'
    */
    trackHeaderState: function () {
        var count = $("#todays_reports ul div.in").length;
        var visible_navs = $("#todays_reports ul div").length;
        if (count === visible_navs) {
            $("#show_hide_reps").text(R_DATE_NAVBAR_COLLAPSE_TEXT);
        } else if (count === 0) {
            $("#show_hide_reps").text(R_DATE_NAVBAR_EXPAND_TEXT);
        }
    },
    toggleReportsHeader: function (event) {
        if (event !== undefined) {
            event.preventDefault();
        }

        var toggle_text = $("#show_hide_reps").text();

        if (toggle_text === R_DATE_NAVBAR_COLLAPSE_TEXT) {
            $("#todays_reports ul div").removeClass("in").css("height", "0px");
        } else {
            $("#todays_reports ul div").addClass("in").css("height", "auto");
        }

        toggle_text = (toggle_text === R_DATE_NAVBAR_COLLAPSE_TEXT) ? R_DATE_NAVBAR_EXPAND_TEXT : R_DATE_NAVBAR_COLLAPSE_TEXT;
        $("#show_hide_reps").text(toggle_text);
    },

    checkDetailReport:  function (report_item, thispage) {
        //1. When clicking a specific application name in Application Usage report under services category:
        //    a) Application (Host);
        //    b) Application (Mobile Device);
        //    c) Top Hosts;
        //    d) Top Mobile Devices.
        //   The report type is defined to specific name to show different detail report and the report type could be:
        //   "top_cli_app_usage_hosts_detail" or "top_cli_app_usage_devices_detail"
        //   But the default report type when link from menu could only be "top_cli_app_usage_users_detail".

        //2. When clicking a specific application name in Blocked Application report under services category:
        //    a) Top Blocked by Host;
        //    b) Top Blocked by Mobile Device;
        //    c) Top Hosts Blocked;
        //    d) Top Mobile Devices Blocked.
        //   The report type is defined to specific name to show different detail report and the report type could be:
        //   "top_cli_app_block_hosts_detail" or "top_cli_app_block_devices_detail"
        //   But the default report type when link from menu could only be "top_cli_app_block_users_detail".

        // In this case, the menu should be shown up and expended rightly.

        var flag = false;
        if (report_item !== undefined) {
            if (report_item.indexOf("top_cli_app_usage_users_detail") !== -1 &&
                    (thispage.indexOf("top_cli_app_usage_hosts_detail") !== -1 ||
                     thispage.indexOf("top_cli_app_usage_devices_detail") !== -1)) {
                flag = true;
            } else if (report_item.indexOf("top_cli_app_block_users_detail") !== -1 &&
                    (thispage.indexOf("top_cli_app_block_hosts_detail") !== -1 ||
                     thispage.indexOf("top_cli_app_block_devices_detail") !== -1)) {
                flag = true;
            }
        }
        return flag;
    },

    getReportTabFragment: function (data) {
        var thispage = window.location.pathname + window.location.search;
        var classval = '';

        var fragment = '<ul class="nav nav-list">';
        if (data[0].reports.length > 0 && $.inArray(0, data[0].reports) === -1) {
            $('#show_hide_reps').show();
        } else {
            $('#show_hide_reps').hide();
        }
        var i, j,
            collapse,
            group,
            d_target,
            report_item;
        for (i = 0; i < data.length; i++) {
            group = data[i];
            d_target = "#collapse" + i;
            fragment += '<li class="nav-header" style="cursor:pointer" ' +
                        'data-toggle="collapse" data-target=' + d_target + '>' +
                         group.name;
            fragment += '</li>';

            collapse = '<div id=' + "collapse" + i + ' class="collapse" style="display:block;">';
            fragment += collapse;
            for (j = 0; j < group.reports.length; j++) {
                report_item = group.reports[j][1];
                if (thispage.indexOf(report_item) === 0 || R_DATE_NAVBAR.checkDetailReport(report_item, thispage)) {
                    $('#report_tabs a[href="#tabReports"]').tab("show");
                    classval = "active";
                    R_DATE_NAVBAR.active_div_id = "#collapse" + i;
                }
                fragment += '<li class="' + classval + '"><a href="' + report_item + '">' + group.reports[j][0] + '</a></li>';
                classval = '';
            }
            fragment += '</div>';
        }
        fragment += '</ul>';
        return fragment;
    },

    getServerReportTabFragment: function (data) {
        //REFACTOR: refactor backend server_tabs method to work just like normal reports, then fold this into getReportTabFragment.
        var fragment = '<ul class="nav nav-list">';
        var display_report_link = false;
        var i, j,
            group;
        for (i = 0; i < data.length; i++) {
            group = data[i];
            fragment += '<li class="nav-header">' + group.name;
            fragment += '</li>';

            for (j = 0; j < group.reports.length; j++) {
                display_report_link = true;
            }
        }
        if (display_report_link === true) {
            var report_link_status = '';
            if (window.location.pathname === '/report/server') {
                report_link_status = "active";
            }
            fragment += '<li class="' + report_link_status + '"><a href="/report/server?sn=' + R_DATE_NAVBAR.urlSn + '">' + "Server Reports" + '</a></li>';
            fragment += '</ul>';
        }
        return fragment;
    },

    convertTimeAndDisplay: function (data) {
        // Convert start/end from UTC and display
        var begin_time = '';
        var end_time = '';
        var time_range = '';
        var begin,
            end,
            pickerDate;
        if (data.length > 0) {
            begin = data[0].data_begin_time;
            end = data[0].data_end_time;
            if (begin !== '') {
                begin_time = $.getDateDisplay(begin, false, '');
                end_time = $.getDateDisplay(end, false, '');
                time_range = begin_time + ' &mdash; ' + end_time;
                pickerDate = R_DATE_NAVBAR.convertDate(begin_time + ":00");
                if ($("#datepicker").val() === '') {
                    $('#datepicker').datepicker("setDate", pickerDate);
                }
            }
        }
        $("#reports_toolbar_start").html(begin_time + ' &mdash; ');
        $("#reports_toolbar_end").html(end_time);

        var htmlDate = $("#end_date").val();
        if (htmlDate && htmlDate !== '') {
            pickerDate = R_DATE_NAVBAR.convertDate(end_time + ":00");
            if ($("#datepicker_end").val() === '') {
                $('#datepicker_end').datepicker("setDate", pickerDate);
            }
        }
        $("#mobile_date_navbar_daterange").html(time_range);
    },

    _getInternalTimeStr: function (getStartTime) {
        // Used to get the current datetime set in the picker.
        // This is distinct from the reports_toolbar time, which is the time
        // the user has "set".
        var selector = getStartTime ? '#datepicker' : '#datepicker_end';
        var date_time = $(selector).datetimepicker('getDate');
        var date_time_fmt;
        if (date_time !== null) {
            date_time_fmt = date_time.format("yyyy-mm-dd HH:MM");
        } else {
            date_time_fmt = '';
        }
        return date_time_fmt;
    },

    getStartEndIsoStr: function () {
        var start_dt = $("#reports_toolbar_start").text();
        var end_dt = $("#reports_toolbar_end").text();
        if (start_dt !== '') {
            start_dt = start_dt.substring(0, start_dt.length - 2).trim(); //Remove the '-' from date at the end'
        }
        return [start_dt, end_dt];
    },

    getStartEndSeconds: function () {
        var startEnd = R_DATE_NAVBAR.getStartEndIsoStr();
        var start_dt = startEnd[0];
        var end_dt = startEnd[1];
        if (start_dt !== '') {
            start_dt = $.getDateLocalToSecs(start_dt);
        }
        if (end_dt !== '') {
            end_dt = $.getDateLocalToSecs(end_dt);
        }
        return [start_dt, end_dt];
    }

};
$(document).ready(R_DATE_NAVBAR.init);
