/*global S_VIEW_TEXT,S_EDIT_TEXT,manage_vpns_perm,VpnObj,S_VPN_DEL_MSG,vpnColNames,vpnColModel,resizeGrid*/
var S_LOG_VPNS = {

    remove_vpns_list: [],
    avail_device_list: [],
    active_vpn_list: [],

    // setup the page
    init: function () {
        if ($("#tabVpns").html() === undefined) {
            return;
        }
        S_LOG_VPNS.initUI();
        S_LOG_VPNS.initEvents();
    },

    // initialize UI elements
    initUI: function () {
        $('#progress_save').hide();
        $('error_container').hide();
        $('#vpn_error_container').hide();

        WGRD.enableUIElements(false, ['#remove_vpn']);
        //Vpns
        S_LOG_VPNS.createVpnsGrid();
    },

    // add event handlers
    initEvents: function () {
        $('#add_vpn').on('click', S_LOG_VPNS.addVpn);
        $('#remove_vpn').on('click', S_LOG_VPNS.removeVpn);

        $(window).bind('resizeEnd', function () {
            S_LOG_VPNS.resizeGrids();
        });
        $('a[data-toggle="tab"]').on('shown', function (e) {
            S_LOG_VPNS.resizeGrids();
        });

        $('#vpn_confirm_save_btn').click(function () {
            $('#vpn_confirm_dlg').modal("hide");
            S_LOG_VPNS.deleteVpn();
        });

        //User mode changes
        //S_USER_MODE.initEvents();
    },

    addVpn: function () {
        window.location = '/control/vpn';
        return;
    },

    removeVpn: function () {

        var sel_row = $('#vpns_table').jqGrid('getGridParam', 'selrow');
        if (sel_row === null) {
            return;
        }
        $("#vpn_confirm_dlg").modal();
    },

    deleteVpn: function () {
        WGRD.enableUIElements(false, ['#remove_vpn']);
        var value = jQuery('#vpns_table').jqGrid('getGridParam', 'selrow');
        var sel_row = parseInt(value, 10);
        var vpn_id = $('#vpns_table').jqGrid('getCell', sel_row, 'vpn_id');

        var vpn_obj = new VpnObj();
        vpn_obj.vpn_action = 1; // delete
        vpn_obj.vpn_id = parseInt(vpn_id, 10);

        //Delete VPN
        $('#loading').show();
        WGRD.putData(vpn_obj).success(function (response) {
            $('#loading').hide();
            $('#error_container').hide();
            if (!response.status) {
                $('#vpn_error_container').text(response.message)
                                        .removeClass('alert-success')
                                        .addClass('alert-error')
                                        .show();
            } else {
                $('#vpn_error_container').text(S_VPN_DEL_MSG)
                                        .removeClass('alert-error')
                                        .addClass('alert-success')
                                        .show().delay(2000)
                                        .fadeOut();
                $('#vpns_table').jqGrid('delRowData', sel_row);
            }
        });
        return false;
    },

    createVpnsGrid: function () {
        var vpns_grid = $('#vpns_table').jqGrid({
            loadonce: true,
            loadui: 'block',
            datatype: S_LOG_VPNS.jqgridDataType,
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            colNames: vpnColNames,
            colModel: vpnColModel,
            pager: '#vpns_pager',
            altRows: true,
            altclass: 'gridAltRow',
            sortname: 'name',
            viewrecords: true,
            sortorder: 'asc',
            rowNum: 10,
            pagerpos: 'right',
            recordpos: 'left',
            rowList: [10, 20, 50, 100],
            loadComplete: function () {
                S_LOG_VPNS.toggleEditRemoveBtn();
            },
            onSelectRow: function (rowid, status, e) {
                S_LOG_VPNS.toggleEditRemoveBtn();
            }
        });
        vpns_grid.jqGrid('navGrid', '#vpns_pager', { edit: false, add: false, del: false, search: false, refresh: false });
    },

    toggleEditRemoveBtn: function () {
        // enable/disable "Remove"/"Edit" button depending on if any rows are selected or not
        var selRowId = $('#vpns_table').jqGrid('getGridParam', 'selrow');
        WGRD.enableUIElements(selRowId, ['#remove_vpn']);
    },

    nameFormatter: function (cellValue, options, rowObject) {
        var id = rowObject.vpn_id;
        var display_name = rowObject.name;
        return '<a class="devices_namelink" href="/control/vpn?sn=' + id + '">' + display_name + '</a>';
    },

    jqgridDataType: function (ts, data, loading_div, rowcnt, page, adjust) {
        S_LOG_VPNS.refreshVpnsGrid(null);
    },
    refreshVpnsGrid: function (complete_cb) {
        // Note, this function is also called by S_LOG_DEVICES.doRefreshTabs() in log_devices.js
        $('#vpns_table').jqGrid('clearGridData');
        $.ajax({
            url: 'log_vpns',
            method: 'GET',
            dataType: 'json',
            success: function (response) {
                if (response.status) {
                    S_LOG_VPNS.vpn_list = response.vpn_list;
                }
            },
            complete: function () {
                $('#vpns_table').jqGrid('setGridParam', {
                    datatype: 'local',
                    data: S_LOG_VPNS.vpn_list,
                    loadComplete: function () {
                        S_LOG_VPNS.toggleEditRemoveBtn();
                        if (complete_cb) {
                            complete_cb();
                        }
                    }
                });
                $('#vpns_table').trigger('reloadGrid');
            }
        });
    },

    resizeGrids: function () {
        resizeGrid('#vpns_table', '#vpns_grid');
    }
};
$(document).ready(S_LOG_VPNS.init);
