/*global S_USER_MODE, lock_page, is_page_locked, S_VIEW_TEXT, S_EDIT_TEXT, manage_groups_perm, S_ADD_GROUP_TITLE, view_group_members_perm, S_EDIT_GROUP_TITLE, S_VIEW_GROUP_TITLE, unescapeHtml, S_GROUP_DEL_MSG, S_GROUP_NAME_MSG, S_GROUP_NAME_DUPLICATE_MSG, S_ERROR_GROUP_NAME, S_DEVICE_ADD_MSG, GroupObj, escapeHtml, S_GROUP_ADD_MSG, S_LOG_DEVICES, S_GROUP_EDIT_MSG, S_SEL_DEVICES_TITLE, groupColNames, groupColModel, resizeGrid, user_has_only_vl_role, anonymization_enabled, S_EMPTY_GROUP */
var S_LOG_GROUPS = {

    remove_groups_list: [],
    avail_device_list: [],
    active_group_list: [],

    // setup the page
    init: function () {
        if ($("#tabGroups").html() === undefined) {
            return;
        }
        S_LOG_GROUPS.initUI();
        S_LOG_GROUPS.initEvents();
    },

    // initialize UI elements
    initUI: function () {
        $('#progress_save').hide();
        $('#error_container').hide();

        WGRD.enableUIElements(false, ['#edit_group', '#remove_group']);
        //Report Groups
        S_LOG_GROUPS.createGroupsGrid();
        S_LOG_GROUPS.initUserModeUI();
    },

    initUserModeUI: function () {
        var ids = ['#add_group', '#remove_group'];

        // Check if the lock_page is in sessionStorage, this will be true
        // if user acquired a lock and clicked on refresh on the same page
        // and is in the same browser tab.
        S_LOG_GROUPS.pg_tracker = window.sessionStorage.getItem(lock_page);

        var viewMode = WGRD.userInViewMode(is_page_locked, S_LOG_GROUPS.pg_tracker);

        S_USER_MODE.initUI(ids, viewMode);

        if (viewMode) {
            $('#edit_group').val(S_VIEW_TEXT);
        } else {
            $('#edit_group').val(S_EDIT_TEXT);
        }

        if (manage_groups_perm === 0) {
            $('#user_mode_div').show();
        } else {
            $('#user_mode_div').hide();
        }
    },
    // add event handlers
    initEvents: function () {
        WGRD.pgUnloadCallBack(S_LOG_GROUPS.pg_tracker, lock_page);
        $('#group_names').change(S_LOG_GROUPS.showAvailableDevices);

        //Groups
        $('#add_group').on('click', S_LOG_GROUPS.showGroupModal);
        $('#edit_group').on('click', S_LOG_GROUPS.showGroupModal);
        $('#remove_group').on('click', S_LOG_GROUPS.removeGroup);

        $('#device_server_name').on("keyup", S_LOG_GROUPS.groupDeviceSearchEvent);

        $('#add_grp_dev').on('click', S_LOG_GROUPS.addGroupDevice);
        $('#remove_grp_dev').on('click', S_LOG_GROUPS.remGroupDevice);

        $('#copy_device').on('click', S_LOG_GROUPS.copyGroupDevice);
        $('#del_device').on('click', S_LOG_GROUPS.delGroupDevice);

        $('#specify_device_close').on('click', S_LOG_GROUPS.closeGroupDevice);
        $('#specify_device_save').on('click', S_LOG_GROUPS.saveGroupDevice);

        $(window).bind('resizeEnd', function () {
            S_LOG_GROUPS.resizeGrids();
        });
        $('a[data-toggle="tab"]').on('shown', function (e) {
            S_LOG_GROUPS.resizeGrids();
        });

        $('#confirm_save_btn').click(function () {
            $('#confirm_dlg').modal("hide");
            S_LOG_GROUPS.deleteGroup();
        });
        //User mode changes
        S_USER_MODE.initEvents();
    },

    // -----------------------------   Action related to groups UI begin here -------------------- //

    /*
    Called when add or Edit buttons are clicked for groups
    If edit, then pass in row data
    */
    showGroupModal: function () {
        var button_id = $(this).attr('id');
        var params = { 'parent_id': button_id };
        if (button_id === 'edit_group') {
            var sel_row = jQuery('#groups_table').jqGrid('getGridParam', 'selrow');
            if (sel_row === null) {
                return;
            }
        }
        WGRD.doModal('#manage_group_dlg',
                     S_LOG_GROUPS.initializeGroups,
                     S_LOG_GROUPS.saveGroups,
                     params);
    },

    initializeGroups: function (params) {
        var parent_id = params.parent_id;

        if (parent_id === 'add_group') { //Initialize UI
            S_LOG_GROUPS._add_group();
        } else { //Update UI
            S_LOG_GROUPS._edit_group();
        }
        $('#main_group_div').show();
        $('#specify_device_div').hide();
        return true;
    },

    _add_group: function () {
        $('#manage_group_dlg h3').text(S_ADD_GROUP_TITLE);
        $('#group_name').val("")
                        .attr('disabled', false);
        $('#group_desc').val("");
        $('#active_group_dev').empty();
    },

    _edit_group: function () {
        //For a user who has view only permissions for groups, let them just see the group members
        //No save or add/remove operations.
        if ((parseInt(manage_groups_perm, 10) === 1 && parseInt(view_group_members_perm, 10) === 0) || WGRD.userInViewMode(is_page_locked, S_LOG_GROUPS.pg_tracker)) {
            $('#add_grp_dev').hide();
            $('#remove_grp_dev').hide();
            $('#add_save').attr('disabled', true);
            $('#manage_group_dlg h3').text(S_VIEW_GROUP_TITLE);
        } else {
            $('#manage_group_dlg h3').text(S_EDIT_GROUP_TITLE);
        }

        var sel_row = jQuery('#groups_table').jqGrid('getGridParam', 'selrow');
        var data = $("#groups_table").jqGrid('getGridParam', 'data');
        var grp_obj = null;
        var i, len;
        for (i = 0, len = data.length; i < len; i++) {
            grp_obj = data[i];
            if (grp_obj.group_name === sel_row) {
                break;
            }
        }

        $('#group_name').val(grp_obj.group_name)
                        .attr('disabled', true);
        $('#group_desc').val(unescapeHtml(grp_obj.group_desc));
        $('#active_group_dev').empty();
        var device_list = grp_obj.active_device_list;
        if (device_list.length !== 0) {
            var count = 0;
            var resource_id;
            var name_sn;
            $.each(S_LOG_GROUPS.avail_device_list, function (index, resource) {
                resource_id = resource.id;

                if (device_list.indexOf(resource_id) !== -1) {
                    name_sn = resource.name;
                    $('#active_group_dev').append('<option value=' + resource_id + ' title="' + name_sn + '">' + name_sn + '</option>');
                    count = count + 1;
                }
                if (count === device_list.length) {
                    return false;
                }
            });
        }
    },

    removeGroup: function () {

        var sel_row = $('#groups_table').jqGrid('getGridParam', 'selrow');
        if (sel_row === null) {
            return;
        }
        $("#confirm_dlg").modal();
    },

    deleteGroup: function () {
        WGRD.enableUIElements(false, ['#remove_group']);
        var sel_row = jQuery('#groups_table').jqGrid('getGridParam', 'selrow');
        var data = $('#groups_table').jqGrid('getGridParam', 'data');
        var grp_obj = null;
        var i, len;
        for (i = 0, len = data.length; i < len; i++) {
            grp_obj = data[i];
            if (grp_obj.group_name === sel_row) {
                break;
            }
        }

        grp_obj.group_action = 1;
        var group_info = {};
        group_info.group_id = grp_obj.group_id;
        group_info.group_name = grp_obj.group_name;
        grp_obj.remove_groups_list.push(group_info);

        // save the data to the server
        WGRD.putData(grp_obj).success(function (response) {
            if (response.status) {
                S_LOG_GROUPS.remove_groups_list.push(grp_obj.group_name);
                data.splice($.inArray(grp_obj, data), 1);
                $('#groups_table').trigger('reloadGrid');
                $('#error_container').text(S_GROUP_DEL_MSG);
            }
            $('#error_container')
                .delay(2000)
                .fadeOut();
        });
    },

    saveGroups: function (params) {

        var parent_id = params.parent_id;

        if (parent_id === 'add_group') { //Initialize UI
            return S_LOG_GROUPS._save_group();
        }
        return S_LOG_GROUPS._update_group();
    },

    _save_group: function () {

        //validate dialog controls here
        var name = $('#group_name').val();

        if (name.trim().length === 0) {
            //return error message string here
            return S_GROUP_NAME_MSG;
        }

        //Check if group name exists already
        var data = $('#groups_table').jqGrid('getGridParam', 'data');
        var grp_obj = null;
        var i, len;
        for (i = 0, len = data.length; i < len; i++) {
            grp_obj = data[i];
            if (grp_obj.group_name === name.trim().toLowerCase()) {
                return S_GROUP_NAME_DUPLICATE_MSG;
            }
        }

        // don't allow greater-than, less-than or single quote in the name
        if (name.indexOf('>') !== -1 || name.indexOf('<') !== -1 || name.indexOf('\'') !== -1) {
            return S_ERROR_GROUP_NAME;
        }

        var active_device_list = [];
        if ($('#active_group_dev option').length === 0) {
            return S_DEVICE_ADD_MSG;
        }

        $('#active_group_dev option').each(function () {
            active_device_list.push(parseInt(this.value, 10));
        });

        grp_obj = new GroupObj();
        grp_obj.group_name = name;
        grp_obj.group_desc = $('#group_desc').val();
        grp_obj.group_action = 0;
        grp_obj.active_device_list = active_device_list;
        grp_obj.remove_groups_list = [];

        // save the data to the server
        WGRD.putData(grp_obj).success(function (response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                data.push({ 'group_name': grp_obj.group_name,
                    'group_desc': escapeHtml(grp_obj.group_desc),  // make sure local data is escaped
                    'group_id': response.group_id,
                    'active_device_list': grp_obj.active_device_list,
                    'remove_groups_list': grp_obj.remove_groups_list,
                    '__module__': 'modules.scripts.log.group_scripts',
                    '__class__': 'GroupObj'
                    });

                $('#groups_table').trigger('reloadGrid');
                $('#error_container').text(S_GROUP_ADD_MSG);
                S_LOG_DEVICES.doRefreshTabs();
            }
            $('#error_container')
                .delay(2000)
                .fadeOut();
        });
        return "";
    },

    _update_group: function () {

        var name = $('#group_name').val();
        var data = $('#groups_table').jqGrid('getGridParam', 'data');
        var grp_obj = null;
        var i, len;
        for (i = 0, len = data.length; i < len; i++) {
            grp_obj = data[i];
            if (grp_obj.group_name === name) {
                break;
            }
        }

        var active_device_list = [];
        if ($('#active_group_dev option').length === 0) {
            return S_DEVICE_ADD_MSG;
        }

        $('#active_group_dev option').each(function () {
            active_device_list.push(parseInt(this.value, 10));
        });

        grp_obj.active_device_list = active_device_list;
        grp_obj.group_action = 2;  //Edit
        grp_obj.group_desc = $('#group_desc').val();
        // save the data to the server
        WGRD.putData(grp_obj).success(function (response) {
            // we need to do some things after the save operations is successful
            if (response.status) {
                // unescaped data was sent to server, so we need to escape the local data
                grp_obj.group_desc = escapeHtml(grp_obj.group_desc);

                $('#groups_table').trigger('reloadGrid');
                $('#error_container').text(S_GROUP_EDIT_MSG);
            }
            $('#error_container')
                .delay(2000)
                .fadeOut();
        });
        return "";
    },

    copyGroupDevice: function (event) {
        event.preventDefault();
        var selected_items = $('#filtered_devices_servers option:selected');

        $.each(selected_items, function (index, value) {
            var device_id = value.value;
            var title = value.text;
            if ($('#active_devices_servers option[value =' + device_id + ']').length === 0) {
                $('#active_devices_servers').append('<option value=' + device_id + ' title="' + title + '">' + title + '</option>');
            }
        });
    },

    delGroupDevice: function (event) {
        event.preventDefault();
        $('#active_devices_servers option:selected').remove();
    },

    addGroupDevice: function (event) {
        event.preventDefault();
        $('#add_error_device').hide();
        $('#device_server_name').val("");

        $('#filtered_devices_servers').empty();
        $('#active_devices_servers').empty();

        S_LOG_GROUPS.populate_group_device_select();

        $('#active_devices_servers')
            .append($('#active_group_dev option')
                .clone()
                .children()
                .end());

        $('#specify_device_div')
                         .show()
                         .find('h3').text(S_SEL_DEVICES_TITLE);
        $('#main_group_div').hide();
    },

    remGroupDevice: function (event) {
        event.preventDefault();
        $('#active_group_dev option:selected').remove();
    },

    closeGroupDevice: function () {
        $('#specify_device_div').hide();
        $('#main_group_div').show();
    },

    saveGroupDevice: function () {

        var active_grp_device_length = $('#active_devices_servers option').length;
        if (active_grp_device_length !== 0) {
            $('#active_group_dev').empty();
            $('#active_group_dev')
                .append($('#active_devices_servers option')
                    .clone()
                    .children()
                    .end());
        }
        S_LOG_GROUPS.closeGroupDevice();
    },

    groupDeviceSearchEvent: function () {
        var val = $('#device_server_name').val();

        $('#filtered_devices_servers').empty();
        var matching_list = $.map(S_LOG_GROUPS.avail_device_list, function (value) {
            var search = new RegExp(val, "gi");
            var name_sn = value.name;
            if (name_sn.match(search)) {
                return value;
            }
            return null;
        });

        $.each(matching_list, function (index, value) {
            var resource_id = value.id;
            var name_sn = value.name;
            $('#filtered_devices_servers').append('<option value=' + resource_id + ' title="' + name_sn + '">' + name_sn + '</option>');
        });
    },

    populate_group_device_select: function () {
        $('#filtered_devices_servers').empty();
        $.each(S_LOG_GROUPS.avail_device_list, function (index, value) {
            var resource_id = value.id;
            var name_sn = value.name;
            $('#filtered_devices_servers').append('<option value=' + resource_id + ' title="' + name_sn + '">' + name_sn + '</option>');
        });
    },

    // ----------------------------- Action related to groups UI Ends -------------------- //

    createGroupsGrid: function () {
        var groups_grid = $('#groups_table').jqGrid({
            loadonce: true,
            loadui: 'block',
            datatype: S_LOG_GROUPS.jqgridDataType, //'local', //S_LOG_GROUPS.refreshGroupsGrid,
            height: 'auto',
            autowidth: true,
            shrinkToFit: true,
            colNames: groupColNames,
            colModel: groupColModel,
            pager: '#groups_pager',
            altRows: true,
            altclass: 'gridAltRow',
            sortname: 'group_name',
            viewrecords: true,
            sortorder: 'asc',
            rowNum: 10,
            pagerpos: 'right',
            toppager: true,
            recordpos: 'left',
            rowList: [10, 20, 50, 100],
            loadComplete: function () {
                S_LOG_GROUPS.toggleEditRemoveBtn();
                if (user_has_only_vl_role === 1 && anonymization_enabled === 1) {
                    $('.devices_namelink').removeAttr('href')
                                          .css('border', 'none');
                }
            },
            onSelectRow: function (rowid, status, e) {
                S_LOG_GROUPS.toggleEditRemoveBtn();
            }
        });
        groups_grid.jqGrid('navGrid', '#groups_pager', { edit: false, add: false, del: false, search: false, refresh: false });
    },

    toggleEditRemoveBtn: function () {
        // enable/disable "Remove"/"Edit" button depending on if any rows are selected or not
        var selRowId = $('#groups_table').jqGrid('getGridParam', 'selrow');
        WGRD.enableUIElements(selRowId, ['#edit_group', '#remove_group']);
    },

    myCustomFormatter: function (cellValue, options, rowObject) {
        var id = rowObject.group_id;
        var display_name = rowObject.group_name;
        var group_members = rowObject.active_device_list;
        var href = '<a class="devices_namelink" href="/dashboard/executive?sn=' + id + '">' + display_name + '</a>';
        if (group_members.length === 0) {
            href = display_name + '  ' + S_EMPTY_GROUP;
        }
        return href;
    },

    jqgridDataType: function (ts, data, loading_div, rowcnt, page, adjust) {
        S_LOG_GROUPS.refreshGroupsGrid(null);
    },
    refreshGroupsGrid: function (complete_cb) {
        // Note, this function is also called by S_LOG_DEVICES.doRefreshTabs() in log_devices.js
        $('#groups_table').jqGrid('clearGridData');
        $.ajax({
            url: 'log_groups',
            method: 'GET',
            dataType: 'json',
            success: function (response) {
                if (response.status) {
                    S_LOG_GROUPS.active_group_list = JSON.parse(response.active_group_list);
                    S_LOG_GROUPS.avail_device_list = JSON.parse(response.avail_device_list);
                }
            },
            complete: function () {
                $('#groups_table').jqGrid('setGridParam', {
                    datatype: 'local',
                    data: S_LOG_GROUPS.active_group_list,
                    loadComplete: function () {
                        S_LOG_GROUPS.toggleEditRemoveBtn();
                        if (complete_cb) {
                            complete_cb();
                        }
                    }
                });
                $('#groups_table').trigger('reloadGrid');
            }
        });
    },

    resizeGrids: function () {
        resizeGrid('#groups_table', '#groups_grid');
    }
};
$(document).ready(S_LOG_GROUPS.init);
