/*global VpnObj,SpokeObj,UpdateDeviceObj,IPHELPER,S_VPN_NEXT_BUTTON,S_VPN_ADD_DEVICE,S_VPN_NEXT_BUTTON,S_VPN_FINISH_BUTTON,showHideErrorMsg,checkLoginPageRedirect,S_VPN_ADD,S_VPN_EDIT,S_VPN_EDIT_SPOKE,S_VPN_ADD_SPOKE,S_VPN_EXTERNALIF_ERR_MSG,S_VPN_RESOURCE_ERR_MSG,S_VPN_NAME_EMPTY_MSG,S_VPN_DEVICE_EMPTY_MSG,S_VPN_NAME_LEN_MSG,S_VPN_SAVE_VPN_MSG,S_VPN_SAVE_VPN_APPLY_MSG,S_VPN_SAVE_VPN_SUCCESS_MSG,S_VPN_IP_ERR_MSG,S_VPN_METRIC_ERR_MSG,S_VPN_ROUTETO_ERR_MSG,S_VPN_SAVE_VPN_MSG_1,S_VPN_SAVE_VPN_MSG_2,S_VPN_SAVE_VPN_MSG_3,S_VPN_SAVE_VPN_MSG_1_COMPLETE,S_VPN_SAVE_VPN_MSG_2_COMPLETE,S_VPN_SAVE_VPN_MSG_3_COMPLETE,S_VPN_NAT_MUST_MATCH,S_VPN_VIEW_SPOKE,S_VPN_UNUSED_IP_ERR_MSG,S_VPN_DIMENSION,S_VPN_P2_FORCE_KEY_ERR_MSG,S_VPN_P2_TIME,S_VPN_P2_TRAFFIC,S_VPN_HOST_IP_ERR_MSG*/
var VPN_WIZARD = {

    currentPane : 0,
    nextPane : 1,

    activePanes : [],
    manualModePages : ['manualMode_DevicePage'],
    deviceID: '',
    wizAction: 'add',
    wizType: 'hub',

    hub_resource_list: [],
    save_resource_list: [],
    save_routing_list: [],
    save_ifname_list: [],
    save_device_id: -1,
    save_device_name: '',
    save_name: '',
    save_virtual_ip: '',
    save_hub_virtual_ip: false,
    save_tunnel_switching: false,
    save_policy: 1,
    save_auto_start: true,
    save_security_obj: null,
    save_spoke_id: 0,
    save_tunnel_mode: 0,
    virtualip_supported: false,
    edit_obj: {},
    cbComplete: null,
    progressComplete: 0,
    progressTotal: 0,

    managed_vpn_id: 0,
    save_use_vif: false,

    init : function () {
        VPN_WIZARD.initUI();
        VPN_WIZARD.initEvents();
    },

    initUI : function () {
        $('#vpn_backButton').attr('disabled', true);
        $('#vpn_nextButton').attr('disabled', false);

        $('#vpn_closeButton').hide();
        $('#vpn_saveButton').hide();
    },

    initEvents : function () {
        //Events for buttons on the wizard, next/back are visible when adding a device
        $('#vpn_nextButton').on('click', VPN_WIZARD.nextButtonAction);
        $('#vpn_backButton').on('click', VPN_WIZARD.backButtonAction);

        //Close and save are visible when editing a vpn
        $('#vpn_closeButton').on('click', VPN_WIZARD.closeVpnDialog);
        $('#vpn_saveButton').on('click', VPN_WIZARD.updateVpn);

        //External Interface
        $('#vpn_add_if').on('click', VPN_WIZARD.addExternalIf);
        $('#vpn_rem_if').on('click', VPN_WIZARD.delExternalIf);
        $('#vpn_up_if').on('click', VPN_WIZARD.upExternalIf);
        $('#vpn_down_if').on('click', VPN_WIZARD.downExternalIf);

        $('#vpn_external_if_close').on('click', VPN_WIZARD.closeExternalIf);
        $('#vpn_external_if_save').on('click', VPN_WIZARD.saveExternalIf);

        //Hub VPN Resource
        $('#vpn_add_resource').on('click', function (eo) {
            showHideErrorMsg("#vpnResources");
            VPN_WIZARD.addHubVpnResource();
            $('#vpn_resource_save').off('click');
            $('#vpn_resource_save').on('click', VPN_WIZARD.saveHubVpnResource);
        });
        $('#vpn_rem_resource').on('click', VPN_WIZARD.delVpnResource);
        $('#vpn_resource_close').on('click', VPN_WIZARD.closeVpnResource);

        // Spoke VPN Resource
        $('#vpn_add_spokeresource').on('click', function (eo) {
            showHideErrorMsg("#vpnSpokeResources");
            showHideErrorMsg("#vpn_spokeRoute");
            VPN_WIZARD.addSpokeVpnResource();
            $('#vpn_resource_save').off('click');
            $('#vpn_resource_save').on('click', VPN_WIZARD.saveSpokeVpnResource);
        });
        $('#vpn_rem_spokeresource').on('click', VPN_WIZARD.delSpokeVpnResource);
        $('#vpn_resource_close').on('click', VPN_WIZARD.closeVpnResource);
        $('#vpnResourceNatEnabled').on('click', VPN_WIZARD.enableNATVpnResource);

        $("#vpn_add_spokeroute").on('click', VPN_WIZARD.addSpokeRoute);
        $("#vpn_rem_spokeroute").on('click', VPN_WIZARD.delSpokeRoute);
        $('#vpn_route_close').on('click', VPN_WIZARD.closeSpokeRoute);
        $("#vpn_route_save").on('click', VPN_WIZARD.saveSpokeRoute);

        $('#spokeTunnelMode').on('change', VPN_WIZARD.changeTunnelMode);

        // Security
        $("#vpn_security_dlg .checkbox input").click(VPN_WIZARD.uiStateSecurity);
        $("#vpn_EditSecurity").click(VPN_WIZARD.editSecurity);
        $("#vpn_security_close").click(VPN_WIZARD.closeSecurity);
        $("#vpn_security_save").click(VPN_WIZARD.saveSecurity);

        $(document).keydown(function (eo) {
            if (eo.which === 27) {
                if ($('#vpn_resource_dlg, #vpn_external_if_dlg, #vpn_security_dlg, #vpn_route_dlg').is(":visible")) { //escape key pressed
                    $('#vpn_resource_dlg, #vpn_external_if_dlg, #vpn_security_dlg, #vpn_route_dlg').hide();
                    $('#main_vpn_div').show();
                    return;
                }
                if ($('#main_vpn_div').is(":visible")) {
                    VPN_WIZARD.closeVpnDialog();
                    return false;
                }
            }
            if (eo.which === 13) {
                if ($('#vpn_resource_dlg').is(":visible")) { //enter key pressed
                    $("#vpn_resource_save").click();
                    return;
                }
                if ($('#main_vpn_div').is(":visible") && VPN_WIZARD.wizAction === 'add') {
                    $("#vpn_nextButton").click();
                    return;
                }
            }
        });

        // Click handler for Wizard LHS step navigation
        $("#manage_vpn_dlg").find('.wizard-steps').on('click', 'li.already-visited a.wizard-nav-link', $('#manage_vpn_dlg'),
            function (eo) {
                var i = 0;
                var paneNavIndex = $(eo.target).data('navindex');
                for (i = 0; i < VPN_WIZARD.activePanes.length; i++) {
                    if (VPN_WIZARD.activePanes[i] === paneNavIndex) {
                        if (!VPN_WIZARD.validatePane(VPN_WIZARD.currentPane)) {
                            return;
                        }
                        VPN_WIZARD.moveToNextPane(0, i);
                    }
                }
            });
    },

    showVpnDialog: function (type, action, vpn_id, data, cbComplete) {
        var url = '/control/get_vpn_wizard_devices';
        VPN_WIZARD.wizAction = 'add';
        if (action === 'edit' || action === 'view') {
            VPN_WIZARD.wizAction = action;
            if (type === 'hub') {
                VPN_WIZARD.edit_obj = data.managed_vpn_obj;
            } else {
                VPN_WIZARD.edit_obj = data.spoke_obj;
            }
        }
        VPN_WIZARD.hub_device_name = '';
        if (data && data.hub_device_name) {
            VPN_WIZARD.hub_device_name = data.hub_device_name;
        }

        VPN_WIZARD.save_use_vif = false;
        VPN_WIZARD.save_hub_virtual_ip = '';
        if (data && data.use_vif) {
            VPN_WIZARD.save_use_vif = true;
            VPN_WIZARD.save_hub_virtual_ip = data.virtual_ip;
        }
        VPN_WIZARD.wizType = 'hub';
        if (vpn_id) {
            VPN_WIZARD.managed_vpn_id = parseInt(vpn_id, 10);
        }
        if (type === 'spoke') {
            VPN_WIZARD.wizType = 'spoke';
            url = '/control/get_vpn_wizard_devices?id=' + vpn_id;
            url += '&action=' + VPN_WIZARD.wizAction;
        }

        if (data && data.hub_resource_list) {
            VPN_WIZARD.hub_resource_list = data.hub_resource_list;
        }
        VPN_WIZARD.cbComplete = cbComplete;
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                var param = { type: type, action: VPN_WIZARD.wizAction, 'appliance_list': data.appliance_list };

                WGRD.doModal('#manage_vpn_dlg',
                             VPN_WIZARD.initializeVpnDlg, null,
                             param, VPN_WIZARD.closeVpnDialog, null,
                             true, 'static');
            }
        });
    },

    initializeVpnDlg : function (param) {
        $("#vpn_save_progress_close, #vpn_save_progress .close").off('click');
        $("#vpn_save_progress_close, #vpn_save_progress .close").on('click', function (eo) {
            $("#vpn_save_progress").hide();
            VPN_WIZARD.closeVpnDialog();
            if (VPN_WIZARD.cbComplete !== null) {
                VPN_WIZARD.cbComplete();
            }
        });
        VPN_WIZARD.updateUI(param);
        return true;
    },
    viewMode: function () {
        $('#vpn_saveButton').hide();

        $('#vpn_add_if').hide();
        $('#vpn_rem_if').hide();
        $('#vpn_up_if').hide();
        $('#vpn_down_if').hide();

        $('#vpn_add_spokeresource').hide();
        $('#vpn_rem_spokeresource').hide();

        $('#vpn_add_spokeroute').hide();
        $("#vpn_rem_spokeroute").hide();
    },
    updateUI: function (param) {
        var val = 0;
        VPN_WIZARD.currentPane = 0;
        VPN_WIZARD.nextPane = 1;
        $("#main_vpn_div").show();
        $("#vpn_resource_dlg").hide();
        $("#vpn_external_if_dlg").hide();

        VPN_WIZARD.activePanes = [];
        if (VPN_WIZARD.wizType === 'hub') {
            VPN_WIZARD.activePanes.push('vpn_hubPage');
            VPN_WIZARD.activePanes.push('vpn_settingsPage');
            VPN_WIZARD.activePanes.push('vpn_externalifPage');
            VPN_WIZARD.activePanes.push('vpn_hubResourcePage');
        } else if (VPN_WIZARD.wizType === 'spoke') {
            VPN_WIZARD.activePanes.push('vpn_spokePage');
            VPN_WIZARD.activePanes.push('vpn_externalifPage');
            VPN_WIZARD.activePanes.push('vpn_spokeResourcePage');
            VPN_WIZARD.activePanes.push('vpn_spokeOptionsPage');
        }
        $('#' + VPN_WIZARD.activePanes[0]).show();


        //REFACTOR THIS LATER
        VPN_WIZARD.resetPane('vpn_hubPage', param);
        VPN_WIZARD.resetPane('vpn_spokePage', param);
        VPN_WIZARD.resetPane('vpn_settingsPage');
        VPN_WIZARD.resetPane('vpn_externalifPage');
        VPN_WIZARD.resetPane('vpn_spokeResourcePage');
        VPN_WIZARD.resetPane('vpn_spokeOptionsPage');
        VPN_WIZARD.resetPane('vpn_hubResourcePage');
        VPN_WIZARD.deviceID = '';

        $(".wizard-nav-item").removeClass('active already-visited');

        $('#vpn_nextButton').show()
                        .text(S_VPN_NEXT_BUTTON);
        $('#vpn_closeButton').hide();
        $('#vpn_saveButton').hide();

        var title = S_VPN_ADD;
        if (VPN_WIZARD.wizType === 'hub' && VPN_WIZARD.wizAction === 'edit') {
            title = S_VPN_EDIT;
        } else if (VPN_WIZARD.wizType === 'spoke' && VPN_WIZARD.wizAction === 'edit') {
            title = S_VPN_EDIT_SPOKE;
        } else if (VPN_WIZARD.wizType === 'spoke') {
            title = S_VPN_ADD_SPOKE;
        } else if (VPN_WIZARD.wizType === 'spoke' && VPN_WIZARD.wizAction === 'view') {
            title = S_VPN_VIEW_SPOKE;
        }
        $('#main_vpn_div .modal-header h3').text(title);

        $(".wizard-nav-item").hide();
        $.each(VPN_WIZARD.activePanes, function (index, value) {
            $('#' + value).hide();
            $('#' + value + '_li').show();
        });

        $("#" + VPN_WIZARD.activePanes[0] + "_li").addClass('active already-visited');
        $("#" + VPN_WIZARD.activePanes[0]).show();

        var i = 0;
        var value = '';
        var virtual_ip = '';
        if (VPN_WIZARD.wizAction === 'edit' || VPN_WIZARD.wizAction === 'view') {
            $('#vpn_backButton').hide();
            $('#vpn_nextButton').hide();
            $('#vpn_closeButton').show();
            if (VPN_WIZARD.wizAction === 'view') {
                VPN_WIZARD.viewMode();
            } else {
                $('#vpn_saveButton').show();
            }

            for (i = 0; i < VPN_WIZARD.activePanes.length; i++) {
                $("#" + VPN_WIZARD.activePanes[i] + "_li").addClass('already-visited');
            }

            // Set data
            var resource_obj = {};
            var obj = {};
            VPN_WIZARD.save_resource_list = [];
            if (VPN_WIZARD.wizType === 'spoke') {
                // Spoke device
                $("#spokeDeviceList").val(VPN_WIZARD.edit_obj.device_id);
                VPN_WIZARD.save_spoke_id = VPN_WIZARD.edit_obj.id;
                VPN_WIZARD.save_device_name = VPN_WIZARD.edit_obj.name;

                // External interfaces set in getExternalIfs()
                VPN_WIZARD.save_ifname_list = VPN_WIZARD.edit_obj.ifname_list;

                // VPN Resources
                resource_obj = {};
                obj = {};
                for (i = 0; i < VPN_WIZARD.edit_obj.resource_list.length; i++) {
                    resource_obj = VPN_WIZARD.edit_obj.resource_list[i];
                    if (VPN_WIZARD.save_use_vif) {
                        obj = {
                            'ip_address': resource_obj.ip_address,
                            'metric': resource_obj.metric
                        };
                    } else {
                        obj = { 'ip_address': resource_obj.ip_address,
                            'direction': resource_obj.direction,
                            'nat_enabled': resource_obj.nat_enabled,
                            'nat_address': resource_obj.nat_address,
                            'broadcast_enabled': resource_obj.broadcast_enabled
                            };
                    }
                    VPN_WIZARD.save_resource_list.push(obj);
                    value = VPN_WIZARD._getResourceDisplay(resource_obj, VPN_WIZARD.save_use_vif);
                    $("#vpnSpokeResources").append($("<option>").attr('value', resource_obj.ip_address).text(value));
                }
                if (VPN_WIZARD.edit_obj.tunnel_mode < 3) {
                    $("#spokeTunnelMode").val(VPN_WIZARD.edit_obj.tunnel_mode.toString());
                }

                // Routing list
                VPN_WIZARD.save_routing_list = [];
                for (i = 0; i < VPN_WIZARD.edit_obj.routing_list.length; i++) {
                    VPN_WIZARD.save_routing_list.push(VPN_WIZARD.edit_obj.routing_list[i]);
                }
                for (i = 0; i < VPN_WIZARD.hub_resource_list.length; i++) {
                    if (VPN_WIZARD.save_routing_list.indexOf(VPN_WIZARD.hub_resource_list[i].id) >= 0) {
                        value = VPN_WIZARD._getResourceDisplay(VPN_WIZARD.hub_resource_list[i], VPN_WIZARD.save_use_vif);
                        $("#vpn_spokeRoute").append($("<option>").attr('value', VPN_WIZARD.hub_resource_list[i].id).text(value));//VPN_WIZARD.hub_resource_list[i].ip_address));
                    }
                }

                // Virtual IP
                virtual_ip = VPN_WIZARD.edit_obj.virtual_ip;
                if (virtual_ip && virtual_ip.length > 0) {
                    VPN_WIZARD.save_virtual_ip = virtual_ip;
                    $("#vpnSpokeVirtualAddress input").val(virtual_ip);
                }

                // Options
                var policy = parseInt(VPN_WIZARD.edit_obj.policy, 10);
                $("#spokePolicies").val(policy);
            } else {
                // Hub device
                $("#hubDeviceList").val(VPN_WIZARD.edit_obj.hub_device.device_id);
                VPN_WIZARD.save_device_id = VPN_WIZARD.edit_obj.hub_device.device_id;
                $("#vpnType").val(VPN_WIZARD.edit_obj.properties.use_vif ? '1' : '0');
                $("#vpnName").val(VPN_WIZARD.edit_obj.properties.name);
                VPN_WIZARD.save_name = VPN_WIZARD.edit_obj.properties.name;

                // Phase 1
                WGRD.enableUIElements(false, ['#vpnP1NATTInterval', '#vpnP1IKEKAInterval', '#vpnP1IKEKAFailures']);
                var security_obj = VPN_WIZARD.edit_obj.properties.vpn_security;
                $("#vpnP1NATT").prop('checked', false);
                if (security_obj.ike_nat_t_enabled) {
                    $("#vpnP1NATT").prop('checked', true);
                }
                $("#vpnP1NATTInterval").val(security_obj.ike_nat_t_keep_alive);

                $("#vpnP1IKEKA").prop('checked', false);
                if (security_obj.ike_ka_enabled) {
                    $("#vpnP1IKEKA").prop('checked', true);
                }
                $("#vpnP1IKEKAInterval").val(security_obj.ike_ka_interval);
                $("#vpnP1IKEKAFailures").val(security_obj.ike_ka_max);

                $("#vpnP1DPD").prop('checked', false);
                if (security_obj.ike_dpd_enabled) {
                    $("#vpnP1DPD").prop('checked', true);
                }
                $("#vpnP1DPDTimeout").val(security_obj.ike_dpd_interval);
                $("#vpnP1DPDRetries").val(security_obj.ike_dpd_max);

                // Transform
                $("#vpnP1Auth").val(security_obj.ike_auth_algm);
                val = security_obj.ike_encryp_algm;
                if (security_obj.ike_encryp_algm === 7) {
                    if (security_obj.ike_encryp_key_len === 24) {
                        val = 8;
                    } else if (security_obj.ike_encryp_key_len === 32) {
                        val = 9;
                    }
                }
                $("#vpnP1Encr").val(val);
                val = security_obj.ike_lifetime;
                if (security_obj.ike_time_unit === 2) {
                    val = security_obj.ike_lifetime / 60;
                }
                $("#vpnP1SALifetime").val(val);
                $("#vpnP1KeyGroup").val(security_obj.ike_dh_group);

                // Phase 2
                $("#vpnP2PFS").prop('checked', security_obj.ipsec_pfs);
                $("#vpnP2PFSKeyGroup").val(security_obj.ipsec_dh_group);
                $("#vpnP2Auth").val(security_obj.ipsec_auth_algm);
                val = security_obj.ipsec_encryp_algm;
                if (security_obj.ipsec_encryp_algm === 7) {
                    if (security_obj.ipsec_encryp_key_len === 24) {
                        val = 8;
                    } else if (security_obj.ipsec_encryp_key_len === 32) {
                        val = 9;
                    }
                }
                $("#vpnP2Encr").val(val);
                val = false;
                if (security_obj.ipsec_lifetime > 0) {
                    val = true;
                }
                $("#vpnP2ForceTime").prop('checked', (security_obj.ipsec_lifetime > 0));
                val = security_obj.ipsec_lifetime;
                if (security_obj.ipsec_time_unit === 2) {
                    val = security_obj.ipsec_lifetime / 60;
                }
                $("#vpnP2ForceTimeHours").val(val);
                $("#vpnP2ForceTraffic").prop('checked', (security_obj.ipsec_life_length > 0));
                $("#vpnP2ForceTrafficKB").val(security_obj.ipsec_life_length);

                VPN_WIZARD.saveSecurity();
                VPN_WIZARD.uiStateSecurity();

                VPN_WIZARD.save_ifname_list = VPN_WIZARD.edit_obj.hub_gateways[0].ifname_list;

                // VPN Resources
                resource_obj = {};
                obj = {};
                for (i = 0; i < VPN_WIZARD.edit_obj.hub_gateways[0].resource_list.length; i++) {
                    resource_obj = VPN_WIZARD.edit_obj.hub_gateways[0].resource_list[i];
                    obj = {
                        'ip_address': resource_obj.ip_address,
                        'id': resource_obj.id
                    };
                    if (resource_obj.hasOwnProperty('metric')) {
                        obj.metric = resource_obj.metric;
                    }
                    if (resource_obj.hasOwnProperty('nat_enabled')) {
                        obj.nat_enabled = resource_obj.nat_enabled;
                    }
                    if (resource_obj.hasOwnProperty('nat_address')) {
                        obj.nat_address = resource_obj.nat_address;
                    }
                    if (resource_obj.hasOwnProperty('direction')) {
                        obj.direction = resource_obj.direction;
                    }
                    VPN_WIZARD.save_resource_list.push(obj);
                    value = VPN_WIZARD._getResourceDisplay(resource_obj, VPN_WIZARD.save_use_vif);
                    $("#vpnResources").append($("<option>").attr('value', resource_obj.ip_address).text(value));
                }

                virtual_ip = VPN_WIZARD.edit_obj.hub_gateways[0].virtual_ip;
                if (virtual_ip && virtual_ip.length > 0) {
                    VPN_WIZARD.save_virtual_ip = virtual_ip;
                    $("#vpnVirtualAddress input").val(virtual_ip);
                }
            }


        }
        VPN_WIZARD.changeTunnelMode();

        $('#vpn_notification').hide();
        $('#vpn_notification_text').removeClass('text-error');

        VPN_WIZARD.updateButtonStates();
    },
    _getResourceDisplay: function (obj, use_vif) {
        var value = obj.ip_address;
        if (use_vif) {
            value = obj.ip_address + ' [' + obj.metric + ']';
        } else if (obj.nat_enabled) {
            value = obj.ip_address + '⇒' + obj.nat_address;
        }
        return value;
    },

    nextButtonAction: function () {
        if (VPN_WIZARD.wizAction === 'add' && $('#vpn_nextButton').text() === S_VPN_FINISH_BUTTON) {
            VPN_WIZARD.updateVpn();
            return;
        }

        //stay on the currentPane if validation fails
        if (!VPN_WIZARD.validatePane(VPN_WIZARD.currentPane)) {
            return;
        }
        VPN_WIZARD.moveToNextPane(1);
    },

    backButtonAction : function () {
        VPN_WIZARD.moveToNextPane(-1);
    },

    /*
      Based on whether user is moving forward[true] or backward[false]
      show the appropriate pane and update the buttons
     */
    moveToNextPane : function (param, specificPane) {
        var pane = VPN_WIZARD.activePanes[VPN_WIZARD.currentPane];
        $('#' + pane + '_li').removeClass('active');
        $('#' + pane + '_li').addClass('already-visited');

        if (param === 1) {
            VPN_WIZARD.togglePanes(VPN_WIZARD.currentPane, VPN_WIZARD.nextPane, true);
            VPN_WIZARD.nextPane += 1;
            VPN_WIZARD.currentPane += 1;
        } else if (param === -1) {
            VPN_WIZARD.nextPane -= 1;
            VPN_WIZARD.currentPane -= 1;
            VPN_WIZARD.togglePanes(VPN_WIZARD.currentPane, VPN_WIZARD.nextPane, false);
        } else {
            // Don't step, go directly
            VPN_WIZARD.nextPane = specificPane;
            //VPN_WIZARD.currentPane = specificPane;
            VPN_WIZARD.togglePanes(VPN_WIZARD.currentPane, VPN_WIZARD.nextPane, true);
            VPN_WIZARD.currentPane = specificPane;
            VPN_WIZARD.nextPane = specificPane + 1;

        }

        pane = VPN_WIZARD.activePanes[VPN_WIZARD.currentPane];
        $('#' + pane + '_li').addClass('already-visited');
        $('#' + pane + '_li').addClass('active');

        VPN_WIZARD.updateButtonStates();
        //Select the first visible input component
        $('input:text:visible, select:visible').first().focus();
    },

    closeVpnDialog : function () {
        $('#manage_vpn_dlg').modal('hide');
        if (VPN_WIZARD.wizType === 'hub' && VPN_WIZARD.wizAction === 'add') {
            window.location = '/log/devices#tabVpns';
        }
    },

    updateVpn: function () {
        if (!VPN_WIZARD.validatePane(VPN_WIZARD.currentPane)) {
            return;
        }
        if (VPN_WIZARD.wizType === 'spoke') {
            return VPN_WIZARD.save_spoke();
        }
        return VPN_WIZARD.save_wizard();
    },

    /*
      Reset the passed in pane's UI components
    */
    resetPane: function (pane, data) {
        $("#" + pane).hide();
        var i = 0;
        switch (pane) {
        case 'vpn_spokePage':
            $('#nextButton').attr('disabled', false);
            showHideErrorMsg("#spokeDeviceList");
            $("#spokeDeviceList option").remove();
            for (i = 0; i < data.appliance_list.length; i++) {
                $("#spokeDeviceList").append($("<option value=" + data.appliance_list[i].id + ">" + data.appliance_list[i].name + "</option>"));
            }
            WGRD.enableUIElements(false, ["#spokeDeviceList"]);
            if (VPN_WIZARD.wizAction === 'add') {
                WGRD.enableUIElements(true, ["#spokeDeviceList"]);
            }

            showHideErrorMsg("#vpnExternalIf");
            showHideErrorMsg("#vpnSpokeResources");
            showHideErrorMsg("#vpn_spokeRoute");
            break;
        case 'vpn_hubPage':
            $('#nextButton').attr('disabled', false);

            $("#hubDeviceList option").remove();
            for (i = 0; i < data.appliance_list.length; i++) {
                $("#hubDeviceList").append($("<option value=" + data.appliance_list[i].id + ">" + data.appliance_list[i].name + "</option>"));
            }
            WGRD.enableUIElements(false, ["#hubDeviceList", "#vpnType"]);
            if (VPN_WIZARD.wizAction === 'add') {
                WGRD.enableUIElements(true, ["#hubDeviceList", "#vpnType"]);
            }

            showHideErrorMsg("#vpnExternalIf");
            showHideErrorMsg("#vpnResources");
            break;
        case 'vpn_settingsPage':
            $('#vpn_EditSecurity, label[for="vpn_EditSecurity"]').hide();
            if (VPN_WIZARD.wizAction === 'edit') {
                $('#vpn_EditSecurity, label[for="vpn_EditSecurity"]').show();
            }
            break;
        case 'vpn_externalifPage':
            $("#vpnExternalIf option").remove();
            break;
        case 'vpn_hubResourcePage':
            VPN_WIZARD.save_resource_list = [];
            $("#vpnResources option").remove();

            $("#vpnVirtualAddress input").val('');

            $("#vpnVirtualAddress_div").hide();
            if (VPN_WIZARD.save_use_vif) {
                $("#vpnVirtualAddress_div").show();
            }
            break;
        case 'vpn_spokeResourcePage':
            WGRD.enableUIElements(true, ['#spokeTunnelMode']);
            WGRD.enableUIElements(true, ['#vpn_route_dlg_select']);
            showHideErrorMsg("#vpnSpokeResources");
            showHideErrorMsg("#vpnSpokeVirtualAddress");
            showHideErrorMsg("#vpn_spokeRoute");

            // Virtual IP
            $("#spokeTunnelMode option[value=0]").show();
            $("#spokeTunnelMode option[value=1]").show();
            $("#spokeTunnelMode option[value=2]").hide();
            $("#spokeTunnelMode").val('0');

            $("#vpnSpokeResources option").remove();
            VPN_WIZARD.save_resource_list = [];

            $("#vpn_spokeRoute option").remove();
            VPN_WIZARD.save_routing_list = [];

            var value = '';
            $("#vpn_route_dlg_select option").remove();
            if (VPN_WIZARD.hub_resource_list.length > 0) {
                for (i = 0; i < VPN_WIZARD.hub_resource_list.length; i++) {
                    value = VPN_WIZARD._getResourceDisplay(VPN_WIZARD.hub_resource_list[i], VPN_WIZARD.save_use_vif);
                    if (VPN_WIZARD.wizAction === 'add') {
                        $("#vpn_spokeRoute").append("<option value=" + VPN_WIZARD.hub_resource_list[i].id + ">" + value + "</option>");
                    }
                    $("#vpn_route_dlg_select").append("<option value=" + VPN_WIZARD.hub_resource_list[i].id + ">" + value + "</option>");
                }
            }
            break;
        case 'vpn_spokeOptionsPage':
            // Disable tunnel switching choice for now
            //WGRD.enableUIElements(false, ['#spokeSwitching']);
            //$("#spokeSwitching option").removeAttr('selected');

            WGRD.enableUIElements(true, ['#spokePolicies']);
            $("#spokePolicies option").removeAttr('selected');
            break;
        default:
            break;
        }
    },

    getExternalIfs: function (id) {
        $.ajax({
            url: '/control/get_vpn_wizard_iflist?sn=' + id + '&id=' + VPN_WIZARD.managed_vpn_id,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                var i = 0;
                var addFirstTime = false;
                if ($("#vpnExternalIf option").length === 0) {
                    addFirstTime = true;
                }
                $("#external_if_dlg_select option").remove();

                VPN_WIZARD.virtualip_supported = data.virtualip_supported;

                // Add to the select dialog and wizard page on add
                for (i = 0; i < data.if_list.length; i++) {
                    if (VPN_WIZARD.wizType === 'hub' && (data.if_list[i].ip_assignment !== undefined && data.if_list[i].ip_assignment !== 'Static')) {
                        // Only static interfaces for the hub
                        continue;
                    }
                    if (data.if_list[i].ip_assignment === 'Static' && data.if_list[i].ip === '0.0.0.0') {
                        // Bridge mode devices not allowed
                        continue;
                    }
                    $("#external_if_dlg_select").append("<option value=" + data.if_list[i].ifname + ">" + data.if_list[i].name + "</option>");
                    if (VPN_WIZARD.wizAction === 'add') {
                        $("#vpnExternalIf").append("<option value=" + data.if_list[i].ifname + ">" + data.if_list[i].name + "</option>");
                    }
                }
                var j = 0;
                if ((VPN_WIZARD.wizAction === 'edit' || VPN_WIZARD.wizAction === 'view') && addFirstTime) {
                    // Add configured interfaces in correct order
                    var ifname_list = [];
                    if (VPN_WIZARD.wizType === 'hub') {
                        ifname_list = VPN_WIZARD.edit_obj.hub_gateways[0].ifname_list;
                    } else {
                        ifname_list = VPN_WIZARD.edit_obj.ifname_list;
                    }
                    for (i = 0; i < ifname_list.length; i++) {
                        for (j = 0; j < data.if_list.length; j++) {
                            if (data.if_list[j].ip_assignment === 'Static' && data.if_list[j].ip === '0.0.0.0') {
                                // Bridge mode devices not allowed
                                continue;
                            }
                            if (data.if_list[j].ifname === ifname_list[i]) {
                                $("#vpnExternalIf").append("<option value=" + data.if_list[j].ifname + ">" + data.if_list[j].name + "</option>");
                            }
                        }
                    }
                }
            },
            complete: function () {
                // Handle enabling virtualip feature support
                var virtualip_enable = VPN_WIZARD.save_use_vif && VPN_WIZARD.virtualip_supported;

                if (VPN_WIZARD.wizType === 'hub') {
                    $("#vpnVirtualAddress_div").hide();
                    if (virtualip_enable) {
                        $("#vpnVirtualAddress_div").show();
                    }
                } else {
                    var shown = false;
                    var tunnel_mode = '0';
                    if (VPN_WIZARD.wizAction === 'edit') {
                        tunnel_mode = VPN_WIZARD.edit_obj.tunnel_mode.toString();
                    }
                    $("#spokeTunnelMode").val('');
                    $("#spokeTunnelMode option[value=0]").hide();
                    $("#spokeTunnelMode option[value=1]").hide();
                    $("#spokeTunnelMode option[value=2]").hide();
                    if (VPN_WIZARD.hub_resource_list.length > 0) {
                        shown = true;
                        $("#spokeTunnelMode option[value=0]").show();
                        $("#spokeTunnelMode option[value=1]").show();
                    }
                    if (virtualip_enable && VPN_WIZARD.save_hub_virtual_ip !== '') {
                        // Enable virtual ip support
                        shown = true;
                        $("#spokeTunnelMode option[value=2]").show();
                        if (VPN_WIZARD.hub_resource_list.length === 0) {
                            tunnel_mode = '2';
                        }
                    }
                    if (shown) {
                        $("#spokeTunnelMode").val(tunnel_mode);
                        VPN_WIZARD.changeTunnelMode();
                    } else {
                        VPN_WIZARD.uiStateTunnelMode(-1);
                    }
                }
            }
        });
    },
    /*
      For the passed in pane get the pane name from activePanes
      and validate each pane.
      'hubPage' sets up the activePanes array, for manual mode remove the 'reviewPage'
    */
    validatePane : function (pane) {
        var current_pane_id = VPN_WIZARD.activePanes[pane] || VPN_WIZARD.activePanes[0];
        var device_id = 0;
        var virtual_ip = '';
        switch (current_pane_id) {
        case 'vpn_spokePage':
            device_id = $("#spokeDeviceList option:selected").val();
            if (!device_id) {
                showHideErrorMsg("#spokeDeviceList", S_VPN_DEVICE_EMPTY_MSG);
                return false;
            }
            VPN_WIZARD.save_device_id = $("#spokeDeviceList option:selected").val();
            VPN_WIZARD.save_device_name = $("#spokeDeviceList option:selected").text();
            if (VPN_WIZARD.wizAction === 'add') {
                $("#vpnExternalIf option").remove();
            }
            VPN_WIZARD.getExternalIfs(VPN_WIZARD.save_device_id);
            break;
        case 'vpn_hubPage':
            //Welcome Page
            var vpnType = $("#vpnType option:selected").val();
            var use_vif = false;
            $("#vpnVirtualAddress_div").hide();
            if (vpnType === '1') {
                use_vif = true;
            }
            if (use_vif !== VPN_WIZARD.save_use_vif) {
                // If the bovpn type changes, remove any resources
                $("#vpnResources option").remove();
                VPN_WIZARD.save_resource_list = [];
            }
            VPN_WIZARD.save_use_vif = use_vif;

            device_id = $("#hubDeviceList option:selected").val();
            if (!device_id) {
                showHideErrorMsg("#hubDeviceList", S_VPN_DEVICE_EMPTY_MSG);
                return false;
            }
            var device_name = '';
            if (VPN_WIZARD.wizAction === 'add') {
                $("#vpnExternalIf option").remove();
                device_name = $("#hubDeviceList option:selected").text();
                $("#vpnName").val(device_name);
                showHideErrorMsg("#vpnName");
            }
            VPN_WIZARD.getExternalIfs(device_id);
            VPN_WIZARD.save_device_id = parseInt(device_id, 10);
            break;
        case 'vpn_settingsPage':
            if (!VPN_WIZARD.validate_name('#vpnName')) {
                return false;
            }

            VPN_WIZARD.save_name = $("#vpnName").val().trim();

            showHideErrorMsg("#vpnExternalIf");
            break;
        case 'vpn_externalifPage':
            if ($("#vpnExternalIf option").length === 0) {
                showHideErrorMsg("#vpnExternalIf", S_VPN_EXTERNALIF_ERR_MSG);
                return false;
            }
            VPN_WIZARD.save_ifname_list = [];
            $("#vpnExternalIf option").each(function (eo) {
                VPN_WIZARD.save_ifname_list.push(this.value);
            });
            showHideErrorMsg("#vpnResources");
            break;
        case 'vpn_hubResourcePage':
            //Last step for hub devices

            virtual_ip = $("#vpnVirtualAddress input").val();
            if (virtual_ip.length > 0) {
                if (IPHELPER.usableHostIP4(virtual_ip) !== 0) {
                    showHideErrorMsg("#vpnResources", S_VPN_HOST_IP_ERR_MSG);
                    return false;
                }
            }
            VPN_WIZARD.save_virtual_ip = virtual_ip;

            if ($("#vpnResources option").length === 0 && virtual_ip.length === 0) {
                showHideErrorMsg("#vpnResources", S_VPN_RESOURCE_ERR_MSG);
                return false;
            }

            showHideErrorMsg("#vpnVirtualAddress");

            break;
        case 'vpn_spokeResourcePage':
            // Routing list
            VPN_WIZARD.save_routing_list = [];
            VPN_WIZARD.save_virtual_ip = '';

            switch (VPN_WIZARD.save_tunnel_mode) {
            case 0:
                if ($("#vpnSpokeResources option").length === 0) {
                    showHideErrorMsg("#vpnSpokeResources", S_VPN_RESOURCE_ERR_MSG);
                    return false;
                }
                if ($("#vpn_spokeRoute option").length === 0) {
                    showHideErrorMsg("#vpn_spokeRoute", S_VPN_ROUTETO_ERR_MSG);
                    return false;
                }
                $("#vpn_spokeRoute option").each(function (eo) {
                    VPN_WIZARD.save_routing_list.push(parseInt(this.value, 10));
                });
                break;
            case 1:
                if ($("#vpnSpokeResources option").length === 0) {
                    showHideErrorMsg("#vpnSpokeResources", S_VPN_RESOURCE_ERR_MSG);
                    return false;
                }
                break;
            case 2:
                virtual_ip = $("#vpnSpokeVirtualAddress input").val();
                if (IPHELPER.usableHostIP4(virtual_ip) !== 0) {
                    showHideErrorMsg("#vpnSpokeVirtualAddress", S_VPN_HOST_IP_ERR_MSG);
                    return false;
                }
                VPN_WIZARD.save_virtual_ip = virtual_ip;
                showHideErrorMsg("#vpnSpokeVirtualAddress");
                break;
            }

            break;
        case 'vpn_spokeOptionsPage':
            //VPN_WIZARD.save_tunnel_switching = $("#spokeSwitching option:selected").val();
            VPN_WIZARD.save_policy = parseInt($("#spokePolicies option:selected").val(), 10);
            break;
        default:
            break;
        }
        return true;
    },
    validate_name: function (name_id) {
        var name = $(name_id).val().trim();
        if (name.length === 0) {
            showHideErrorMsg(name_id, S_VPN_NAME_EMPTY_MSG);
            return false;
        }
        showHideErrorMsg(name_id);
        if (name.length > 128) {
            showHideErrorMsg(name_id, S_VPN_NAME_LEN_MSG);
            return false;
        }
        showHideErrorMsg(name_id);

        return true;
    },

    save_wizard: function () {
        var vpn_obj = new VpnObj();
        vpn_obj.vpn_action = 0; // add
        vpn_obj.vpn_name = VPN_WIZARD.save_name;
        vpn_obj.device_id = VPN_WIZARD.save_device_id;
        vpn_obj.use_vif = VPN_WIZARD.save_use_vif;
        vpn_obj.ifname_list = VPN_WIZARD.save_ifname_list;
        vpn_obj.resource_list = VPN_WIZARD.save_resource_list;
        vpn_obj.virtual_ip = VPN_WIZARD.save_virtual_ip;
        if (VPN_WIZARD.wizAction === 'edit') {
            vpn_obj.vpn_action = 2;
            vpn_obj.vpn_id = VPN_WIZARD.managed_vpn_id;

            vpn_obj.gateway_id = VPN_WIZARD.edit_obj.hub_gateways[0].id;
            vpn_obj.ike_nat_t_enabled = VPN_WIZARD.save_security_obj.ike_nat_t_enabled;
            vpn_obj.ike_nat_t_keep_alive = parseInt(VPN_WIZARD.save_security_obj.ike_nat_t_keep_alive, 10);
            vpn_obj.ike_ka_enabled = VPN_WIZARD.save_security_obj.ike_ka_enabled;
            vpn_obj.ike_ka_interval = parseInt(VPN_WIZARD.save_security_obj.ike_ka_interval, 10);
            vpn_obj.ike_ka_max = parseInt(VPN_WIZARD.save_security_obj.ike_ka_max, 10);
            vpn_obj.ike_dpd_enabled = VPN_WIZARD.save_security_obj.ike_dpd_enabled;
            vpn_obj.ike_dpd_interval = parseInt(VPN_WIZARD.save_security_obj.ike_dpd_interval, 10);
            vpn_obj.ike_dpd_max = parseInt(VPN_WIZARD.save_security_obj.ike_dpd_max, 10);
            vpn_obj.ike_auth_algm = parseInt(VPN_WIZARD.save_security_obj.ike_auth_algm, 10);
            vpn_obj.ike_encryp_algm = parseInt(VPN_WIZARD.save_security_obj.ike_encryp_algm, 10);
            vpn_obj.ike_encryp_key_len = parseInt(VPN_WIZARD.save_security_obj.ike_encryp_key_len, 10);
            vpn_obj.ike_lifetime = parseInt(VPN_WIZARD.save_security_obj.ike_lifetime, 10);
            vpn_obj.ike_time_unit = parseInt(VPN_WIZARD.save_security_obj.ike_time_unit, 10);
            vpn_obj.ike_dh_group = parseInt(VPN_WIZARD.save_security_obj.ike_dh_group, 10);
            vpn_obj.ipsec_pfs = VPN_WIZARD.save_security_obj.ipsec_pfs;
            vpn_obj.ipsec_dh_group = parseInt(VPN_WIZARD.save_security_obj.ipsec_dh_group, 10);
            vpn_obj.ipsec_auth_algm = parseInt(VPN_WIZARD.save_security_obj.ipsec_auth_algm, 10);
            vpn_obj.ipsec_encryp_algm = parseInt(VPN_WIZARD.save_security_obj.ipsec_encryp_algm, 10);
            vpn_obj.ipsec_encryp_key_len = parseInt(VPN_WIZARD.save_security_obj.ipsec_encryp_key_len, 10);
            vpn_obj.ipsec_lifetime = parseInt(VPN_WIZARD.save_security_obj.ipsec_lifetime, 10);
            vpn_obj.ipsec_time_unit = parseInt(VPN_WIZARD.save_security_obj.ipsec_time_unit, 10);
            vpn_obj.ipsec_life_length = parseInt(VPN_WIZARD.save_security_obj.ipsec_life_length, 10);
        }

        //Save VPN
        WGRD.putData(vpn_obj).success(function (response) {
            $('#backButton').prop("disabled", false);
            $('#nextButton').prop("disabled", false);
            $('#loading').hide();
            if (response.status) {
                if (VPN_WIZARD.wizAction === 'add') {
                    window.location = '/control/vpn?sn=' + response.vpn_id;
                    return true;
                }
                VPN_WIZARD.closeVpnDialog();
                if (VPN_WIZARD.cbComplete !== null) {
                    VPN_WIZARD.cbComplete();
                }
            } else {
                WGRD.okMessageModal(response.message, '');
            }
        });
        return false;
    },
    uiStateSecurity: function (eo) {
        WGRD.enableUIElements(false, ['#vpnP1NATTInterval', '#vpnP1IKEKAInterval', '#vpnP1IKEKAFailures',
            '#vpnP1DPDTimeout', '#vpnP1DPDRetries', '#vpnP2PFSKeyGroup', '#vpnP2ForceTimeHours', '#vpnP2ForceTrafficKB'
            ]);

        var checked = $("#vpnP1NATT").is(':checked');
        WGRD.enableUIElements(checked, ['label[for="vpnP1NATTInterval"]', '#vpnP1NATTInterval']);
        checked = $("#vpnP1IKEKA").is(':checked');
        WGRD.enableUIElements(checked, ['#vpnP1IKEKAInterval', 'label[for="vpnP1IKEKAInterval"]', '#vpnP1IKEKAFailures', 'label[for="vpnP1IKEKAFailures"]']);
        checked = $("#vpnP1DPD").is(':checked');
        WGRD.enableUIElements(checked, ['#vpnP1DPDTimeout', 'label[for="vpnP1DPDTimeout"]', '#vpnP1DPDRetries', 'label[for="vpnP1DPDRetries"]']);
        checked = $("#vpnP2PFS").is(':checked');
        WGRD.enableUIElements(checked, ['#vpnP2PFSKeyGroup', 'label[for="vpnP2PFSKeyGroup"]']);
        checked = $("#vpnP2ForceTime").is(':checked');
        WGRD.enableUIElements(checked, ['#vpnP2ForceTimeHours', 'label[for="vpnP2ForceTimeHours"]']);
        checked = $("#vpnP2ForceTraffic").is(':checked');
        WGRD.enableUIElements(checked, ['#vpnP2ForceTrafficKB', 'label[for="vpnP2ForceTrafficKB"]']);
    },
    uiInitProgress: function (name1, name2, name3) {
        VPN_WIZARD.progressComplete = 0;
        VPN_WIZARD.progressTotal = 0;
        $("#main_vpn_div").hide();
        $("#vpn_save_progress").show();
        $("#vpn_save_progress_div img").hide();
        $("#vpn_save_progress_div .msg").text('');
        $("#vpn_save_progress_div .msg").removeClass('alert alert-error');
        $("#vpn_save_progress_text").text('');
        $(".complete,.failure").hide();
        $("#step1,#step2,#step3").removeClass('alert alert-error');
        $("#step1 .vpn_save_progress_name").text(name1);
        $("#step2 .vpn_save_progress_name").text(name2);
        $("#step3 .vpn_save_progress_name").text(name3);
        $(".vpn_save_progress_name").hide();
        WGRD.enableUIElements(false, ["#vpn_save_progress_close", "#vpn_save_progress .close"]);
    },
    uiStateProgress: function (state, step, text) {
        if (state === 'complete' || state === 'failure') {
            VPN_WIZARD.progressTotal += 1;
            if (state === 'complete') {
                VPN_WIZARD.progressComplete += 1;
            }
        }
        WGRD.showUIElements(false, ["#vpn_save_progress_yes, #vpn_save_progress_no"]);
        WGRD.showUIElements(true, ["#vpn_save_progress_close"]);
        $("#vpn_save_progress_text").text('');
        if (VPN_WIZARD.progressComplete === 3) {
            $("#vpn_save_progress_text").text(S_VPN_SAVE_VPN_SUCCESS_MSG);
        }
        if (VPN_WIZARD.progressTotal === 3) {
            WGRD.enableUIElements(true, ["#vpn_save_progress_close", "#vpn_save_progress .close"]);
        }
        $("#step" + step + " .loading").hide();
        if (['loading', 'failure', 'complete'].indexOf(state) >= 0) {
            $("#step" + step + " ." + state).each(function (eo) {
                $(this).show();
            });
            $("#step" + step + " .vpn_save_progress_name").show();
        }
        $("#step" + step + " .msg").text(text);
        if (state === 'failure') {
            $("#step" + step).addClass('alert alert-error');
        }
    },
    save_spoke: function () {
        var spoke_obj = new SpokeObj();
        spoke_obj.action = 0; // add
        spoke_obj.managed_vpn_id = VPN_WIZARD.managed_vpn_id;
        spoke_obj.device_id = VPN_WIZARD.save_device_id;
        spoke_obj.name = VPN_WIZARD.save_device_name;
        spoke_obj.ifname_list = VPN_WIZARD.save_ifname_list;
        spoke_obj.resource_list = VPN_WIZARD.save_resource_list;
        spoke_obj.routing_list = VPN_WIZARD.save_routing_list;
        spoke_obj.tunnel_switching = VPN_WIZARD.save_tunnel_switching;
        spoke_obj.policy = VPN_WIZARD.save_policy;
        spoke_obj.auto_start = VPN_WIZARD.save_auto_start;
        spoke_obj.tunnel_mode = VPN_WIZARD.save_tunnel_mode;
        switch (spoke_obj.tunnel_mode) {
        case 0:
            spoke_obj.virtual_ip = '';
            break;
        case 1:
            spoke_obj.routing_list = [];
            spoke_obj.virtual_ip = '';
            break;
        case 2:
            spoke_obj.resource_list = [];
            spoke_obj.routing_list = [];
            spoke_obj.virtual_ip = VPN_WIZARD.save_virtual_ip;
            break;
        }

        if (VPN_WIZARD.wizAction === 'edit') {
            spoke_obj.action = 2;
            spoke_obj.id = VPN_WIZARD.save_spoke_id;
            spoke_obj.name = VPN_WIZARD.save_device_name;
        }

        VPN_WIZARD.uiInitProgress(S_VPN_DIMENSION, VPN_WIZARD.save_device_name, VPN_WIZARD.hub_device_name);
        VPN_WIZARD.uiStateProgress('loading', 1, S_VPN_SAVE_VPN_MSG_1);

        //Save to Dimension
        WGRD.putData(spoke_obj).success(function (response) {
            if (response.status) {
                VPN_WIZARD.save_spoke_id = response.spoke_id;
                VPN_WIZARD.uiStateProgress('complete', 1, S_VPN_SAVE_VPN_MSG_1_COMPLETE);
                return VPN_WIZARD.save_spoke_apply();
            }
            $("#vpn_save_progress").hide();
            WGRD.okMessageModal(response.message, '', function () {
                $("#main_vpn_div").show();
            });
        });
        return false;
    },
    save_spoke_apply: function () {
        var update_device_obj = new UpdateDeviceObj();
        update_device_obj.apply_device = 'spoke';
        update_device_obj.action = 0;
        if (VPN_WIZARD.wizAction === 'edit') {
            update_device_obj.action = 2;
        }
        update_device_obj.spoke_device_id = VPN_WIZARD.save_device_id;
        update_device_obj.spoke_id = VPN_WIZARD.save_spoke_id;
        update_device_obj.vpn_id = VPN_WIZARD.managed_vpn_id;

        // Save to spoke
        VPN_WIZARD.uiStateProgress('loading', 2, S_VPN_SAVE_VPN_MSG_2);
        WGRD.putData(update_device_obj).success(function (response) {
            if (response.status) {
                VPN_WIZARD.uiStateProgress('complete', 2, S_VPN_SAVE_VPN_MSG_2_COMPLETE);
            } else {
                VPN_WIZARD.uiStateProgress('failure', 2, response.message);
            }
        });
        setTimeout(VPN_WIZARD.save_hub_apply, 200);
    },
    save_hub_apply: function () {
        var update_device_obj = new UpdateDeviceObj();
        update_device_obj.apply_device = 'hub';
        update_device_obj.action = 0;
        if (VPN_WIZARD.wizAction === 'edit') {
            update_device_obj.action = 2;
        }
        update_device_obj.spoke_device_id = VPN_WIZARD.save_device_id;
        update_device_obj.spoke_id = VPN_WIZARD.save_spoke_id;
        update_device_obj.vpn_id = VPN_WIZARD.managed_vpn_id;

        // Save to hub
        VPN_WIZARD.uiStateProgress('loading', 3, S_VPN_SAVE_VPN_MSG_3);
        WGRD.putData(update_device_obj).success(function (response) {
            if (response.status) {
                VPN_WIZARD.uiStateProgress('complete', 3, S_VPN_SAVE_VPN_MSG_3_COMPLETE);
            } else {
                VPN_WIZARD.uiStateProgress('failure', 3, response.message);
            }
        });

    },

    /* Begin - Add External Interface */
    addExternalIf: function (eo) {
        $("#main_vpn_div").hide();
        $("#vpn_external_if_dlg").show();
    },
    delExternalIf: function (eo) {
        $("#vpnExternalIf option:selected").remove();
    },
    upExternalIf: function (eo) {
        $("#vpnExternalIf option:selected").each(function () {
            var insertpos = $(this).prev();
            if (insertpos) {
                $(this).insertBefore(insertpos);
            }

        });
    },
    downExternalIf: function (eo) {
        $($("#vpnExternalIf option:selected").get().reverse()).each(function () {
            var insertpos = $(this).next();
            if (insertpos) {
                $(this).insertAfter(insertpos);
            }

        });
    },
    closeExternalIf: function (eo) {
        $("#main_vpn_div").show();
        $("#vpn_external_if_dlg").hide();
    },
    saveExternalIf: function (eo) {
        $("#external_if_dlg_select option:selected").each(function () {
            var ifname = $(this).val();
            var name = $(this).text();
            if ($("#vpnExternalIf option[value=" + ifname + "]").length === 0) {
                $("#vpnExternalIf").append("<option value=" + ifname + ">" + name + "</option>");
            }
        });
        showHideErrorMsg("#vpnExternalIf");
        VPN_WIZARD.closeExternalIf();
        return;
    },
    /* End - Add External Interface */

    /* Begin - Add VPN Resource */
    addHubVpnResource: function (ishub) {
        VPN_WIZARD.addVpnResource(false);
    },
    addSpokeVpnResource: function () {
        VPN_WIZARD.addVpnResource(true);
    },
    addVpnResource: function (isspoke) {
        $("#vpn_resource_vif_settings").hide();
        $("#vpn_resource_traditional_settings").hide();
        showHideErrorMsg("#vpnResourceText");
        showHideErrorMsg("#vpnResourceMetric");
        $("#vpnResourceText").val("");
        $("#vpnResourceDirection").val("0");
        $("#vpnResourceNatAddress").val("");
        $("#vpnResourceNatEnabled").prop('checked', false);
        WGRD.enableUIElements(false, ['#vpnResourceNatAddress']);
        if (VPN_WIZARD.save_use_vif) {
            $("#vpn_resource_vif_settings").show();
        } else {
            if (isspoke) {
                $("#vpn_resource_traditional_settings").show();
            }
        }
        $("#main_vpn_div").hide();
        $("#vpn_resource_dlg").show();
        $("#vpnResourceText").focus();
    },
    delVpnResource: function (eo) {
        VPN_WIZARD._delVpnResource("vpnResources");
    },
    delSpokeVpnResource: function (eo) {
        VPN_WIZARD._delVpnResource("vpnSpokeResources");
    },
    _delVpnResource: function (domid) {
        $("#" + domid + " option:selected").each(function (eo) {
            var ip = $(this).val();
            var i = 0;
            for (i = 0; i < VPN_WIZARD.save_resource_list.length; i++) {
                if (ip === VPN_WIZARD.save_resource_list[i].ip_address) {
                    VPN_WIZARD.save_resource_list.splice(i, 1);
                    break;
                }
            }
        });
        $("#" + domid + " option:selected").remove();
    },
    closeVpnResource: function (eo) {
        $("#main_vpn_div").show();
        $("#vpn_resource_dlg").hide();
    },
    enableNATVpnResource: function (eo) {
        var checked = $("#vpnResourceNatEnabled").is(':checked');
        WGRD.enableUIElements(checked, ['#vpnResourceNatAddress']);
    },
    saveHubVpnResource: function (eo) {
        VPN_WIZARD._saveVpnResource('vpnResources');
    },
    saveSpokeVpnResource: function (eo) {
        VPN_WIZARD._saveVpnResource('vpnSpokeResources');
    },
    _validateVpnResource: function (resources_div) {
        showHideErrorMsg("#vpnResourceText");
        showHideErrorMsg("#vpnResourceNatAddress");

        var ip = $("#vpnResourceText").val();

        if (IPHELPER.usableHostIP4(ip) !== 0 && IPHELPER.usableNetworkIP4(ip) !== 0
                /*&& IPHELPER.usableRangeIP4(ip) !== 0*/) {
            showHideErrorMsg("#vpnResourceText", S_VPN_IP_ERR_MSG);
            return false;
        }
        if (VPN_WIZARD.save_use_vif === false) {
            var nat_enabled = $("#vpnResourceNatEnabled").is(':checked');
            var nat_address = '';
            if (nat_enabled) {
                nat_address = $("#vpnResourceNatAddress").val();

                if (IPHELPER.usableHostIP4(nat_address) !== 0 && IPHELPER.usableNetworkIP4(nat_address) !== 0
                        && IPHELPER.usableRangeIP4(nat_address) !== 0) {
                    showHideErrorMsg("#vpnResourceNatAddress", S_VPN_IP_ERR_MSG);
                    return false;
                }

                if (nat_address.indexOf('/') > 0) {
                    if (IPHELPER.sizeOfNetwork4(ip) !== IPHELPER.sizeOfNetwork4(nat_address)) {
                        showHideErrorMsg("#vpnResourceNatAddress", S_VPN_NAT_MUST_MATCH);
                        return false;
                    }
                } else if (nat_address.indexOf('-') > 0) {
                    if (IPHELPER.sizeOfRange4(ip) !== IPHELPER.sizeOfRange4(nat_address)) {
                        showHideErrorMsg("#vpnResourceNatAddress", S_VPN_NAT_MUST_MATCH);
                        return false;
                    }
                } else {
                    if (ip.indexOf('-') > 0 || ip.indexOf('/') > 0) {
                        showHideErrorMsg("#vpnResourceNatAddress", S_VPN_NAT_MUST_MATCH);
                        return false;
                    }
                    if (ip === nat_address) {
                        showHideErrorMsg("#vpnResourceNatAddress", S_VPN_NAT_MUST_MATCH);
                        return false;
                    }
                }
            }
        }

        var i = 0;
        var foundit = false;
        for (i = 0; i < VPN_WIZARD.save_resource_list.length; i++) {
            if (ip === VPN_WIZARD.save_resource_list[i].ip_address) {
                foundit = true;
                break;
            }
        }
        if (foundit) {
            showHideErrorMsg("#vpnResourceText", S_VPN_UNUSED_IP_ERR_MSG);
            return false;
        }

        return true;
    },
    _saveVpnResource: function (resources_div) {
        var metric = '';
        var ip = $("#vpnResourceText").val();
        var resource_obj = { 'ip_address': ip };

        if (!VPN_WIZARD._validateVpnResource(resources_div)) {
            return;
        }

        if (VPN_WIZARD.save_use_vif) {
            // VIF
            metric = $("#vpnResourceMetric").val();
            var metricn = parseInt(metric, 10);
            if (isNaN(metricn) || metricn < 1 || metricn > 254) {
                showHideErrorMsg("#vpnResourceMetric", S_VPN_METRIC_ERR_MSG);
                return;
            }
            resource_obj = { 'ip_address': ip, 'metric': metric };
        } else {
            var broadcast_enabled = false;
            var direction = $("#vpnResourceDirection option:selected").val();
            var nat_enabled = $("#vpnResourceNatEnabled").is(':checked');
            var nat_address = '';
            if (nat_enabled) {
                nat_address = $("#vpnResourceNatAddress").val();
            }

            resource_obj = { 'ip_address': ip, 'direction': direction, 'nat_enabled': nat_enabled, 'nat_address': nat_address, 'broadcast_enabled': broadcast_enabled };
        }
        var i = 0;
        var foundit = false;
        for (i = 0; i < VPN_WIZARD.save_resource_list.length; i++) {
            if (ip === VPN_WIZARD.save_resource_list[i].ip_address) {
                foundit = true;
            }
        }
        if (!foundit) {
            VPN_WIZARD.save_resource_list.push(resource_obj);
            var value = VPN_WIZARD._getResourceDisplay(resource_obj, VPN_WIZARD.save_use_vif);
            $('#' + resources_div).append($("<option>").attr('value', ip).text(value));
        }

        VPN_WIZARD.closeVpnResource();
    },
    addSpokeRoute: function (eo) {
        $("#main_vpn_div").hide();
        $("#vpn_route_dlg").show();
    },
    delSpokeRoute: function (eo) {
        $("#vpn_spokeRoute option:selected").each(function (eo) {
            var val = $(this).val();
            var i = 0;
            for (i = 0; i < VPN_WIZARD.save_routing_list.length; i++) {
                if (parseInt(val, 10) === VPN_WIZARD.save_routing_list[i]) {
                    VPN_WIZARD.save_routing_list.splice(i, 1);
                    break;
                }
            }
            $(this).remove();
        });
    },
    closeSpokeRoute: function (eo) {
        $("#main_vpn_div").show();
        $("#vpn_route_dlg").hide();
    },
    saveSpokeRoute: function (eo) {
        $("#vpn_route_dlg_select option:selected").each(function () {
            var val = $(this).val();
            var ip_address = $(this).text();
            if ($("#vpn_spokeRoute option[value=" + val + "]").length === 0) {
                $("#vpn_spokeRoute").append("<option value=" + val + ">" + ip_address + "</option>");
            }
        });
        showHideErrorMsg("#vpn_spokeRoute");

        VPN_WIZARD.closeSpokeRoute();
    },
    changeTunnelMode: function (eo) {
        VPN_WIZARD.save_tunnel_mode = parseInt($("#spokeTunnelMode").val(), 10);
        VPN_WIZARD.uiStateTunnelMode(VPN_WIZARD.save_tunnel_mode);
    },
    uiStateTunnelMode: function (tunnel_mode) {
        var elems = [];
        WGRD.showUIElements(false, ['#vpnSpokeResources_div', '#vpnSpokeRoutes_div', '#vpnSpokeVirtualAddress_div', '#spokeroute_help_text_0', '#spokeroute_help_text_1', '#spokeroute_help_text_2', '#spokeroute_help_text_3']);
        switch (tunnel_mode) {
        case 0:
            elems = ['#vpnSpokeResources_div', '#vpnSpokeRoutes_div', '#spokeroute_help_text_0'];
            break;
        case 1:
            elems = ['#vpnSpokeResources_div', '#spokeroute_help_text_1'];
            break;
        case 2:
            elems = ['#vpnSpokeVirtualAddress_div', '#spokeroute_help_text_2'];
            break;
        case -1:
            elems = ['#spokeroute_help_text_3'];
            break;
        }
        WGRD.showUIElements(true, elems);
    },
    /* End - Add VPN Resource */

    /* Begin - Security Template */
    editSecurity: function () {
        $("#main_vpn_div").hide();
        $("#vpn_security_dlg").show();
    },
    saveSecurity: function () {
        var security_obj = null;
        var val = '';
        showHideErrorMsg("#vpnP2InlineError");
        if (VPN_WIZARD.wizAction === 'edit') {
            security_obj = {};
            security_obj.vpn_action = 2;

            security_obj.ike_nat_t_enabled = $("#vpnP1NATT").is(':checked');
            security_obj.ike_nat_t_keep_alive = $("#vpnP1NATTInterval").val();
            security_obj.ike_ka_enabled = $("#vpnP1IKEKA").is(':checked');
            security_obj.ike_ka_interval = $("#vpnP1IKEKAInterval").val();
            security_obj.ike_ka_max = $("#vpnP1IKEKAFailures").val();
            security_obj.ike_dpd_enabled = $("#vpnP1DPD").is(':checked');
            security_obj.ike_dpd_interval = $("#vpnP1DPDTimeout").val();
            security_obj.ike_dpd_max = $("#vpnP1DPDRetries").val();
            security_obj.ike_auth_algm = $("#vpnP1Auth").val();

            val = $("#vpnP1Encr").val();
            security_obj.ike_encryp_algm = parseInt(val, 10);
            security_obj.ike_encryp_key_len = 16;
            if (val === '8') {
                security_obj.ike_encryp_algm = 7;
                security_obj.ike_encryp_key_len = 24;
            } else if (val === '9') {
                security_obj.ike_encryp_algm = 7;
                security_obj.ike_encryp_key_len = 32;

            }
            security_obj.ike_lifetime = $("#vpnP1SALifetime").val();
            security_obj.ike_time_unit = 1;
            security_obj.ike_dh_group = $("#vpnP1KeyGroup").val();
            security_obj.ipsec_pfs = $("#vpnP2PFS").is(':checked');
            security_obj.ipsec_dh_group = $("#vpnP2PFSKeyGroup").val();
            security_obj.ipsec_auth_algm = $("#vpnP2Auth").val();
            val = $("#vpnP2Encr").val();
            security_obj.ipsec_encryp_algm = parseInt(val, 10);
            security_obj.ipsec_encryp_key_len = 16;
            if (val === '8') {
                security_obj.ipsec_encryp_algm = 7;
                security_obj.ipsec_encryp_key_len = 24;
            } else if (val === '9') {
                security_obj.ipsec_encryp_algm = 7;
                security_obj.ipsec_encryp_key_len = 32;

            }
            var vpnP2ForceTime = $("#vpnP2ForceTime").is(':checked');
            var vpnP2ForceTraffic = $("#vpnP2ForceTraffic").is(':checked');

            if (!vpnP2ForceTime && !vpnP2ForceTraffic) {
                showHideErrorMsg("#vpnP2InlineError", S_VPN_P2_FORCE_KEY_ERR_MSG);
                return false;
            }

            var force_err;
            var ipsec_lifetime = 0;
            if (vpnP2ForceTime) {
                ipsec_lifetime = $("#vpnP2ForceTimeHours").val();
                force_err = WGRD.isValidNumeric($("#vpnP2ForceTimeHours"), S_VPN_P2_TIME);
                if (force_err && force_err.length > 0) {
                    showHideErrorMsg("#vpnP2InlineError", force_err);
                    return false;
                }
            }
            security_obj.ipsec_lifetime = ipsec_lifetime;

            security_obj.ipsec_time_unit = 1;
            var ipsec_life_length = 0;
            if (vpnP2ForceTraffic) {
                ipsec_life_length = $("#vpnP2ForceTrafficKB").val();
                force_err = WGRD.isValidNumeric($("#vpnP2ForceTrafficKB"), S_VPN_P2_TRAFFIC);
                if (force_err && force_err.length > 0) {
                    showHideErrorMsg("#vpnP2InlineError", force_err);
                    return false;
                }
            }
            security_obj.ipsec_life_length = ipsec_life_length;
        }
        VPN_WIZARD.save_security_obj = security_obj;
        VPN_WIZARD.closeSecurity();
    },
    closeSecurity: function () {
        $("#vpn_security_dlg").hide();
        $("#main_vpn_div").show();
    },
    /* End - Security Template*/

    // Hide current pane, show nextPrevPane
    togglePanes : function (currPane, nextPrevPane, param) {

        $('#vpn_notification').hide();
        if (param) {
            $('#' + VPN_WIZARD.activePanes[currPane]).hide();
            $('#' + VPN_WIZARD.activePanes[nextPrevPane]).show();
        } else {
            $('#' + VPN_WIZARD.activePanes[currPane]).show();
            $('#' + VPN_WIZARD.activePanes[nextPrevPane]).hide();
        }
    },

    /*
      If last pane, change text to Finish.
      If first or last pane disable back button.
    */
    updateButtonStates : function () {
        var is_finish_pane = (VPN_WIZARD.currentPane === VPN_WIZARD.activePanes.length - 1);

        var back_button_state = (VPN_WIZARD.currentPane === 0);

        $('#vpn_backButton').attr('disabled', back_button_state);

        if (VPN_WIZARD.wizAction === 'add') {
            $('#vpn_backButton').show();
        }
        if (VPN_WIZARD.currentPane === 0) {
            $('#vpn_nextButton').attr('disabled', false);
            $('#vpn_backButton').hide();
        }
        $('#vpn_nextButton').text(S_VPN_NEXT_BUTTON);
        if (is_finish_pane) {
            $('#vpn_nextButton').text(S_VPN_FINISH_BUTTON);
        }

    }

};
$(document).ready(VPN_WIZARD.init);
