/*global checkLoginPageRedirect, WGMAP_ORTHOGRAPHIC, S_CONTROL_STATE_DISCONNECTED, S_CONTROL_STATE_CONNECTED, S_CONTROL_STATE_BACKUPMASTER, S_CONTROL_STATE_DISABLED, S_CONTROL_DEVICE_DAYS, S_CONTROL_DEVICE_MINUTES, S_CONTROL_DEVICE_HOURS, view_health_summary_rep, view_config_history, colConfigHistoryNames, colConfigHistoryModel, createRsSingleGrid, S_CONTROL_STATE_NA, S_CONTROL_REBOOT_REQ_SEND_MSG, S_CONTROL_REBOOT_OK_MSG, S_CONTROL_ERROR_MSG, S_CONTROL_UPDATE_FK_OK_MSG, S_CONTROL_UPDATE_FK_REQ_SEND_MSG, plain_device_name, device_manage_perm, S_CONTROL_CONFIG_REVISIONS_SHOWN, R_DATE_NAVBAR, S_CONTROL_REFRESH_ERROR, anonymization_enabled*/
var CONTROL_DEVICE = {
    urlSn: 'all',
    memberUrlSn: null,
    tid: null,
    updateTimeout: 300000,
    clrAlive: 'rgb(74,171,83)',
    clrDead: '#000',
    clrDisabled: '#999',
    policy_history: null,
    config_history: null,
    init: function () {
        $.getUrlVars();
        CONTROL_DEVICE.urlSn = $.getUrlVar('sn');
        CONTROL_DEVICE.initUI();
        CONTROL_DEVICE.initEvents();
        CONTROL_DEVICE.getData();
    },

    initUI: function () {
        $("#btn_continue").hide();
        $('#div_config_history_cont').hide();
        $('#btn_policy_view_all').hide();
        if (view_health_summary_rep === 0) {
            $('#btn_health_snapshot').show();
            if (anonymization_enabled !== 1) {
                $('#btn_policy_view_all').show();
            }
        } else {
            $('#btn_health_snapshot').hide();
        }
        WGRD.showUIElements(device_manage_perm, ["#action_reboot", "#action_fk"]);
    },

    initEvents: function () {
        $("#custom_datepicker_trigger").bind('click', function () {
            // Listen for a click on this div, it means the date changed 
            // and a refresh is needed
            CONTROL_DEVICE.getData();
        });

        $(window).bind('resizeEnd', function () {
            CONTROL_DEVICE.doResize();
        });

        $("a").click(function () {
            // Custom to disable anchor if it's been set to 'disabled'
            return ($(this).attr('disabled')) ? false : true;
        });

        // When click the "VIEW ALL" button, redirect to Policy Usage summary report. 
        $('#btn_policy_view_all').button().click(function () {
            window.location = '/report/policyusage?sn=' + CONTROL_DEVICE.urlSn + '&reptype=policy_usage';
        });

        $("#btn_refresh").click(function (e) {
            CONTROL_DEVICE.refreshHealth();
        });

        $('#btn_view_all').button().click(function () {
            if (CONTROL_DEVICE.memberUrlSn) {
                window.location = '/control/config_history?sn=' + CONTROL_DEVICE.urlSn + '&msn=' + CONTROL_DEVICE.memberUrlSn;
            } else {
                window.location = '/control/config_history?sn=' + CONTROL_DEVICE.urlSn;
            }
        });

        $('#action_reboot').click(function () {
            WGRD.doModal('#reboot_modal',
                    CONTROL_DEVICE.initRebootModal,
                    CONTROL_DEVICE.doDeviceReboot,
                    null, null,
                    true, true);
        });

        $('#action_fk').click(function () {
            WGRD.doModal('#fk_sync_modal',
                    CONTROL_DEVICE.initUpdateFKModal,
                    CONTROL_DEVICE.doDeviceUpdateFK,
                    null, null,
                    true, true);
        });
    },

    loadGridPolicyHistory : function (last_5_history, total_history) {
        var grid = '#grid_policy_history';
        jQuery(grid).GridUnload(grid);

        var optparams = {
                hoverrows: false,
                beforeSelectRow: function (rowid, e) {
                    return false;
                }
            };
        createRsSingleGrid(colPolicyHistoryNames, colPolicyHistoryModel, grid, optparams);

        var $grid = $(grid);
        var policy_history = CONTROL_DEVICE.policy_history;
        var entries = policy_history.length;
        var loop = 0;
        var i, history_entry, obj;

        var name;
        var bytes;
        var hits;

        $grid.setColProp('bytes', { formatter: WGRD.colFormatterChart });
        $grid.setColProp('hits', { formatter: WGRD.colFormatterChart });
        
        for (i = 0; i <= entries - 1; i++) {
            name = policy_history[i].name;
            if (name != 'undefined') {
                bytes = policy_history[i].bytes;
                hits = policy_history[i].hits;
                disable_flag = policy_history[i].disable_flag;
                unused_flag = policy_history[i].unused_flag;
                S_CHART_MAX_BYTES = Math.max(S_CHART_MAX_BYTES, bytes);
                S_CHART_MAX_HITS = Math.max(S_CHART_MAX_HITS, hits);
                // The deleted or unused policies should not be shown up in device dashboard.
                if (disable_flag == false && unused_flag == false) {
                    if (loop == last_5_history) {
                        break;
                    } else {
                        history_entry = {'name': name, 'bytes': bytes, 'hits': hits};
                        obj = jQuery.extend(true, {}, history_entry); 
                        $grid.jqGrid('addRowData', i + 1, obj);
                        loop ++;
                    }
                }
            }
        }
        $("#last_5_policies").text(S_CONTROL_POLICY_REVISIONS_SHOWN.format(loop, total_history));
    },

    loadGridConfigurationHistory : function (last_5_history) {
        var grid = '#grid_config_history';
        jQuery(grid).GridUnload(grid);

        var optparams = {
                hoverrows: false,
                beforeSelectRow: function (rowid, e) {
                    return false;
                }
            };
        createRsSingleGrid(colConfigHistoryNames, colConfigHistoryModel, grid, optparams);

        var $grid = $(grid);
        var config_history = CONTROL_DEVICE.config_history;
        var entries = config_history.length;
        var loop = entries - last_5_history;
        var i, history_entry, obj;
        var revision;
        var annotation;

        config_history.sort(function (a, b) {
            return (a.config_revision > b.config_revision) ? 1 : ((b.config_revision > a.config_revision) ? -1 : 0);
        });

        for (i = entries - 1; i >= loop; --i) {
            if (config_history[i].preserved) {
                revision = config_history[i].config_revision + "*";
            } else {
                revision = config_history[i].config_revision;
            }
            if (config_history[i].annotation && config_history[i].annotation.length > 50) {
                annotation = config_history[i].annotation.substring(0, 50) + '...';
            } else {
                annotation = config_history[i].annotation;
            }
            history_entry = {'revision': revision, 'when': config_history[i].update_time,
                    'user': config_history[i].user_name, 'comment': config_history[i].user_comment,
                    'preserved': config_history[i].preserved, 'annotation': annotation };
            obj = jQuery.extend(true, {}, history_entry); // deep copy
            $grid.jqGrid('addRowData', i + 1, obj);
        }

        if (entries > 0) {
            WGRD.enableUIElements(true, ['#btn_view_all']);
        } else {
            WGRD.enableUIElements(false, ['#btn_view_all']);
        }
    },

    getData: function () {
        clearTimeout(CONTROL_DEVICE.tid);
        CONTROL_DEVICE.toggleSpinner(true);
        var url = 'get_health_summary?sn=' + CONTROL_DEVICE.urlSn;
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            success: function (data) {
                CONTROL_DEVICE.receivedData(data);
            },
            complete: function () {
                CONTROL_DEVICE.toggleSpinner(false);
                CONTROL_DEVICE.tid = setTimeout(CONTROL_DEVICE.getData, CONTROL_DEVICE.updateTimeout);
                CONTROL_DEVICE.doResize();
            }
        });
    },

    getPolicyHistoryData: function () {
        CONTROL_DEVICE.toggleSpinner(true);
        var url = 'get_policy_history?sn=' + CONTROL_DEVICE.urlSn;
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            success: function (data) {
                CONTROL_DEVICE.receivedPolicyHistoryData(data);
            },
            complete: function () {
                CONTROL_DEVICE.toggleSpinner(false);
                CONTROL_DEVICE.doResize();
            }
        });
    },

    getConfigHistoryData: function () {
        CONTROL_DEVICE.toggleSpinner(true);
        var url = 'get_config_history?sn=' + CONTROL_DEVICE.urlSn;
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            success: function (data) {
                CONTROL_DEVICE.receivedConfigHistoryData(data);
            },
            complete: function () {
                CONTROL_DEVICE.toggleSpinner(false);
                CONTROL_DEVICE.doResize();
            }
        });
    },

    initRebootModal: function () {
        WGRD.showUIElements(false, ["#reboot_loading_spinner", "#reboot_event_icon", "#reboot_modal_close"]);
        WGRD.showUIElements(true, ["#reboot_modal_yes", '#reboot_modal_no']);
        $('#reboot_event_msg').text(S_CONTROL_REBOOT_OK_MSG.format(plain_device_name));
        $('#reboot_status_msg').attr('class', 'hide');
        return true;
    },

    doDeviceReboot: function () {
        WGRD.showUIElements(true, ["#reboot_loading_spinner", "#reboot_modal_close"]);
        WGRD.showUIElements(false, ["#reboot_modal_yes", '#reboot_modal_no']);
        WGRD.enableUIElements(false, ['#reboot_modal_close']);
        $('#reboot_event_msg').text(S_CONTROL_REBOOT_REQ_SEND_MSG.format(plain_device_name));
        var rebootSn = CONTROL_DEVICE.urlSn;

        if (CONTROL_DEVICE.memberUrlSn) { //For clusters use master's urlSn.
            rebootSn = CONTROL_DEVICE.memberUrlSn;
        }

        //var url = 'reboot_device?sn=' + CONTROL_DEVICE.urlSn + '&membersn=' + CONTROL_DEVICE.memberUrlSn + '&name=' + plain_device_name;
        var url = 'reboot_device?sn=' + rebootSn + '&name=' + plain_device_name;

        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            success: function (data) {
                WGRD.showUIElements(false, ["#reboot_loading_spinner"]);
                WGRD.showUIElements(true, ['#reboot_event_icon']);
                if (data) {
                    if (data.status) {
                        $('#reboot_status_msg').attr('class', 'alert alert-success');
                        $("#reboot_event_icon").removeClass("icon-warning-sign").addClass("icon-ok");
                        $('#reboot_status_msg').text(data.message);
                    } else {
                        $('#reboot_status_msg').attr('class', 'alert alert-error');
                        $("#reboot_event_icon").removeClass("icon-ok").addClass("icon-warning-sign");
                        $('#reboot_status_msg').text(S_CONTROL_ERROR_MSG.format(data.message));
                    }
                }
            },
            complete: function () {
                WGRD.enableUIElements(true, ['#reboot_modal_close']);
            }
        });
        return;
    },

    initUpdateFKModal: function () {
        WGRD.showUIElements(false, ["#fk_sync_loading_spinner", "#fk_sync_event_icon", "#fk_sync_modal_close"]);
        WGRD.showUIElements(true, ["#fk_sync_modal_yes", '#fk_sync_modal_no']);
        $('#fk_sync_event_msg').text(S_CONTROL_UPDATE_FK_OK_MSG.format(plain_device_name));
        $('#fk_sync_status_msg').attr('class', 'hide');
        return true;
    },

    doDeviceUpdateFK: function () {
        WGRD.showUIElements(true, ["#fk_sync_loading_spinner", "#fk_sync_modal_close"]);
        WGRD.showUIElements(false, ["#fk_sync_modal_yes", '#fk_sync_modal_no']);
        WGRD.enableUIElements(false, ['#fk_sync_modal_close']);
        $('#fk_sync_event_msg').text(S_CONTROL_UPDATE_FK_REQ_SEND_MSG.format(plain_device_name));
        var fksyncurlSn = CONTROL_DEVICE.urlSn;

        if (CONTROL_DEVICE.memberUrlSn) { //For clusters use master's urlsn.
            fksyncurlSn = CONTROL_DEVICE.memberUrlSn;
        }

        var url = 'fk_sync_device?sn=' + fksyncurlSn + '&name=' + plain_device_name;

        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            success: function (data) {
                WGRD.showUIElements(false, ["#fk_sync_loading_spinner"]);
                WGRD.showUIElements(true, ['#fk_sync_event_icon']);
                if (data) {
                    if (data.status) {
                        $("#fk_sync_event_icon").removeClass("icon-warning-sign").addClass("icon-ok");
                        $('#fk_sync_status_msg').attr('class', 'alert alert-success');
                        $('#fk_sync_status_msg').text(data.message);
                    } else {
                        $("#fk_sync_event_icon").removeClass("icon-ok").addClass("icon-warning-sign");
                        $('#fk_sync_status_msg').attr('class', 'alert alert-error');
                        $('#fk_sync_status_msg').text(S_CONTROL_ERROR_MSG.format(data.message));
                    }
                }
            },
            complete: function () {
                WGRD.enableUIElements(true, ['#fk_sync_modal_close']);
            }
        });
        return;
    },

    convertUptime: function (uptime) {
        var val = parseInt(uptime, 10);
        var secs = val % 60;
        var mins = ((val - secs) / 60) % 60;
        var totalhours = (((val - secs) / 60) - mins) / 60;
        var hours = totalhours % 24;
        var days = (totalhours - hours) / 24;

        if (days > 0) {
            return [days, S_CONTROL_DEVICE_DAYS];
        }
        if (hours > 0) {
            return [hours, S_CONTROL_DEVICE_HOURS];
        }
        return [mins, S_CONTROL_DEVICE_MINUTES];
    },
    receivedData: function (data) {
        var idx = 0;
        CONTROL_DEVICE.memberUrlSn = null;
        $("#health_snapshot_div").show();
        $("#policy_history_div").hide();
        if (data.appliance_info.control.enabled === 0 || data.appliance_info.control.sample_time === null) {
            $("#health_snapshot_div").hide();
            $('#device_actions').hide();
        } else if (data.appliance_info.control.connected === 1 || data.appliance_info.control.role === 'backup master') {
            $("#cpu_usage").text(data.appliance_info.control.cpu_util_1);
            var mem_pct = 0;
            if (data.appliance_info.control.mem_total > 0) {
                mem_pct = parseInt(data.appliance_info.control.mem_used / data.appliance_info.control.mem_total * 100, 10);
            }
            $("#mem_usage").text(mem_pct);
            var uptime = CONTROL_DEVICE.convertUptime(data.appliance_info.control.uptime);
            $("#uptime_usage").text(uptime[0]);
            $("#uptime_caption_usage").text(uptime[1]);

            var sample_time = $.getDateDisplay(data.appliance_info.control.sample_time + " GMT");
            $("#update_time").text(sample_time);
            R_DATE_NAVBAR.setUpdateTime(sample_time);
            var member = {};
            var el_member_name = "#member_name";
            var el_cpu_usage = "#cpu_usage";
            var el_mem_usage = "#mem_usage";
            var el_uptime_usage = "#uptime_usage";
            var el_uptime_caption = "#uptime_caption_usage";
            var href = '';
            if (data.appliance_info.members) {

                for (idx = 0; idx < data.appliance_info.members.length; idx++) {
                    if (data.appliance_info.members[idx].control.cpu_util_1 === null) {
                        continue;
                    }
                    if (idx === 1) {
                        el_member_name = "#member_name2";
                        el_cpu_usage = "#cpu_usage2";
                        el_mem_usage = "#mem_usage2";
                        el_uptime_usage = "#uptime_usage2";
                        el_uptime_caption = "#uptime_caption_usage2";
                        $("#bignum_row_member2").show();
                    }
                    href = '<a class="device_name_sn" href="/control/device?sn=' + data.appliance_info.members[idx].id + '">' + data.appliance_info.members[idx].name + '</a>';
                    $(el_member_name).html(href + ' (' + data.appliance_info.members[idx].control.role + ')');
                    $(el_member_name).show();
                    $(el_cpu_usage).text(data.appliance_info.members[idx].control.cpu_util_1);
                    mem_pct = 0;
                    if (data.appliance_info.members[idx].control.mem_total > 0) {
                        mem_pct = parseInt(data.appliance_info.members[idx].control.mem_used / data.appliance_info.members[idx].control.mem_total * 100, 10);
                    }
                    $(el_mem_usage).text(mem_pct);
                    uptime = CONTROL_DEVICE.convertUptime(data.appliance_info.members[idx].control.uptime);
                    $(el_uptime_usage).text(uptime[0]);
                    $(el_uptime_caption).text(uptime[1]);

                    member = data.appliance_info.members[idx];
                    if (member.control.role === 'master') {
                        CONTROL_DEVICE.memberUrlSn = member.id;
                    }
                }
            }
            CONTROL_DEVICE.getPolicyHistoryData();
        }

        /* Device configuration history */
        if (data.appliance_info.control.enabled === 0 || !data.appliance_info.control.sample_time) {
            $('#div_config_history_cont').hide();
        } else if (data.appliance_info.control.enabled === 1 && view_config_history === 1) {
            if (data.appliance_info.control.role === undefined) {
                $('#div_config_history_cont').show(); //Show config history only when not a cluster member
                CONTROL_DEVICE.getConfigHistoryData();
            }
        }

        /* Device summary data */
        $("#deviceinfo_model").text(data.appliance_info.type_name);
        $("#deviceinfo_sn").text(data.appliance_info.sn);
        $("#deviceinfo_version").text(data.appliance_info.version);
        $("#deviceinfo_ip").text(data.appliance_info.ip_address);

        $("#deviceinfo_active").css('font-weight', 'bold');
        $("#deviceinfo_active").css('color', CONTROL_DEVICE.clrDead);
        var connected = data.appliance_info.control.connected;
        WGRD.enableUIElements(connected, ["#device_actions"]);
        var control_status = 0;
        var active_text = S_CONTROL_STATE_DISCONNECTED;
        if (data.appliance_info.control.enabled === 0 || data.appliance_info.control.sample_time === null) {
            active_text = S_CONTROL_STATE_DISABLED;
            $("#deviceinfo_active").css('color', CONTROL_DEVICE.clrDisabled);
            control_status = -1;
        } else if (data.appliance_info.control.connected === 1) {
            control_status = 1;
            active_text = S_CONTROL_STATE_CONNECTED;
            $("#deviceinfo_active").css('color', CONTROL_DEVICE.clrAlive);
        } else if (data.appliance_info.control.role === 'backup master') {
            control_status = 1;
            active_text = S_CONTROL_STATE_BACKUPMASTER;
            $("#deviceinfo_active").css('color', CONTROL_DEVICE.clrDisabled);
        }
        $("#deviceinfo_active").text(active_text);

        $("#deviceinfo_logging").css('font-weight', 'bold');
        $("#deviceinfo_logging").css('color', CONTROL_DEVICE.clrDead);
        var visibility_status = -1;
        active_text = S_CONTROL_STATE_DISCONNECTED;
        if (data.appliance_info.visibility) {
            if (data.appliance_info.visibility.accept_logs === 0) {
                active_text = S_CONTROL_STATE_DISABLED;
                $("#deviceinfo_logging").css('color', CONTROL_DEVICE.clrDisabled);
                visibility_status = -1;
            } else if (data.appliance_info.visibility.connected === 1) {
                active_text = S_CONTROL_STATE_CONNECTED;
                $("#deviceinfo_logging").css('color', CONTROL_DEVICE.clrAlive);
                visibility_status = 1;
            } else {
                visibility_status = 0;
            }
        } else {
            $("#deviceinfo_logging").css('color', CONTROL_DEVICE.clrDisabled);
            active_text = S_CONTROL_STATE_NA;
        }
        $("#deviceinfo_logging").text(active_text);

        var active_status = control_status && visibility_status;
        if (visibility_status === -1 && control_status === -1) {
            active_status = 2;
        }
        if (data.appliance_info.control.enabled && data.appliance_info.control.connected) {
            var expires = 0,
                expire_date = '',
                feature_key_status = data.appliance_info.control.feature_key_status;

            if (feature_key_status !== null) {
                expires = feature_key_status.left;
                expire_date = feature_key_status.expiration.replace('T', ' ');
                expire_date = expire_date.replace('Z', ' GMT');
                expire_date = $.getDateDisplay(expire_date);
                expire_date = expire_date.substring(0, expire_date.indexOf(' '));
            }

            $(".control_only").show();

            var expire_class,
                expire_text = expire_date;
            if (expires >= 90) {
                expire_class = 'fk';
            } else if (expires > 30 && expires < 90) {
                expire_class = "fk-expire90";
            } else if (expires > 0) {
                expire_class = "fk-expire30";
            } else {
                expire_class = "fk-expired";
            }
            $("#deviceinfo_fk").addClass(expire_class);
            $("#deviceinfo_fk").text(expire_text);
        }
        /* Map data */
        var latitude = data.appliance_info.control.latitude;
        var longitude = data.appliance_info.control.longitude;
        if (latitude === null || latitude === 0 || longitude === null || longitude === 0) {
            if (data.appliance_info.geoip_info !== undefined) {
                latitude = data.appliance_info.geoip_info.latitude;
                longitude = data.appliance_info.geoip_info.longitude;
            } else {
                latitude = null;
                longitude = null;
            }
        }
        var mapdata = {
            'nodes': [],
            'links': []
        };
        if (latitude && longitude) {
            mapdata.nodes = [{ 'status': active_status, 'longlat': [longitude, latitude], 'name': data.appliance_info.name }];
        }
        WGMAP_ORTHOGRAPHIC.initMap("netmap", mapdata, 250, 250, 0.45);
    },

    /* Show the received policy history data in the history table 
     */
    receivedPolicyHistoryData: function (data) {
        if (data.length > 0) {
            $("#policy_history_div").show();
        }

        CONTROL_DEVICE.policy_history = data;

        var total_history = CONTROL_DEVICE.policy_history.length;
        var last_5_history = 0;

        if (total_history >= 5) {
            last_5_history = 5;
        } else {
            last_5_history = total_history;
        }

        CONTROL_DEVICE.loadGridPolicyHistory(last_5_history, total_history);
    },

    /* Show the received config history data in the history table 
     */
    receivedConfigHistoryData: function (data) {
        CONTROL_DEVICE.config_history = data.config_history;

        var total_history = CONTROL_DEVICE.config_history.length;
        var last_5_history = 0;

        if (total_history >= 5) {
            last_5_history = 5;
        } else {
            last_5_history = total_history;
        }

        $("#last_5_history").text(S_CONTROL_CONFIG_REVISIONS_SHOWN.format(last_5_history, total_history));

        CONTROL_DEVICE.loadGridConfigurationHistory(last_5_history);
    },

    refreshHealth: function (eo) {
        CONTROL_DEVICE.toggleSpinner(true);
        WGRD.enableUIElements(false, ['#btn_refresh']);
        var url = 'refresh_health?device_id=' + CONTROL_DEVICE.urlSn;
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            error: function (xhr, status, error) {
                CONTROL_DEVICE.toggleSpinner(false);
                checkLoginPageRedirect(xhr, status, error);
            },
            success: function (data) {
                if (data.status === false) {
                    WGRD.okMessageModal(S_CONTROL_REFRESH_ERROR.format(data.message), '');
                    return;
                }
                setTimeout(CONTROL_DEVICE.getData, 1000);
            },
            complete: function () {
                WGRD.enableUIElements(true, ['#btn_refresh']);
            }
        });
    },

    toggleSpinner: function (b) {
        WGRD.showUIElements(b, ["#detail_loading_spinner"]);
    },
    doResize: function () {
        $(".frontpanelUnitGrid").width(0);
        var fp_div_width = $(".frontpanelUnitGrid").parent().width();
        $(".frontpanelUnitGrid").width(fp_div_width);
        $(".resizableGrid").setGridWidth(fp_div_width - 1);
        CONTROL_DEVICE.resizeGrids();
    },

    resizeGrids: function () {
        $('#grid_config_history').setGridWidth(100, true);
        $('#grid_config_history').setGridWidth($('#div_config_history_cont').width(), true);
        $('#grid_policy_history').setGridWidth(100, true);
        $('#grid_policy_history').setGridWidth($('#policy_history_div').width(), true);
    }
};
$(document).ready(CONTROL_DEVICE.init);
