/*global jstz, checkLoginPageRedirect, _doPost, alert, S_OP_COMPLETE_MSG, S_OK, S_WAITING, S_OP_COMPLETE_TITLE, S_ERROR_TITLE, S_WGRD_SERVER_REBOOT_ERROR_MSG, S_WGRD_SERVER_FAILED_ERROR_MSG, S_ERROR_VAL_RANGE, S_ERROR_VAL_NAN, S_RW_MODE_MSG, S_EDIT_MODE_MSG, S_RO_BTN_TXT, S_RO_MODE_MSG, S_RW_BTN_TXT, S_FORMAT_GB, S_FORMAT_MB, S_FORMAT_KB, S_FORMAT_BYTES,
  S_DAYS_STRING, S_DAY_STRING, S_BYTES_SPAN, S_CHART_MAX_BYTES, S_CHART_MAX_HITS*/

/* Write an array of errors to the error_container div,
 * success - true means write it in a green alert, false in red
 */
function writeErrorContainer(message, success) {
    if (success === undefined || success === null) {
        success = false;
    }

    var error_msg = '<button class="close" onclick="$(\'#error_container\').hide()" type="button">&times;</button>';
    if (typeof message === 'string' || message instanceof String) {
        error_msg += message;
    } else {
        var i;
        // assume array of strings
        for (i = 0; i < message.length; i++) {
            error_msg += message[i];
            if (i !== message.length - 1) {
                error_msg += '<br>';
            }
        }
    }

    if (success) {
        $('#error_container').removeClass('alert-error');
        $('#error_container').addClass('alert-success');
    } else {
        $('#error_container').removeClass('alert-success');
        $('#error_container').addClass('alert-error');
    }

    $('#error_container').html(error_msg);
    $('#error_container').show();
}

/* Checks the response from a put_data call, if there's an error
 * this expects an 'error_container' div to exist and it adds
 * the error messages to that div and shows it.
 */
function checkResponse(response) {
    $('#submit_button').removeAttr('disabled');
    $('#progress_save').hide();

    // if the session expired, we will get redirected to the login page by the server (auth.py check_auth() is a before_handler which will redirect)
    if (checkLoginPageRedirect(response)) {
        // do nothing since checkLoginPageRedirect() already redirected us
        return;
    }
    if (!response.status) { // normal response from put_data()
        if (response.error_code !== undefined) {
            if (response.error_code === 410) {
                var from_page = window.location.pathname + window.location.search;
                window.location.href = '/auth/login?from_page=' + encodeURIComponent(from_page);
            } else {
                writeErrorContainer(response.message, response.status);
            }
        } else if (response.message.length > 0) {
            writeErrorContainer(response.message, response.status);
        } else {
            alert('No error message returned');
        }
    } else {
        writeErrorContainer(response.message, response.status);
    }
}

function checkErrorResponse(response) {
    $('#submit_button').removeAttr('disabled');
    $('#progress_save').hide();

    writeErrorContainer(response.statusText + ": " + response.status, response.status);
}

var WGRD = {
    init : function () {
        WGRD.initEvents();
        WGRD.initMenu();
        var tz = jstz.determine(); // Determines the time zone of the browser client
        WGRD.client_tz = tz.name(); // Returns the name of the time zone eg "Europe/Berlin"
    },

    initEvents: function () {
        $('.webui_logout').click(function (eo) {
            eo.preventDefault();
            WGRD.logout();
        });

        $.ajaxSetup({
            beforeSend: function (xhr, settings) {
                var csrf_token = '';
                if (settings.type === 'POST') {
                    csrf_token = $("#csrf_token").val();
                    xhr.setRequestHeader('X-CSRFToken', csrf_token);
                }
            }
        });
    },

    initMenu : function () {
        if ($('#webui_nav_list').is(':visible')) {
            $('#webui_nav_list .collapse').collapse();
        }
    },

    putData : function (obj) {
        var url = 'put_data';

        var jqxhr = $.ajax({
                type: 'POST',
                url: url,
                data: JSON.stringify(obj),
                success: checkResponse,
                error: checkErrorResponse,
                contentType: 'application/json'
            });
        return jqxhr;
    },

    logout : function () {
        var csrf_token = $("#csrf_token").val();
        var form = document.createElement("form");
        form.setAttribute("method", "post");
        form.setAttribute("action", "/auth/logout");

        var field;
        field = document.createElement("input");
        field.setAttribute("type", "hidden");
        field.setAttribute("name", "csrf_token");
        field.setAttribute("value", csrf_token);
        form.appendChild(field);

        document.body.appendChild(form);
        form.submit();
    },

    /*
     * Callback handler to trigger a release of page lock 
     * when user closes his browser.
    */
    pgUnloadCallBack : function (pg_tracker, lock_page) {
        window.onbeforeunload = function (e) {
            WGRD.triggerLockRelease(pg_tracker, lock_page);
        };
    },

    /*
     * Helper function to remove the page from the browser's 
     * session storage if val is 0.
    */
    updatePgInBrowserSession : function (val, page) {
        if (val === 0) {
            window.sessionStorage.removeItem(page);
        }
    },

    /*
     * Release the lock on a page that is currently in edit mode.
    */
    triggerLockRelease : function (pg_tracker, lock_page) {
        var cur_locked_pg = window.sessionStorage.getItem('cur_locked_pg');
        // if cur_locked_pg is present and is same as the lock_page,
        // then also release the lock. (This addresses the case when user refreshes the current unlocked page)
        if ((pg_tracker && pg_tracker !== undefined) || (cur_locked_pg && cur_locked_pg === lock_page)) {
            var page_info = {'page': lock_page};
            WGRD.updatePgInBrowserSession(0, lock_page);
            WGRD.releasePgLock(page_info);
        }
    },

    /*
      If is_page_locked is 1 [this comes from the backend] page should be in edit mode
      else if either pg_tracker is not defined or is empty [this primarily is to check for the same session but
      different browser tabs or windows]
      return True to indicate viewMode [gray out UI and other view mode settings]
    */
    userInViewMode : function (is_page_locked, pg_tracker) {
        var roMode = true;
        if (is_page_locked === 1) {
            roMode = false;
        } else {
            roMode = (pg_tracker === undefined || !pg_tracker);
        }
        return roMode;
    },

    /* This method basically updates the user mode banner, on the top of the page
     * If a page does not have any changes that need to be saved, that page will not show the banner
     * If a page has changes that can be saved, it will show banner having :
     *     Read only view:
     *        1. Show lock icon and appropriate text
     *
     *     Read write view:
     *        1. Show unlock icon and appropriate text
     */
    updateModeUI : function (view_mode) {
        $('#user_mode_div').show();
        if (!view_mode) { // Edit Mode
            $('#user_mode_btn').attr('src', '/images/unlock_32.png');
            $('#lock_msg').text(S_EDIT_MODE_MSG);
        } else {
            $('#user_mode_btn').attr('src', '/images/lock_32.png');
            $('#lock_msg').text(S_RO_MODE_MSG);
        }
    },

    releasePgLock : function (page_obj) {
        $.ajax({
            type: 'POST',
            url: '/usersandroles/release_page_lock',
            data: JSON.stringify(page_obj),
            async: false,
            contentType: 'application/json'
        });
    },

    /* This method resets the lock on a page
     */
    resetUserMode : function (page_obj) {
        // handle case where there is no page_obj
        if (!page_obj) {
            page_obj = '';
        }

        $('#user_mode_loading').show();
        $('#user_mode_btn').attr('disabled', true);
        $.ajax({
            type: 'POST',
            url: '/usersandroles/reset_page_lock',
            success: WGRD.redirectUserResponse,
            data: JSON.stringify(page_obj),
            error: checkErrorResponse,
            contentType: 'application/json'
        });
    },

    redirectUserResponse : function (lock_state) {
        var url = window.location.pathname;
        if (lock_state === 'edit') {
            url += '?mode=' + lock_state;
        }
        window.location.href = url;
    },

    /* For the passed in page_obj check if
     * the current user can have read-write rights
     * or if some other user has the lock
     */
    checkUserMode : function (page_obj) {
        $('#user_mode_loading').show();
        $('#user_mode_btn').attr('disabled', true);
        if (page_obj) {
            var jqxhr = $.ajax({
                    type: 'POST',
                    url: '/usersandroles/check_user_mode',
                    data: JSON.stringify(page_obj),
                    error: checkErrorResponse,
                    contentType: 'application/json'
                });
            return jqxhr;
        }
    },

    handleUserModeResponse : function (response, $save_btn_id) {
        $('#user_mode_loading').hide();
        $('#user_mode_msg strong').show()
                                  .text("");
        if (response.status) {
            $('#lock_msg').text(S_RW_MODE_MSG);
            $('#user_mode_loading').show();

            //Redirect user to the current page after 2 secs
            setTimeout(function () {
                WGRD.redirectUserResponse('edit');
            }, 2000);
        } else {
            $('#lock_msg').hide();
            $($save_btn_id).hide();
            $('#user_mode_msg strong').html(response.message)
                                      .delay(3000)
                                      .fadeOut(function () { $('#lock_msg').show(); });
            setTimeout(function () {
                $('#user_mode_btn').attr('disabled', false);
            }, 3000);
        }
    }
};
$(document).ready(WGRD.init);

function defaultErrorHandling(response) {
    if (response.error_code !== undefined) {
        if (response.error_code === 410) {
            var from_page = window.location.pathname + window.location.search;
            window.location.href = '/auth/login?from_page=' + encodeURIComponent(from_page);
        } else {
            writeErrorContainer(response.message, false);
        }
    } else if (response.message.length > 0) {
        var error_msg = '<button class="close" onclick="$(\'#error_container\').hide()" type="button">&times;</button>';
        var i;
        for (i = 0; i < response.message.length; i++) {
            error_msg += response.message[i] + '<br>';
        }
        //error_msg += '</ul>';
        $('#error_container').html(error_msg);
        $('#error_container').show();
    } else {
        alert('No error message returned');
    }
}

// Create a multiselect datagrid in a div using colNames and colModel
function createGrid(colNames, colModel, div) {
    $(div).jqGrid({
        datatype: "local",
        colNames: colNames,
        colModel: colModel,
        autoencode: true,
        height: 'auto',
        autowidth: true,
        shrinkToFit: true,
        multiselect: true,
        multiselectWidth: 30 //for IE
    });
}
// Create a single select datagrid in a div using colNames and colModel
function createSingleGrid(colNames, colModel, div) {
    $(div).jqGrid({
        datatype: "local",
        colNames: colNames,
        colModel: colModel,
        autoencode: true,
        height: 'auto',
        autowidth: true,
        shrinkToFit: true
    });
}

// Create a single select datagrid in a div using colNames and colModel
// optParams are additional jqGrid parameters (optional)
function createRsSingleGrid(colNames, colModel, div, optParams) {

    var base_params = {
            datatype: "local",
            colNames: colNames,
            colModel: colModel,
            autoencode: true,
            height: 'auto',
            autowidth: true,
            shrinkToFit: true
        };

    var params = {};
    if (optParams === undefined) {
        params = base_params;
    } else {
        $.extend(params, base_params, optParams);
    }

    $(div).jqGrid(params);
}

// Create a multiselect datagrid in a div using colNames and colModel
// optParams are additional jqGrid parameters (optional)
function createRsGrid(colNames, colModel, div, optParams) {

    var base_params = {
        multiselect: false,
        multiselectWidth: 30
    };

    var params = {};
    if (optParams === undefined) {
        params = base_params;
    } else {
        $.extend(params, base_params, optParams);
    }

    createRsSingleGrid(colNames, colModel, div, params);
}

// Determines if a checkbox is checked and returns 0/1
function isChecked(divName) {
    if ($(divName).is(':checked')) {
        return 1;
    }
    return 0;
}

function getRadioVal(name) {
    return $("input[name='" + name + "']:checked").val();
}
/*
 *  Toggles inputs and selects for children of 'div_id' based
 *  on the value of 'checkbox'
 */
WGRD.toggleUI = function (checkbox, div_id) {
    if ($(checkbox).is(':checked')) {
        $(div_id + ' input').removeAttr('disabled');
        $(div_id + ' select').removeAttr('disabled');
    } else {
        $(div_id + ' input').attr('disabled', true);
        $(div_id + ' select').attr('disabled', true);
    }
};

/*
 * Enables/Disables the children of 'div_id' or 'class' based on
 * the value of 'enable'
 */
WGRD.enableUI = function (enable, div_id) {
    if (enable) {
        $(div_id + ' input').removeAttr('disabled');
        $(div_id + ' select').removeAttr('disabled');
        $(div_id + ' button').removeAttr('disabled');
    } else {
        $(div_id + ' input').attr('disabled', true);
        $(div_id + ' select').attr('disabled', true);
        $(div_id + ' button').attr('disabled', true);
    }
};

/*
 * Enables/Disables elements based on
 * the value of 'enable'
 */
WGRD.enableUIElements = function (enable, elems) {
    $.each(elems, function (index, value) {
        if (enable) {
            $(value).removeAttr('disabled');
            $(value).removeClass('disabled');
        } else {
            $(value).attr('disabled', true);
            $(value).addClass('disabled');
        }
    });
};

/*
 * Return the state of the passed in element
 * If the element has 'disabled' class then return false 
 * otherwise return true
 */
WGRD.isEnabled = function (elem) {
    return !$(elem).hasClass('disabled');
};

/*
 * Shows/hides elements based on
 * the value of 'enable'
 */
WGRD.showUIElements = function (enable, elems) {
    $.each(elems, function (index, value) {
        if (enable) {
            $(value).show();
        } else {
            $(value).hide();
        }
    });
};

//Clear the values for all the passed in elements
WGRD.clearAllVals = function (elems) {
    $.each(elems, function (index, value) {
        $(value).val('');
    });
};

// Verify a value is a valid number
WGRD.isNumber = function (n) {
    return !isNaN(parseFloat(n)) && isFinite(n);
};

// $spn is an input element that is initialized with spinner().
// this function makes sure the return value will not be out of bound.
//
// $spn:   $('xxx')
//
WGRD.getSpinnerVal = function ($spn) {
    var ret = null;

    if ($spn) {
        ret = $spn.spinner("value");
        var max = $spn.spinner("option", "max");
        var min = $spn.spinner("option", "min");
        if ((max !== null) && (ret > max)) {
            ret = max;
        }

        if ((min !== null) && (ret < min)) {
            ret = min;
        }
    }

    return ret;
};

// support string formatting like "This is a {0} test {1}!".format("freakin", ", buddy");
String.prototype.format = function () {
    var s = this, i = arguments.length;

    while (i--) {
        s = s.replace(new RegExp('\\{' + i + '\\}', 'gm'), arguments[i]);
    }
    return s;
};

// checks the given element's value against its 'min' and 'max' attributes
// returns an error string if the element's value is not an integer or is out of the min-max range
// returns an empty string otherwise
WGRD.isValidNumeric = function ($spn, fld_name) {
    var new_val = parseInt($spn.val(), 10);
    var min = parseInt($spn.attr("min"), 10);  // will be NaN if not defined
    var max = parseInt($spn.attr("max"), 10);  // will be NaN if not defined

    if (!isFinite(new_val) || $spn.val() !== new_val.toString()) {
        return S_ERROR_VAL_NAN.format(fld_name);
    }
    if (new_val < min || new_val > max) {
        return S_ERROR_VAL_RANGE.format(fld_name, min, max);
    }
    return "";
};

// $spn is an input element that is initialized with spinner() first before
// calling this.
//
// $spn:   $('xxx')
//
WGRD.setSpinnerMinMaxStep = function ($spn, min, max, step) {
    if ($spn) {
        $spn.spinner("option", "min", min);
        $spn.spinner("option", "max", max);
        $spn.spinner("option", "step", step);
    }
};

/**
 * Only allow numeric typing.
 *
 * $spn:   $('xxx')
 */
WGRD.numericSpinner = function ($spn) {
    $spn.bind('keypress', function (event) {
        var regex = new RegExp("^[0-9]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
        }
    });
};


/**
 *  Setup a wizard with pages div, back, next, and finished buttons
 *
 *  wizDiv:         string '#xxx' of the div id.
 *                  NOTE: the following tags must have the following classes
 *                      pages for the wizard - "wgrd-wizard-page"
 *                      back button for the wizard - "wgrd-wizard-back"
 *                      next button for the wizard - "wgrd-wizard-next"
 *                      finish button for the wizard - "wgrd-wizard-finish"
 *
 *  pages:          array of dictionaries of the following:
 *                      page_id:'#wiz_page2' //div id for wizard page
 *                      initPage: function  //function callback when page is shown (on next/back button)
 *                                          //and returns true if last page
 *                      validate: function //function callback when page is going to the next page and
 *                                         //   returns the next page div id if success or returns null if failed.
 *                                         //Note: this is not used on the page with "button.wgrd-wizard-finish" button
 *
 *                      save: function //function callback with the function parameter of a nextPage callback
 *                                     //   if save function is successful call nextPage callback
 *                                     //Note: This is optional, if null the nextPage call will be called in it's place.
 *                                     //   This is NOT optional for the page with the "button.wgrd-wizard-finish" button.
 *                                     //   There is no nextPage callback for this save call.
 *
 */
WGRD.doWizard = function (wizDiv, pages) {
    var wiz = $(wizDiv);
    var backBtn = $(wizDiv + ' button.wgrd-wizard-back');
    var nextBtn = $(wizDiv + ' button.wgrd-wizard-next');
    var finishBtn = $(wizDiv + ' button.wgrd-wizard-finish');

    var pageStack = [];
    var topPage = pages[0];

    $(wizDiv + ' .wgrd-wizard-page').hide();
    backBtn.hide();
    nextBtn.hide();
    finishBtn.hide();

    //show first page
    $('#error_container').hide();
    var isLastPage = topPage.initPage();
    if (isLastPage) {
        finishBtn.show();
    } else {
        nextBtn.show();
    }
    $(topPage.page_id).show();
    wiz.show();


    backBtn.unbind('click').click(function () {
        $('#error_container').hide();
        $(topPage.page_id).hide();

        //Pop for new topPage
        topPage = pageStack.pop();
        $(wizDiv + ' .wgrd-wizard-page').hide();
        if (pageStack.length > 0) {
            backBtn.show();
        } else {
            backBtn.hide();
        }
        nextBtn.show();
        finishBtn.hide();

        //init and show topPage
        $(topPage.page_id).show();
        topPage.initPage();
    });

    nextBtn.unbind('click').click(function () {
        $('#error_container').hide();
        var page_id = topPage.validate();
        if (page_id) {
            var nextPage = function () {
                $(topPage.page_id).hide();
                backBtn.show();

                //push topPage to stack
                pageStack.push(topPage);

                //get new topPage with page_id here
                var i;
                for (i = 0; i < pages.length; i++) {
                    if (pages[i].page_id === page_id) {
                        topPage = pages[i];
                    }
                }
                // Call show before initPage can resize can be done properly
                $(topPage.page_id).show();

                //init and show topPage
                isLastPage = topPage.initPage();
                if (isLastPage) {
                    nextBtn.hide();
                    finishBtn.show();
                } else {
                    nextBtn.show();
                    finishBtn.hide();
                }
            };

            if (topPage.save) {
                topPage.save(nextPage);
            } else {
                nextPage();
            }
        }
    });

    finishBtn.unbind('click').click(function () {
        $('#error_container').hide();
        topPage.save(null);
    });
};

/**
 *  Setup a modal dialog with the basic error div, save, and close buttons
 *
 *  dlgDiv:         string '#xxx' of the div id.
 *                  NOTE: the following tags must have the following class
 *                      error message div for the dialog - "wgrd-modal-error"
 *                      close button for the dialog - "wgrd-modal-close"
 *                      save button for the dialog - "wgrd-modal-save"
 *
 *  initCtrls:      function() this function will be called by the dialog
 *                  to initialize the controls for the dialog.
 *                  Return: true to show dialog. false to not show dialog.
 *
 *  validateAndSave:    function() this function will be called to
 *                  validate and save the contents of the dialog.
 *                  Return: error string if there is an error that will be
 *                  put in the alert div at the top the dialog. empty string if
 *                  there is no error.
 *
 *  params:         Optional parameters that can be passed to initCtrls and
 *                  validateAndSave functions.
 *
 *  cancelHandler:  this is an optional function() which will be called when
 *                  the Close or x button is clicked.
 *
 *  stayOpenOnSave: true means the dialog is not automatically hidden when the
 *                  "save" button is clicked
 *
 *  callerHandlesEscKey: true means the dialog is not automatically hidden when the
 *                  escape key is pressed. The caller takes handles the closing of the dialog
 * 
 *  backdrop: custom backdrop settings, true - show, false - hide, 'static' - show but don't allow clickaway
 */
WGRD.doModal = function (dlgDiv, initCtrls, validateAndSave, params, cancelHandler, stayOpenOnSave, callerHandlesEscKey, backdrop) {
    var dlg = $(dlgDiv);
    var errorDiv = $(dlgDiv + ' div.wgrd-modal-error');
    var closeBtn = $(dlgDiv + ' button.wgrd-modal-close');
    var saveBtn = $(dlgDiv + ' button.wgrd-modal-save');
    var xBtn = $(dlgDiv + ' button.wgrd-modal-close-x'); // for x button for closing the modal

    errorDiv.hide();
    if (closeBtn) {
        closeBtn.unbind('click').click(function () {
            if (cancelHandler) {
                cancelHandler();
            }

            dlg.modal("hide");
        });
    }

    if (xBtn) {
        xBtn.unbind('click').click(function () {
            if (cancelHandler) {
                cancelHandler();
            }

            dlg.modal("hide");
        });
    }

    if (saveBtn) {
        saveBtn.unbind('click').click(function () {
            errorDiv.hide();
            var errorMsg = validateAndSave(params);

            if (errorMsg) {
                errorDiv.show();
                errorDiv.html(errorMsg);
                return;
            }

            if (!stayOpenOnSave) {
                dlg.modal("hide");
            }
        });
    }


    if (!initCtrls(params)) {
        return;
    }

    var enable_keyboard = true;
    var show_backdrop = true;
    if (backdrop !== undefined) {
        show_backdrop = backdrop;
    }

    if (callerHandlesEscKey) {
        enable_keyboard = false;
    }

    dlg.modal({
        keyboard: enable_keyboard,
        backdrop: show_backdrop
    });

};


/**
 *  Setup a simple confim modal dialog with the basic save, and close buttons
 *
 *  message_html:   string that contains the html that will be displayed in the confirm dialog
 *
 *  bYesNo:         if true use yes/no buttons, false use ok/cancel
 *
 *  onConfirm:      function() this function will be called if the use clicks 'OK'
 *
 * stayOpenOnConfirm: will not close the dialog when the 'yes' button is clicked if this true
 *
 * defaultCancelNo:   if true, will make the No/Cancel button the default button; o.w., the Ok/Yes button is the default
 *
 * params:   If specified, onConfirm will be called with these params.
 *
 * onCancel:           callback when the user clicks No or Cancel; can be null/undefined
 */
WGRD.confirmModal = function (messsage_html, bYesNo, onConfirm, stayOpenOnConfirm, defaultCancelNo, params, onCancel) {
    var dlgDiv = '#confirmBoxDiv';
    var dlg = $(dlgDiv);
    var modalbody = $(dlgDiv + ' div.modal-body');
    var cancelBtn = $(dlgDiv + ' button.wgrd-modal-cancel');
    var closeBtn = $(dlgDiv + ' .close');
    var noBtn = $(dlgDiv + ' button.wgrd-modal-no');
    var okBtn = $(dlgDiv + ' button.wgrd-modal-ok');
    var yesBtn = $(dlgDiv + ' button.wgrd-modal-yes');
    var progress = $(dlgDiv + ' div.wgrd-modal-progress');

    var confirmFunc = function () {
        if (!stayOpenOnConfirm) {
            dlg.modal("hide");
        } else {
            progress.show();
            WGRD.enableUIElements(false, [cancelBtn.selector, noBtn.selector, okBtn.selector, yesBtn.selector]);
        }
        if (params === undefined) {
            onConfirm();
        } else {
            onConfirm(params);
        }
    };

    var cancelFunc = function () {
        dlg.modal("hide");
        if (onCancel) {
            onCancel();
        }
    };

    yesBtn.hide().unbind('click');
    noBtn.hide().unbind('click');
    okBtn.hide().unbind('click');
    cancelBtn.hide().unbind('click');
    closeBtn.hide().unbind('click');
    WGRD.enableUIElements(true, [cancelBtn.selector, noBtn.selector, okBtn.selector, yesBtn.selector]);
    progress.hide();

    if (bYesNo) {
        yesBtn.show().click(confirmFunc);
        noBtn.show().click(cancelFunc);
    } else {
        okBtn.show().click(confirmFunc);
        cancelBtn.show().click(cancelFunc);
    }
    closeBtn.show().click(cancelFunc);

    if (defaultCancelNo) {
        yesBtn.removeClass('btn-primary');
        okBtn.removeClass('btn-primary');
        noBtn.addClass('btn-primary');
        cancelBtn.addClass('btn-primary');
    } else {
        yesBtn.addClass('btn-primary');
        okBtn.addClass('btn-primary');
        noBtn.removeClass('btn-primary');
        cancelBtn.removeClass('btn-primary');
    }

    modalbody.html(messsage_html);

    dlg.modal({
        keyboard: true,
        backdrop: true
    });

};

/**
 * Set the title for the WGRD confirm modal.
 */
WGRD.setConfirmModalTitle = function (title) {
    $('#confirmBoxDiv h3').text(title);
};

/**
 *  Setup a simple message dialog with Ok button
 *
 *  message_html:   string that contains the html that will be displayed in the message dialog
 *  title:          string that will be used as the dialog's title
 *  onClose:        callback when the dialog is hidden; can be null/undefined
 *
 */
WGRD.okMessageModal = function (messsage_html, title, onClose) {
    var dlgDiv = '#confirmBoxDiv';  // see also WGRD._isOkMessageDialog()
    var dlg = $(dlgDiv);
    var modalbody = $(dlgDiv + ' div.modal-body');
    var modalheaderTitle = $(dlgDiv + ' div.modal-header h3');
    var cancelBtn = $(dlgDiv + ' button.wgrd-modal-cancel');
    var noBtn = $(dlgDiv + ' button.wgrd-modal-no');
    var okBtn = $(dlgDiv + ' button.wgrd-modal-ok');
    var yesBtn = $(dlgDiv + ' button.wgrd-modal-yes');
    var progress = $(dlgDiv + ' div.wgrd-modal-progress');

    var cancelFunc = function () {
        dlg.modal("hide");
    };

    dlg.unbind('hidden');
    if (onClose) {
        dlg.on('hidden', function () {
            onClose();
        });
    }

    yesBtn.hide().unbind('click');
    noBtn.hide().unbind('click');
    okBtn.hide().unbind('click');
    cancelBtn.hide().unbind('click');

    okBtn.show().click(cancelFunc);

    WGRD.enableUIElements(true, [cancelBtn.selector, noBtn.selector, okBtn.selector, yesBtn.selector]);
    progress.hide();

    yesBtn.addClass('btn-primary');
    okBtn.addClass('btn-primary');
    noBtn.removeClass('btn-primary');
    cancelBtn.removeClass('btn-primary');

    modalheaderTitle.text(title);
    modalbody.html(messsage_html);

    dlg.modal({
        keyboard: true,
        backdrop: true
    });

    return dlg;
};

/**
 *  Returns the 'OK' button for the okMessage modal dialog.
 */
WGRD.okMessageModalBtn = function () {
    var dlgDiv = '#confirmBoxDiv';  // see also WGRD._isOkMessageDialog()
    return $(dlgDiv + ' button.wgrd-modal-ok');
};

// returns true if the given object is the OkMessageDialog
WGRD._isOkMessageDialog = function (dlg) {
    return (dlg && dlg.selector === '#confirmBoxDiv');
};

/**
 * Closes/hides the confirmation/ok #confirmBoxDiv dialog.
 */
WGRD.closeModal = function () {
    var dlgDiv = '#confirmBoxDiv';
    $(dlgDiv).modal("hide");
};

/**
 *  Setup a simple message dialog to show the exporting progress 
 *
 *  title:   string that will be used as the dialog's title
 *  message: string that will be used as the dialog's content
 *
 */
WGRD.progressModal = function (title, messsage) {
    var dlgDiv = '#export_processing';
    var dlg = $(dlgDiv);
    var modalheaderTitle = $(dlgDiv + ' div.modal-header');
    var modalbody = $(dlgDiv + ' div.modal-body span');
    modalheaderTitle.text(title);
    modalbody.text(messsage);

    dlg.modal({
        keyboard: true,
        backdrop: 'static'
    });

    return dlg;
};

/**
 * Closes/hides the exporting progress dialog.
 */
WGRD.progressModalClose = function () {
    var dlgDiv = '#export_processing';
    $(dlgDiv).modal("hide");
};

/**
 * Monitors the webserver and waits for it to go down and then back up. When it comes up, it redirects to the new page.
 * The parameters are optional.
 *
 * dlg -     a dialog that should be closed when this action is done; can be undefined/null
 * url -     the url to redirect to; uses /auth/login if null/undefined
 * timeout - time in millis to wait for reboot before a timeout error; uses 10 minutes if null/undefined
 */
WGRD.redirectAfterRestart = function (dlg, url, timeout) {
    return WGRD.redirectAfterRestartOrTask(dlg, url, null, timeout);
};

/**
 * Monitors the webserver and waits for it to go down and then back up or to waits for the given server system task to complete.
 * When it comes up or the task completes, it redirects to the new page. If the task fails, an error is shown.
 * This asynchronously calls waitForServerRestartOrTask() with the given timeout and auto-redirects to the given URL when done.
 * The parameters are optional.
 *
 * dlg -     a dialog that should be closed when this action is done; can be undefined/null
 * url -     the url to redirect to; uses /auth/login if null/undefined
 * task -    the filename of the system task to monitor; can be undefined/null
 * timeout - time in millis to wait for reboot before a timeout error; uses 10 minutes if null/undefined
 */
WGRD.redirectAfterRestartOrTask = function (dlg, url, task, timeout) {
    // default values for the parameters
    var from_page = window.location.pathname + window.location.search;
    var _url = '/auth/login?from_page=' + encodeURIComponent(from_page);  // login page by default
    var _timeout = 1000 * 60 * 10;  // 10 mins by default

    // use passed in params, if any
    if (url) {
        _url = url;
    }
    if (timeout) {
        _timeout = timeout;
    }
    var okBtn;
    // function that calls WGRD.waitForServerRestartOrTask()
    var rebootFunc = function () {
        // change the "OK" button to "Waiting..."
        if (WGRD._isOkMessageDialog(dlg)) {
            okBtn = $(dlg.selector + ' button.wgrd-modal-ok');
            okBtn.html(S_WAITING);
            WGRD.enableUIElements(false, [okBtn.selector]);
        }

        // start polling for server availablilty
        WGRD.waitForServerRestartOrTask.apply(
            null,
            [
                function (status, msgStr) { // onDone
                    // restore in the ok message dialog
                    if (WGRD._isOkMessageDialog(dlg)) {
                        okBtn = $(dlg.selector + ' button.wgrd-modal-ok');
                        okBtn.html(S_OK);
                        WGRD.enableUIElements(true, [okBtn.selector]);
                    }

                    if (status) {
                        // get the error message
                        var msg = '';
                        if (msgStr) {
                            msg = S_WGRD_SERVER_FAILED_ERROR_MSG.format(msgStr);
                        } else {
                            msg = S_WGRD_SERVER_REBOOT_ERROR_MSG.format(status);
                        }

                        // show error message
                        WGRD.okMessageModal(msg, S_ERROR_TITLE, function () {
                            // redirect when they close the window
                            window.location.href = _url;
                        });
                    } else {
                        // show success message, if there is one
                        if (msgStr) {
                            WGRD.okMessageModal(msgStr, S_OP_COMPLETE_TITLE, function () {
                                // redirect when they close the window
                                window.location.href = _url;
                            });
                        } else {
                            // success, redirect now
                            window.location.href = _url;
                        }
                    }
                },
                task, // task filename
                _timeout  // timeout
            ]
        );
    };

    // start the polling and return
    setTimeout(rebootFunc, 100);
};

/**
 * See WGRD.redirectAfterRestart() to redirect after restart/reboot.
 * See WGRD.redirectAfterRestartOrTask() to redirect after task completion.
 *
 * Monitors a server reboot or task status and call the onDone function when done.
 *
 * onDone:  function called when done; single integer parameter
 * task:    task filename to check status on; will wait for reboot if null/undefined
 * timeout: time in millis to wait for the server to come up before giving up
 *
 * The onDone function will be called with (int statusCode, string msgStr).
 * Possible statusCode values:
 *    0 - success, msgStr may be set
 *    1 - server did not come up within the timeout period
 *    2 - server did not go down within the timeout period
 *    3 - error, and msgStr will be set
 */
WGRD.waitForServerRestartOrTask = function (onDone, task, timeout) {
    var startTime = (new Date()).getTime();

    // wait for the server to come up
    var upPoll = function () {
        var currTime = (new Date()).getTime();
        if (startTime + timeout < currTime) {
            onDone(1);
            return;
        }

        var serverUp = WGRD.isServerOnline();
        if (serverUp) {
            onDone(0);
        } else {
            setTimeout(upPoll, 5000);
        }
    };

    // wait for the server to go down
    var downPoll = function () {
        var currTime = (new Date()).getTime();
        if (startTime + timeout < currTime) {
            onDone(2);
            return;
        }

        var serverUp = WGRD.isServerOnline();
        if (serverUp) {
            // server is up
            if (task) {
                // check if the task is still running
                var ret = WGRD.checkSystemTaskStatus(task);
                if (!ret) {
                    // error, assume server is down
                    setTimeout(upPoll, 500);
                    return;
                }
                if (ret.state === 'complete') {
                    // task is done
                    onDone(0, S_OP_COMPLETE_MSG);
                    return;
                }
                if (ret.state === 'failed') {
                    // task failed
                    onDone(3, ret['failure-reason']);
                    return;
                }
            }
            // server is up and either no task or task is still running, so poll again
            setTimeout(downPoll, 500);
        } else {
            // server is down
            setTimeout(upPoll, 500);
        }
    };

    // start the polling
    setTimeout(downPoll, 100);
};

// check if the webserver is up by trying to access the login page, synchronously
// returns true or false
WGRD.isServerOnline = function () {
    try {
        var uri = '/auth/login';
        var xhr = new XMLHttpRequest();
        xhr.open("GET", uri, false);
        xhr.send(null);
        return xhr.status === 200;
    } catch (e) {
        return false;
    }
};

// get the system task status for the given task filename
// returns the task-status dict {state, percent-complete, failure-reason} or null on error
WGRD.checkSystemTaskStatus = function (task) {
    var ret = null;
    $.ajax({
        url: '/system/get_task_status',
        data: {'task': task},
        dataType: 'json',
        async: false,
        success: function (response) {
            ret = response;
        }
    });

    return ret;
};


// convert an AM/PM time string to military time format
function converToTimeStr24(time_str) {
    var d = new Date(new Date().toDateString() + " " + time_str);
    var time_str24 = "";

    if (d.getHours() < 10) {
        time_str24 += "0";
    }
    time_str24 += d.getHours() + ":";
    if (d.getMinutes() < 10) {
        time_str24 += "0";
    }
    time_str24 += d.getMinutes() + ":";
    if (d.getSeconds() < 10) {
        time_str24 += "0";
    }
    time_str24 += d.getSeconds();

    return time_str24;
}

// convert hh:mm time string from UTC to local time string
function utcTimeStrToLocalStr(time_str, wants_secs) {
    var date = utcTimeStrToLocalStr(time_str, wants_secs);

    if (wants_secs) {
        return date.getHours() + ':' + date.getMinutes() + ":" + date.getSeconds();
    }
    return date.getHours() + ':' + date.getMinutes();
}

// converts a hh:mm:ss utc time string to a Date object
function utcTimeStrToDate(time_str, wants_secs) {
    var date = new Date();
    var time_split = time_str.split(':');
    date.setUTCHours(parseInt(time_split[0], 10));
    date.setUTCMinutes(parseInt(time_split[1], 10));
    if (time_split.length > 2) {
        date.setUTCSeconds(time_split[2]);
    }

    return date;
}

// takes a date object and returns a string in hh:mm:ss format
function dateToUTCTimeStr(date, wants_secs) {
    var time_str = "";
    if (date.getUTCHours() < 10) {
        time_str += "0";
    }
    time_str += date.getUTCHours() + ":";
    if (date.getUTCMinutes() < 10) {
        time_str += "0";
    }
    time_str += date.getUTCMinutes();

    if (wants_secs) {
        time_str += ":";
        if (date.getUTCSeconds() < 10) {
            time_str += "0";
        }
        time_str += date.getUTCSeconds();
    }

    return time_str;
}

// returns the date object set the time at midnight.
// offset: 0: yesterday; 1: today; ...
function createDateAtMidnight(offset) {
    if (offset === undefined) {
        offset = 0;
    }
    var d = new Date((new Date()).getTime() + offset * 24 * 60 * 60 * 1000);
    d.setHours(0, 0, 0, 0);
    return d;
}

// date_str format is: 2013-02-28 00:45:54
function createDateFromStr(date_time_str) {
    var date_time_split = date_time_str.split(' ');
    var date_str = date_time_split[0];
    var date_split = date_str.split('-');
    var time_str = date_time_split[1];
    var time_split = time_str.split(':');

    var date = new Date();
    date.setUTCFullYear(parseInt(date_split[0], 10));
    date.setUTCMonth(parseInt(date_split[1], 10) - 1);
    date.setUTCDate(parseInt(date_split[2], 10));
    date.setUTCHours(parseInt(time_split[0], 10));
    date.setUTCMinutes(parseInt(time_split[1], 10));
    date.setUTCSeconds(parseInt(time_split[2], 10));

    return date;
}

// returns the date/time string representation in UTC 'yyyy-mm-dd hh:mm'
function getDateTimeStrUTC(date) {
    var str = date.toISOString();
    str = str.replace('T', ' ');
    str = str.substring(0, str.lastIndexOf(':'));
    return str;
}

// encodes special html characters: (&amp; '&', &gt; '>', &lt; '<')
// Only works in a plain html parsing context.
function escapeHtml(htmlStr) {
    htmlStr = htmlStr.replace(/\&/g, '&amp;');
    htmlStr = htmlStr.replace(/>/g, '&gt;');
    htmlStr = htmlStr.replace(/</g, '&lt;');
    return htmlStr;
}

// decodes special html characters: (&amp; '&', &gt; '>', &lt; '<')
function unescapeHtml(htmlStr) {
    htmlStr = htmlStr.replace(/\&gt;/g, '>');
    htmlStr = htmlStr.replace(/\&lt;/g, '<');
    htmlStr = htmlStr.replace(/\&amp;/g, '&');
    return htmlStr;
}

// Checks if a character is an ascii alphanumeric.
function isAlphaNumeric(str) {
    var regExp = /^[A-Za-z0-9]+$/;
    return (str.match(regExp));
}

// Escapes an HTML string in such a way that it can be safely used in any HTML context.
function escapeHtml2(str) {
    var escaped_str_array = [];
    var i;
    var character, char_code, escaped_character;
    for (i = 0; i < str.length; i++) {
        character = str[i];
        if (isAlphaNumeric(character)) {
            escaped_str_array.push(character);
        } else {
            char_code = character.charCodeAt(0);
            escaped_character = "&#x" + char_code.toString(16) + ";";
            escaped_str_array.push(escaped_character);
        }
    }
    return escaped_str_array.join("");
}

// XTM version: 11.8.429494, 11.9.7.B475559, 11.10.1.B474758, etc.
// Return: 1 --( v1 > v2) , -1 -- (v1 < v2) or 0 -- (v1 == v2)
function compareVersion(v1, v2) {
    if (v1 === v2) {
        return 0;
    }
    var fields1 = v1.split('.');
    var fields2 = v2.split('.');
    var sub1, sub2;
    var i, len = Math.min(fields1.length, fields2.length);
    // First compare sub version number
    for (i = 0; i < len - 1; i++) {
        sub1 = parseInt(fields1[i], 10);
        sub2 = parseInt(fields2[i], 10);
        if (sub1 !== sub2) {
            return sub1 > sub2 ? 1 : -1;
        }
    }
    // 11.8.1.xxxxxx > 11.8.xxxxxx
    if (fields1.length !== fields2.length) {
        return fields1.length > fields2.length ? 1 : -1;
    }
    // Need to compare build number
    var num1 = parseInt(fields1[fields1.length - 1].replace(/[^0-9]/g, ''), 10);
    var num2 = parseInt(fields2[fields2.length - 1].replace(/[^0-9]/g, ''), 10);
    if (num1 !== num2) {
        return num1 > num2 ? 1 : -1;
    }
    return 0;
}

//format the data for the chart 
WGRD.bwFormatterChart = function (format, bytes) {
    return $.formatBytes(bytes, S_FORMAT_GB, S_FORMAT_MB, S_FORMAT_KB, S_FORMAT_BYTES);
};

//format data for the grid
WGRD.bwFormatterGrid = function (bytes) {
    return $.formatBytes(bytes, S_FORMAT_GB, S_FORMAT_MB, S_FORMAT_KB, S_FORMAT_BYTES);
};

//format data for the span
WGRD.bwFormatterSpan = function (bytes) {
    return $.formatBytes(bytes, S_BYTES_SPAN.format(S_FORMAT_GB), S_BYTES_SPAN.format(S_FORMAT_MB), S_BYTES_SPAN.format(S_FORMAT_KB), ' ');
};

//format bps data in grid
WGRD.bpsFormatterChart = function (format, bps) {
    return $.formatBandwidth(bps);
};
//format bps data in grid
WGRD.bpsFormatterGrid = function (bps) {
    return $.formatBandwidth(bps);
};
//format percent data in grid
WGRD.percentFormatterChart = function (format, percent) {
    return percent + '%';
};

WGRD.colFormatterChart = function (cellvalue, options, rowObject) {
    var data = 0;
    var div = '';
    var div_w = 0;
    var color_class = 'pctbar_hits';
    var percent = 0;
    if (options.colModel.index === 'bytes') {
        var bytes = parseInt(rowObject.bytes, 10);
        data = WGRD.bwFormatterSpan(bytes);
        percent = parseInt((bytes / S_CHART_MAX_BYTES) * 100, 10);
        div_w = (percent > 1 || bytes === 0) ? percent : 1;
        color_class = 'pctbar_byte';
        div = '<div class="pctbar progress-inverse pctbar"><div class="' + color_class
            + ' pctbar-bar" style="width:' + div_w + '%;"></div></div>'
            + '<div>' + data + '</div>';
    } else if (options.colModel.index === 'hits') {
        data = $.commaify(rowObject.hits);
        percent = parseInt((rowObject.hits / S_CHART_MAX_HITS) * 100, 10);
        div_w = (percent > 1) ? percent : 1;
        color_class = 'pctbar_hits';
        div = '<div class="pctbar progress-inverse pctbar"><div class="' + color_class
            + ' pctbar-bar" style="width:' + div_w + '%;"></div></div>'
            + '<div>' + data + '</div>';
    }
    return div;
};

// automatic server poller
// use new POLLER() to create and start a new poller
//    url - url to send ajax request to
//    data - data to post to url
//    interval - time to wait between polls (in millis)
//    successHandler - function(response)
//    errorHandler - function(response, num_failed)
// creator can use pause() and resume() to control polling
// the successHandler and errorHandler callbacks are called in response to the Ajax call
// the polling will stop if successHandler or errorHandler return false
function POLLER(url, data, interval, successHandler, errorHandler) {

    // tracks whether polling is currently paused or not
    var paused = false;

    // number of consecutive failed attempts
    var failed = 0;

    // keep a private instance reference for inner functions
    var that = this;

    /*
     * public variables / functions
     */

    // URL to poll
    this.url = url;

    // data to POST
    this.data = data;

    // waiting interval between polls (in millis)
    this.interval = interval;

    // callback on successful poll
    // polling will stop if it returns false
    this.successHandler = successHandler;

    // callback on server error from poll
    // polling will stop if it returns false
    this.errorHandler = errorHandler;

    // stop the polling
    this.pause = function () {
        paused = true;
    };

    /*
     * private variables / functions
     */

    // start the timer
    function _init() {
        setTimeout($.proxy(_doPost, that), that.interval);  // ensures 'that' is the poller obj inside _doPost(), not the window object
    }

    // send the ajax erquest
    function _doPost() {
        var self = that;

        // don't make the ajax call if we are paused
        if (paused) {
            _init();
            return;
        }

        $.ajax({
            url: self.url,
            type: 'POST',
            dataType: 'json',
            data: self.data,
            success: function (response) {
                if (!paused) {
                    if (self.successHandler(response)) {
                        failed = 0;
                        _init();
                    }
                } else {
                    // schedule next poll, even if we are paused
                    _init();
                }
            },
            error: function (response) {
                if (!paused) {
                    if (self.errorHandler(response, ++failed)) {
                        _init();
                    }
                } else {
                    // schedule next poll, even if we are paused
                    _init();
                }
            }
        });
    }

    // resume the polling
    this.resume = function (force_refresh) {
        paused = false;
        if (force_refresh) {
            _doPost();
        }
    };

    // start the poller automatically when it is created
    _init();
}

WGRD.fullScreenEnterCB = null;
WGRD.fullScreenExitCB = null;
WGRD.FullScreen_Register = function (selector, onEnterPreCB, onEnterPostCB, onExitCB, btnSelectors) {
    if (!WGRD.hasFullScreen()) {
        $(btnSelectors).hide();
        return;
    }
    WGRD.fullScreenEnterCB = onEnterPostCB;
    WGRD.fullScreenExitCB = onExitCB;
    $(document).bind('fullscreenchange', WGRD.onFullScreenChange);
    $(document).bind('mozfullscreenchange', WGRD.onFullScreenChange);
    $(document).bind('MSFullscreenChange', WGRD.onFullScreenChange);
    $(document).bind('webkitfullscreenchange ', WGRD.onFullScreenChange);

    $(btnSelectors).click(function () {
        if (WGRD.isFullScreen()) {
            WGRD.closeFullScreen();
        } else {
            onEnterPreCB();
            WGRD.doFullScreen(selector);
        }
    });
};

WGRD.doFullScreen = function (selector) {
    var e = document.documentElement;
    e = $(selector)[0];
    $(selector).css("background", "White");
    if (e.requestFullscreen) {
        e.requestFullscreen();
    } else if (e.mozRequestFullScreen) {
        e.mozRequestFullScreen();
    } else if (e.webkitRequestFullScreen) {
        e.webkitRequestFullScreen();
    } else if (e.msRequestFullscreen) {
        e.msRequestFullscreen();
    }
};
WGRD.closeFullScreen = function () {
    var e = $(document)[0];
    if (e.exitFullscreen) {
        e.exitFullscreen();
    } else if (e.mozCancelFullScreen) {
        e.mozCancelFullScreen();
    } else if (e.webkitCancelFullScreen) {
        e.webkitCancelFullScreen();
    } else if (e.msExitFullscreen) {
        e.msExitFullscreen();
    }
};
WGRD.isFullScreen = function () {
    if (document.fullScreenElement || document.mozFullScreenElement || document.msFullscreenElement || document.webkitIsFullScreen) {
        return true;
    }
    return false;
};
WGRD.onFullScreenChange = function () {
    if (WGRD.isFullScreen()) {
        WGRD.fullScreenEnterCB();
    } else {
        WGRD.fullScreenExitCB();
    }
};
WGRD.hasFullScreen = function () {
    var e = $(document)[0];
    var ret = false;
    if (e.exitFullscreen || e.mozCancelFullScreen || e.webkitCancelFullScreen || e.msExitFullscreen) {
        ret = true;
    }
    return ret;
};

/*
 * Converts a number of seconds to "2 days 12:31"
 * val: Number value in seconds
 * includeSeconds: Boolean
 *                 - true include seconds "2 days 12:31:12"
 *                 - false stop at minutes "2 days 12:31"
 */
WGRD.timeFormatter = function (val, includeSeconds) {
    var secs = val % 60;
    var mins = ((val - secs) / 60) % 60;
    var totalhours = (((val - secs) / 60) - mins) / 60;
    var hours = totalhours % 24;
    var days = (totalhours - hours) / 24;

    var daystr = S_DAYS_STRING;
    if (days === 1) {
        daystr = S_DAY_STRING;
    }

    if (includeSeconds) {
        return days.toString() + daystr + ("0" + hours).slice(-2) + ":" + ("0" + mins).slice(-2) + ":" + ("0" + secs).slice(-2);
    }
    return days.toString() + daystr + ("0" + hours).slice(-2) + ":" + ("0" + mins).slice(-2);
};
