#!/bin/sh

# Helper script to create or restore a Dimension snapshot backup.

set -e

usage() {
    echo "usage: $1 create" >&2
    echo "       $1 restore <snapshot file>" >&2
    exit 1
}

DEFAULTS="/etc/default/wg_system"

if [ ! -f "$DEFAULTS" ]; then
    exit 0
fi

. "$DEFAULTS"

if [ $# -lt 1 -o $# -gt 2 ]; then
    usage $0
fi

PYTHON_CMD=${WG_BINDIR}/python

case "$1" in
"create")
    sudo -u "$WG_ADMIN_USER" "$PYTHON_CMD" -m wg_system.snapshot create
    ;;
"restore")
    sudo -u "$WG_ADMIN_USER" "$PYTHON_CMD" -m wg_system.snapshot restore "$2"
    ;;
*)
    usage $0
    ;;
esac

exit 0
