#!/bin/sh

# wg_admin_acl.sh - wrapper script to update admin's access control list.
#    calls wg_admin_acl.pyc
#
#    usage: admin_acl <ip address | network address(in cidr notation)>
#

set -eu

. /etc/default/wg_system

export WG_BINDIR WG_ETCDIR WG_LIBDIR WG_RUNDIR WG_SHAREDIR WG_VARDIR 
export WG_ADMIN_USER WG_ADMIN_GROUP WG_SUPPORT_USER

interpreter="${WG_BINDIR}/python"
program="${WG_BINDIR}/wg_admin_acl.pyc"

if [ ! -e "$interpreter" -o ! -x "$interpreter" ]; then
    echo "Interpreter file \"$interpreter\" does not exist or is non-executable" >&2
    exit 1
fi

if [ ! -e "$program" -o ! -s "$program" ]; then
    echo "Program file \"$program\" does not exist or is empty" >&2
    exit 1
fi

"$interpreter" "$program" "$@"